/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.coulomb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.opensha.commons.util.IDPairing;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.coulomb.CoulombRatesRecord;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class CoulombRates
extends HashMap<IDPairing, CoulombRatesRecord> {
    private static final long serialVersionUID = 1L;
    private static HashMap<FaultModels, String> modelDataFilesMap = new HashMap();
    private static final String DATA_SUB_DIR = "coulomb";
    private FaultModels fm;

    private CoulombRates(FaultModels fm) {
        this.fm = fm;
    }

    public CoulombRates(FaultModels fm, Map<IDPairing, CoulombRatesRecord> rates) {
        this.fm = fm;
        this.putAll(rates);
    }

    public boolean isApplicableTo(Collection<IDPairing> pairings) {
        for (IDPairing pairing : pairings) {
            if (this.containsKey(pairing) && this.containsKey(pairing.getReversed())) continue;
            return false;
        }
        return true;
    }

    public static CoulombRates loadUCERF3CoulombRates(FaultModels faultModel) throws IOException {
        String fileName = modelDataFilesMap.get(faultModel);
        Preconditions.checkNotNull((Object)fileName, (Object)("No coulomb file exists for the given fault model: " + String.valueOf(faultModel)));
        return CoulombRates.loadExcelFile(faultModel, UCERF3_DataUtils.locateResourceAsStream(DATA_SUB_DIR, fileName));
    }

    public static CoulombRates loadExcelFile(FaultModels faultModel, InputStream is) throws IOException {
        CoulombRates rates = new CoulombRates(faultModel);
        POIFSFileSystem fs = new POIFSFileSystem(is);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        int lastRowIndex = sheet.getLastRowNum();
        for (int r = 1; r <= lastRowIndex; ++r) {
            HSSFCell id1_cell;
            int cellNum;
            HSSFRow row = sheet.getRow(r);
            if (row == null || (cellNum = row.getFirstCellNum()) < 0 || (id1_cell = row.getCell(cellNum++)) == null || id1_cell.getCellType() != 0) continue;
            int id1 = (int)id1_cell.getNumericCellValue();
            int id2 = (int)row.getCell(cellNum++).getNumericCellValue();
            double ds = row.getCell(cellNum++).getNumericCellValue();
            double dcff = row.getCell(cellNum++).getNumericCellValue();
            double pds = row.getCell(cellNum++).getNumericCellValue();
            double pdcff = row.getCell(cellNum++).getNumericCellValue();
            IDPairing pairing = new IDPairing(id1, id2);
            rates.put(pairing, new CoulombRatesRecord(pairing, ds, pds, dcff, pdcff));
        }
        return rates;
    }

    public static void writeExcelFile(CoulombRates rates, Map<IDPairing, Double> distancesMap, File file) throws IOException {
        int lastRowIndex;
        ArrayList pairings = Lists.newArrayList(rates.keySet());
        Collections.sort(pairings, new Comparator<IDPairing>(){

            @Override
            public int compare(IDPairing o1, IDPairing o2) {
                Integer id11 = o1.getID1();
                Integer id12 = o1.getID2();
                Integer id21 = o2.getID1();
                Integer id22 = o2.getID2();
                int cmp = id11.compareTo(id21);
                if (cmp != 0) {
                    return cmp;
                }
                return id12.compareTo(id22);
            }
        });
        InputStream is = UCERF3_DataUtils.locateResourceAsStream(DATA_SUB_DIR, modelDataFilesMap.get(FaultModels.FM3_1));
        POIFSFileSystem fs = new POIFSFileSystem(is);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        if (sheet.getLastRowNum() != sheet.getPhysicalNumberOfRows() - 1) {
            for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
                if (sheet.getRow(i) != null) continue;
                sheet.createRow(i);
            }
        }
        if ((lastRowIndex = sheet.getLastRowNum()) != pairings.size()) {
            if (lastRowIndex < pairings.size()) {
                for (int i = lastRowIndex + 1; i <= pairings.size(); ++i) {
                    sheet.createRow(i);
                }
            } else {
                int removeCnt = 0;
                for (int i = lastRowIndex; i > pairings.size(); --i) {
                    sheet.removeRow((Row)sheet.getRow(i));
                    ++removeCnt;
                }
            }
            Preconditions.checkState(((lastRowIndex = sheet.getLastRowNum()) == pairings.size() ? 1 : 0) != 0, (Object)("Last row index messed up...expected=" + pairings.size() + ", actual=" + lastRowIndex));
        }
        Preconditions.checkState((sheet.getFirstRowNum() == 0 ? 1 : 0) != 0);
        Preconditions.checkState((sheet.getLastRowNum() == sheet.getPhysicalNumberOfRows() - 1 ? 1 : 0) != 0, (Object)("Last row num=" + sheet.getLastRowNum() + ", num rows: " + sheet.getPhysicalNumberOfRows()));
        for (int r = 1; r <= lastRowIndex; ++r) {
            IDPairing pairing = (IDPairing)pairings.get(r - 1);
            CoulombRatesRecord rec = (CoulombRatesRecord)rates.get(pairing);
            double dist = distancesMap.get(pairing);
            HSSFRow row = sheet.getRow(r);
            for (int i = 0; i < 7; ++i) {
                row.createCell(i, 0);
            }
            row.getCell(0).setCellValue((double)pairing.getID1());
            row.getCell(1).setCellValue((double)pairing.getID2());
            row.getCell(2).setCellValue(rec.getShearStressChange());
            row.getCell(3).setCellValue(rec.getCoulombStressChange());
            row.getCell(4).setCellValue(rec.getShearStressProbability());
            row.getCell(5).setCellValue(rec.getCoulombStressProbability());
            row.getCell(6).setCellValue(dist);
        }
        FileOutputStream fos = new FileOutputStream(file);
        wb.write((OutputStream)fos);
    }

    public static void main(String[] args) throws IOException {
        CoulombRates rates = CoulombRates.loadUCERF3CoulombRates(FaultModels.FM3_1);
        IDPairing pairing = new IDPairing(594, 2402);
        System.out.println(rates.get(pairing));
        System.out.println(rates.get(pairing.getReversed()));
        pairing = new IDPairing(2402, 635);
        System.out.println(rates.get(pairing));
        System.out.println(rates.get(pairing.getReversed()));
    }

    static {
        modelDataFilesMap.put(FaultModels.FM3_1, "2013_04_08-Stress_Table-FM3.1.xls");
        modelDataFilesMap.put(FaultModels.FM3_2, "2013_04_08-Stress_Table-FM3.2.xls");
    }

    public static class Adapter
    extends TypeAdapter<CoulombRates> {
        public void write(JsonWriter out, CoulombRates value) throws IOException {
            Preconditions.checkNotNull((Object)value.fm);
            out.beginObject();
            out.name("faultModel").value(value.fm.name());
            out.endObject();
        }

        public CoulombRates read(JsonReader in) throws IOException {
            in.beginObject();
            Preconditions.checkState((boolean)in.hasNext());
            Preconditions.checkState((boolean)in.nextName().equals("faultModel"));
            FaultModels fm = FaultModels.valueOf(in.nextString());
            in.endObject();
            return CoulombRates.loadUCERF3CoulombRates(fm);
        }
    }
}

