/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.coulomb;

import com.google.common.base.Preconditions;
import org.opensha.commons.util.IDPairing;

public class CoulombRatesRecord {
    private double ds;
    private double pds;
    private double dcff;
    private double pdcff;
    private IDPairing pairing;

    public CoulombRatesRecord(IDPairing pairing, double ds, double pds, double dcff, double pdcff) {
        Preconditions.checkNotNull((Object)pairing);
        this.pairing = pairing;
        Preconditions.checkState((Double.isFinite(ds) && Double.isFinite(pds) && Double.isFinite(dcff) && Double.isFinite(pdcff) ? 1 : 0) != 0);
        Preconditions.checkState((pds >= 0.0 && pds <= 1.0 ? 1 : 0) != 0, (String)"bad pds=%s", (Object)pds);
        Preconditions.checkState((pdcff >= 0.0 && pdcff <= 1.0 ? 1 : 0) != 0, (String)"bad pdcff=%s", (Object)pdcff);
        this.ds = ds;
        this.pds = pds;
        this.dcff = dcff;
        this.pdcff = pdcff;
    }

    public double getShearStressChange() {
        return this.ds;
    }

    public double getShearStressProbability() {
        return this.pds;
    }

    public double getCoulombStressChange() {
        return this.dcff;
    }

    public double getCoulombStressProbability() {
        return this.pdcff;
    }

    public IDPairing getPairing() {
        return this.pairing;
    }

    public String toString() {
        return "CoulombRatesRecord [pairing=" + String.valueOf(this.pairing) + ", ds=" + this.ds + ", pds=" + this.pds + ", dcff=" + this.dcff + ", pdcff=" + this.pdcff + "]";
    }
}

