/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.laughTest;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.laughTest.AbstractPlausibilityFilter;

public class AzimuthChangeFilter
extends AbstractPlausibilityFilter {
    private boolean applyGarlockPintoMtnFix;
    private HashSet<Integer> leftLateralFixParents;
    private Map<IDPairing, Double> sectionAzimuths;
    private boolean totAzChangeAtJunctionsOnly = false;
    private double maxAzimuthChange;
    private double maxTotAzimuthChange;

    public AzimuthChangeFilter(double maxAzimuthChange, double maxTotAzimuthChange, boolean applyGarlockPintoMtnFix, Map<IDPairing, Double> sectionAzimuths) {
        this.maxAzimuthChange = maxAzimuthChange;
        this.maxTotAzimuthChange = maxTotAzimuthChange;
        this.applyGarlockPintoMtnFix = applyGarlockPintoMtnFix;
        this.sectionAzimuths = sectionAzimuths;
        if (applyGarlockPintoMtnFix) {
            this.setUCERF3p3LL_List();
        }
    }

    public void setUCERF3p2LL_List() {
        this.leftLateralFixParents = new HashSet();
        this.leftLateralFixParents.add(48);
        this.leftLateralFixParents.add(49);
        this.leftLateralFixParents.add(93);
        this.leftLateralFixParents.add(341);
    }

    public void setUCERF3p3LL_List() {
        this.setUCERF3p2LL_List();
        this.leftLateralFixParents.add(47);
        this.leftLateralFixParents.add(169);
    }

    @Override
    public PlausibilityResult applyLastSection(List<? extends FaultSection> rupture, List<IDPairing> pairings, List<Integer> junctionIndexes) {
        boolean testTotal;
        if (rupture.size() < 4 || junctionIndexes.isEmpty()) {
            return PlausibilityResult.PASS;
        }
        int lastIndexInRup = rupture.size() - 1;
        boolean testLast = junctionIndexes.contains(lastIndexInRup - 1);
        boolean bl = testTotal = testLast || !this.totAzChangeAtJunctionsOnly;
        if (junctionIndexes.get(junctionIndexes.size() - 1) == lastIndexInRup) {
            testTotal = false;
        }
        if (!testLast && !testTotal) {
            return PlausibilityResult.PASS;
        }
        IDPairing firstPairing = pairings.get(0);
        int firstSectParent = rupture.get(0).getParentSectionId();
        IDPairing prevSectPairing = pairings.get(pairings.size() - 3);
        int prevSectParent = rupture.get(lastIndexInRup - 2).getParentSectionId();
        IDPairing newSectPairing = pairings.get(pairings.size() - 1);
        int newSectParent = rupture.get(lastIndexInRup).getParentSectionId();
        if (!Double.isNaN(this.maxAzimuthChange) && testLast && !this.testAzimuth(prevSectPairing, prevSectParent, newSectPairing, newSectParent, this.maxAzimuthChange)) {
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        if (this.totAzChangeAtJunctionsOnly && this.leftLateralFixParents != null && this.leftLateralFixParents.contains(firstSectParent)) {
            firstPairing = firstPairing.getReversed();
        }
        if (!Double.isNaN(this.maxTotAzimuthChange) && testTotal && !this.testAzimuth(firstPairing, firstSectParent, newSectPairing, newSectParent, this.maxTotAzimuthChange)) {
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        return PlausibilityResult.PASS;
    }

    private boolean testAzimuth(IDPairing pairing1, int parent1, IDPairing pairing2, int parent2, double threshold) {
        double az2;
        double az1;
        double diff;
        if (this.applyGarlockPintoMtnFix) {
            if (this.leftLateralFixParents.contains(parent1)) {
                pairing1 = pairing1.getReversed();
            }
            if (this.leftLateralFixParents.contains(parent2)) {
                pairing2 = pairing2.getReversed();
            }
        }
        return (diff = Math.abs(AzimuthChangeFilter.getAzimuthDifference(az1 = this.sectionAzimuths.get(pairing1).doubleValue(), az2 = this.sectionAzimuths.get(pairing2).doubleValue()))) <= threshold;
    }

    @Override
    public boolean isApplyJunctionsOnly() {
        return false;
    }

    public static double getAzimuthDifference(double azimuth1, double azimuth2) {
        double diff = azimuth2 - azimuth1;
        if (diff > 180.0) {
            return diff - 360.0;
        }
        if (diff < -180.0) {
            return diff + 360.0;
        }
        return diff;
    }

    public boolean isTotAzChangeAtJunctionsOnly() {
        return this.totAzChangeAtJunctionsOnly;
    }

    public void setTotAzChangeAtJunctionsOnly(boolean totAzChangeAtJunctionsOnly) {
        this.totAzChangeAtJunctionsOnly = totAzChangeAtJunctionsOnly;
    }

    @Override
    public String getName() {
        return "Azimuth Change Filter";
    }

    @Override
    public String getShortName() {
        return "Azimuth";
    }
}

