/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.laughTest;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.laughTest.AbstractPlausibilityFilter;

public class MinSectsPerParentFilter {

    public static class CleanupFilter
    extends AbstractPlausibilityFilter {
        private int minSectsPerParent;
        private boolean allowIfOnlyPath;
        private Map<Integer, Collection<Integer>> parentSectConnectionsMap;

        public CleanupFilter(int minSectsPerParent, boolean allowIfOnlyPath, List<List<Integer>> sectionConnectionsListList, List<? extends FaultSection> subSectData) {
            this.minSectsPerParent = minSectsPerParent;
            this.allowIfOnlyPath = allowIfOnlyPath;
            if (allowIfOnlyPath) {
                this.parentSectConnectionsMap = Maps.newHashMap();
                for (int sectIndex1 = 0; sectIndex1 < sectionConnectionsListList.size(); ++sectIndex1) {
                    Integer parentID1 = subSectData.get(sectIndex1).getParentSectionId();
                    Collection<Integer> parentConnections = this.parentSectConnectionsMap.get(parentID1);
                    if (parentConnections == null) {
                        parentConnections = new HashSet<Integer>();
                        this.parentSectConnectionsMap.put(parentID1, parentConnections);
                    }
                    for (int sectIndex2 : sectionConnectionsListList.get(sectIndex1)) {
                        Integer parentID2 = subSectData.get(sectIndex2).getParentSectionId();
                        parentConnections.add(parentID2);
                    }
                }
            }
        }

        @Override
        public PlausibilityResult applyLastSection(List<? extends FaultSection> rupture, List<IDPairing> pairings, List<Integer> junctionIndexes) {
            boolean pass;
            int numJunctions = junctionIndexes.size();
            if (rupture.size() < this.minSectsPerParent + 1) {
                return PlausibilityResult.FAIL_HARD_STOP;
            }
            if (numJunctions < 2) {
                return PlausibilityResult.PASS;
            }
            boolean bl = pass = junctionIndexes.get(numJunctions - 2) < rupture.size() - this.minSectsPerParent;
            if (!pass && this.allowIfOnlyPath) {
                int fromID = rupture.get(junctionIndexes.get(numJunctions - 2) - 1).getParentSectionId();
                int toID = rupture.get(junctionIndexes.get(numJunctions - 1)).getParentSectionId();
                if (this.parentSectConnectionsMap.get(fromID).contains(toID)) {
                    return PlausibilityResult.FAIL_HARD_STOP;
                }
                return PlausibilityResult.PASS;
            }
            return PlausibilityResult.PASS;
        }

        @Override
        public boolean isApplyJunctionsOnly() {
            return true;
        }

        @Override
        public String getName() {
            return "Min Sects Per Parent Cleanup Filter";
        }

        @Override
        public String getShortName() {
            return "SectsPerParentBridge";
        }
    }

    public static class ContinualFilter
    extends AbstractPlausibilityFilter {
        private int minSectsPerParent;

        public ContinualFilter(int minSectsPerParent) {
            this.minSectsPerParent = minSectsPerParent;
        }

        @Override
        public PlausibilityResult applyLastSection(List<? extends FaultSection> rupture, List<IDPairing> pairings, List<Integer> junctionIndexes) {
            int numJunctions = junctionIndexes.size();
            if (rupture.size() >= this.minSectsPerParent && numJunctions > 0 && junctionIndexes.get(0) < this.minSectsPerParent) {
                return PlausibilityResult.FAIL_HARD_STOP;
            }
            if (rupture.size() >= this.minSectsPerParent && (numJunctions == 0 || junctionIndexes.get(numJunctions - 1) < rupture.size() - this.minSectsPerParent + 1)) {
                return PlausibilityResult.PASS;
            }
            return PlausibilityResult.FAIL_FUTURE_POSSIBLE;
        }

        @Override
        public boolean isApplyJunctionsOnly() {
            return false;
        }

        @Override
        public String getName() {
            return "Min Sects Per Parent Continous Filter";
        }

        @Override
        public String getShortName() {
            return "SectsPerParent";
        }
    }
}

