/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.logicTree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.opensha.commons.logicTree.LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;

public class VariableLogicTreeBranch
extends U3LogicTreeBranch {
    private List<String> variations;

    private VariableLogicTreeBranch() {
    }

    public VariableLogicTreeBranch(U3LogicTreeBranch branch, List<String> variations) {
        super(branch);
        this.variations = variations;
    }

    public List<String> getVariations() {
        return this.variations;
    }

    public boolean matchesVariation(VariableLogicTreeBranch branch) {
        if (this.variations != null) {
            List<String> o = branch.getVariations();
            if (o == null) {
                return this.variations.isEmpty();
            }
            if (this.variations.size() > o.size()) {
                return false;
            }
            for (int i = 0; i < this.variations.size(); ++i) {
                String myVar = this.variations.get(i);
                if (myVar == null || this.variations.get(i).equals(o.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.variations == null ? 0 : this.variations.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof U3LogicTreeBranch)) {
            return false;
        }
        U3LogicTreeBranch other = (U3LogicTreeBranch)obj;
        List<String> oVariations = other instanceof VariableLogicTreeBranch ? ((VariableLogicTreeBranch)other).variations : null;
        return !(this.variations == null || this.variations.isEmpty() ? oVariations != null && !oVariations.isEmpty() : !this.variations.equals(oVariations));
    }

    @Override
    public int compareTo(LogicTreeBranch o) {
        int lBranchComp = super.compareTo(o);
        if (lBranchComp != 0) {
            return lBranchComp;
        }
        if (!(o instanceof VariableLogicTreeBranch)) {
            return 1;
        }
        VariableLogicTreeBranch other = (VariableLogicTreeBranch)o;
        if (this.variations == null) {
            Preconditions.checkState((other.variations == null ? 1 : 0) != 0);
            return 0;
        }
        Preconditions.checkState((other.variations.size() == this.variations.size() ? 1 : 0) != 0, (Object)"Num variations inconsistent!");
        for (int i = 0; i < this.variations.size(); ++i) {
            String oval;
            String val = this.variations.get(i);
            int cmp = val.compareTo(oval = other.variations.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static List<String> parseVariations(String name) {
        ArrayList<String> vars = null;
        while (name.contains("_Var")) {
            String sub;
            if (vars == null) {
                vars = new ArrayList<String>();
            }
            if ((sub = (name = name.substring(name.indexOf("_Var") + 4))).endsWith(".csv")) {
                sub = sub.substring(0, name.indexOf(".csv"));
            }
            if (sub.endsWith("_sol.zip")) {
                sub = sub.substring(0, name.indexOf("_sol.zip"));
            }
            if (sub.endsWith("_rates.bin")) {
                sub = sub.substring(0, name.indexOf("_rates.bin"));
            }
            if (sub.contains("_Run")) {
                sub = sub.substring(0, sub.indexOf("_Run"));
            }
            if (sub.contains("_Var")) {
                sub = sub.substring(0, sub.indexOf("_Var"));
            }
            vars.add(sub);
        }
        return vars;
    }

    public static U3LogicTreeBranch fromStringValues(List<String> strings) {
        return VariableLogicTreeBranch.fromFileName(Joiner.on((String)"_").join(strings));
    }

    public static VariableLogicTreeBranch fromFileName(String name) {
        List<String> variations = VariableLogicTreeBranch.parseVariations(name);
        U3LogicTreeBranch branch = U3LogicTreeBranch.fromFileName(name);
        return new VariableLogicTreeBranch(branch, variations);
    }

    @Override
    public String buildFileName() {
        Object name = super.buildFileName();
        if (this.variations != null) {
            for (String variation : this.variations) {
                name = (String)name + "_Var" + variation;
            }
        }
        return name;
    }

    public static void main(String[] args) {
        String name = "FM3_1_ZENG_HB08_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarPaleo10_VarSectNuclMFDWt0.01";
        VariableLogicTreeBranch branch = VariableLogicTreeBranch.fromFileName(name);
        for (String var : branch.getVariations()) {
            System.out.println(var);
        }
        ArrayList branches = Lists.newArrayList();
        branches.add(VariableLogicTreeBranch.fromFileName("FM3_1_ZENG_HB08_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarPOISSON_VarABCD"));
        branches.add(VariableLogicTreeBranch.fromFileName("FM3_1_ZENG_HB08_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarMID_VarABCD"));
        branches.add(VariableLogicTreeBranch.fromFileName("FM3_1_ZENG_HB08_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarHIGH_VarCB2008"));
        branches.add(VariableLogicTreeBranch.fromFileName("FM3_1_ZENG_HB08_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarPOISSON_Var2190"));
        branches.add(VariableLogicTreeBranch.fromFileName("FM3_2_ZENG_HB08_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarPOISSON_VarABCD"));
        branches.add(VariableLogicTreeBranch.fromFileName("FM3_2_ZENG_HB08_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarMID_VarABCD"));
        branches.add(VariableLogicTreeBranch.fromFileName("FM3_2_ZENG_HB08_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarHIGH_VarCB2008"));
        branches.add(VariableLogicTreeBranch.fromFileName("FM3_2_ZENG_HB08_DsrUni_CharConst_M5Rate8.7_MMaxOff7.6_NoFix_SpatSeisU3_VarPOISSON_Var2190"));
        Collections.shuffle(branches);
        Collections.sort(branches);
        for (U3LogicTreeBranch b : branches) {
            System.out.println(b.buildFileName());
        }
    }

    public static VariableLogicTreeBranch fromXMLMetadata(Element branchEl) {
        U3LogicTreeBranch branch = U3LogicTreeBranch.fromXMLMetadata(branchEl);
        Preconditions.checkState((boolean)(branch instanceof VariableLogicTreeBranch), (Object)"Has no variations!");
        return (VariableLogicTreeBranch)branch;
    }
}

