/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.simulatedAnnealing.hpc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dom4j.DocumentException;
import org.opensha.commons.hpc.JavaShellScriptWriter;
import org.opensha.commons.hpc.mpj.FastMPJShellScriptWriter;
import org.opensha.commons.hpc.mpj.MPJExpressShellScriptWriter;
import org.opensha.commons.hpc.pbs.BatchScriptWriter;
import org.opensha.commons.hpc.pbs.EpicenterScriptWriter;
import org.opensha.commons.hpc.pbs.RangerScriptWriter;
import org.opensha.commons.hpc.pbs.StampedeScriptWriter;
import org.opensha.commons.hpc.pbs.USC_HPCC_ScriptWriter;
import org.opensha.commons.util.ClassUtils;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ThreadedSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.TimeCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.CoolingScheduleType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.NonnegativityConstraintType;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.logicTree.DiscreteListTreeTrimmer;
import scratch.UCERF3.logicTree.ListBasedTreeTrimmer;
import scratch.UCERF3.logicTree.LogicTreeBranchIterator;
import scratch.UCERF3.logicTree.LogicalNotTreeTrimmer;
import scratch.UCERF3.logicTree.LogicalOrTrimmer;
import scratch.UCERF3.logicTree.SingleValsTreeTrimmer;
import scratch.UCERF3.logicTree.TreeTrimmer;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.simulatedAnnealing.hpc.MPJInversionDistributor;

public class LogicTreePBSWriter {
    public static DateFormat df = new SimpleDateFormat("yyyy_MM_dd");
    private static final String TAG_OPTION_ON = "Option On";
    private static final String TAG_OPTION_OFF = null;

    public static ArrayList<File> getClasspath(RunSites runSite, File jobDir) {
        return LogicTreePBSWriter.getClasspath(runSite.RUN_DIR, jobDir);
    }

    public static ArrayList<File> getClasspath(File jarDir, File jobDir) {
        ArrayList<File> jars = new ArrayList<File>();
        jars.add(new File(jobDir, "opensha-dev-all.jar"));
        return jars;
    }

    private static ArrayList<CustomArg[]> buildVariationBranches(List<CustomArg[]> variations, CustomArg[] curVariation) {
        if (curVariation == null) {
            curVariation = new CustomArg[variations.size()];
        }
        int ind = curVariation.length - variations.size();
        List<CustomArg[]> nextVars = variations.size() > 1 ? variations.subList(1, variations.size()) : null;
        ArrayList<CustomArg[]> retVal = new ArrayList<CustomArg[]>();
        for (CustomArg var : variations.get(0)) {
            CustomArg[] branch = Arrays.copyOf(curVariation, curVariation.length);
            branch[ind] = var;
            if (nextVars == null) {
                retVal.add(branch);
                continue;
            }
            retVal.addAll(LogicTreePBSWriter.buildVariationBranches(nextVars, branch));
        }
        return retVal;
    }

    private static CustomArg[] forOptions(CommandLineInversionRunner.InversionOptions op, String ... args) {
        CustomArg[] ops = new CustomArg[args.length];
        for (int i = 0; i < args.length; ++i) {
            ops[i] = new CustomArg(op, args[i]);
        }
        return ops;
    }

    private static <E> E[] toArray(E ... vals) {
        return vals;
    }

    public static List<U3LogicTreeBranchNode<?>> getNonZeroChoices(Class<? extends U3LogicTreeBranchNode<?>> clazz, InversionModels im) {
        ArrayList nonZeros = Lists.newArrayList();
        for (U3LogicTreeBranchNode<?> val : clazz.getEnumConstants()) {
            if (!(val.getRelativeWeight(im) > 0.0)) continue;
            nonZeros.add(val);
        }
        return nonZeros;
    }

    private static List<U3LogicTreeBranchNode<?>> allOf(Class<? extends U3LogicTreeBranchNode<?>> clazz) {
        U3LogicTreeBranchNode<?>[] vals = clazz.getEnumConstants();
        return Arrays.asList(vals);
    }

    private static List<U3LogicTreeBranchNode<?>> toList(U3LogicTreeBranchNode<?> ... vals) {
        return Arrays.asList(vals);
    }

    private static CustomArg[] buildVariationBranch(CommandLineInversionRunner.InversionOptions[] ops, String[] vals) {
        Preconditions.checkArgument((ops.length == vals.length ? 1 : 0) != 0);
        CustomArg[] args = new CustomArg[ops.length];
        for (int i = 0; i < args.length; ++i) {
            if (!ops[i].hasOption()) {
                if (vals[i] == null || !vals[i].equals(TAG_OPTION_ON)) continue;
                args[i] = new CustomArg(ops[i], null);
                continue;
            }
            args[i] = new CustomArg(ops[i], vals[i]);
        }
        return args;
    }

    private static U3LogicTreeBranch getUCERF2_noIM() {
        U3LogicTreeBranch UCERF2_noIM = (U3LogicTreeBranch)U3LogicTreeBranch.UCERF2.clone();
        UCERF2_noIM.clearValue(InversionModels.class);
        return UCERF2_noIM;
    }

    private static TreeTrimmer getUCERF2Trimmer() {
        return new ListBasedTreeTrimmer(LogicTreePBSWriter.getUCERF2_noIM(), false);
    }

    private static TreeTrimmer getAllDM_IM_Trimmer(boolean bothFMs) {
        ArrayList limitations = Lists.newArrayList();
        ArrayList faultModels = Lists.newArrayList();
        faultModels.add(FaultModels.FM3_1);
        if (bothFMs) {
            faultModels.add(FaultModels.FM3_2);
        }
        limitations.add(faultModels);
        List<U3LogicTreeBranchNode<?>> defModels = LogicTreePBSWriter.getNonZeroChoices(DeformationModels.class, null);
        limitations.add(defModels);
        List<U3LogicTreeBranchNode<?>> invModels = LogicTreePBSWriter.getNonZeroChoices(InversionModels.class, null);
        limitations.add(invModels);
        return ListBasedTreeTrimmer.getDefaultPlusSpecifiedTrimmer(limitations);
    }

    private static TreeTrimmer getUCERF3RefBranches() {
        ArrayList branches = Lists.newArrayList();
        List<U3LogicTreeBranchNode<?>> dms = LogicTreePBSWriter.getNonZeroChoices(DeformationModels.class, null);
        List<U3LogicTreeBranchNode<?>> ims = LogicTreePBSWriter.getNonZeroChoices(InversionModels.class, null);
        for (U3LogicTreeBranchNode<?> dm : dms) {
            for (U3LogicTreeBranchNode<?> im : ims) {
                boolean isChar = ((InversionModels)im).isCharacteristic();
                MomentRateFixes momFix = MomentRateFixes.NONE;
                branches.add(U3LogicTreeBranch.fromValues(false, FaultModels.FM3_1, dm, im, ScalingRelationships.SHAW_2009_MOD, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, momFix, SpatialSeisPDF.UCERF3));
            }
        }
        for (U3LogicTreeBranchNode<?> im : ims) {
            boolean isChar = ((InversionModels)im).isCharacteristic();
            MomentRateFixes momFix = MomentRateFixes.NONE;
            branches.add(U3LogicTreeBranch.fromValues(false, FaultModels.FM2_1, DeformationModels.UCERF2_ALL, im, ScalingRelationships.SHAW_2009_MOD, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, momFix, SpatialSeisPDF.UCERF3));
        }
        return new DiscreteListTreeTrimmer(branches);
    }

    public static TreeTrimmer getNonZeroOrUCERF2Trimmer() {
        final ListBasedTreeTrimmer nonZero = ListBasedTreeTrimmer.getNonZeroWeightsTrimmer();
        final TreeTrimmer ucerf2Trim = LogicTreePBSWriter.getUCERF2Trimmer();
        return new TreeTrimmer(){

            @Override
            public boolean isTreeValid(U3LogicTreeBranch branch) {
                return nonZero.isTreeValid(branch) || ucerf2Trim.isTreeValid(branch);
            }
        };
    }

    public static TreeTrimmer getNoUCERF2Trimmer() {
        return new TreeTrimmer(){

            @Override
            public boolean isTreeValid(U3LogicTreeBranch branch) {
                return !branch.getValue(FaultModels.class).equals(FaultModels.FM2_1);
            }
        };
    }

    public static TreeTrimmer getNeokinemaOnlyTrimmer() {
        return new TreeTrimmer(){

            @Override
            public boolean isTreeValid(U3LogicTreeBranch branch) {
                return branch.getValue(DeformationModels.class).equals(DeformationModels.NEOKINEMA);
            }
        };
    }

    public static TreeTrimmer getZengOnlyTrimmer() {
        return new SingleValsTreeTrimmer(DeformationModels.ZENGBB);
    }

    private static TreeTrimmer getDiscreteCustomTrimmer() {
        ArrayList branches = Lists.newArrayList();
        ScalingRelationships[] scales = new ScalingRelationships[]{ScalingRelationships.SHAW_2009_MOD};
        SlipAlongRuptureModels[] dsrs = new SlipAlongRuptureModels[]{SlipAlongRuptureModels.UNIFORM};
        DeformationModels[] dms = new DeformationModels[]{DeformationModels.UCERF2_ALL};
        for (ScalingRelationships scale : scales) {
            for (SlipAlongRuptureModels dsr : dsrs) {
                for (DeformationModels dm : dms) {
                    if (dm == DeformationModels.UCERF2_ALL) {
                        branches.add(U3LogicTreeBranch.fromValues(true, FaultModels.FM2_1, dm, InversionModels.CHAR_CONSTRAINED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF2, scale, dsr));
                        continue;
                    }
                    branches.add(U3LogicTreeBranch.fromValues(true, FaultModels.FM3_1, dm, InversionModels.CHAR_CONSTRAINED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3, scale, dsr));
                }
            }
        }
        return new DiscreteListTreeTrimmer(branches);
    }

    private static TreeTrimmer getFullBranchSpan() {
        ArrayList limitations = Lists.newArrayList();
        List<U3LogicTreeBranchNode<?>> faultModels = LogicTreePBSWriter.toList(FaultModels.FM3_1, FaultModels.FM3_2);
        limitations.add(faultModels);
        List<U3LogicTreeBranchNode<?>> defModels = LogicTreePBSWriter.getNonZeroChoices(DeformationModels.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(defModels);
        List<U3LogicTreeBranchNode<?>> inversionModels = LogicTreePBSWriter.toList(InversionModels.CHAR_CONSTRAINED);
        limitations.add(inversionModels);
        List<U3LogicTreeBranchNode<?>> scaling = LogicTreePBSWriter.getNonZeroChoices(ScalingRelationships.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(scaling);
        List<U3LogicTreeBranchNode<?>> slipAlongs = LogicTreePBSWriter.getNonZeroChoices(SlipAlongRuptureModels.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(slipAlongs);
        List<U3LogicTreeBranchNode<?>> mag5s = LogicTreePBSWriter.getNonZeroChoices(TotalMag5Rate.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(mag5s);
        List<U3LogicTreeBranchNode<?>> maxMags = LogicTreePBSWriter.getNonZeroChoices(MaxMagOffFault.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(maxMags);
        List<U3LogicTreeBranchNode<?>> momentFixes = LogicTreePBSWriter.toList(MomentRateFixes.NONE);
        limitations.add(momentFixes);
        List<U3LogicTreeBranchNode<?>> spatialSeis = LogicTreePBSWriter.getNonZeroChoices(SpatialSeisPDF.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(spatialSeis);
        int tally = 1;
        System.out.println("FULL BRANCH SPAN. Allowed:");
        for (List allowed : limitations) {
            ArrayList names = Lists.newArrayList();
            for (U3LogicTreeBranchNode a : allowed) {
                names.add(a.name());
            }
            System.out.println("\t" + ClassUtils.getClassNameWithoutPackage(((U3LogicTreeBranchNode)allowed.get(0)).getClass()) + " (" + names.size() + "): " + Joiner.on((String)", ").join((Iterable)names));
            tally *= names.size();
        }
        System.out.println("TOTAL TALLY: " + tally);
        return new ListBasedTreeTrimmer(limitations);
    }

    private static TreeTrimmer getMiniBranchSpan() {
        ArrayList limitations = Lists.newArrayList();
        List<U3LogicTreeBranchNode<?>> faultModels = LogicTreePBSWriter.toList(FaultModels.FM3_1, FaultModels.FM3_2);
        limitations.add(faultModels);
        List<U3LogicTreeBranchNode<?>> defModels = LogicTreePBSWriter.getNonZeroChoices(DeformationModels.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(defModels);
        List<U3LogicTreeBranchNode<?>> inversionModels = LogicTreePBSWriter.toList(InversionModels.CHAR_CONSTRAINED);
        limitations.add(inversionModels);
        List<U3LogicTreeBranchNode<?>> scaling = LogicTreePBSWriter.getNonZeroChoices(ScalingRelationships.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(scaling);
        List<U3LogicTreeBranchNode<?>> slipAlongs = LogicTreePBSWriter.getNonZeroChoices(SlipAlongRuptureModels.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(slipAlongs);
        List<U3LogicTreeBranchNode<?>> mag5s = LogicTreePBSWriter.toList(TotalMag5Rate.RATE_7p9);
        limitations.add(mag5s);
        List<U3LogicTreeBranchNode<?>> maxMags = LogicTreePBSWriter.toList(MaxMagOffFault.MAG_7p6);
        limitations.add(maxMags);
        List<U3LogicTreeBranchNode<?>> momentFixes = LogicTreePBSWriter.toList(MomentRateFixes.NONE);
        limitations.add(momentFixes);
        List<U3LogicTreeBranchNode<?>> spatialSeis = LogicTreePBSWriter.toList(SpatialSeisPDF.UCERF3);
        limitations.add(spatialSeis);
        return new ListBasedTreeTrimmer(limitations);
    }

    public static TreeTrimmer getCustomTrimmer() {
        ArrayList limitations = Lists.newArrayList();
        List<U3LogicTreeBranchNode<?>> faultModels = LogicTreePBSWriter.toList(FaultModels.FM3_1);
        limitations.add(faultModels);
        List<U3LogicTreeBranchNode<?>> defModels = LogicTreePBSWriter.getNonZeroChoices(DeformationModels.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(defModels);
        List<U3LogicTreeBranchNode<?>> inversionModels = LogicTreePBSWriter.toList(InversionModels.CHAR_CONSTRAINED);
        limitations.add(inversionModels);
        List<U3LogicTreeBranchNode<?>> scaling = LogicTreePBSWriter.getNonZeroChoices(ScalingRelationships.class, InversionModels.CHAR_CONSTRAINED);
        limitations.add(scaling);
        List<U3LogicTreeBranchNode<?>> slipAlongs = LogicTreePBSWriter.toList(SlipAlongRuptureModels.UNIFORM);
        limitations.add(slipAlongs);
        List<U3LogicTreeBranchNode<?>> mag5s = LogicTreePBSWriter.toList(TotalMag5Rate.RATE_7p9);
        limitations.add(mag5s);
        List<U3LogicTreeBranchNode<?>> maxMags = LogicTreePBSWriter.toList(MaxMagOffFault.MAG_7p6);
        limitations.add(maxMags);
        List<U3LogicTreeBranchNode<?>> momentFixes = LogicTreePBSWriter.toList(MomentRateFixes.NONE);
        limitations.add(momentFixes);
        List<U3LogicTreeBranchNode<?>> spatialSeis = LogicTreePBSWriter.toList(SpatialSeisPDF.UCERF3);
        limitations.add(spatialSeis);
        return new ListBasedTreeTrimmer(limitations);
    }

    private static HashSet<String> loadIgnoresFromZip(File zipFile) throws IOException {
        HashSet<String> set = new HashSet<String>();
        ZipFile zip = new ZipFile(zipFile);
        for (ZipEntry zipEntry : Collections.list(zip.entries())) {
            String name;
            if (zipEntry.isDirectory() || (name = new File(zipEntry.getName()).getName()).contains("noMinRates")) continue;
            if (name.contains(".")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            System.out.println("Ignoring: " + name);
            set.add(name);
        }
        return set;
    }

    public static void main(String[] args) throws IOException, DocumentException {
        Iterable it;
        InversionArg[] saOps;
        boolean noPlots;
        Object runName = "ave-slip-scale-tests";
        if (args.length > 1) {
            runName = args[1];
        }
        int constrained_run_mins = 300;
        runName = df.format(new Date()) + "-" + (String)runName;
        RunSites site = RunSites.HPCC;
        int batchSize = 16;
        int jobsPerNode = 4;
        String threads = "5";
        U3LogicTreeBranch prescribedBranch = (U3LogicTreeBranch)U3LogicTreeBranch.DEFAULT.clone();
        Object nameAdd = null;
        HashSet ignores = null;
        int numRuns = 100;
        int runStart = 0;
        boolean forcePlots = false;
        boolean lightweight = numRuns > 10 || batchSize > 1;
        boolean bl = noPlots = batchSize > 1;
        if (forcePlots) {
            lightweight = false;
            noPlots = false;
        }
        File runSubDir = new File(site.RUN_DIR, (String)runName);
        int overallMaxJobs = -1;
        TreeTrimmer trimmer = LogicTreePBSWriter.getUCERF3RefBranches();
        SingleValsTreeTrimmer charOnly = new SingleValsTreeTrimmer(InversionModels.CHAR_CONSTRAINED);
        SingleValsTreeTrimmer charUnconstOnly = new SingleValsTreeTrimmer(InversionModels.CHAR_UNCONSTRAINED);
        SingleValsTreeTrimmer grOnly = new SingleValsTreeTrimmer(InversionModels.GR_CONSTRAINED);
        SingleValsTreeTrimmer grUnconstOnly = new SingleValsTreeTrimmer(InversionModels.GR_UNCONSTRAINED);
        LogicalOrTrimmer charOrGR = new LogicalOrTrimmer(charOnly, grOnly);
        LogicalNotTreeTrimmer noRefBranches = new LogicalNotTreeTrimmer(LogicTreePBSWriter.getUCERF3RefBranches());
        TreeTrimmer noUCERF2 = LogicTreePBSWriter.getNoUCERF2Trimmer();
        TreeTrimmer defaultBranchesTrimmer = null;
        HashMap maxAway = Maps.newHashMap();
        maxAway.put(InversionModels.CHAR_CONSTRAINED, 0);
        maxAway.put(InversionModels.CHAR_UNCONSTRAINED, 0);
        maxAway.put(InversionModels.GR_CONSTRAINED, 0);
        maxAway.put(InversionModels.GR_UNCONSTRAINED, 0);
        ArrayList<Object> variationBranches = null;
        List variations = null;
        variationBranches = Lists.newArrayList();
        CommandLineInversionRunner.InversionOptions[] ops = new CommandLineInversionRunner.InversionOptions[]{CommandLineInversionRunner.InversionOptions.AVE_SLIP_SCALE, CommandLineInversionRunner.InversionOptions.AVE_SLIP_WT};
        variationBranches.add(LogicTreePBSWriter.buildVariationBranch(ops, LogicTreePBSWriter.toArray("1.5", "1.2")));
        List saOptions = null;
        VariableLogicTreeBranch[] defaultBranches = null;
        boolean extraDM2Away = true;
        if (defaultBranchesTrimmer != null) {
            ArrayList defBranches = Lists.newArrayList();
            for (U3LogicTreeBranch branch : new LogicTreeBranchIterator(defaultBranchesTrimmer)) {
                defBranches.add(branch);
            }
            defaultBranches = new VariableLogicTreeBranch[defBranches.size()];
            for (int i = 0; i < defBranches.size(); ++i) {
                U3LogicTreeBranch branch;
                branch = (U3LogicTreeBranch)defBranches.get(i);
                defaultBranches[i] = new VariableLogicTreeBranch(null, branch);
            }
        }
        if (variationBranches == null && (variations == null || variations.size() == 0)) {
            variationBranches = new ArrayList<CustomArg[]>();
            variationBranches.add(new CustomArg[0]);
        } else if (variationBranches == null) {
            variationBranches = LogicTreePBSWriter.buildVariationBranches(variations, null);
        }
        File writeDir = args.length > 0 ? new File(new File(args[0]), (String)runName) : new File(new File("/home/kevin/OpenSHA/UCERF3/inversions"), (String)runName);
        if (!writeDir.exists()) {
            writeDir.mkdir();
        }
        String queue = "scec";
        File javaBin = site.JAVA_BIN;
        CoolingScheduleType cool = CoolingScheduleType.FAST_SA;
        if (saOptions != null) {
            Iterator iterator = saOptions.iterator();
            block2: while (iterator.hasNext()) {
                for (InversionArg op : saOps = (InversionArg[])iterator.next()) {
                    if (!op.arg.startsWith("--cool")) continue;
                    cool = null;
                    break block2;
                }
            }
        }
        boolean noNonNeg = false;
        if (saOptions != null) {
            saOps = saOptions.iterator();
            block4: while (saOps.hasNext()) {
                InversionArg[] saOps2;
                for (InversionArg op : saOps2 = (InversionArg[])saOps.next()) {
                    if (!op.arg.startsWith("--nonnegativity")) continue;
                    noNonNeg = true;
                    break block4;
                }
            }
        }
        CompletionCriteria[] subCompletions = new CompletionCriteria[]{TimeCompletionCriteria.getInSeconds(1L)};
        boolean keepCurrentAsBest = false;
        JavaShellScriptWriter javaWriter = new JavaShellScriptWriter(javaBin, -1, LogicTreePBSWriter.getClasspath(site, runSubDir));
        javaWriter.setHeadless(true);
        if (site.FM_STORE != null) {
            javaWriter.setProperty("FaultModelStore", site.FM_STORE);
        }
        int runDigits = new String("" + (numRuns - 1)).length();
        double nodeHours = 0.0;
        int cnt = 0;
        int ignoreCnt = 0;
        if (prescribedBranch != null) {
            it = Lists.newArrayList();
            ((List)it).add(prescribedBranch);
            System.out.println("Using prescribed/hardcoded branch! " + String.valueOf(prescribedBranch));
        } else {
            it = new LogicTreeBranchIterator(trimmer);
        }
        if (saOptions == null) {
            saOptions = Lists.newArrayList();
        }
        if (saOptions.isEmpty()) {
            saOptions.add(new InversionArg[0]);
        }
        ArrayList argsList = Lists.newArrayList();
        int maxJobMins = 0;
        block6: for (U3LogicTreeBranch br : it) {
            for (CustomArg[] customArgArray : variationBranches) {
                for (InversionArg[] invArgs : saOptions) {
                    for (CompletionCriteria subCompletion : subCompletions) {
                        TimeCompletionCriteria checkPointCriteria;
                        NonnegativityConstraintType nonNeg;
                        int mins;
                        if (subCompletions.length > 1) {
                            System.out.println("SUB: " + String.valueOf(subCompletion));
                        }
                        VariableLogicTreeBranch branch = new VariableLogicTreeBranch(customArgArray, br);
                        InversionModels im = branch.getValue(InversionModels.class);
                        if (defaultBranches != null && defaultBranches.length > 0) {
                            int closest = Integer.MAX_VALUE;
                            for (VariableLogicTreeBranch defaultBranch : defaultBranches) {
                                int away = ((U3LogicTreeBranch)defaultBranch).getNumAwayFrom(branch);
                                if (away >= closest) continue;
                                closest = away;
                            }
                            int myMaxAway = (Integer)maxAway.get(im);
                            if (extraDM2Away && myMaxAway > 0 && branch.getValue(FaultModels.class) == FaultModels.FM2_1) {
                                ++myMaxAway;
                            }
                            if (closest > myMaxAway) continue;
                        }
                        Object name = branch.buildFileName();
                        for (CustomArg variation : customArgArray) {
                            name = variation == null ? (String)name + "_VarNone" : (String)name + "_Var" + variation.op.getFileName(variation.arg);
                        }
                        for (InversionArg invArg : invArgs) {
                            if (invArg == null) continue;
                            name = (String)name + "_Var" + invArg.prefix;
                        }
                        if (nameAdd != null && !((String)nameAdd).isEmpty()) {
                            if (!((String)nameAdd).startsWith("_")) {
                                nameAdd = "_" + (String)nameAdd;
                            }
                            name = (String)name + (String)nameAdd;
                        }
                        if (subCompletions.length > 1) {
                            name = (String)name + "_VarSubComp" + ThreadedSimulatedAnnealing.subCompletionArgVal(subCompletion);
                        }
                        BatchScriptWriter batch = site.forBranch(branch);
                        if (im == InversionModels.GR_CONSTRAINED) {
                            mins = constrained_run_mins;
                            nonNeg = NonnegativityConstraintType.PREVENT_ZERO_RATES;
                            batch = site.forBranch(branch);
                            checkPointCriteria = null;
                        } else if (im == InversionModels.CHAR_CONSTRAINED) {
                            mins = constrained_run_mins;
                            nonNeg = NonnegativityConstraintType.LIMIT_ZERO_RATES;
                            checkPointCriteria = null;
                        } else {
                            mins = 60;
                            nonNeg = NonnegativityConstraintType.LIMIT_ZERO_RATES;
                            checkPointCriteria = null;
                        }
                        if (noNonNeg) {
                            nonNeg = null;
                        }
                        int ppn = site.getPPN(branch);
                        TimeCompletionCriteria criteria = TimeCompletionCriteria.getInMinutes(mins);
                        javaWriter.setMaxHeapSizeMB(site.getMaxHeapSizeMB(branch));
                        javaWriter.setInitialHeapSizeMB(site.getInitialHeapSizeMB(branch));
                        block13: for (int r = runStart; r < numRuns; ++r) {
                            Object jobName = name;
                            if (numRuns > 1) {
                                Object rStr = "" + r;
                                while (((String)rStr).length() < runDigits) {
                                    rStr = "0" + (String)rStr;
                                }
                                jobName = (String)jobName + "_run" + (String)rStr;
                            }
                            if (cnt == overallMaxJobs) break block6;
                            if (ignores != null) {
                                for (String ignore : ignores) {
                                    if (!((String)jobName).startsWith(ignore)) continue;
                                    ++ignoreCnt;
                                    continue block13;
                                }
                            }
                            File pbs = new File(writeDir, (String)jobName + ".pbs");
                            System.out.println("Writing: " + pbs.getName());
                            int jobMins = mins + 60;
                            if (jobMins > maxJobMins) {
                                maxJobMins = jobMins;
                            }
                            String className = CommandLineInversionRunner.class.getName();
                            Object classArgs = ThreadedSimulatedAnnealing.completionCriteriaToArgument(criteria);
                            classArgs = (String)classArgs + " " + ThreadedSimulatedAnnealing.subCompletionCriteriaToArgument(subCompletion);
                            if (keepCurrentAsBest) {
                                classArgs = (String)classArgs + " --cur-as-best";
                            }
                            if (cool != null) {
                                classArgs = (String)classArgs + " --cool " + cool.name();
                            }
                            if (nonNeg != null) {
                                classArgs = (String)classArgs + " --nonneg " + nonNeg.name();
                            }
                            classArgs = (String)classArgs + " --num-threads " + threads;
                            if (checkPointCriteria != null) {
                                classArgs = (String)classArgs + " --checkpoint " + checkPointCriteria.getTimeStr();
                            }
                            classArgs = (String)classArgs + " --branch-prefix " + (String)jobName;
                            classArgs = (String)classArgs + " --directory " + runSubDir.getAbsolutePath();
                            if (lightweight && r > 0) {
                                classArgs = (String)classArgs + " --lightweight";
                            }
                            if (noPlots) {
                                classArgs = (String)classArgs + " --no-plots";
                            }
                            for (CustomArg variation : customArgArray) {
                                if (variation == null) continue;
                                classArgs = (String)classArgs + " " + variation.op.getCommandLineArgs(variation.arg);
                            }
                            for (InversionArg invArg : invArgs) {
                                if (invArg == null) continue;
                                classArgs = (String)classArgs + " " + invArg.arg;
                            }
                            argsList.add(classArgs);
                            batch.writeScript(pbs, javaWriter.buildScript(className, (String)classArgs), jobMins, 1, ppn, queue);
                            nodeHours += (double)mins / 60.0;
                            ++cnt;
                        }
                    }
                }
            }
        }
        System.out.println("Wrote " + cnt + " jobs (ignored " + ignoreCnt + ")");
        System.out.println("Node hours: " + (float)nodeHours + " (/60: " + (float)nodeHours / 60.0f + ") (/14: " + (float)nodeHours / 14.0f + ")");
        if (batchSize > 0) {
            System.out.println("Writing batches!");
            LogicTreePBSWriter.writeMPJDispatchJob(site, argsList, numRuns, batchSize, jobsPerNode, maxJobMins, queue, runSubDir, writeDir);
        }
        System.exit(0);
    }

    public static void writeMPJDispatchJob(RunSites site, List<String> argsList, int numRuns, int maxNodes, int jobsPerNode, int maxRuntimeMins, String queue, File remoteDir, File writeDir) throws IOException {
        if (numRuns > 1) {
            ArrayList sortedArgsList = Lists.newArrayList();
            Preconditions.checkState((argsList.size() % numRuns == 0 ? 1 : 0) != 0);
            int numBranches = argsList.size() / numRuns;
            for (int r = 0; r < numRuns; ++r) {
                for (int i = 0; i < numBranches; ++i) {
                    int index = i * numRuns + r;
                    sortedArgsList.add((String)argsList.get(index));
                }
            }
            argsList = sortedArgsList;
        }
        int maxJobsPerBatch = maxNodes * jobsPerNode;
        ArrayList bins = Lists.newArrayList();
        ArrayList curBin = Lists.newArrayList();
        for (String args : argsList) {
            if (curBin.size() == maxJobsPerBatch) {
                bins.add(curBin);
                curBin = Lists.newArrayList();
            }
            curBin.add(args);
        }
        if (!curBin.isEmpty()) {
            bins.add(curBin);
        }
        int numLen = ("" + (bins.size() - 1)).length();
        BatchScriptWriter batch = site.forBranch(null);
        int jobMins = maxRuntimeMins + 60;
        int ppn = site.getPPN(null);
        JavaShellScriptWriter mpjWrite = site.fastMPJ ? new FastMPJShellScriptWriter(site.JAVA_BIN, site.getMaxHeapSizeMB(null), LogicTreePBSWriter.getClasspath(site, remoteDir), site.MPJ_HOME) : new MPJExpressShellScriptWriter(site.JAVA_BIN, site.getMaxHeapSizeMB(null), LogicTreePBSWriter.getClasspath(site, remoteDir), site.MPJ_HOME);
        mpjWrite.setInitialHeapSizeMB(site.getInitialHeapSizeMB(null));
        mpjWrite.setHeadless(true);
        for (int i = 0; i < bins.size(); ++i) {
            String iStr = "" + i;
            while (iStr.length() < numLen) {
                iStr = "0" + iStr;
            }
            List bin = (List)bins.get(i);
            ArrayList binArrays = Lists.newArrayList();
            for (String args : bin) {
                binArrays.add((String[])Iterables.toArray((Iterable)Splitter.on((String)" ").split((CharSequence)args), String.class));
            }
            File xmlFile = new File(writeDir, "batch" + iStr + ".xml");
            MPJInversionDistributor.writeXMLInputFile(binArrays, xmlFile);
            File remoteXMLFile = new File(remoteDir, xmlFile.getName());
            String args = "--exact-dispatch " + jobsPerNode + " " + remoteXMLFile.getAbsolutePath();
            List<String> script = mpjWrite.buildScript(MPJInversionDistributor.class.getName(), args);
            double nodesNeeded = (double)bin.size() / (double)jobsPerNode;
            int nodes = (int)Math.ceil(nodesNeeded);
            File batchFile = new File(writeDir, "batch" + iStr + ".pbs");
            batch.writeScript(batchFile, script, jobMins, nodes, ppn, queue);
            System.out.println("Writing " + batchFile.getName() + " (" + nodes + " nodes)");
        }
    }

    private static void writeBinnedJobs(RunSites site, List<String> pbsNames, int runsPerJob, int maxRuntimeMins, File remoteDir, File writeDir) throws IOException {
        Collections.sort(pbsNames, new Comparator<String>(){

            private int parseRun(String name) {
                if (!name.contains("_run")) {
                    return 0;
                }
                name = name.substring(name.indexOf("_run") + 4);
                return Integer.parseInt(name.substring(0, name.indexOf(".pbs")));
            }

            @Override
            public int compare(String o1, String o2) {
                Integer r2;
                Integer r1 = this.parseRun(o1);
                if (r1 == (r2 = Integer.valueOf(this.parseRun(o2)))) {
                    return o1.compareTo(o2);
                }
                return r1.compareTo(r2);
            }
        });
        ArrayList bins = Lists.newArrayList();
        ArrayList curBin = Lists.newArrayList();
        for (String pbsName : pbsNames) {
            if (curBin.size() == runsPerJob) {
                bins.add(curBin);
                curBin = Lists.newArrayList();
            }
            curBin.add(pbsName);
        }
        if (!curBin.isEmpty()) {
            bins.add(curBin);
        }
        int numLen = ("" + (bins.size() - 1)).length();
        BatchScriptWriter batch = site.forBranch(null);
        int jobMins = maxRuntimeMins + 30;
        int ppn = site.getPPN(null);
        for (int i = 0; i < bins.size(); ++i) {
            ArrayList script = Lists.newArrayList();
            int nodeNumber = 1;
            List bin = (List)bins.get(i);
            for (int j = 0; j < bin.size(); ++j) {
                String pbsName = (String)bin.get(j);
                script.add("");
                script.add("# run " + nodeNumber + ": " + pbsName);
                script.add("node=`sed -n '" + nodeNumber + "p' $PBS_NODEFILE`");
                File pbsFile = new File(remoteDir, pbsName);
                File pbsStdOutFile = new File(remoteDir, pbsName + ".output");
                script.add("chmod u+x " + pbsFile.getAbsolutePath());
                if (j == bin.size() - 1) {
                    script.add("ssh $node \"sh -c '" + pbsFile.getAbsolutePath() + " > " + pbsStdOutFile.getAbsolutePath() + " 2>&1'\"");
                } else {
                    script.add("ssh -n -f $node \"sh -c 'nohup " + pbsFile.getAbsolutePath() + " > " + pbsStdOutFile.getAbsolutePath() + " 2>&1 &'\"");
                }
                ++nodeNumber;
            }
            script.add("# sleep for 30 mins to make sure everything is done");
            script.add("sleep 1800");
            int nodes = bin.size();
            String iStr = "" + i;
            while (iStr.length() < numLen) {
                iStr = "0" + iStr;
            }
            File batchFile = new File(writeDir, "batch" + iStr + ".pbs");
            batch.writeScript(batchFile, script, jobMins, nodes, ppn, null);
            System.out.println("Writing " + batchFile.getName() + " (" + nodes + " nodes)");
        }
    }

    public static enum RunSites {
        EPICENTER("/home/epicenter/kmilner/inversions", EpicenterScriptWriter.JAVA_BIN, null, null, false){

            @Override
            public BatchScriptWriter forBranch(U3LogicTreeBranch branch) {
                InversionModels im = branch.getValue(InversionModels.class);
                Preconditions.checkState((im != InversionModels.GR_CONSTRAINED ? 1 : 0) != 0, (Object)"are you kidding me? we can't run GR on epicenter!");
                return new EpicenterScriptWriter();
            }

            @Override
            public int getMaxHeapSizeMB(U3LogicTreeBranch branch) {
                return 7000;
            }

            @Override
            public int getPPN(U3LogicTreeBranch branch) {
                return 8;
            }
        }
        ,
        HPCC("/home/scec-02/kmilner/ucerf3/inversions", USC_HPCC_ScriptWriter.JAVA_BIN, null, USC_HPCC_ScriptWriter.MPJ_HOME, false){

            @Override
            public BatchScriptWriter forBranch(U3LogicTreeBranch branch) {
                return new USC_HPCC_ScriptWriter();
            }

            @Override
            public int getMaxHeapSizeMB(U3LogicTreeBranch branch) {
                return 60000;
            }

            @Override
            public int getPPN(U3LogicTreeBranch branch) {
                return 20;
            }
        }
        ,
        RANGER("/work/00950/kevinm/ucerf3/inversion", RangerScriptWriter.JAVA_BIN, null, RangerScriptWriter.FMPJ_HOME, true){

            @Override
            public BatchScriptWriter forBranch(U3LogicTreeBranch branch) {
                return new RangerScriptWriter();
            }

            @Override
            public int getMaxHeapSizeMB(U3LogicTreeBranch branch) {
                return 20000;
            }

            @Override
            public int getPPN(U3LogicTreeBranch branch) {
                return 16;
            }
        }
        ,
        STAMPEDE("/work/00950/kevinm/ucerf3/inversion", StampedeScriptWriter.JAVA_BIN, null, StampedeScriptWriter.FMPJ_HOME, true){

            @Override
            public BatchScriptWriter forBranch(U3LogicTreeBranch branch) {
                return new StampedeScriptWriter();
            }

            @Override
            public int getMaxHeapSizeMB(U3LogicTreeBranch branch) {
                return 25000;
            }

            @Override
            public int getPPN(U3LogicTreeBranch branch) {
                return 16;
            }
        };

        private File RUN_DIR;
        private File JAVA_BIN;
        private String FM_STORE;
        private File MPJ_HOME;
        private boolean fastMPJ;

        private RunSites(String path, File javaBin, String fmStore, File mpjHome, boolean fastMPJ) {
            this.RUN_DIR = new File(path);
            this.JAVA_BIN = javaBin;
            this.FM_STORE = fmStore;
            this.MPJ_HOME = mpjHome;
            this.fastMPJ = fastMPJ;
        }

        public abstract BatchScriptWriter forBranch(U3LogicTreeBranch var1);

        public abstract int getMaxHeapSizeMB(U3LogicTreeBranch var1);

        public int getInitialHeapSizeMB(U3LogicTreeBranch branch) {
            return this.getMaxHeapSizeMB(branch);
        }

        public abstract int getPPN(U3LogicTreeBranch var1);

        public File getRUN_DIR() {
            return this.RUN_DIR;
        }

        public File getJAVA_BIN() {
            return this.JAVA_BIN;
        }

        public String getFM_STORE() {
            return this.FM_STORE;
        }

        public File getMPJ_HOME() {
            return this.MPJ_HOME;
        }

        public boolean isFastMPJ() {
            return this.fastMPJ;
        }
    }

    private static class CustomArg {
        private CommandLineInversionRunner.InversionOptions op;
        private String arg;

        public CustomArg(CommandLineInversionRunner.InversionOptions op, String arg) {
            this.op = op;
            if (op.hasOption()) {
                Preconditions.checkState((arg != null && !arg.isEmpty() ? 1 : 0) != 0);
            } else {
                Preconditions.checkState((arg == null || arg.isEmpty() ? 1 : 0) != 0);
            }
            this.arg = arg;
        }
    }

    private static class VariableLogicTreeBranch
    extends U3LogicTreeBranch {
        CustomArg[] args;

        public VariableLogicTreeBranch(CustomArg[] args, boolean setNullToDefault, U3LogicTreeBranchNode<?> ... branchChoices) {
            this(args, U3LogicTreeBranch.fromValues(setNullToDefault, branchChoices));
        }

        public VariableLogicTreeBranch(CustomArg[] args, U3LogicTreeBranch branch) {
            super(branch);
            this.args = args;
        }

        @Override
        public int getNumAwayFrom(U3LogicTreeBranch branch) {
            int num = super.getNumAwayFrom(branch);
            if (!(branch instanceof VariableLogicTreeBranch)) {
                return num;
            }
            VariableLogicTreeBranch variableBranch = (VariableLogicTreeBranch)branch;
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    CustomArg myArg = this.args[i];
                    if (myArg == null) continue;
                    if (variableBranch.args == null || variableBranch.args.length <= i) {
                        ++num;
                        break;
                    }
                    CustomArg theirArg = variableBranch.args[i];
                    if (theirArg.op != myArg.op) {
                        ++num;
                        break;
                    }
                    if (myArg.arg == null && theirArg.arg != null) {
                        ++num;
                        break;
                    }
                    if (myArg.arg.equals(theirArg.arg)) continue;
                    ++num;
                    break;
                }
            }
            return num;
        }
    }

    private static class InversionArg {
        private String arg;
        private String prefix;

        public InversionArg(String arg, String prefix) {
            this.arg = arg;
            this.prefix = prefix;
        }
    }
}

