/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.simulatedAnnealing.hpc;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.opensha.commons.hpc.JavaShellScriptWriter;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ThreadedSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.TimeCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.CoolingScheduleType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.GenerationFunctionType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.params.NonnegativityConstraintType;

public class ThreadedScriptCreator {
    private JavaShellScriptWriter writer;
    private File aMat;
    private File dMat;
    private File a_ineqMat;
    private File d_ineqMat;
    private File initial;
    private File zipFile;
    private String numThreads;
    private File solFile;
    private CompletionCriteria criteria;
    private CompletionCriteria subCompletion;
    private TimeCompletionCriteria checkPointCriteria;
    private File progFile;
    private CoolingScheduleType cool;
    private GenerationFunctionType perturb;
    private NonnegativityConstraintType nonNeg;
    private boolean setSubIterationsZero = false;
    private boolean plots = false;

    public ThreadedScriptCreator(JavaShellScriptWriter writer, String numThreads, File solFile, CompletionCriteria criteria, CompletionCriteria subCompletion) {
        this.writer = writer;
        this.numThreads = numThreads;
        this.solFile = solFile;
        this.criteria = criteria;
        this.subCompletion = subCompletion;
    }

    public String getArgs() {
        String args;
        Preconditions.checkNotNull((Object)this.subCompletion, (Object)"subCompletion cannot be null");
        Preconditions.checkNotNull((Object)this.numThreads, (Object)"numThreads cannot be null");
        Preconditions.checkState((!this.numThreads.isEmpty() ? 1 : 0) != 0, (Object)"numThreads cannot be blank");
        Preconditions.checkNotNull((Object)this.solFile, (Object)"solution file is required!");
        if (this.zipFile == null) {
            Preconditions.checkNotNull((Object)this.aMat, (Object)"A matrix file is required!");
            Preconditions.checkNotNull((Object)this.dMat, (Object)"d matrix file is required!");
            args = "--a-matrix-file " + this.aMat.getAbsolutePath() + " --d-matrix-file " + this.dMat.getAbsolutePath();
            if (this.a_ineqMat != null) {
                args = (String)args + " --a-ineq-matrix-file " + this.a_ineqMat.getAbsolutePath() + " --d-ineq-matrix-file " + this.d_ineqMat.getAbsolutePath();
            }
        } else {
            args = "--zip-file " + this.zipFile.getAbsolutePath();
        }
        if (this.initial != null) {
            args = args + " --initial-state-file " + this.initial.getAbsolutePath();
        }
        args = args + " --num-threads " + this.numThreads + " --solution-file " + this.solFile.getAbsolutePath();
        Preconditions.checkNotNull((Object)this.criteria, (Object)"Criteria cannot be null!");
        args = args + " " + ThreadedSimulatedAnnealing.completionCriteriaToArgument(this.criteria);
        Preconditions.checkNotNull((Object)this.subCompletion, (Object)"subCompletion cannot be null!");
        args = args + " " + ThreadedSimulatedAnnealing.subCompletionCriteriaToArgument(this.subCompletion);
        if (this.progFile != null) {
            args = args + " --progress-file " + this.progFile.getAbsolutePath();
        }
        if (this.setSubIterationsZero) {
            args = args + " --start-sub-iters-zero";
        }
        if (this.cool != null) {
            args = args + " --cool " + this.cool.name();
        }
        if (this.perturb != null) {
            args = args + " --perturb " + this.perturb.name();
        }
        if (this.nonNeg != null) {
            args = args + " --nonneg " + this.nonNeg.name();
        }
        if (this.checkPointCriteria != null) {
            args = args + " --checkpoint " + this.checkPointCriteria.getTimeStr();
        }
        if (this.plots) {
            args = args + " --plots";
        }
        return args;
    }

    public String getClassName() {
        return ThreadedSimulatedAnnealing.class.getName();
    }

    public List<String> buildScript() {
        return this.writer.buildScript(this.getClassName(), this.getArgs());
    }

    public void writeScript(File file, List<String> script) throws IOException {
        JavaShellScriptWriter.writeScript(file, script);
    }

    public void setaMat(File aMat) {
        this.aMat = aMat;
    }

    public void setdMat(File dMat) {
        this.dMat = dMat;
    }

    public void setInitial(File initial) {
        this.initial = initial;
    }

    public void setA_ineqMat(File a_ineqMat) {
        this.a_ineqMat = a_ineqMat;
    }

    public void setD_ineqMat(File d_ineqMat) {
        this.d_ineqMat = d_ineqMat;
    }

    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    public void setSubCompletion(CompletionCriteria subCompletion) {
        this.subCompletion = subCompletion;
    }

    public void setNumThreads(String numThreads) {
        this.numThreads = numThreads;
    }

    public void setSolFile(File solFile) {
        this.solFile = solFile;
    }

    public void setProgFile(File progFile) {
        this.progFile = progFile;
    }

    public void setCriteria(CompletionCriteria criteria) {
        this.criteria = criteria;
    }

    public void setCool(CoolingScheduleType cool) {
        this.cool = cool;
    }

    public void setPerturb(GenerationFunctionType perturb) {
        this.perturb = perturb;
    }

    public void setNonNeg(NonnegativityConstraintType nonNeg) {
        this.nonNeg = nonNeg;
    }

    public void setSubIterationsZero(boolean setSubIterationsZero) {
        this.setSubIterationsZero = setSubIterationsZero;
    }

    public TimeCompletionCriteria getCheckPointCriteria() {
        return this.checkPointCriteria;
    }

    public void setCheckPointCriteria(TimeCompletionCriteria checkPointCriteria) {
        this.checkPointCriteria = checkPointCriteria;
    }

    public void setPlots(boolean plots) {
        this.plots = plots;
    }

    public boolean isPlots() {
        return this.plots;
    }
}

