/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.data.NamedComparator;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.DeformationModelPrefDataFinal;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.PrefFaultSectionDataFinal;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.GriddedSurfaceUtils;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.UCERF3SectionConnectionStrategy;
import scratch.UCERF3.utils.DeformationModelFileParser;
import scratch.UCERF3.utils.FaultSectionDataWriter;
import scratch.UCERF3.utils.QuickSurfaceDistanceCalculator;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class DeformationModelFetcher {
    protected static final boolean D = false;
    private static final boolean CUSTOM_PARKFIELD_CREEPING_SECTION_MOMENT_REDUCTIONS = true;
    private static final double[] creep_mo_reds = new double[]{0.9112, 0.9361, 0.9557, 0.9699, 0.9786, 0.9819, 0.9796, 0.9719, 0.9585, 0.9396, 0.915, 0.8847, 0.8487, 0.8069, 0.7593, 0.7059, 0.6466, 0.5814, 0.5103, 0.4331, 0.35};
    private static final double[] parkfield_mo_reds = new double[]{0.5, 0.5571, 0.6143, 0.6714, 0.7286, 0.7857, 0.8429, 0.9};
    private static final double[] custom_mendocino_couplings = new double[]{1.0, 1.0, 0.15, 0.15, 0.15};
    private static final double brawley_aseis = 0.9;
    private static final double quien_sabe_aseis = 0.9;
    static final double MOMENT_REDUCTION_THRESHOLD = 0.9;
    public static final double MOMENT_REDUCTION_MAX = 0.95;
    private static final int GLEN_IVY_STEPOVER_FAULT_SECTION_ID = 297;
    private static final int TEMECULA_STEPOVER_FAULT_SECTION_ID = 298;
    private static final int ELSINORE_COMBINED_STEPOVER_FAULT_SECTION_ID = 402;
    private static final int SJ_VALLEY_STEPOVER_FAULT_SECTION_ID = 290;
    private static final int SJ_ANZA_STEPOVER_FAULT_SECTION_ID = 291;
    private static final int SJ_COMBINED_STEPOVER_FAULT_SECTION_ID = 401;
    private static final double POLY_BUFFER_DEFAULT = 12.0;
    private DeformationModels chosenDefModName;
    private FaultModels faultModel;
    private FaultGridAssociations polyMgr;
    String fileNamePrefix;
    File precomputedDataDir;
    public static final String SUB_DIR_NAME = "FaultSystemRupSets";
    List<FaultSection> faultSectPrefDataList;
    List<FaultSection> faultSubSectPrefDataList;
    HashMap<Integer, FaultSection> faultSubSectPrefDataIDMap;
    static int ucerf2_DefModelId = 82;
    static boolean alphabetize = true;
    public static boolean IMPERIAL_DDW_HACK = false;
    private static Table<FaultModels, DeformationModels, Map<IDPairing, Double>> distCache = HashBasedTable.create();

    public DeformationModelFetcher(FaultModels faultModel, DeformationModels deformationModel, File precomputedDataDir, double defaultAseismicityValue) {
        File parent;
        double maxSubSectionLength = 0.5;
        if (precomputedDataDir != null && !precomputedDataDir.exists() && (parent = precomputedDataDir.getParentFile()) != null && parent.getName().equals("scratch")) {
            precomputedDataDir.mkdir();
        }
        this.precomputedDataDir = new File(precomputedDataDir, SUB_DIR_NAME);
        Preconditions.checkArgument((boolean)deformationModel.isApplicableTo(faultModel), (Object)"Deformation model and fault model aren't compatible!");
        this.chosenDefModName = deformationModel;
        this.faultModel = faultModel;
        if (deformationModel.getDataFileURL(faultModel) != null || deformationModel == DeformationModels.MEAN_UCERF3) {
            URL url = deformationModel.getDataFileURL(faultModel);
            try {
                Map<Integer, DeformationModelFileParser.DeformationSection> model = deformationModel == DeformationModels.MEAN_UCERF3 ? DeformationModelFileParser.loadMeanUCERF3_DM(faultModel) : DeformationModelFileParser.load(url);
                DeformationModelFileParser.applyMomentReductions(model, 0.95);
                this.faultSectPrefDataList = faultModel.getFaultSections();
                Map<Integer, DeformationModelFileParser.DeformationSection> rakesModel = null;
                this.faultSubSectPrefDataList = this.loadUCERF3DefModel(this.faultSectPrefDataList, model, maxSubSectionLength, rakesModel, defaultAseismicityValue);
                this.applyCustomGeologicTapers();
                this.fileNamePrefix = deformationModel.name() + "_" + faultModel.name() + "_" + this.faultSubSectPrefDataList.size();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
        } else {
            if (deformationModel == DeformationModels.UCERF2_NCAL) {
                this.faultSubSectPrefDataList = this.createNorthCal_UCERF2_SubSections(false, maxSubSectionLength);
                this.fileNamePrefix = "nCal_0_82_" + this.faultSubSectPrefDataList.size();
            } else if (deformationModel == DeformationModels.UCERF2_ALL) {
                this.faultSubSectPrefDataList = this.createAll_UCERF2_SubSections(false, maxSubSectionLength);
                this.fileNamePrefix = "all_0_82_" + this.faultSubSectPrefDataList.size();
            } else if (deformationModel == DeformationModels.UCERF2_BAYAREA) {
                this.faultSubSectPrefDataList = this.createBayAreaSubSections(maxSubSectionLength);
                this.fileNamePrefix = "bayArea_0_82_" + this.faultSubSectPrefDataList.size();
            } else {
                throw new IllegalStateException("Deformation model couldn't be loaded: " + String.valueOf(deformationModel));
            }
            if (defaultAseismicityValue > 0.0) {
                Preconditions.checkState((defaultAseismicityValue < 1.0 ? 1 : 0) != 0, (Object)"asesimicity values must be in the range (0,1)");
                for (FaultSection data : this.faultSubSectPrefDataList) {
                    if (data.getAseismicSlipFactor() != 0.0) continue;
                    data.setAseismicSlipFactor(defaultAseismicityValue);
                }
            }
        }
        this.faultSubSectPrefDataIDMap = new HashMap();
        for (FaultSection data : this.faultSubSectPrefDataList) {
            int id = data.getSectionId();
            Preconditions.checkState((!this.faultSubSectPrefDataIDMap.containsKey(id) ? 1 : 0) != 0, (Object)("multiple sub sections exist with ID: " + id));
            this.faultSubSectPrefDataIDMap.put(id, data);
        }
    }

    public DeformationModels getDeformationModel() {
        return this.chosenDefModName;
    }

    public FaultModels getFaultModel() {
        return this.faultModel;
    }

    public FaultGridAssociations getPolyMgr() {
        return this.polyMgr;
    }

    public List<? extends FaultSection> getSubSectionList() {
        return this.faultSubSectPrefDataList;
    }

    public List<? extends FaultSection> getParentSectionList() {
        return this.faultSectPrefDataList;
    }

    private List<FaultSection> createAll_UCERF2_SubSections(boolean includeSectionsWithNaN_slipRates, double maxSubSectionLength) {
        DeformationModelPrefDataFinal deformationModelPrefDB = new DeformationModelPrefDataFinal();
        List<FaultSection> allFaultSectionPrefData = this.getAll_UCERF2Sections(includeSectionsWithNaN_slipRates);
        ArrayList<FaultSection> subSectionPrefDataList = new ArrayList<FaultSection>();
        int subSectionIndex = 0;
        for (int i = 0; i < allFaultSectionPrefData.size(); ++i) {
            FaultSectionPrefData faultSectionPrefData = (FaultSectionPrefData)allFaultSectionPrefData.get(i);
            String name = faultSectionPrefData.getName();
            double maxSectLength = faultSectionPrefData.getOrigDownDipWidth() * maxSubSectionLength;
            List<? extends FaultSection> subSectData = faultSectionPrefData.getSubSectionsList(maxSectLength, subSectionIndex);
            subSectionIndex += subSectData.size();
            subSectionPrefDataList.addAll(subSectData);
        }
        this.faultSectPrefDataList = allFaultSectionPrefData;
        return subSectionPrefDataList;
    }

    private List<FaultSection> createNorthCal_UCERF2_SubSections(boolean includeSectionsWithNaN_slipRates, double maxSubSectionLength) {
        DeformationModelPrefDataFinal deformationModelPrefDB = new DeformationModelPrefDataFinal();
        List<FaultSection> allFaultSectionPrefData = this.getAll_UCERF2Sections(includeSectionsWithNaN_slipRates);
        CaliforniaRegions.RELM_NOCAL relm_nocal_reg = new CaliforniaRegions.RELM_NOCAL();
        Region mod_relm_nocal_reg = new Region(relm_nocal_reg.getBorder(), BorderType.GREAT_CIRCLE);
        ArrayList<FaultSection> nCalFaultSectionPrefData = new ArrayList<FaultSection>();
        for (FaultSection sectData : allFaultSectionPrefData) {
            FaultTrace trace = sectData.getFaultTrace();
            Location endLoc1 = (Location)trace.get(0);
            Location endLoc2 = (Location)trace.get(trace.size() - 1);
            if (!mod_relm_nocal_reg.contains(endLoc1) && !mod_relm_nocal_reg.contains(endLoc2)) continue;
            nCalFaultSectionPrefData.add(sectData);
        }
        this.faultSectPrefDataList = allFaultSectionPrefData;
        ArrayList<FaultSection> subSectionPrefDataList = new ArrayList<FaultSection>();
        int subSectionIndex = 0;
        for (int i = 0; i < nCalFaultSectionPrefData.size(); ++i) {
            FaultSection faultSectionPrefData = (FaultSection)nCalFaultSectionPrefData.get(i);
            double maxSectLength = faultSectionPrefData.getOrigDownDipWidth() * maxSubSectionLength;
            List<? extends FaultSection> subSectData = faultSectionPrefData.getSubSectionsList(maxSectLength, subSectionIndex);
            subSectionIndex += subSectData.size();
            subSectionPrefDataList.addAll(subSectData);
        }
        return subSectionPrefDataList;
    }

    private List<FaultSection> getAll_UCERF2Sections(boolean includeSectionsWithNaN_slipRates) {
        int i;
        DeformationModelPrefDataFinal deformationModelPrefDB = new DeformationModelPrefDataFinal();
        ArrayList<FaultSectionPrefData> prelimFaultSectionPrefData = deformationModelPrefDB.getAllFaultSectionPrefData(ucerf2_DefModelId);
        ArrayList<FaultSection> allFaultSectionPrefData = new ArrayList<FaultSection>();
        FaultSectionPrefData glenIvyStepoverfaultSectionPrefData = null;
        FaultSectionPrefData temeculaStepoverfaultSectionPrefData = null;
        FaultSectionPrefData anzaStepoverfaultSectionPrefData = null;
        FaultSectionPrefData valleyStepoverfaultSectionPrefData = null;
        for (FaultSectionPrefData data : prelimFaultSectionPrefData) {
            int id = data.getSectionId();
            if (id == 297) {
                glenIvyStepoverfaultSectionPrefData = data;
                continue;
            }
            if (id == 298) {
                temeculaStepoverfaultSectionPrefData = data;
                continue;
            }
            if (id == 291) {
                anzaStepoverfaultSectionPrefData = data;
                continue;
            }
            if (id == 290) {
                valleyStepoverfaultSectionPrefData = data;
                continue;
            }
            allFaultSectionPrefData.add(data);
        }
        PrefFaultSectionDataFinal faultSectionDataFinal = new PrefFaultSectionDataFinal();
        FaultSectionPrefData newElsinoreSectionData = faultSectionDataFinal.getFaultSectionPrefData(402);
        newElsinoreSectionData.setAveSlipRate(glenIvyStepoverfaultSectionPrefData.getOrigAveSlipRate() + temeculaStepoverfaultSectionPrefData.getOrigAveSlipRate());
        newElsinoreSectionData.setSlipRateStdDev(glenIvyStepoverfaultSectionPrefData.getOrigSlipRateStdDev() + temeculaStepoverfaultSectionPrefData.getOrigSlipRateStdDev());
        allFaultSectionPrefData.add(newElsinoreSectionData);
        FaultSectionPrefData newSanJacinntoSectionData = faultSectionDataFinal.getFaultSectionPrefData(401);
        newSanJacinntoSectionData.setAveSlipRate(anzaStepoverfaultSectionPrefData.getOrigAveSlipRate() + valleyStepoverfaultSectionPrefData.getOrigAveSlipRate());
        newSanJacinntoSectionData.setSlipRateStdDev(anzaStepoverfaultSectionPrefData.getOrigSlipRateStdDev() + valleyStepoverfaultSectionPrefData.getOrigSlipRateStdDev());
        allFaultSectionPrefData.add(newSanJacinntoSectionData);
        if (alphabetize) {
            Collections.sort(allFaultSectionPrefData, new NamedComparator());
        }
        if (!includeSectionsWithNaN_slipRates) {
            for (i = allFaultSectionPrefData.size() - 1; i >= 0; --i) {
                if (!Double.isNaN(allFaultSectionPrefData.get(i).getOrigAveSlipRate())) continue;
                allFaultSectionPrefData.remove(i);
            }
        }
        for (i = 0; i < allFaultSectionPrefData.size(); ++i) {
            if (allFaultSectionPrefData.get(i).getSectionId() != 13) continue;
            allFaultSectionPrefData.remove(i);
        }
        return allFaultSectionPrefData;
    }

    public static ArrayList<FaultSectionPrefData> getAll_UCERF2Sections(boolean includeSectionsWithNaN_slipRates, int u2_DefModelId) {
        int i;
        DeformationModelPrefDataFinal deformationModelPrefDB = new DeformationModelPrefDataFinal();
        ArrayList<FaultSectionPrefData> prelimFaultSectionPrefData = deformationModelPrefDB.getAllFaultSectionPrefData(u2_DefModelId);
        ArrayList<FaultSectionPrefData> allFaultSectionPrefData = new ArrayList<FaultSectionPrefData>();
        FaultSectionPrefData glenIvyStepoverfaultSectionPrefData = null;
        FaultSectionPrefData temeculaStepoverfaultSectionPrefData = null;
        FaultSectionPrefData anzaStepoverfaultSectionPrefData = null;
        FaultSectionPrefData valleyStepoverfaultSectionPrefData = null;
        for (FaultSectionPrefData data : prelimFaultSectionPrefData) {
            int id = data.getSectionId();
            if (id == 297) {
                glenIvyStepoverfaultSectionPrefData = data;
                continue;
            }
            if (id == 298) {
                temeculaStepoverfaultSectionPrefData = data;
                continue;
            }
            if (id == 291) {
                anzaStepoverfaultSectionPrefData = data;
                continue;
            }
            if (id == 290) {
                valleyStepoverfaultSectionPrefData = data;
                continue;
            }
            allFaultSectionPrefData.add(data);
        }
        PrefFaultSectionDataFinal faultSectionDataFinal = new PrefFaultSectionDataFinal();
        FaultSectionPrefData newElsinoreSectionData = faultSectionDataFinal.getFaultSectionPrefData(402);
        newElsinoreSectionData.setAveSlipRate(glenIvyStepoverfaultSectionPrefData.getOrigAveSlipRate() + temeculaStepoverfaultSectionPrefData.getOrigAveSlipRate());
        newElsinoreSectionData.setSlipRateStdDev(glenIvyStepoverfaultSectionPrefData.getOrigSlipRateStdDev() + temeculaStepoverfaultSectionPrefData.getOrigSlipRateStdDev());
        allFaultSectionPrefData.add(newElsinoreSectionData);
        FaultSectionPrefData newSanJacinntoSectionData = faultSectionDataFinal.getFaultSectionPrefData(401);
        newSanJacinntoSectionData.setAveSlipRate(anzaStepoverfaultSectionPrefData.getOrigAveSlipRate() + valleyStepoverfaultSectionPrefData.getOrigAveSlipRate());
        newSanJacinntoSectionData.setSlipRateStdDev(anzaStepoverfaultSectionPrefData.getOrigSlipRateStdDev() + valleyStepoverfaultSectionPrefData.getOrigSlipRateStdDev());
        allFaultSectionPrefData.add(newSanJacinntoSectionData);
        if (alphabetize) {
            Collections.sort(allFaultSectionPrefData, new NamedComparator());
        }
        if (!includeSectionsWithNaN_slipRates) {
            for (i = allFaultSectionPrefData.size() - 1; i >= 0; --i) {
                if (!Double.isNaN(allFaultSectionPrefData.get(i).getOrigAveSlipRate())) continue;
                allFaultSectionPrefData.remove(i);
            }
        }
        for (i = 0; i < allFaultSectionPrefData.size(); ++i) {
            if (allFaultSectionPrefData.get(i).getSectionId() != 57) continue;
            allFaultSectionPrefData.remove(i);
        }
        return allFaultSectionPrefData;
    }

    private List<FaultSection> createBayAreaSubSections(double maxSubSectionLength) {
        DeformationModelPrefDataFinal deformationModelPrefDB = new DeformationModelPrefDataFinal();
        ArrayList<Integer> faultSectionIds = new ArrayList<Integer>();
        faultSectionIds.add(26);
        faultSectionIds.add(27);
        faultSectionIds.add(67);
        faultSectionIds.add(56);
        faultSectionIds.add(25);
        faultSectionIds.add(68);
        faultSectionIds.add(69);
        faultSectionIds.add(4);
        faultSectionIds.add(5);
        faultSectionIds.add(55);
        faultSectionIds.add(71);
        faultSectionIds.add(1);
        faultSectionIds.add(3);
        faultSectionIds.add(12);
        faultSectionIds.add(29);
        faultSectionIds.add(6);
        faultSectionIds.add(7);
        faultSectionIds.add(2);
        ArrayList<FaultSection> subSectionPrefDataList = new ArrayList<FaultSection>();
        int subSectIndex = 0;
        this.faultSectPrefDataList = Lists.newArrayList();
        for (int i = 0; i < faultSectionIds.size(); ++i) {
            FaultSectionPrefData faultSectionPrefData = deformationModelPrefDB.getFaultSectionPrefData(ucerf2_DefModelId, (Integer)faultSectionIds.get(i));
            this.faultSectPrefDataList.add(faultSectionPrefData);
            double maxSectLength = faultSectionPrefData.getOrigDownDipWidth() * maxSubSectionLength;
            List subSectData = faultSectionPrefData.getSubSectionsList(maxSectLength, subSectIndex);
            subSectIndex += ((ArrayList)subSectData).size();
            subSectionPrefDataList.addAll(subSectData);
        }
        return subSectionPrefDataList;
    }

    private static List<? extends FaultSection> buildSubSections(FaultSection section, double maxSubSectionLength, int subSectIndex) {
        double ddw = section.getOrigDownDipWidth();
        if (IMPERIAL_DDW_HACK & section.getSectionId() == 97) {
            System.err.println("*** WARNING: USING OLD IMPERIAL DDW FOR SUBSECTIONING! HACK HACK HACK!!! ***");
            ddw = (double)14.6f / Math.sin(section.getAveDip() * Math.PI / 180.0);
            System.out.println("OLD SECTIONING HAS: " + section.getSubSectionsList(ddw * maxSubSectionLength, subSectIndex, 2).size());
            System.out.println("NEW SECTIONING HAS: " + section.getSubSectionsList(section.getOrigDownDipWidth() * maxSubSectionLength, subSectIndex, 2).size());
        }
        double maxSectLength = ddw * maxSubSectionLength;
        return section.getSubSectionsList(maxSectLength, subSectIndex, 2);
    }

    protected static HashMap<Integer, DeformationModelFileParser.DeformationSection> getFixedModel(ArrayList<FaultSectionPrefData> sections, HashMap<Integer, DeformationModelFileParser.DeformationSection> model, DeformationModels dm) {
        HashMap<Integer, DeformationModelFileParser.DeformationSection> fixed = new HashMap<Integer, DeformationModelFileParser.DeformationSection>();
        for (FaultSectionPrefData section : sections) {
            List<Double> slips;
            int i;
            int sectID = section.getSectionId();
            if (sectID == 402 && model.containsKey(297) && model.containsKey(298) && model.containsKey(402)) {
                DeformationModelFileParser.DeformationSection def297 = model.get(297);
                DeformationModelFileParser.DeformationSection def298 = model.get(298);
                DeformationModelFileParser.DeformationSection def402 = model.get(402);
                System.out.println("Fixing Elsinore Special Case!");
                double slips297 = DeformationModelFetcher.getLengthBasedAverage(def297.getLocsAsTrace(), def297.getSlips());
                double slips298 = DeformationModelFetcher.getLengthBasedAverage(def298.getLocsAsTrace(), def298.getSlips());
                double slips402 = DeformationModelFetcher.getLengthBasedAverage(def402.getLocsAsTrace(), def402.getSlips());
                double combinedSlip = 0.0;
                if (!Double.isNaN(slips297)) {
                    combinedSlip += slips297;
                }
                if (!Double.isNaN(slips298)) {
                    combinedSlip += slips298;
                }
                if (!Double.isNaN(slips402)) {
                    combinedSlip += slips402;
                }
                model.remove(297);
                model.remove(298);
                List<Double> slipsList = def402.getSlips();
                for (i = 0; i < slipsList.size(); ++i) {
                    slipsList.set(i, combinedSlip);
                }
            }
            FaultTrace trace = section.getFaultTrace();
            DeformationModelFileParser.DeformationSection def = model.get(sectID);
            if (sectID == 294) {
                if (dm == DeformationModels.ABM || dm == DeformationModels.GEOBOUND || dm == DeformationModels.ZENG) {
                    System.out.println("Setting rate on San Andreas (North Branch Mill Creek) to 2mm for " + String.valueOf(dm));
                    slips = def.getSlips();
                    for (int i2 = 0; i2 < slips.size(); ++i2) {
                        slips.set(i2, 2.0);
                    }
                }
            } else if (sectID == 284) {
                if (dm == DeformationModels.ABM) {
                    System.out.println("Setting rate on San Andreas (San Gorgonio Pass-Garnet HIll) for " + String.valueOf(dm));
                    slips = def.getSlips();
                    slips.set(0, 18.56823);
                    slips.set(1, 18.72589);
                    slips.set(2, 19.0792);
                    slips.set(3, 19.9856);
                    slips.set(4, 19.5641);
                    slips.set(5, 17.534);
                    slips.set(6, 4.3732);
                    slips.set(7, 6.44856);
                } else if (dm == DeformationModels.GEOBOUND) {
                    System.out.println("Setting rate on San Andreas (San Gorgonio Pass-Garnet HIll) for " + String.valueOf(dm));
                    slips = def.getSlips();
                    slips.set(0, 26.15245);
                    slips.set(1, 25.958323);
                    slips.set(2, 27.08835);
                    slips.set(3, 28.54066);
                    slips.set(4, 29.2336);
                    slips.set(5, 26.6797);
                    slips.set(6, 16.48237);
                    slips.set(7, 18.79608);
                } else if (dm == DeformationModels.ZENG) {
                    System.out.println("Setting rate on San Andreas (San Gorgonio Pass-Garnet HIll) for " + String.valueOf(dm));
                    slips = def.getSlips();
                    for (int i3 = 0; i3 < slips.size(); ++i3) {
                        slips.set(i3, 7.71);
                    }
                }
            } else if (sectID == 282) {
                if (dm == DeformationModels.ABM) {
                    System.out.println("Setting rate on San Andreas (San Bernardino N) for " + String.valueOf(dm));
                    slips = def.getSlips();
                    slips.set(3, 17.132);
                } else if (dm == DeformationModels.GEOBOUND) {
                    System.out.println("Setting rate on San Andreas (San Bernardino N) for " + String.valueOf(dm));
                    slips = def.getSlips();
                    slips.set(3, 20.0);
                } else if (dm == DeformationModels.ZENG) {
                    System.out.println("Setting rate on San Andreas (San Bernardino N) for " + String.valueOf(dm));
                    slips = def.getSlips();
                    slips.set(3, 16.12);
                }
            } else if (sectID == 283) {
                if (dm == DeformationModels.ABM) {
                    System.out.println("Setting rate on San Andreas (San Bernardino S) for " + String.valueOf(dm));
                    slips = def.getSlips();
                    slips.set(0, 7.1185);
                    slips.set(1, 6.93328);
                    slips.set(2, 6.97722);
                    slips.set(3, 6.175124);
                    slips.set(4, 6.48748);
                } else if (dm == DeformationModels.GEOBOUND) {
                    System.out.println("Setting rate on San Andreas (San Bernardino S) for " + String.valueOf(dm));
                    slips = def.getSlips();
                    slips.set(0, 15.97851);
                    slips.set(1, 15.79637);
                    slips.set(2, 16.21834);
                    slips.set(3, 16.44794);
                    slips.set(4, 16.70018);
                } else if (dm == DeformationModels.ZENG) {
                    System.out.println("Setting rate on San Andreas (San Bernardino S) for " + String.valueOf(dm));
                    slips = def.getSlips();
                    for (int i4 = 0; i4 < slips.size(); ++i4) {
                        slips.set(i4, 8.16);
                    }
                }
            }
            if (def == null || !def.validateAgainst(section)) {
                List<Location> locs1;
                if (section.getSectionId() == 82) {
                    System.out.println("Fixing North Frontal Special Case!");
                    locs1 = def.getLocs1();
                    List<Location> locs2 = def.getLocs2();
                    List<Double> slips2 = def.getSlips();
                    List<Double> rakes = def.getRakes();
                    List<Location> locs = locs1.subList(3, 6);
                    List<Double> slipsPart = slips2.subList(3, 5);
                    List<Double> rakesPart = rakes.subList(3, 5);
                    double avgSlip = DeformationModelFetcher.getLengthBasedAverage(locs, slipsPart);
                    double avgRake = DeformationModelFetcher.getLengthBasedRakeAverage(locs, rakesPart);
                    slips2.remove(3);
                    slips2.remove(4);
                    slips2.add(3, avgSlip);
                    rakes.remove(3);
                    rakes.remove(4);
                    rakes.add(3, avgRake);
                    locs1.remove(4);
                    locs2.remove(3);
                } else if (section.getSectionId() == 664) {
                    System.out.println("Fixing Silver Creek Special Case!");
                    List<Location> locs2 = def.getLocs2();
                    Location correctPt = (Location)trace.get(5);
                    locs2.set(4, correctPt);
                } else if (section.getSectionId() == 666) {
                    System.out.println("Fixing Point Reyes Special Case!");
                    locs1 = def.getLocs1();
                    List<Location> locs2 = def.getLocs2();
                    Location correctPt = (Location)trace.get(2);
                    locs1.set(2, correctPt);
                    locs2.set(1, correctPt);
                } else if (section.getSectionId() == 401) {
                    DeformationModelFileParser.DeformationSection def290 = model.get(290);
                    DeformationModelFileParser.DeformationSection def291 = model.get(291);
                    System.out.println("Fixing San Jacinto Special Case!");
                    double slips290 = DeformationModelFetcher.getLengthBasedAverage(def290.getLocsAsTrace(), def290.getSlips());
                    double slips291 = DeformationModelFetcher.getLengthBasedAverage(def291.getLocsAsTrace(), def291.getSlips());
                    double slips401 = 0.0;
                    if (def != null) {
                        slips401 = DeformationModelFetcher.getLengthBasedAverage(def.getLocsAsTrace(), def.getSlips());
                    }
                    double combinedSlip = 0.0;
                    if (!Double.isNaN(slips290)) {
                        combinedSlip += slips290;
                    }
                    if (!Double.isNaN(slips291)) {
                        combinedSlip += slips291;
                    }
                    if (!Double.isNaN(slips401)) {
                        combinedSlip += slips401;
                    }
                    model.remove(290);
                    model.remove(291);
                    if (def == null) {
                        DeformationModelFileParser.DeformationSection def401 = new DeformationModelFileParser.DeformationSection(401);
                        for (int i5 = 0; i5 < trace.size() - 1; ++i5) {
                            def401.add((Location)trace.get(i5), (Location)trace.get(i5 + 1), combinedSlip, section.getAveRake());
                        }
                        model.put(401, def401);
                        def = def401;
                    } else {
                        for (i = 0; i < def.getSlips().size(); ++i) {
                            def.getSlips().set(i, combinedSlip);
                        }
                    }
                }
                Preconditions.checkState((boolean)def.validateAgainst(section), (Object)("fix didn't work for section: " + section.getSectionId()));
            }
            for (int i6 = 0; i6 < trace.size() - 1; ++i6) {
                def.getLocs1().set(i6, (Location)trace.get(i6));
                def.getLocs2().set(i6, (Location)trace.get(i6 + 1));
            }
            fixed.put(sectID, def);
        }
        return fixed;
    }

    private ArrayList<FaultSection> loadUCERF3DefModel(List<? extends FaultSection> sections, Map<Integer, DeformationModelFileParser.DeformationSection> model, double maxSubSectionLength, Map<Integer, DeformationModelFileParser.DeformationSection> rakesModel, double defaultAseismicityValue) throws IOException {
        boolean DD = false;
        ArrayList<FaultSection> subSections = new ArrayList<FaultSection>();
        int subSectIndex = 0;
        for (FaultSection faultSection : sections) {
            DeformationModelFileParser.DeformationSection def = model.get(faultSection.getSectionId());
            FaultTrace trace = faultSection.getFaultTrace();
            List<? extends FaultSection> subSectData = DeformationModelFetcher.buildSubSections(faultSection, maxSubSectionLength, subSectIndex);
            List<Double> slips = def.getSlips();
            List<Double> rakes = rakesModel == null ? def.getRakes() : rakesModel.get(faultSection.getSectionId()).getRakes();
            List<Double> momentReductions = def.getMomentReductions();
            Preconditions.checkState((slips.size() == rakes.size() ? 1 : 0) != 0);
            for (int s = 0; s < subSectData.size(); ++s) {
                boolean customQuienSabe;
                boolean customBrawley;
                boolean customMendocino;
                boolean customParkfield;
                FaultSection subSect = subSectData.get(s);
                FaultTrace subTrace = subSect.getFaultTrace();
                Preconditions.checkState((subTrace.size() > 1 ? 1 : 0) != 0, (Object)"sub section trace only has one point!!!!");
                Location subStart = (Location)subTrace.get(0);
                Location subEnd = (Location)subTrace.get(subTrace.size() - 1);
                int traceIndexBefore = -1;
                int traceIndexAfter = -1;
                for (int i = 0; i < trace.size(); ++i) {
                    Location tracePt = (Location)trace.get(i);
                    if (DeformationModelFetcher.isBefore(subStart, subEnd, tracePt)) {
                        traceIndexBefore = i;
                        continue;
                    }
                    if (!DeformationModelFetcher.isAfter(subStart, subEnd, tracePt)) continue;
                    traceIndexAfter = i;
                    break;
                }
                Preconditions.checkState((traceIndexBefore >= 0 ? 1 : 0) != 0, (Object)"trace index before not found!");
                Preconditions.checkState((traceIndexAfter > traceIndexBefore ? 1 : 0) != 0, (Object)"trace index after not found!");
                ArrayList<Location> subLocs = new ArrayList<Location>();
                ArrayList<Double> subSlips = new ArrayList<Double>();
                ArrayList<Double> subRakes = new ArrayList<Double>();
                ArrayList<Double> subMomentReductions = momentReductions == null ? null : new ArrayList<Double>();
                subLocs.add(subStart);
                for (int i = traceIndexBefore; i < traceIndexAfter; ++i) {
                    subSlips.add(slips.get(i));
                    subRakes.add(rakes.get(i));
                    if (subMomentReductions != null) {
                        subMomentReductions.add(momentReductions.get(i));
                    }
                    if (i <= traceIndexBefore || i >= traceIndexAfter) continue;
                    subLocs.add((Location)trace.get(i));
                }
                subLocs.add(subEnd);
                double avgSlip = DeformationModelFetcher.getLengthBasedAverage(subLocs, subSlips);
                double avgRake = DeformationModelFetcher.getLengthBasedRakeAverage(subLocs, subRakes);
                subSect.setAveSlipRate(avgSlip);
                subSect.setAveRake(avgRake);
                int parentID = faultSection.getSectionId();
                boolean bl = customParkfield = parentID == 32 || parentID == 658;
                if (subMomentReductions != null || customParkfield) {
                    double couplingCoeff;
                    double aseismicityFactor;
                    double momentReductionFactor = customParkfield ? (parentID == 32 ? parkfield_mo_reds[s] : creep_mo_reds[s]) : DeformationModelFetcher.getLengthBasedAverage(subLocs, subMomentReductions);
                    if (momentReductionFactor <= 0.9) {
                        aseismicityFactor = momentReductionFactor;
                        couplingCoeff = 1.0;
                    } else {
                        aseismicityFactor = 0.9;
                        double slipRateReduction = (momentReductionFactor - 0.9) / (1.0 - aseismicityFactor);
                        couplingCoeff = 1.0 - slipRateReduction;
                    }
                    subSect.setAseismicSlipFactor(aseismicityFactor);
                    subSect.setCouplingCoeff(couplingCoeff);
                } else if (subSect.getAseismicSlipFactor() == 0.0) {
                    subSect.setAseismicSlipFactor(defaultAseismicityValue);
                }
                boolean bl2 = customMendocino = parentID == 13;
                if (customMendocino) {
                    ArrayList subCouplingCoeffs = Lists.newArrayList();
                    for (int i = traceIndexBefore; i < traceIndexAfter; ++i) {
                        subCouplingCoeffs.add(custom_mendocino_couplings[i]);
                    }
                    double couplingCoeff = DeformationModelFetcher.getLengthBasedAverage(subLocs, subCouplingCoeffs);
                    subSect.setCouplingCoeff(couplingCoeff);
                }
                boolean bl3 = customBrawley = parentID == 170 || parentID == 171;
                if (customBrawley) {
                    subSect.setAseismicSlipFactor(0.9);
                }
                boolean bl4 = customQuienSabe = parentID == 648;
                if (!customQuienSabe) continue;
                subSect.setAseismicSlipFactor(0.9);
            }
            subSections.addAll(subSectData);
            subSectIndex += subSectData.size();
        }
        return subSections;
    }

    private static double getLengthBasedRakeAverage(List<Location> locs, List<Double> rakes) {
        double avg = FaultUtils.getLengthBasedAngleAverage(locs, rakes);
        if (avg > 180.0) {
            avg -= 360.0;
        }
        return avg;
    }

    public static double getLengthBasedAverage(List<Location> locs, List<Double> scalars) {
        Preconditions.checkArgument((locs.size() == scalars.size() + 1 ? 1 : 0) != 0, (Object)"there must be exactly one less slip than location!");
        Preconditions.checkArgument((!scalars.isEmpty() ? 1 : 0) != 0, (Object)"there must be at least 2 locations and 1 slip rate");
        if (scalars.size() == 1) {
            return scalars.get(0);
        }
        if (Double.isNaN(scalars.get(0))) {
            return Double.NaN;
        }
        boolean equal = true;
        for (int i = 1; i < scalars.size(); ++i) {
            if (Double.isNaN(scalars.get(i))) {
                return Double.NaN;
            }
            if (scalars.get(i) == scalars.get(0)) continue;
            equal = false;
            break;
        }
        if (equal) {
            return scalars.get(0);
        }
        ArrayList<Double> dists = new ArrayList<Double>();
        for (int i = 1; i < locs.size(); ++i) {
            dists.add(LocationUtils.linearDistanceFast(locs.get(i - 1), locs.get(i)));
        }
        return DeformationModelFetcher.calcLengthBasedAverage(dists, scalars);
    }

    public static double calcLengthBasedAverage(List<Double> lengths, List<Double> scalars) {
        double totDist = 0.0;
        for (double len : lengths) {
            totDist += len;
        }
        double scaledAvg = 0.0;
        for (int i = 0; i < lengths.size(); ++i) {
            double relative = lengths.get(i) / totDist;
            scaledAvg += relative * scalars.get(i);
        }
        return scaledAvg;
    }

    private static boolean isBefore(Location start, Location end, Location pt) {
        if (start.equals(pt) || LocationUtils.areSimilar(start, pt)) {
            return true;
        }
        double pt_start_dist = LocationUtils.linearDistanceFast(pt, start);
        if (pt_start_dist == 0.0) {
            return true;
        }
        double pt_end_dist = LocationUtils.linearDistanceFast(pt, end);
        double start_end_dist = LocationUtils.linearDistanceFast(start, end);
        return pt_start_dist < pt_end_dist && pt_end_dist > start_end_dist;
    }

    private static boolean isAfter(Location start, Location end, Location pt) {
        if (end.equals(pt) || LocationUtils.areSimilar(end, pt)) {
            return true;
        }
        double pt_end_dist = LocationUtils.linearDistanceFast(pt, end);
        if (pt_end_dist == 0.0) {
            return true;
        }
        double pt_start_dist = LocationUtils.linearDistanceFast(pt, start);
        double start_end_dist = LocationUtils.linearDistanceFast(start, end);
        return pt_end_dist < pt_start_dist && pt_start_dist > start_end_dist;
    }

    private void applyCustomGeologicTapers() {
        HashMap tapers = Maps.newHashMap();
        double taperMin = 0.01;
        tapers.put(172, DeformationModelFetcher.toArray(new Location(32.3715, -115.2366), new Location(32.6508, -115.6121)));
        tapers.put(97, DeformationModelFetcher.toArray(new Location(32.786, -115.453), new Location(32.47, -115.169)));
        tapers.put(651, DeformationModelFetcher.toArray(new Location(38.4678, -122.7056), new Location(38.7625, -122.9963)));
        tapers.put(644, DeformationModelFetcher.toArray(new Location(38.8157, -122.958), new Location(38.4999, -122.6472)));
        for (Integer parentID : tapers.keySet()) {
            Location[] taperLocs = (Location[])tapers.get(parentID);
            double taperLen = LocationUtils.horzDistanceFast(taperLocs[0], taperLocs[1]);
            for (FaultSection sect : this.faultSubSectPrefDataList) {
                if (sect.getParentSectionId() != parentID.intValue()) continue;
                FaultTrace trace = sect.getFaultTrace();
                Location subStart = (Location)trace.get(0);
                Location subEnd = (Location)trace.get(trace.size() - 1);
                double len = LocationUtils.horzDistanceFast(subStart, subEnd);
                double az = LocationUtils.azimuth(subStart, subEnd);
                Location midPt = LocationUtils.location(subStart, az, len * 0.5);
                if (DeformationModelFetcher.isBefore(taperLocs[0], taperLocs[1], midPt)) continue;
                if (DeformationModelFetcher.isAfter(taperLocs[0], taperLocs[1], midPt)) {
                    sect.setAveSlipRate(taperMin);
                    continue;
                }
                sect.setAveSlipRate(sect.getOrigAveSlipRate() * (1.0 - LocationUtils.horzDistanceFast(taperLocs[0], midPt) / taperLen));
            }
        }
    }

    private static <E> E[] toArray(E ... vals) {
        return vals;
    }

    public static Map<IDPairing, Double> readMapFile(File file) throws IOException {
        HashMap<IDPairing, Double> map = new HashMap<IDPairing, Double>();
        FileInputStream file_input = new FileInputStream(file);
        DataInputStream data_in = new DataInputStream(file_input);
        int size = data_in.readInt();
        for (int i = 0; i < size; ++i) {
            int id1 = data_in.readInt();
            int id2 = data_in.readInt();
            double dist = data_in.readDouble();
            IDPairing ind = new IDPairing(id1, id2);
            map.put(ind, dist);
        }
        data_in.close();
        return map;
    }

    public static void writeMapFile(Map<IDPairing, Double> map, File file) throws IOException {
        FileOutputStream file_output = new FileOutputStream(file);
        DataOutputStream data_out = new DataOutputStream(file_output);
        Set<IDPairing> keys = map.keySet();
        data_out.writeInt(keys.size());
        for (IDPairing ind : keys) {
            data_out.writeInt(ind.getID1());
            data_out.writeInt(ind.getID2());
            data_out.writeDouble(map.get(ind));
        }
        file_output.close();
    }

    public static void writePairingsTextFile(File file, List<? extends FaultSection> faultSubSections, Map<IDPairing, Double> distances, double maxJumpDist) throws IOException {
        List<List<Integer>> connections = UCERF3SectionConnectionStrategy.computeCloseSubSectionsListList(faultSubSections, distances, maxJumpDist, null);
        FileWriter fw = new FileWriter(file);
        fw.write("ID1\tID2\tDist\n");
        for (int sectIndex = 0; sectIndex < connections.size(); ++sectIndex) {
            List<Integer> conns = connections.get(sectIndex);
            Collections.sort(conns);
            for (int otherIndex : conns) {
                if (sectIndex > otherIndex) continue;
                Preconditions.checkState((sectIndex != otherIndex ? 1 : 0) != 0);
                Preconditions.checkState((sectIndex >= 0 ? 1 : 0) != 0);
                Preconditions.checkState((otherIndex >= 0 ? 1 : 0) != 0);
                Preconditions.checkState((otherIndex < connections.size() ? 1 : 0) != 0);
                IDPairing pair = new IDPairing(sectIndex, otherIndex);
                Preconditions.checkState((boolean)distances.containsKey(pair));
                fw.write(sectIndex + "\t" + otherIndex + "\t" + distances.get(pair).floatValue() + "\n");
            }
        }
        fw.close();
    }

    private static synchronized Map<IDPairing, Double> loadCachedDistances(FaultModels fm, DeformationModels dm) {
        return (Map)distCache.get((Object)fm, (Object)dm);
    }

    private static synchronized void cacheDistances(FaultModels fm, DeformationModels dm, Map<IDPairing, Double> distMap) {
        if (!distCache.contains((Object)fm, (Object)dm)) {
            distCache.put((Object)fm, (Object)dm, distMap);
        }
    }

    public Map<IDPairing, Double> getSubSectionDistanceMap(double maxDistance) {
        int numSubSections = this.faultSubSectPrefDataList.size();
        Map<IDPairing, Double> distances = DeformationModelFetcher.loadCachedDistances(this.faultModel, this.chosenDefModName);
        String name = this.fileNamePrefix + "_Distances";
        name = name + "_" + (float)maxDistance + "km";
        String fullpathname = this.precomputedDataDir.getAbsolutePath() + File.separator + name;
        File file = new File(fullpathname);
        File pairingsTextFile = new File(fullpathname + "_pairings.txt");
        if (distances == null) {
            if (file.exists()) {
                try {
                    distances = DeformationModelFetcher.readMapFile(file);
                }
                catch (IOException e) {
                    System.out.println("IO Exception =: " + String.valueOf(e));
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
            System.out.println("Calculating data and will save to file: " + file.getAbsolutePath());
            distances = DeformationModelFetcher.calculateDistances(maxDistance, this.faultSubSectPrefDataList);
            try {
                Preconditions.checkState((this.precomputedDataDir.exists() || this.precomputedDataDir.mkdir() ? 1 : 0) != 0, (String)"Couldn't create data dir: %s", (Object)this.precomputedDataDir.getAbsolutePath());
                DeformationModelFetcher.writeMapFile(distances, file);
            }
            catch (IOException e) {
                System.out.println("IO exception = " + String.valueOf(e));
            }
            catch (IllegalStateException e) {
                System.out.println("exception = " + String.valueOf(e));
            }
            DeformationModelFetcher.cacheDistances(this.faultModel, this.chosenDefModName, distances);
        }
        if (!pairingsTextFile.exists()) {
            try {
                DeformationModelFetcher.writePairingsTextFile(pairingsTextFile, this.faultSubSectPrefDataList, distances, maxDistance);
            }
            catch (IOException e) {
                System.out.println("Couldn't write pairings file: " + e.getMessage());
            }
        }
        HashMap<IDPairing, Double> reversed = new HashMap<IDPairing, Double>();
        for (IDPairing pair : distances.keySet()) {
            IDPairing reverse = pair.getReversed();
            reversed.put(reverse, distances.get(pair));
        }
        distances.putAll(reversed);
        return distances;
    }

    public static Map<IDPairing, Double> calculateDistances(double maxDistance, List<? extends FaultSection> subSections) {
        HashMap<IDPairing, Double> distances = new HashMap<IDPairing, Double>();
        double quickSurfDistThreshold = maxDistance * 3.0;
        if (quickSurfDistThreshold < 15.0) {
            quickSurfDistThreshold = 15.0;
        }
        int numSubSections = subSections.size();
        int progress = 0;
        int progressInterval = 10;
        System.out.print("Dist Calc % Done:");
        for (int a = 0; a < numSubSections; ++a) {
            if (100 * a / numSubSections > progress) {
                System.out.print("\t" + progress);
                progress += progressInterval;
            }
            FaultSection data1 = subSections.get(a);
            RuptureSurface surf1 = data1.getFaultSurface(1.0, false, false);
            for (int b = a + 1; b < numSubSections; ++b) {
                FaultSection data2 = subSections.get(b);
                RuptureSurface surf2 = data2.getFaultSurface(1.0, false, false);
                double minDist = QuickSurfaceDistanceCalculator.calcMinDistance(surf1, surf2, quickSurfDistThreshold);
                if (!(minDist < maxDistance)) continue;
                IDPairing ind = new IDPairing(data1.getSectionId(), data2.getSectionId());
                Preconditions.checkState((!distances.containsKey(ind) ? 1 : 0) != 0, (Object)"distances already computed for given sections! duplicate sub section ids?");
                distances.put(ind, minDist);
            }
        }
        System.out.println();
        return distances;
    }

    public Map<IDPairing, Double> getSubSectionAzimuthMap(Set<IDPairing> indices) {
        return DeformationModelFetcher.getSubSectionAzimuthMap(indices, this.faultSubSectPrefDataList);
    }

    public static Map<IDPairing, Double> getSubSectionAzimuthMap(Set<IDPairing> indices, List<? extends FaultSection> subSections) {
        HashMap<IDPairing, Double> azimuths = new HashMap<IDPairing, Double>();
        int progress = 0;
        int progressInterval = 10;
        int cnt = 0;
        for (IDPairing ind : indices) {
            if (100.0 * (double)cnt / (double)indices.size() > (double)progress) {
                progress += progressInterval;
            }
            ++cnt;
            FaultSection data1 = subSections.get(ind.getID1());
            Location loc1 = GriddedSurfaceUtils.getSurfaceMiddleLoc(data1.getFaultSurface(1.0, false, false));
            FaultSection data2 = subSections.get(ind.getID2());
            Location loc2 = GriddedSurfaceUtils.getSurfaceMiddleLoc(data2.getFaultSurface(1.0, false, false));
            azimuths.put(ind, LocationUtils.azimuth(loc1, loc2));
        }
        return azimuths;
    }

    public void writeFractParentSectionsWithNonZeroAsies() {
        int num = 0;
        int totNum = 0;
        ArrayList parentNames = new ArrayList();
        for (FaultSection faultSection : this.getSubSectionList()) {
            if (parentNames.contains(faultSection.getParentSectionName())) continue;
            ++totNum;
            if (!(faultSection.getAseismicSlipFactor() > 0.0)) continue;
            ++num;
        }
        System.out.println("num non-zero aseis =" + num);
        System.out.println("total num =" + totNum);
        System.out.println("fract non-zero = " + (float)num / (float)totNum);
    }

    public static void main(String[] args) {
        try {
            FaultModels fm = FaultModels.FM3_1;
            DeformationModelFetcher dm = new DeformationModelFetcher(fm, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
            dm.getSubSectionDistanceMap(5.0);
            ArrayList metaData = Lists.newArrayList((Object[])new String[]{"UCERF3 Geologic Deformation Model, " + String.valueOf(fm) + " Subsections", new SimpleDateFormat().format(new Date())});
            FaultSectionDataWriter.writeSectionsToFile(dm.getSubSectionList(), metaData, new File(new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, SUB_DIR_NAME), "fault_sections_" + fm.name() + ".txt").getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

