/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;

public class FaultSectionDataWriter {
    private static final boolean INCLUDE_CC = true;

    public static final void writeSectionsToFile(List<? extends FaultSection> subSectionPrefDataList, List<String> metaData, String filePathAndName) throws IOException {
        FaultSectionDataWriter.writeSectionsToFile(subSectionPrefDataList, metaData, new File(filePathAndName), false);
    }

    public static final void writeSectionsToFile(List<? extends FaultSection> subSectionPrefDataList, List<String> metaData, File file, boolean applyReductions) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(FaultSectionDataWriter.getSectionsASCII(subSectionPrefDataList, metaData, applyReductions).toString());
        fw.close();
    }

    public static final StringBuffer getSectionsASCII(List<? extends FaultSection> subSectionPrefDataList, List<String> metaData, boolean applyReductions) {
        StringBuffer buff = new StringBuffer();
        if (metaData != null && !metaData.isEmpty()) {
            Object header1 = "# ******** MetaData **************\n";
            for (String metaDataLine : metaData) {
                header1 = (String)header1 + "# " + metaDataLine + "\n";
            }
            buff.append((String)header1);
        }
        String reducedStr = "";
        if (applyReductions) {
            reducedStr = "Reduced ";
        }
        String header2 = "# ******** Data Format ***********\n# Section Index\n# Section Name\n# Parent Section ID\n# Parent Section Name\n# Ave " + reducedStr + "Upper Seis Depth (km)\n# Ave Lower Seis Depth (km)\n# Ave Dip (degrees)\n# Ave Dip Direction\n# Ave " + reducedStr + "Long Term Slip Rate\n# Ave Aseismic Slip Factor\n";
        header2 = header2 + "# Coupling Coefficient\n";
        header2 = header2 + "# Ave Rake\n# Trace Length (derivative value) (km)\n# Num Trace Points\n# lat1 lon1\n# lat2 lon2\n# etc for all trace points\n# ********************************\n";
        buff.append(header2);
        for (int i = 0; i < subSectionPrefDataList.size(); ++i) {
            FaultSection sectData = subSectionPrefDataList.get(i);
            FaultTrace faultTrace = sectData.getFaultTrace();
            String str = sectData.getSectionId() + "\n" + sectData.getSectionName() + "\n" + FaultSectionDataWriter.getValue(sectData.getParentSectionId()) + "\n" + FaultSectionDataWriter.getValue(sectData.getParentSectionName()) + "\n";
            str = applyReductions ? str + FaultSectionDataWriter.getValue(sectData.getReducedAveUpperDepth()) + "\n" : str + FaultSectionDataWriter.getValue(sectData.getOrigAveUpperDepth()) + "\n";
            str = str + FaultSectionDataWriter.getValue(sectData.getAveLowerDepth()) + "\n" + FaultSectionDataWriter.getValue(sectData.getAveDip()) + "\n" + FaultSectionDataWriter.getValue(sectData.getDipDirection()) + "\n";
            str = applyReductions ? str + FaultSectionDataWriter.getValue(sectData.getReducedAveSlipRate()) + "\n" : str + FaultSectionDataWriter.getValue(sectData.getOrigAveSlipRate()) + "\n";
            str = str + FaultSectionDataWriter.getValue(sectData.getAseismicSlipFactor()) + "\n";
            str = str + FaultSectionDataWriter.getValue(sectData.getCouplingCoeff()) + "\n";
            str = str + FaultSectionDataWriter.getValue(sectData.getAveRake()) + "\n" + FaultSectionDataWriter.getValue(faultTrace.getTraceLength()) + "\n" + faultTrace.getNumLocations() + "\n";
            for (int j = 0; j < faultTrace.getNumLocations(); ++j) {
                str = str + (float)((Location)faultTrace.get(j)).getLatitude() + "\t" + (float)((Location)faultTrace.get(j)).getLongitude() + "\n";
            }
            buff.append(str);
        }
        return buff;
    }

    private static final String getValue(double val) {
        if (Double.isNaN(val)) {
            return "Not Available";
        }
        return GUI_Utils.decimalFormat.format(val);
    }

    private static final String getValue(int val) {
        if (val == -1) {
            return "Not Available";
        }
        return Integer.toString(val);
    }

    private static final String getValue(String val) {
        if (val == null || val.equalsIgnoreCase("")) {
            return "Not Available";
        }
        return val;
    }

    public static void writeRupsToFiles(String filePathAndName, FaultSystemRupSet rupSet) throws IOException {
        FileWriter fw = new FileWriter(filePathAndName);
        fw.write(FaultSectionDataWriter.getRupsASCII(rupSet).toString());
        fw.close();
    }

    public static StringBuffer getRupsASCII(FaultSystemRupSet rupSet) {
        return FaultSectionDataWriter.getRupsASCII(rupSet, null);
    }

    public static StringBuffer getRupsASCII(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        StringBuffer buff = new StringBuffer();
        buff.append("rupID\tclusterID\trupInClustID\tmag\t");
        if (sol != null) {
            buff.append("rate\t");
        }
        buff.append("numSectIDs\tsect1_ID\tsect2_ID\t...\n");
        ArrayList rupsForClusters = Lists.newArrayList();
        if (rupSet instanceof InversionFaultSystemRupSet) {
            InversionFaultSystemRupSet invRupSet = (InversionFaultSystemRupSet)rupSet;
            for (int c = 0; c < invRupSet.getNumClusters(); ++c) {
                rupsForClusters.add(invRupSet.getRupturesForCluster(c));
            }
        } else {
            ArrayList rups = Lists.newArrayList();
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                rups.add(r);
            }
            rupsForClusters.add(rups);
        }
        for (int c = 0; c < rupsForClusters.size(); ++c) {
            List rups = (List)rupsForClusters.get(c);
            for (int i = 0; i < rups.size(); ++i) {
                int rupIndex = (Integer)rups.get(i);
                List<Integer> sections = rupSet.getSectionsIndicesForRup(rupIndex);
                String line = Integer.toString(rupIndex) + "\t" + Integer.toString(c) + "\t" + Integer.toString(rupIndex) + "\t" + (float)rupSet.getMagForRup(rupIndex);
                if (sol != null) {
                    line = line + "\t" + sol.getRateForRup(rupIndex);
                }
                line = line + "\t" + sections.size();
                for (Integer sectID : sections) {
                    line = line + "\t" + sectID;
                }
                line = line + "\n";
                buff.append(line);
                ++rupIndex;
            }
        }
        return buff;
    }
}

