/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.FindEquivUCERF2_Ruptures;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.analysis.GMT_CA_Maps;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemRupSetFactory;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.FindEquivUCERF2_Ruptures.FindEquivUCERF2_Ruptures;
import scratch.UCERF3.utils.ModUCERF2.ModMeanUCERF2;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class FindEquivUCERF2_FM2pt1_Ruptures
extends FindEquivUCERF2_Ruptures {
    protected static final boolean D = false;
    ArrayList<ArrayList<String>> parentSectionNamesForUCERF2_Sources;
    ArrayList<double[]> magsAndRatesForRuptures;
    String DATA_FILE_PREFIX = "equivUCERF2_RupData";
    static final String INFO_FILE_PATH_PREFIX = "InfoForUCERF2_RupAssociations";
    static final String SECT_FOR_UCERF2_SRC_FILE_PATH_NAME = "FM2_SectionsForUCERF2_Sources.txt";
    File dataFile;
    FileWriter info_fw;
    int[] firstSectOfUCERF2_Rup;
    int[] lastSectOfUCERF2_Rup;
    int[] srcIndexOfUCERF2_Rup;
    int[] rupIndexOfUCERF2_Rup;
    int[] invRupIndexForUCERF2_Rup;
    double[] magOfUCERF2_Rup;
    double[] lengthOfUCERF2_Rup;
    double[] rateOfUCERF2_Rup;
    boolean[] subSeismoUCERF2_Rup;
    boolean[] problemUCERF2_Source;
    ArrayList<ArrayList<Integer>> rupAssociationList;
    SummedMagFreqDist mfdOfAssocRupsAndModMags;
    SummedMagFreqDist mfdOfAssocRupsWithOrigMags;
    SummedMagFreqDist mfdOfSummedUCERF2_Sources;
    SummedMagFreqDist mfdOfSubSeismoRups;
    SummedMagFreqDist mfdOfOtherUnassocInvsionRups;
    EvenlyDiscretizedFunc ucerf2_AandB_FaultCumMFD;

    public FindEquivUCERF2_FM2pt1_Ruptures(FaultSystemRupSet faultSysRupSet, File precomputedDataDir) {
        super(faultSysRupSet, precomputedDataDir, FindEquivUCERF2_Ruptures.UCERF2_FaultModel.FM2_1);
        this.firstSectOfUCERF2_Rup = new int[this.ucerf2_fm.numRuptures];
        this.lastSectOfUCERF2_Rup = new int[this.ucerf2_fm.numRuptures];
        this.srcIndexOfUCERF2_Rup = new int[this.ucerf2_fm.numRuptures];
        this.rupIndexOfUCERF2_Rup = new int[this.ucerf2_fm.numRuptures];
        this.magOfUCERF2_Rup = new double[this.ucerf2_fm.numRuptures];
        this.lengthOfUCERF2_Rup = new double[this.ucerf2_fm.numRuptures];
        this.rateOfUCERF2_Rup = new double[this.ucerf2_fm.numRuptures];
        this.subSeismoUCERF2_Rup = new boolean[this.ucerf2_fm.numRuptures];
        this.invRupIndexForUCERF2_Rup = new int[this.ucerf2_fm.numRuptures];
        this.problemUCERF2_Source = new boolean[this.ucerf2_fm.sourcesToUse];
        this.dataFile = new File(this.scratchDir, this.DATA_FILE_PREFIX + "_" + this.NUM_SECTIONS + "_" + this.NUM_INVERSION_RUPTURES);
        if (this.dataFile.exists()) {
            try {
                FileInputStream file_input = new FileInputStream(this.dataFile);
                DataInputStream data_in = new DataInputStream(file_input);
                int numInvSections = data_in.readInt();
                int numInvRups = data_in.readInt();
                if (this.NUM_SECTIONS != numInvSections) {
                    throw new RuntimeException("Error: Input file number of inversion sections (" + numInvSections + ") is inconsistent with that from the given faultSysRupSet (" + this.faultSectionData.size() + "); there must be a filename problem");
                }
                if (this.NUM_INVERSION_RUPTURES != numInvRups) {
                    throw new RuntimeException("Error: Input file number of rupturess (" + numInvRups + ") is inconsistent with that from the given faultSysRupSet (" + faultSysRupSet.getNumRuptures() + "); there must be a filename problem");
                }
                for (int i = 0; i < this.ucerf2_fm.numRuptures; ++i) {
                    this.firstSectOfUCERF2_Rup[i] = data_in.readInt();
                    this.lastSectOfUCERF2_Rup[i] = data_in.readInt();
                    this.srcIndexOfUCERF2_Rup[i] = data_in.readInt();
                    this.rupIndexOfUCERF2_Rup[i] = data_in.readInt();
                    this.magOfUCERF2_Rup[i] = data_in.readDouble();
                    this.lengthOfUCERF2_Rup[i] = data_in.readDouble();
                    this.rateOfUCERF2_Rup[i] = data_in.readDouble();
                    this.subSeismoUCERF2_Rup[i] = data_in.readBoolean();
                    this.invRupIndexForUCERF2_Rup[i] = data_in.readInt();
                }
                for (int s = 0; s < this.ucerf2_fm.sourcesToUse; ++s) {
                    this.problemUCERF2_Source[s] = data_in.readBoolean();
                }
                data_in.close();
            }
            catch (IOException e) {
                System.out.println("IO Exception =: " + String.valueOf(e));
            }
            this.rupAssociationList = new ArrayList();
            for (int ir = 0; ir < this.NUM_INVERSION_RUPTURES; ++ir) {
                this.rupAssociationList.add(new ArrayList());
            }
            for (int ur = 0; ur < this.invRupIndexForUCERF2_Rup.length; ++ur) {
                if (this.invRupIndexForUCERF2_Rup[ur] == -1) continue;
                this.rupAssociationList.get(this.invRupIndexForUCERF2_Rup[ur]).add(ur);
            }
        } else {
            this.readSectionNamesForUCERF2_SourcesFile();
            try {
                this.info_fw = new FileWriter(new File(this.scratchDir, "InfoForUCERF2_RupAssociations_" + this.NUM_SECTIONS + "_" + this.NUM_INVERSION_RUPTURES + ".txt"));
            }
            catch (IOException e) {
                System.out.println("Can't write to scratch dir: " + e.getMessage());
                e.printStackTrace();
            }
            this.findSectionEndsForUCERF2_Rups();
            this.findAssociations(faultSysRupSet.getSectionIndicesForAllRups());
            try {
                if (this.info_fw != null) {
                    this.info_fw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.writePreComputedDataFile();
        }
        this.computeMagsAndRatesForAllRuptures();
    }

    private void findSectionEndsForUCERF2_Rups() {
        for (int r = 0; r < this.ucerf2_fm.numRuptures; ++r) {
            this.firstSectOfUCERF2_Rup[r] = -1;
            this.lastSectOfUCERF2_Rup[r] = -1;
        }
        ArrayList<CallSite> resultsString = new ArrayList<CallSite>();
        ArrayList<String> problemSourceList = new ArrayList<String>();
        ArrayList<CallSite> subseismoRateString = new ArrayList<CallSite>();
        this.problemUCERF2_Source = new boolean[this.ucerf2_fm.sourcesToUse];
        int rupIndex = -1;
        for (int s = 0; s < this.ucerf2_fm.sourcesToUse; ++s) {
            this.problemUCERF2_Source[s] = false;
            boolean bl = false;
            ProbEqkSource src = this.modifiedUCERF2.getSource(s);
            double srcDDW = src.getSourceSurface().getAveWidth();
            double totMoRate = 0.0;
            double partMoRate = 0.0;
            ArrayList<String> parentSectionNames = this.parentSectionNamesForUCERF2_Sources.get(s);
            for (int r = 0; r < src.getNumRuptures(); ++r) {
                String errorString;
                int secondEndIndex;
                ++rupIndex;
                ProbEqkRupture rup = src.getRupture(r);
                double ddw = rup.getRuptureSurface().getAveWidth();
                double len = rup.getRuptureSurface().getAveLength();
                double mag = (double)((int)(rup.getMag() * 100.0)) / 100.0;
                totMoRate += MagUtils.magToMoment(rup.getMag()) * rup.getMeanAnnualRate(30.0);
                this.srcIndexOfUCERF2_Rup[rupIndex] = s;
                this.rupIndexOfUCERF2_Rup[rupIndex] = r;
                this.magOfUCERF2_Rup[rupIndex] = rup.getMag();
                this.lengthOfUCERF2_Rup[rupIndex] = len;
                this.rateOfUCERF2_Rup[rupIndex] = rup.getMeanAnnualRate(30.0);
                this.subSeismoUCERF2_Rup[rupIndex] = false;
                FaultTrace rupTrace = rup.getRuptureSurface().getEvenlyDiscritizedUpperEdge();
                Location rupEndLoc1 = (Location)rupTrace.get(0);
                Location rupEndLoc2 = (Location)rupTrace.get(rupTrace.size() - 1);
                int firstEndIndex = this.getCloseSection(rupEndLoc1, rupTrace, parentSectionNames);
                if (firstEndIndex == (secondEndIndex = this.getCloseSection(rupEndLoc2, rupTrace, parentSectionNames)) && firstEndIndex != -1) {
                    if (ddw != srcDDW) {
                        throw new RuntimeException("Problem");
                    }
                    this.subSeismoUCERF2_Rup[rupIndex] = true;
                    bl = true;
                    String errorString2 = rupIndex + ":\tSub-Seismogenic Rupture:  rup & src ddw=" + (float)ddw + "\trupLen=" + (float)len + "\tlength/ddw=" + (float)(len / ddw) + "\tmag=" + (float)mag + "\tiRup=" + r + "\tiSrc=" + s + "\t(" + src.getName() + ")\n";
                    resultsString.add((CallSite)((Object)errorString2));
                    partMoRate += MagUtils.magToMoment(rup.getMag()) * rup.getMeanAnnualRate(30.0);
                    continue;
                }
                String sectName1 = "None Found";
                String sectName2 = "None Found";
                if (firstEndIndex != -1) {
                    this.firstSectOfUCERF2_Rup[rupIndex] = firstEndIndex;
                    sectName1 = ((FaultSection)this.faultSectionData.get(firstEndIndex)).getSectionName();
                } else {
                    this.problemUCERF2_Source[s] = true;
                    errorString = "Error - end1 section not found for rup " + r + " of src " + s + ", M=" + (float)rup.getMag() + ", (" + src.getName() + ")\n";
                    resultsString.add((CallSite)((Object)errorString));
                }
                if (secondEndIndex != -1) {
                    this.lastSectOfUCERF2_Rup[rupIndex] = secondEndIndex;
                    sectName2 = ((FaultSection)this.faultSectionData.get(secondEndIndex)).getSectionName();
                } else {
                    this.problemUCERF2_Source[s] = true;
                    errorString = "Error - end2 section not found for rup " + r + " of src " + s + ", M=" + (float)rup.getMag() + ", (" + src.getName() + ")\n";
                    resultsString.add((CallSite)((Object)errorString));
                }
                String result = rupIndex + ":\t" + this.firstSectOfUCERF2_Rup[rupIndex] + "\t" + this.lastSectOfUCERF2_Rup[rupIndex] + "\t(" + sectName1 + "   &  " + sectName2 + ")  are the Sections at ends of rup " + r + " of src " + s + ", M=" + (float)rup.getMag() + ", (" + src.getName() + ")\n";
                resultsString.add((CallSite)((Object)result));
                if (!this.problemUCERF2_Source[s] || problemSourceList.contains(src.getName())) continue;
                problemSourceList.add(src.getName());
            }
            String infoString = (float)(partMoRate / totMoRate) + "\tis the fract MoRate below for\t" + src.getName();
            if (!bl) continue;
            subseismoRateString.add((CallSite)((Object)infoString));
        }
        try {
            if (this.info_fw != null) {
                for (String string : resultsString) {
                    this.info_fw.write(string);
                }
                this.info_fw.write("\nProblem Sources (can't find associated inv section for one end of at least one rupture):\n\n");
                for (String string : problemSourceList) {
                    this.info_fw.write("\t" + string + "\n");
                }
                this.info_fw.write("\nSubseimso Sources (has one or more subseismogenic ruptures):\n\n");
                for (String string : subseismoRateString) {
                    this.info_fw.write("\t" + string + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writePreComputedDataFile() {
        try {
            FileOutputStream file_output = new FileOutputStream(this.dataFile);
            DataOutputStream data_out = new DataOutputStream(file_output);
            data_out.writeInt(this.NUM_SECTIONS);
            data_out.writeInt(this.NUM_INVERSION_RUPTURES);
            for (int i = 0; i < this.ucerf2_fm.numRuptures; ++i) {
                data_out.writeInt(this.firstSectOfUCERF2_Rup[i]);
                data_out.writeInt(this.lastSectOfUCERF2_Rup[i]);
                data_out.writeInt(this.srcIndexOfUCERF2_Rup[i]);
                data_out.writeInt(this.rupIndexOfUCERF2_Rup[i]);
                data_out.writeDouble(this.magOfUCERF2_Rup[i]);
                data_out.writeDouble(this.lengthOfUCERF2_Rup[i]);
                data_out.writeDouble(this.rateOfUCERF2_Rup[i]);
                data_out.writeBoolean(this.subSeismoUCERF2_Rup[i]);
                data_out.writeInt(this.invRupIndexForUCERF2_Rup[i]);
            }
            for (int s = 0; s < this.ucerf2_fm.sourcesToUse; ++s) {
                data_out.writeBoolean(this.problemUCERF2_Source[s]);
            }
            file_output.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + String.valueOf(e));
        }
    }

    private double[] computeMagAndRateForRupture(int invRupIndex) {
        ArrayList<Integer> ucerf2_assocRups = this.rupAssociationList.get(invRupIndex);
        if (ucerf2_assocRups.size() == 0) {
            return null;
        }
        if (ucerf2_assocRups.size() == 1) {
            int r = ucerf2_assocRups.get(0);
            double[] result = new double[]{this.magOfUCERF2_Rup[r], this.rateOfUCERF2_Rup[r]};
            this.mfdOfAssocRupsAndModMags.addResampledMagRate(this.magOfUCERF2_Rup[r], this.rateOfUCERF2_Rup[r], true);
            this.mfdOfAssocRupsWithOrigMags.addResampledMagRate(this.magOfUCERF2_Rup[r], this.rateOfUCERF2_Rup[r], true);
            return result;
        }
        double totRate = 0.0;
        double totMoRate = 0.0;
        for (Integer ur : ucerf2_assocRups) {
            totRate += this.rateOfUCERF2_Rup[ur];
            totMoRate += this.rateOfUCERF2_Rup[ur] * MagUtils.magToMoment(this.magOfUCERF2_Rup[ur]);
            this.mfdOfAssocRupsWithOrigMags.addResampledMagRate(this.magOfUCERF2_Rup[ur], this.rateOfUCERF2_Rup[ur], true);
        }
        double aveMoment = totMoRate / totRate;
        double mag = MagUtils.momentToMag(aveMoment);
        double[] result = new double[]{mag, totRate};
        this.mfdOfAssocRupsAndModMags.addResampledMagRate(mag, totRate, false);
        return result;
    }

    private void findAssociations(List<? extends List<Integer>> inversionRups) {
        this.rupAssociationList = new ArrayList();
        for (int r = 0; r < this.ucerf2_fm.numRuptures; ++r) {
            this.invRupIndexForUCERF2_Rup[r] = -1;
        }
        for (int ir = 0; ir < inversionRups.size(); ++ir) {
            List<Integer> invRupSectIDs = inversionRups.get(ir);
            ArrayList<String> parSectNamesList = new ArrayList<String>();
            for (Integer s : invRupSectIDs) {
                String parName = ((FaultSection)this.faultSectionData.get(s)).getParentSectionName();
                if (parSectNamesList.contains(parName)) continue;
                parSectNamesList.add(parName);
            }
            int invSectID_1 = invRupSectIDs.get(0);
            int invSectID_2 = invRupSectIDs.get(invRupSectIDs.size() - 1);
            ArrayList<Integer> ucerfRupsIndexList = new ArrayList<Integer>();
            for (int ur = 0; ur < this.ucerf2_fm.numRuptures; ++ur) {
                int ucerf2_SectID_1 = this.firstSectOfUCERF2_Rup[ur];
                int ucerf2_SectID_2 = this.lastSectOfUCERF2_Rup[ur];
                if ((invSectID_1 != ucerf2_SectID_1 || invSectID_2 != ucerf2_SectID_2) && (invSectID_1 != ucerf2_SectID_2 || invSectID_2 != ucerf2_SectID_1)) continue;
                boolean match = true;
                ArrayList<String> ucerf2_sectNames = this.parentSectionNamesForUCERF2_Sources.get(this.srcIndexOfUCERF2_Rup[ur]);
                for (String invParSectName : parSectNamesList) {
                    if (ucerf2_sectNames.contains(invParSectName)) continue;
                    match = false;
                }
                if (!match) continue;
                if (this.invRupIndexForUCERF2_Rup[ur] != -1) {
                    throw new RuntimeException("UCERF2 rupture " + ur + " was already associated with inv rup " + this.invRupIndexForUCERF2_Rup[ur] + "\t can assoc with: " + ir);
                }
                ucerfRupsIndexList.add(ur);
                this.invRupIndexForUCERF2_Rup[ur] = ir;
            }
            this.rupAssociationList.add(ucerfRupsIndexList);
        }
        try {
            if (this.info_fw != null) {
                HashMap<String, Double> srcRateExcluded = new HashMap<String, Double>();
                int numUnassociated = 0;
                this.info_fw.write("\nUnassociated UCERF2 ruptures (not from FM 2.2 or subseismogenic, so there should be a mapping?)\n");
                this.info_fw.write("\n(because these do not pass the laugh-test filter?)\n");
                this.info_fw.write("\n\tu2_rup\tsrcIndex\trupIndex\tsubSeis\tinvRupIndex\tsrcName\t(first-subsect-name\tlast-subsect-name\n");
                double duration = this.modifiedUCERF2.getTimeSpan().getDuration();
                for (int r = 0; r < this.ucerf2_fm.numRuptures; ++r) {
                    int srcIndex = this.srcIndexOfUCERF2_Rup[r];
                    if (this.subSeismoUCERF2_Rup[r] || this.invRupIndexForUCERF2_Rup[r] != -1 || this.problemUCERF2_Source[srcIndex]) continue;
                    boolean isFirstOrLastSubsect = false;
                    if (this.isFirstOrLastSubsectInSect(this.firstSectOfUCERF2_Rup[r]) || this.isFirstOrLastSubsectInSect(this.lastSectOfUCERF2_Rup[r])) {
                        isFirstOrLastSubsect = true;
                    }
                    this.info_fw.write("\t" + r + "\t" + this.srcIndexOfUCERF2_Rup[r] + "\t" + this.rupIndexOfUCERF2_Rup[r] + "\t" + this.subSeismoUCERF2_Rup[r] + "\t" + this.invRupIndexForUCERF2_Rup[r] + "\t" + this.modifiedUCERF2.getSource(this.srcIndexOfUCERF2_Rup[r]).getName() + "\t(" + ((FaultSection)this.faultSectionData.get(this.firstSectOfUCERF2_Rup[r])).getName() + "\t" + ((FaultSection)this.faultSectionData.get(this.lastSectOfUCERF2_Rup[r])).getName() + ");  atLeastOneIsFirstOrLastSubsectInSect = " + isFirstOrLastSubsect + "\n");
                    ++numUnassociated;
                    String srcName = this.modifiedUCERF2.getSource(this.srcIndexOfUCERF2_Rup[r]).getName();
                    double rate = this.modifiedUCERF2.getSource(this.srcIndexOfUCERF2_Rup[r]).getRupture(this.rupIndexOfUCERF2_Rup[r]).getMeanAnnualRate(duration);
                    if (srcRateExcluded.containsKey(srcName)) {
                        double oldRate = (Double)srcRateExcluded.get(srcName);
                        srcRateExcluded.put(srcName, oldRate + rate);
                        continue;
                    }
                    srcRateExcluded.put(srcName, rate);
                }
                this.info_fw.write("\tTot Num of Above Problems = " + numUnassociated + " (of " + this.ucerf2_fm.numRuptures + ")\n\n");
                this.info_fw.write("\nRates of filtered ruptures from each UCERF2 source:\n\n");
                for (String name : srcRateExcluded.keySet()) {
                    this.info_fw.write("\t" + name + "\t" + ((Double)srcRateExcluded.get(name)).floatValue() + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArrayList<double[]> getMagsAndRatesForRuptures() {
        return this.magsAndRatesForRuptures;
    }

    @Override
    public double[] getMagsAndRatesForRupture(int invRupIndex) {
        return this.magsAndRatesForRuptures.get(invRupIndex);
    }

    private void computeOtherMFDs() {
        this.mfdOfSubSeismoRups = new SummedMagFreqDist(5.05, 35, 0.1);
        this.mfdOfSubSeismoRups.setName("MFD for Sub-seismogenic rups");
        this.mfdOfSubSeismoRups.setInfo("");
        this.mfdOfOtherUnassocInvsionRups = new SummedMagFreqDist(5.05, 35, 0.1);
        this.mfdOfOtherUnassocInvsionRups.setName("MFD for inversion rups with no association");
        this.mfdOfOtherUnassocInvsionRups.setInfo("not including sub-seismo or fault model 2.2 rups");
        for (int r = 0; r < this.ucerf2_fm.numRuptures; ++r) {
            double rate = this.magOfUCERF2_Rup[r];
            double mag = this.rateOfUCERF2_Rup[r];
            if (this.subSeismoUCERF2_Rup[r]) {
                this.mfdOfSubSeismoRups.addResampledMagRate(rate, mag, true);
            }
            if (this.subSeismoUCERF2_Rup[r] || this.invRupIndexForUCERF2_Rup[r] != -1) continue;
            this.mfdOfOtherUnassocInvsionRups.addResampledMagRate(rate, mag, true);
        }
        this.mfdOfSummedUCERF2_Sources = new SummedMagFreqDist(5.05, 35, 0.1);
        this.mfdOfSummedUCERF2_Sources.setName("MFD summed from UCERF2 sources");
        this.mfdOfSummedUCERF2_Sources.setInfo("(only including non-problematic sources)");
        double duration = this.modifiedUCERF2.getTimeSpan().getDuration();
        for (int s = 0; s < this.ucerf2_fm.sourcesToUse; ++s) {
            if (this.problemUCERF2_Source[s]) continue;
            ProbEqkSource src = this.modifiedUCERF2.getSource(s);
            this.mfdOfSummedUCERF2_Sources.addIncrementalMagFreqDist(ERF_Calculator.getTotalMFD_ForSource(src, duration, 5.05, 8.45, 35, true));
        }
        this.ucerf2_AandB_FaultCumMFD = new EvenlyDiscretizedFunc(5.0, 35, 0.1);
        this.ucerf2_AandB_FaultCumMFD.setName("MFD for A and B Faults");
        this.ucerf2_AandB_FaultCumMFD.setInfo("(from Table 8 of UCERF2 Report)");
        this.ucerf2_AandB_FaultCumMFD.setTolerance(1.0E-4);
        this.ucerf2_AandB_FaultCumMFD.set(5.0, 0.329465);
        this.ucerf2_AandB_FaultCumMFD.set(5.1, 0.329465);
        this.ucerf2_AandB_FaultCumMFD.set(5.2, 0.329465);
        this.ucerf2_AandB_FaultCumMFD.set(5.3, 0.329465);
        this.ucerf2_AandB_FaultCumMFD.set(5.4, 0.329072);
        this.ucerf2_AandB_FaultCumMFD.set(5.5, 0.327401);
        this.ucerf2_AandB_FaultCumMFD.set(5.6, 0.323692);
        this.ucerf2_AandB_FaultCumMFD.set(5.7, 0.317977);
        this.ucerf2_AandB_FaultCumMFD.set(5.8, 0.310212);
        this.ucerf2_AandB_FaultCumMFD.set(5.9, 0.300378);
        this.ucerf2_AandB_FaultCumMFD.set(6.0, 0.291053);
        this.ucerf2_AandB_FaultCumMFD.set(6.1, 0.27998);
        this.ucerf2_AandB_FaultCumMFD.set(6.2, 0.269713);
        this.ucerf2_AandB_FaultCumMFD.set(6.3, 0.260056);
        this.ucerf2_AandB_FaultCumMFD.set(6.4, 0.249241);
        this.ucerf2_AandB_FaultCumMFD.set(6.5, 0.235843);
        this.ucerf2_AandB_FaultCumMFD.set(6.6, 0.19227);
        this.ucerf2_AandB_FaultCumMFD.set(6.7, 0.157186);
        this.ucerf2_AandB_FaultCumMFD.set(6.8, 0.126887);
        this.ucerf2_AandB_FaultCumMFD.set(6.9, 0.100995);
        this.ucerf2_AandB_FaultCumMFD.set(7.0, 0.078341);
        this.ucerf2_AandB_FaultCumMFD.set(7.1, 0.059611);
        this.ucerf2_AandB_FaultCumMFD.set(7.2, 0.044868);
        this.ucerf2_AandB_FaultCumMFD.set(7.3, 0.033416);
        this.ucerf2_AandB_FaultCumMFD.set(7.4, 0.024701);
        this.ucerf2_AandB_FaultCumMFD.set(7.5, 0.018085);
        this.ucerf2_AandB_FaultCumMFD.set(7.6, 0.013207);
        this.ucerf2_AandB_FaultCumMFD.set(7.7, 0.009341);
        this.ucerf2_AandB_FaultCumMFD.set(7.8, 0.006075);
        this.ucerf2_AandB_FaultCumMFD.set(7.9, 0.003351);
        this.ucerf2_AandB_FaultCumMFD.set(8.0, 0.001473);
        this.ucerf2_AandB_FaultCumMFD.set(8.1, 5.1E-4);
        this.ucerf2_AandB_FaultCumMFD.set(8.2, 1.0E-4);
        this.ucerf2_AandB_FaultCumMFD.set(8.3, 7.0E-6);
        this.ucerf2_AandB_FaultCumMFD.set(8.4, 1.0E-6);
    }

    public void plotMFD_Test() {
        this.computeOtherMFDs();
        ArrayList<SummedMagFreqDist> funcs = new ArrayList<SummedMagFreqDist>();
        funcs.add(this.mfdOfAssocRupsAndModMags);
        funcs.add(this.mfdOfAssocRupsWithOrigMags);
        funcs.add(this.mfdOfSummedUCERF2_Sources);
        funcs.add(this.mfdOfSubSeismoRups);
        funcs.add(this.mfdOfOtherUnassocInvsionRups);
        GraphWindow graph = new GraphWindow(funcs, "Incremental Mag-Freq Dists");
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setYLog(true);
        graph.setY_AxisRange(1.0E-6, 1.0);
        ArrayList<EvenlyDiscretizedFunc> cumFuncs = new ArrayList<EvenlyDiscretizedFunc>();
        cumFuncs.add(this.mfdOfAssocRupsAndModMags.getCumRateDistWithOffset());
        cumFuncs.add(this.mfdOfAssocRupsWithOrigMags.getCumRateDistWithOffset());
        cumFuncs.add(this.mfdOfSummedUCERF2_Sources.getCumRateDistWithOffset());
        cumFuncs.add(this.ucerf2_AandB_FaultCumMFD);
        cumFuncs.add(this.mfdOfSubSeismoRups.getCumRateDistWithOffset());
        cumFuncs.add(this.mfdOfOtherUnassocInvsionRups.getCumRateDistWithOffset());
        GraphWindow graph2 = new GraphWindow(cumFuncs, "Cumulative Mag-Freq Dists");
        graph2.setX_AxisLabel("Mag");
        graph2.setY_AxisLabel("Rate");
        graph2.setYLog(true);
        graph2.setY_AxisRange(1.0E-6, 1.0);
    }

    private void computeMagsAndRatesForAllRuptures() {
        this.mfdOfAssocRupsAndModMags = new SummedMagFreqDist(5.05, 35, 0.1);
        this.mfdOfAssocRupsAndModMags.setName("MFD for UCERF2 associated ruptures");
        this.mfdOfAssocRupsAndModMags.setInfo("using modified (average) mags; this excludes sub-seimogenic rups");
        this.mfdOfAssocRupsWithOrigMags = new SummedMagFreqDist(5.05, 35, 0.1);
        this.mfdOfAssocRupsWithOrigMags.setName("MFD for UCERF2 associated ruptures");
        this.mfdOfAssocRupsWithOrigMags.setInfo("using original mags; this excludes sub-seimogenic rups");
        this.magsAndRatesForRuptures = new ArrayList();
        for (int r = 0; r < this.NUM_INVERSION_RUPTURES; ++r) {
            this.magsAndRatesForRuptures.add(this.computeMagAndRateForRupture(r));
        }
    }

    private void readSectionNamesForUCERF2_SourcesFile() {
        this.parentSectionNamesForUCERF2_Sources = new ArrayList();
        try {
            String line;
            BufferedReader reader = new BufferedReader(UCERF3_DataUtils.getReader("FindEquivUCERF2_Ruptures", SECT_FOR_UCERF2_SRC_FILE_PATH_NAME));
            int l = -1;
            int s = -1;
            while ((line = reader.readLine()) != null) {
                String targetSrcName;
                String[] st = StringUtils.split((String)line, (String)"\t");
                int srcIndex = Integer.valueOf(st[0]);
                if (srcIndex != ++l) {
                    throw new RuntimeException("problem with source index");
                }
                String srcName = st[1];
                int faultModelForSource = Integer.valueOf(st[2]);
                if (faultModelForSource == 2) continue;
                if (!srcName.equals(targetSrcName = this.modifiedUCERF2.getSource(++s).getName())) {
                    throw new RuntimeException("problem with source name:\t" + srcName + "\t" + targetSrcName);
                }
                ArrayList<String> parentSectNamesList = new ArrayList<String>();
                for (int i = 3; i < st.length; ++i) {
                    parentSectNamesList.add(st[i]);
                }
                this.parentSectionNamesForUCERF2_Sources.add(parentSectNamesList);
                String test = l + "\t" + srcName + "\t" + faultModelForSource;
                for (String name : parentSectNamesList) {
                    test = test + "\t" + name;
                }
                if (test.equals(line)) continue;
                throw new RuntimeException("problem with recreating file line");
            }
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    public static ArrayList<String> getAllSectionNames(File precomputedDataSubDir) {
        ArrayList<String> sectNames = new ArrayList<String>();
        File sectsFile = new File(precomputedDataSubDir, SECT_FOR_UCERF2_SRC_FILE_PATH_NAME);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(sectsFile.getPath()));
            int l = -1;
            int s = -1;
            while ((line = reader.readLine()) != null) {
                String[] st = StringUtils.split((String)line, (String)"\t");
                int srcIndex = Integer.valueOf(st[0]);
                if (srcIndex != ++l) {
                    throw new RuntimeException("problem with source index");
                }
                String srcName = st[1];
                int faultModelForSource = Integer.valueOf(st[2]);
                for (int i = 3; i < st.length; ++i) {
                    if (sectNames.contains(st[i])) continue;
                    sectNames.add(st[i]);
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        return sectNames;
    }

    private void writePrelimSectionsForUCERF2_Sources() {
        DeformationModelFetcher deformationModelFetcher = new DeformationModelFetcher(FaultModels.FM2_1, DeformationModels.UCERF2_ALL, this.scratchDir, 0.1);
        List<? extends FaultSection> faultSectionData = deformationModelFetcher.getSubSectionList();
        ArrayList<String> parentSectionNames = new ArrayList<String>();
        for (int i = 0; i < faultSectionData.size(); ++i) {
            if (parentSectionNames.contains(faultSectionData.get(i).getParentSectionName())) continue;
            parentSectionNames.add(faultSectionData.get(i).getParentSectionName());
        }
        ModMeanUCERF2 modMeanUCERF2 = new ModMeanUCERF2();
        modMeanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        modMeanUCERF2.setParameter("Probability Model", "Poisson");
        modMeanUCERF2.getTimeSpan().setDuration(30.0);
        modMeanUCERF2.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
        modMeanUCERF2.updateForecast();
        File file = new File(this.scratchDir, "SectionsForUCERF2_SourcesPrelim.txt");
        try {
            FileOutputStream file_output = new FileOutputStream(file);
            DataOutputStream data_out = new DataOutputStream(file_output);
            int s = 0;
            for (ProbEqkSource src : modMeanUCERF2) {
                data_out.writeChars(s + "\t" + src.getName() + "\t0\t");
                if (parentSectionNames.contains(src.getName())) {
                    data_out.writeChars(src.getName() + "\n");
                } else {
                    data_out.writeChars("NOT_SAME\n");
                }
                ++s;
            }
            file_output.close();
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    private int getCloseSection(Location rupEndLoc, FaultTrace rupTrace, ArrayList<String> parentSectionNames) {
        int targetSection = -1;
        double closestDist = Double.MAX_VALUE;
        double secondClosestDist = Double.MAX_VALUE;
        int clostestSect = -1;
        int secondClosestSect = -1;
        for (int i = 0; i < this.faultSectionData.size(); ++i) {
            FaultSection sectionData = (FaultSection)this.faultSectionData.get(i);
            if (!parentSectionNames.contains(sectionData.getParentSectionName())) continue;
            FaultTrace sectionTrace = sectionData.getFaultSurface(1.0, false, true).getEvenlyDiscritizedUpperEdge();
            double dist = sectionTrace.minDistToLocation(rupEndLoc);
            if (dist < closestDist) {
                secondClosestDist = closestDist;
                secondClosestSect = clostestSect;
                closestDist = dist;
                clostestSect = i;
                continue;
            }
            if (!(dist < secondClosestDist)) continue;
            secondClosestDist = dist;
            secondClosestSect = i;
        }
        if (clostestSect == -1) {
            return targetSection;
        }
        FaultTrace sectionTrace = ((FaultSection)this.faultSectionData.get(clostestSect)).getFaultSurface(1.0, false, true).getEvenlyDiscritizedUpperEdge();
        double sectHalfLength = 0.5 * sectionTrace.getTraceLength() + 0.5;
        Location sectEnd1 = (Location)sectionTrace.get(0);
        Location sectEnd2 = (Location)sectionTrace.get(sectionTrace.size() - 1);
        double dist1 = rupTrace.minDistToLocation(sectEnd1);
        double dist2 = rupTrace.minDistToLocation(sectEnd2);
        double maxDistClosest = Math.max(dist1, dist2);
        if (dist1 < sectHalfLength && dist2 < sectHalfLength) {
            targetSection = clostestSect;
        }
        double maxDistSecondClosest = Double.NaN;
        if (targetSection == -1) {
            sectionTrace = ((FaultSection)this.faultSectionData.get(secondClosestSect)).getFaultSurface(1.0, false, true).getEvenlyDiscritizedUpperEdge();
            sectHalfLength = 0.5 * sectionTrace.getTraceLength() + 0.5;
            sectEnd1 = (Location)sectionTrace.get(0);
            sectEnd2 = (Location)sectionTrace.get(sectionTrace.size() - 1);
            dist1 = rupTrace.minDistToLocation(sectEnd1);
            dist2 = rupTrace.minDistToLocation(sectEnd2);
            maxDistSecondClosest = Math.max(dist1, dist2);
            if (dist1 < sectHalfLength && dist2 < sectHalfLength) {
                targetSection = secondClosestSect;
            }
        }
        if (targetSection == -1) {
            targetSection = maxDistClosest < maxDistSecondClosest ? clostestSect : secondClosestSect;
        }
        if (targetSection == -1) {
            System.out.println("clostestSect\t" + ((FaultSection)this.faultSectionData.get(clostestSect)).getName() + "\tclosestDist=" + closestDist);
            System.out.println("secondClosestSect\t" + ((FaultSection)this.faultSectionData.get(secondClosestSect)).getName() + "\tsecondClosestDist=" + secondClosestDist);
        }
        return targetSection;
    }

    @Override
    public ProbEqkRupture getRthUCERF2_Rupture(int r) {
        return this.modifiedUCERF2.getSource(this.srcIndexOfUCERF2_Rup[r]).getRupture(this.rupIndexOfUCERF2_Rup[r]);
    }

    @Override
    public int getEquivFaultSystemRupIndexForUCERF2_Rupture(int r) {
        return this.invRupIndexForUCERF2_Rup[r];
    }

    public void plotGMT_MapRatio_Tests() throws IOException {
        GriddedRegion griddedRegion = GMT_CA_Maps.getDefaultGriddedRegion();
        GriddedGeoDataSet erfNucleationRates = ERF_Calculator.getNucleationRatesInRegion(this.modifiedUCERF2, griddedRegion, 0.0, 10.0);
        GriddedGeoDataSet mappingNucleationRates = new GriddedGeoDataSet(griddedRegion, true);
        double[] zVals = new double[mappingNucleationRates.size()];
        for (int ur = 0; ur < this.rateOfUCERF2_Rup.length; ++ur) {
            int ir = this.invRupIndexForUCERF2_Rup[ur];
            if (ir < 0) continue;
            ArrayList<RuptureSurface> surfaces = new ArrayList<RuptureSurface>();
            for (FaultSection fltData : this.faultSysRupSet.getFaultSectionDataForRupture(ir)) {
                surfaces.add(fltData.getFaultSurface(1.0, false, true));
            }
            CompoundSurface compSurf = new CompoundSurface(surfaces);
            LocationList surfLocs = compSurf.getEvenlyDiscritizedListOfLocsOnSurface();
            double ptRate = this.rateOfUCERF2_Rup[ur] / (double)surfLocs.size();
            for (Location loc : surfLocs) {
                int index = griddedRegion.indexForLocation(loc);
                if (index < 0) continue;
                int n = index;
                zVals[n] = zVals[n] + ptRate;
            }
        }
        for (int i = 0; i < griddedRegion.getNodeCount(); ++i) {
            mappingNucleationRates.set(i, zVals[i]);
        }
        GMT_CA_Maps.plotRatioOfRateMaps(mappingNucleationRates, erfNucleationRates, "Nucleation Rates Ratio", "FindEquivUCERF2_FM2_Ruptures Nucleation Rate Ratio Test", "ucerf2to2pt1_MapNuclRatioTest");
        GriddedGeoDataSet erfParticipationRates = ERF_Calculator.getParticipationRatesInRegion(this.modifiedUCERF2, griddedRegion, 0.0, 10.0);
        GriddedGeoDataSet mappingParticipationRates = new GriddedGeoDataSet(griddedRegion, true);
        zVals = new double[mappingParticipationRates.size()];
        for (int ur = 0; ur < this.rateOfUCERF2_Rup.length; ++ur) {
            int ir = this.invRupIndexForUCERF2_Rup[ur];
            if (ir < 0) continue;
            ArrayList<RuptureSurface> surfaces = new ArrayList<RuptureSurface>();
            for (FaultSection fltData : this.faultSysRupSet.getFaultSectionDataForRupture(ir)) {
                surfaces.add(fltData.getFaultSurface(1.0, false, true));
            }
            CompoundSurface compSurf = new CompoundSurface(surfaces);
            LocationList surfLocs = compSurf.getEvenlyDiscritizedListOfLocsOnSurface();
            HashSet<Integer> locIndices = new HashSet<Integer>();
            for (Location loc : surfLocs) {
                int index = griddedRegion.indexForLocation(loc);
                if (index < 0) continue;
                locIndices.add(griddedRegion.indexForLocation(loc));
            }
            double qkRate = this.rateOfUCERF2_Rup[ur];
            for (Integer locIndex : locIndices) {
                int n = locIndex;
                zVals[n] = zVals[n] + qkRate;
            }
        }
        for (int i = 0; i < griddedRegion.getNodeCount(); ++i) {
            mappingParticipationRates.set(i, zVals[i]);
        }
        GMT_CA_Maps.plotRatioOfRateMaps(mappingParticipationRates, erfParticipationRates, "Participation Rates Ratio", "FindEquivUCERF2_FM2_Ruptures Participation Rate Ratio Test", "ucerf2to2pt1_MapPartRatioTest");
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File precompDataDir = UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR;
        InversionFaultSystemRupSet faultSysRupSet = InversionFaultSystemRupSetFactory.forBranch(FaultModels.FM2_1, DeformationModels.UCERF2_ALL, InversionModels.GR_UNCONSTRAINED, ScalingRelationships.AVE_UCERF2, SlipAlongRuptureModels.TAPERED, TotalMag5Rate.RATE_7p9, MaxMagOffFault.MAG_7p6, MomentRateFixes.NONE, SpatialSeisPDF.UCERF3);
        FindEquivUCERF2_FM2pt1_Ruptures test = new FindEquivUCERF2_FM2pt1_Ruptures(faultSysRupSet, precompDataDir);
        test.plotMFD_Test();
        test.plotGMT_MapRatio_Tests();
    }
}

