/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import java.awt.Color;
import java.io.BufferedReader;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import scratch.UCERF3.utils.MFD_InversionConstraint;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class OLD_UCERF3_MFD_ConstraintFetcher {
    static final boolean D = true;
    private static final String SUB_DIR_NAME = "mfdData/old";
    static final double MIN_MAG = 4.0;
    static final double MAX_MAG = 7.5;
    static final int NUM_MAG = 8;
    static final double DELTA_MAG = 0.5;
    static final double TARGET_MIN_MAG = 5.05;
    static final int TARGET_NUM_MAG = 35;
    static final double TARGET_DELTA_MAG = 0.1;
    static final double TARGET_MAX_MAG = 8.45;
    static final double TARGET_B_VALUE = 1.0;
    EvenlyDiscretizedFunc allCal1850_mean_cumMFD;
    EvenlyDiscretizedFunc allCal1984_mean_cumMFD;
    EvenlyDiscretizedFunc noCal1850_mean_cumMFD;
    EvenlyDiscretizedFunc noCal1984_mean_cumMFD;
    EvenlyDiscretizedFunc soCal1850_mean_cumMFD;
    EvenlyDiscretizedFunc soCal1984_mean_cumMFD;
    EvenlyDiscretizedFunc allCal1850_upper95_cumMFD;
    EvenlyDiscretizedFunc allCal1984_upper95_cumMFD;
    EvenlyDiscretizedFunc noCal1850_upper95_cumMFD;
    EvenlyDiscretizedFunc noCal1984_upper95_cumMFD;
    EvenlyDiscretizedFunc soCal1850_upper95_cumMFD;
    EvenlyDiscretizedFunc soCal1984_upper95_cumMFD;
    EvenlyDiscretizedFunc allCal1850_lower95_cumMFD;
    EvenlyDiscretizedFunc allCal1984_lower95_cumMFD;
    EvenlyDiscretizedFunc noCal1850_lower95_cumMFD;
    EvenlyDiscretizedFunc noCal1984_lower95_cumMFD;
    EvenlyDiscretizedFunc soCal1850_lower95_cumMFD;
    EvenlyDiscretizedFunc soCal1984_lower95_cumMFD;

    public OLD_UCERF3_MFD_ConstraintFetcher() {
        ArrayList<EvenlyDiscretizedFunc> mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("WholeRegion1850_2011_v1.txt");
        this.allCal1850_mean_cumMFD = mfds.get(0);
        this.allCal1850_lower95_cumMFD = mfds.get(1);
        this.allCal1850_upper95_cumMFD = mfds.get(2);
        mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("WholeRegion1984_2011_v1.txt");
        this.allCal1984_mean_cumMFD = mfds.get(0);
        this.allCal1984_lower95_cumMFD = mfds.get(1);
        this.allCal1984_upper95_cumMFD = mfds.get(2);
        mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("NoCal1850_2011_v1.txt");
        this.noCal1850_mean_cumMFD = mfds.get(0);
        this.noCal1850_lower95_cumMFD = mfds.get(1);
        this.noCal1850_upper95_cumMFD = mfds.get(2);
        mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("NoCal1984_2011_v1.txt");
        this.noCal1984_mean_cumMFD = mfds.get(0);
        this.noCal1984_lower95_cumMFD = mfds.get(1);
        this.noCal1984_upper95_cumMFD = mfds.get(2);
        mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("SoCal1850_2011_v1.txt");
        this.soCal1850_mean_cumMFD = mfds.get(0);
        this.soCal1850_lower95_cumMFD = mfds.get(1);
        this.soCal1850_upper95_cumMFD = mfds.get(2);
        mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("SoCal1984_2011_v1.txt");
        this.soCal1984_mean_cumMFD = mfds.get(0);
        this.soCal1984_lower95_cumMFD = mfds.get(1);
        this.soCal1984_upper95_cumMFD = mfds.get(2);
    }

    public static MFD_InversionConstraint getTargetMFDConstraint(TimeAndRegion timeAndRegion) {
        CaliforniaRegions.CA_Region region = null;
        ArrayList<EvenlyDiscretizedFunc> mfds = null;
        switch (timeAndRegion.ordinal()) {
            case 0: {
                mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("WholeRegion1850_2011_v1.txt");
                region = new CaliforniaRegions.RELM_TESTING();
                break;
            }
            case 1: {
                mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("WholeRegion1984_2011_v1.txt");
                region = new CaliforniaRegions.RELM_TESTING();
                break;
            }
            case 2: {
                mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("NoCal1850_2011_v1.txt");
                region = new CaliforniaRegions.RELM_NOCAL();
                break;
            }
            case 3: {
                mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("NoCal1984_2011_v1.txt");
                region = new CaliforniaRegions.RELM_NOCAL();
                break;
            }
            case 4: {
                mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("SoCal1850_2011_v1.txt");
                region = new CaliforniaRegions.RELM_SOCAL();
                break;
            }
            case 5: {
                mfds = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("SoCal1984_2011_v1.txt");
                region = new CaliforniaRegions.RELM_SOCAL();
            }
        }
        double totalTargetRate = mfds.get(0).getY(5.0);
        GutenbergRichterMagFreqDist targetMFD = new GutenbergRichterMagFreqDist(1.0, totalTargetRate, 5.05, 8.45, 35);
        System.out.println(String.valueOf((Object)timeAndRegion) + " totalTargetRate=" + totalTargetRate + "\t" + (float)targetMFD.getTotCumRate());
        return new MFD_InversionConstraint(targetMFD, region);
    }

    private static ArrayList<EvenlyDiscretizedFunc> readMFD_DataFromFile(String fileName) {
        EvenlyDiscretizedFunc mfdMean = new EvenlyDiscretizedFunc(4.0, 7.5, 8);
        EvenlyDiscretizedFunc mfdLower95Conf = new EvenlyDiscretizedFunc(4.0, 7.5, 8);
        EvenlyDiscretizedFunc mfdUpper95Conf = new EvenlyDiscretizedFunc(4.0, 7.5, 8);
        try {
            String line;
            BufferedReader reader = new BufferedReader(UCERF3_DataUtils.getReader(SUB_DIR_NAME, fileName));
            int l = 0;
            while ((line = reader.readLine()) != null) {
                String[] st = StringUtils.split((String)line, (String)" ");
                double magTest = 4.0 + (double)l * 0.5;
                double mag = Double.valueOf(st[0]);
                if (mag != magTest) {
                    throw new RuntimeException("mags are unequal: " + mag + "\t" + magTest);
                }
                mfdMean.set(mag, (double)Double.valueOf(st[1]));
                mfdLower95Conf.set(mag, (double)Double.valueOf(st[2]));
                mfdUpper95Conf.set(mag, (double)Double.valueOf(st[3]));
                ++l;
            }
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        mfdMean.setName("Mean MFD from " + fileName);
        mfdLower95Conf.setName("Lower 95th Conf MFD from " + fileName);
        mfdUpper95Conf.setName("Upper 95th Conf MFD from " + fileName);
        mfdMean.setInfo(" ");
        mfdLower95Conf.setInfo(" ");
        mfdUpper95Conf.setInfo(" ");
        ArrayList<EvenlyDiscretizedFunc> mfds = new ArrayList<EvenlyDiscretizedFunc>();
        mfds.add(mfdMean);
        mfds.add(mfdLower95Conf);
        mfds.add(mfdUpper95Conf);
        return mfds;
    }

    public static void plotGR_MFDsForVariousMmax() {
        double totCumM4_Rate = OLD_UCERF3_MFD_ConstraintFetcher.readMFD_DataFromFile("WholeRegion1850_2011_v1.txt").get(0).getY(4.0);
        System.out.println(totCumM4_Rate);
        double[] mMaxArray = new double[]{10.0, 8.21, 8.42, 8.47, 8.52, 8.75};
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        for (double mMax : mMaxArray) {
            int numPt = (int)Math.round(mMax * 100.0 + 1.0);
            GutenbergRichterMagFreqDist targetMFD = new GutenbergRichterMagFreqDist(1.0, 1.0, 0.0, mMax, numPt);
            targetMFD.scaleToCumRate(4.0, totCumM4_Rate);
            targetMFD.setName("GR with Mmax = " + mMax);
            funcs.add(targetMFD.getCumRateDist());
        }
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.LIGHT_GRAY));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.ORANGE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.MAGENTA));
        GraphWindow graph = new GraphWindow(funcs, "Magnitude-Frequency Distsributions", plotChars);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setTickLabelFontSize(12);
        graph.setPlotLabelFontSize(16);
        graph.setAxisLabelFontSize(14);
        graph.setY_AxisRange(1.0E-4, 10.0);
        graph.setX_AxisRange(5.0, 9.0);
        graph.setYLog(true);
    }

    public void plotCumMFDs() {
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK));
        ArrayList<EvenlyDiscretizedFunc> funcs2 = new ArrayList<EvenlyDiscretizedFunc>();
        funcs2.add(this.noCal1850_mean_cumMFD);
        funcs2.add(this.noCal1850_lower95_cumMFD);
        funcs2.add(this.noCal1850_upper95_cumMFD);
        funcs2.add(this.noCal1984_mean_cumMFD);
        funcs2.add(this.noCal1984_lower95_cumMFD);
        funcs2.add(this.noCal1984_upper95_cumMFD);
        GraphWindow graph2 = new GraphWindow(funcs2, "No Cal Cum Mag-Freq Dists", plotChars);
        graph2.setX_AxisLabel("Mag");
        graph2.setY_AxisLabel("Rate");
        graph2.setY_AxisRange(0.001, 500.0);
        graph2.setX_AxisRange(3.5, 8.0);
        graph2.setYLog(true);
        ArrayList<EvenlyDiscretizedFunc> funcs3 = new ArrayList<EvenlyDiscretizedFunc>();
        funcs3.add(this.soCal1850_mean_cumMFD);
        funcs3.add(this.soCal1850_lower95_cumMFD);
        funcs3.add(this.soCal1850_upper95_cumMFD);
        funcs3.add(this.soCal1984_mean_cumMFD);
        funcs3.add(this.soCal1984_lower95_cumMFD);
        funcs3.add(this.soCal1984_upper95_cumMFD);
        GraphWindow graph3 = new GraphWindow(funcs3, "So Cal Cum Mag-Freq Dists", plotChars);
        graph3.setX_AxisLabel("Mag");
        graph3.setY_AxisLabel("Rate");
        graph3.setY_AxisRange(0.001, 500.0);
        graph3.setX_AxisRange(3.5, 8.0);
        graph3.setYLog(true);
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(this.allCal1850_mean_cumMFD);
        funcs.add(this.allCal1850_lower95_cumMFD);
        funcs.add(this.allCal1850_upper95_cumMFD);
        funcs.add(this.allCal1984_mean_cumMFD);
        funcs.add(this.allCal1984_lower95_cumMFD);
        funcs.add(this.allCal1984_upper95_cumMFD);
        funcs.addAll(UCERF2.getObsCumMFD(true));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.RED));
        GraphWindow graph = new GraphWindow(funcs, "All Cal Cum Mag-Freq Dists", plotChars);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setY_AxisRange(0.001, 500.0);
        graph.setX_AxisRange(3.5, 8.0);
        graph.setYLog(true);
    }

    private static EvenlyDiscretizedFunc getGarderKnoppoffFractAftershocksMDF() {
        EvenlyDiscretizedFunc withAftCum = UCERF2.getObsCumMFD(true).get(0);
        EvenlyDiscretizedFunc noAftCum = UCERF2.getObsCumMFD(false).get(0);
        double min = noAftCum.getX(0) + noAftCum.getDelta() / 2.0;
        double max = noAftCum.getX(noAftCum.size() - 1) - noAftCum.getDelta() / 2.0;
        EvenlyDiscretizedFunc fractFunc = new EvenlyDiscretizedFunc(min, max, noAftCum.size() - 1);
        for (int i = 0; i < withAftCum.size() - 1; ++i) {
            double wOut;
            double mag = (withAftCum.getX(i) + withAftCum.getX(i + 1)) / 2.0;
            double with = withAftCum.getY(i) - withAftCum.getY(i + 1);
            double frac = (with - (wOut = noAftCum.getY(i) - noAftCum.getY(i + 1))) / with;
            if (frac < 0.0) {
                frac = 0.0;
            }
            fractFunc.set(i, frac);
        }
        return fractFunc;
    }

    public void makePrelimReportMFDsPlot() {
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GREEN));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.MAGENTA));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.MAGENTA));
        ArrayList<EvenlyDiscretizedFunc> funcs2 = new ArrayList<EvenlyDiscretizedFunc>();
        funcs2.add(this.noCal1850_mean_cumMFD);
        funcs2.add(this.noCal1984_mean_cumMFD);
        funcs2.add(this.soCal1850_mean_cumMFD);
        funcs2.add(this.soCal1984_mean_cumMFD);
        GraphWindow graph2 = new GraphWindow(funcs2, "N. vs S. Cal MFDs", plotChars);
        graph2.setX_AxisLabel("Mag");
        graph2.setY_AxisLabel("Rate");
        graph2.setY_AxisRange(0.01, 100.0);
        graph2.setX_AxisRange(4.0, 7.5);
        graph2.setYLog(true);
        graph2.setPlotLabelFontSize(18);
        graph2.setAxisLabelFontSize(16);
        graph2.setTickLabelFontSize(16);
        ArrayList<PlotCurveCharacterstics> plotChars2 = new ArrayList<PlotCurveCharacterstics>();
        plotChars2.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        plotChars2.add(new PlotCurveCharacterstics(null, 2.0f, PlotSymbol.BOLD_CROSS, 4.0f, Color.BLUE));
        plotChars2.add(new PlotCurveCharacterstics(null, 2.0f, PlotSymbol.BOLD_CROSS, 4.0f, Color.BLUE));
        plotChars2.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars2.add(new PlotCurveCharacterstics(null, 2.0f, PlotSymbol.BOLD_CROSS, 4.0f, Color.BLACK));
        plotChars2.add(new PlotCurveCharacterstics(null, 2.0f, PlotSymbol.BOLD_CROSS, 4.0f, Color.BLACK));
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(this.allCal1850_mean_cumMFD);
        funcs.add(this.allCal1850_lower95_cumMFD);
        funcs.add(this.allCal1850_upper95_cumMFD);
        funcs.add(this.allCal1984_mean_cumMFD);
        funcs.add(this.allCal1984_lower95_cumMFD);
        funcs.add(this.allCal1984_upper95_cumMFD);
        funcs.addAll(UCERF2.getObsCumMFD(true));
        plotChars2.add(new PlotCurveCharacterstics(null, 2.0f, PlotSymbol.BOLD_CROSS, 4.0f, Color.RED));
        plotChars2.add(new PlotCurveCharacterstics(null, 2.0f, PlotSymbol.BOLD_CROSS, 4.0f, Color.RED));
        plotChars2.add(new PlotCurveCharacterstics(null, 2.0f, PlotSymbol.BOLD_CROSS, 4.0f, Color.RED));
        GraphWindow graph = new GraphWindow(funcs, "All Cal MFDs", plotChars2);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setY_AxisRange(0.001, 500.0);
        graph.setX_AxisRange(3.5, 8.0);
        graph.setYLog(true);
        graph.setPlotLabelFontSize(18);
        graph.setAxisLabelFontSize(16);
        graph.setTickLabelFontSize(16);
    }

    public static void main(String[] args) {
        OLD_UCERF3_MFD_ConstraintFetcher test = new OLD_UCERF3_MFD_ConstraintFetcher();
        test.makePrelimReportMFDsPlot();
    }

    public static enum TimeAndRegion {
        ALL_CA_1850,
        ALL_CA_1984,
        NO_CA_1850,
        NO_CA_1984,
        SO_CA_1850,
        SO_CA_1984;

    }
}

