/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import java.util.ArrayList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.RuptureSurface;

class QuickSurfaceDistanceCalculator {
    QuickSurfaceDistanceCalculator() {
    }

    public static double calcMinDistance(RuptureSurface surface1, RuptureSurface surface2, double cornerMidpointDistCutoff) {
        double cornerMdptDist;
        if (cornerMidpointDistCutoff > 0.0 && (cornerMdptDist = QuickSurfaceDistanceCalculator.calcMinCornerMidptDist(surface1, surface2)) >= cornerMidpointDistCutoff) {
            return Double.NaN;
        }
        double minDist = Double.MAX_VALUE;
        for (Location pt1 : surface1.getEvenlyDiscritizedListOfLocsOnSurface()) {
            for (Location pt2 : surface2.getEvenlyDiscritizedListOfLocsOnSurface()) {
                double dist = LocationUtils.linearDistanceFast(pt1, pt2);
                if (!(dist < minDist)) continue;
                minDist = dist;
            }
        }
        return minDist;
    }

    private static double calcMinCornerMidptDist(RuptureSurface surface1, RuptureSurface surface2) {
        double minDist = Double.MAX_VALUE;
        ArrayList<Location> locs1 = QuickSurfaceDistanceCalculator.getCornerMidpts(surface1);
        ArrayList<Location> locs2 = QuickSurfaceDistanceCalculator.getCornerMidpts(surface2);
        for (Location loc1 : locs1) {
            for (Location loc2 : locs2) {
                double dist = LocationUtils.linearDistanceFast(loc1, loc2);
                if (!(dist < minDist)) continue;
                minDist = dist;
            }
        }
        return minDist;
    }

    private static ArrayList<Location> getCornerMidpts(RuptureSurface surface) {
        ArrayList<Location> pts = new ArrayList<Location>();
        if (surface instanceof EvenlyGriddedSurface) {
            EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surface;
            int lastRow = gridSurf.getNumRows() - 1;
            int lastCol = gridSurf.getNumCols() - 1;
            pts.add((Location)gridSurf.get(0, 0));
            pts.add((Location)gridSurf.get(0, lastCol));
            pts.add((Location)gridSurf.get(lastRow, 0));
            pts.add((Location)gridSurf.get(lastRow, lastCol));
            int midRow = -1;
            int midCol = -1;
            if (lastRow > 3) {
                midRow = gridSurf.getNumRows() / 2;
            }
            if (lastCol > 3) {
                midCol = gridSurf.getNumCols() / 2;
            }
            if (midRow > 0) {
                pts.add((Location)gridSurf.get(midRow, 0));
                pts.add((Location)gridSurf.get(midRow, lastCol));
            }
            if (midCol > 0) {
                pts.add((Location)gridSurf.get(0, midCol));
                pts.add((Location)gridSurf.get(lastRow, midCol));
            }
            if (midRow > 0 && midCol > 0) {
                pts.add((Location)gridSurf.get(midRow, midCol));
            }
        } else {
            pts.addAll(surface.getPerimeter());
            DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
            DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
            DataUtils.MinMaxAveTracker depthTrack = new DataUtils.MinMaxAveTracker();
            for (Location loc : pts) {
                latTrack.addValue(loc.getLatitude());
                lonTrack.addValue(loc.getLongitude());
                depthTrack.addValue(loc.getDepth());
            }
            pts.add(new Location(latTrack.getAverage(), lonTrack.getAverage(), depthTrack.getAverage()));
        }
        return pts;
    }
}

