/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.ClassUtils;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityOptions;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.utils.MatrixIO;

public class TimeDepRateExtractor {
    private static final int START_YEAR_DEFAULT = 2014;
    private static final int HIST_OPEN_INTERVAL_BASIS_DEFAULT = 1875;
    private FaultSystemSolution sol;
    private double duration;
    private int startYear;
    private int histOpenBasis;
    private boolean filterAftershocks;
    private String[] probModels;
    private File outputFile;
    private boolean binary;
    private boolean ignoreNoDateLast;
    private int numSectsWithDateLast = 0;

    private TimeDepRateExtractor(CommandLine cmd) {
        File solFile = new File(cmd.getOptionValue("solution"));
        Preconditions.checkArgument((boolean)solFile.exists(), (Object)("Sol file doesn't exist: " + solFile.getAbsolutePath()));
        try {
            this.sol = FaultSystemSolution.load(solFile);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading solution", e);
        }
        this.duration = Double.parseDouble(cmd.getOptionValue("duration"));
        this.startYear = cmd.hasOption("start-year") ? Integer.parseInt(cmd.getOptionValue("start-year")) : 2014;
        this.histOpenBasis = cmd.hasOption("hist-open-interval-basis") ? Integer.parseInt(cmd.getOptionValue("hist-open-interval-basis")) : 1875;
        this.filterAftershocks = cmd.hasOption("filter-aftershocks");
        this.probModels = cmd.getOptionValue("prob-model").split(",");
        Preconditions.checkArgument((this.probModels.length >= 1 ? 1 : 0) != 0);
        this.outputFile = new File(cmd.getOptionValue("output-file"));
        this.binary = cmd.hasOption("binary");
        this.ignoreNoDateLast = cmd.hasOption("ignore-no-date-last");
        for (FaultSection faultSection : this.sol.getRupSet().getFaultSectionDataList()) {
            if (faultSection.getDateOfLastEvent() <= Long.MIN_VALUE) continue;
            ++this.numSectsWithDateLast;
        }
    }

    private void calc() throws IOException {
        CSVFile<CallSite> csv;
        if (this.numSectsWithDateLast == 0) {
            System.err.println("*** WARNING *** NO FAULT SECTIONS HAVE DATE OF LAST EVENT DATA!");
        } else {
            System.out.println(this.numSectsWithDateLast + "/" + this.sol.getRupSet().getNumSections() + " sects have date of last event.");
        }
        int numRups = this.sol.getRupSet().getNumRuptures();
        if (this.binary) {
            csv = null;
        } else {
            csv = new CSVFile<CallSite>(true);
            ArrayList header = Lists.newArrayList((Object[])new String[]{"FSS Index", "FSS Rate (1/yr)"});
            String durStr = (float)((int)this.duration) == (float)this.duration ? "" + (int)this.duration : "" + (float)this.duration;
            for (String probModel : this.probModels) {
                header.add(probModel + " " + durStr + "yr Prob");
                header.add(probModel + " Equiv Annual Rate (1/yr)");
            }
            csv.addLine(header);
            for (int i = 0; i < numRups; ++i) {
                ArrayList line = Lists.newArrayList((Object[])new String[]{"" + i, "" + this.sol.getRateForRup(i)});
                while (line.size() < header.size()) {
                    line.add("");
                }
                csv.addLine(line);
            }
        }
        for (int i = 0; i < this.probModels.length; ++i) {
            String probModel = this.probModels[i];
            System.out.println("Calculating for " + probModel);
            FaultSystemSolutionERF erf = this.buildERF(probModel);
            erf.updateForecast();
            double[] probs = new double[numRups];
            double[] equivRates = new double[numRups];
            int numSkipped = 0;
            for (int r = 0; r < numRups; ++r) {
                int sourceID = erf.getSrcIndexForFltSysRup(r);
                if (sourceID < 0) {
                    ++numSkipped;
                    continue;
                }
                ProbEqkSource source = erf.getSource(sourceID);
                probs[r] = source.computeTotalProb();
                equivRates[r] = source.computeTotalEquivMeanAnnualRate(this.duration);
            }
            System.out.println("Skipped " + numSkipped + " rups (due to zero rate or below sect min mag)");
            if (this.binary) {
                File outputFile;
                if (this.probModels.length > 1) {
                    Object name = this.outputFile.getName();
                    if (((String)name).contains(".")) {
                        int ind = ((String)name).lastIndexOf(".");
                        name = ((String)name).substring(0, ind) + "_" + probModel + ((String)name).substring(ind);
                    } else {
                        name = (String)name + "_" + probModel;
                    }
                    outputFile = new File(this.outputFile.getParentFile(), (String)name);
                } else {
                    outputFile = this.outputFile;
                }
                System.out.println("Writing binary file to: " + outputFile.getAbsolutePath());
                MatrixIO.doubleArrayToFile(equivRates, outputFile);
                continue;
            }
            int col = 2 + 2 * i;
            for (int r = 0; r < numRups; ++r) {
                int row = r + 1;
                csv.set(row, col, (CallSite)((Object)("" + probs[r])));
                csv.set(row, col + 1, (CallSite)((Object)("" + equivRates[r])));
            }
        }
        if (!this.binary) {
            System.out.println("Writing CSV file to: " + this.outputFile.getAbsolutePath());
            csv.writeToFile(this.outputFile);
        }
    }

    private FaultSystemSolutionERF buildERF(String probModel) {
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(this.sol);
        if (probModel.equals(ProbabilityModelOptions.U3_PREF_BLEND.name())) {
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
        } else if (probModel.equals(ProbabilityModelOptions.POISSON.name())) {
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        } else {
            MagDependentAperiodicityOptions cov;
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_BPT);
            if (probModel.equals("BPT_LOW")) {
                cov = MagDependentAperiodicityOptions.LOW_VALUES;
            } else if (probModel.equals("BPT_MID")) {
                cov = MagDependentAperiodicityOptions.MID_VALUES;
            } else if (probModel.equals("BPT_HIGH")) {
                cov = MagDependentAperiodicityOptions.HIGH_VALUES;
            } else {
                throw new IllegalArgumentException("Unknown prob model: " + probModel);
            }
            erf.setParameter("Aperiodicity", (Object)cov);
        }
        boolean timeDep = !erf.getParameter("Probability Model").getValue().equals((Object)ProbabilityModelOptions.POISSON);
        System.out.println("Time dep? " + timeDep);
        erf.getTimeSpan().setDuration(this.duration);
        if (timeDep) {
            erf.getTimeSpan().setStartTime(this.startYear);
        }
        Preconditions.checkState((erf.getTimeSpan().getDuration() == this.duration ? 1 : 0) != 0);
        if (timeDep) {
            Preconditions.checkState((erf.getTimeSpan().getStartTimeYear() == this.startYear ? 1 : 0) != 0);
        }
        if (timeDep) {
            erf.setParameter("Historic Open Interval", this.startYear - this.histOpenBasis);
        }
        erf.setParameter("Apply Aftershock Filter", this.filterAftershocks);
        erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
        System.out.println("Built ERF for " + probModel);
        System.out.println("******** ERF PARAMS ********");
        for (Parameter<?> param : erf.getAdjustableParameterList()) {
            System.out.println("\t" + param.getName() + ": " + String.valueOf(param.getValue()));
        }
        System.out.println("\tTime Span Duration: " + erf.getTimeSpan().getDuration());
        if (timeDep) {
            System.out.println("\tTime Span Start Year: " + erf.getTimeSpan().getStartTimeYear());
        }
        System.out.println("****************************");
        Preconditions.checkState((!timeDep || this.numSectsWithDateLast > 0 || this.ignoreNoDateLast ? 1 : 0) != 0, (Object)"You are attempting to calculate time dependent probabilities on a fault system solution where the date of last event is not set on any fault section. You can skip this check and only calculation probabilities using the historical open interval with the --ignore-no-date-last flag.");
        return erf;
    }

    public static Options createOptions() {
        Options ops = new Options();
        Option durationOp = new Option("d", "duration", true, "Forecast duration in years.");
        durationOp.setRequired(true);
        ops.addOption(durationOp);
        Option startYearOp = new Option("y", "start-year", true, "Forecast start year. Default: 2014");
        startYearOp.setRequired(false);
        ops.addOption(startYearOp);
        Option probModelOp = new Option("p", "prob-model", true, "Probability model. One or more of " + ProbabilityModelOptions.U3_PREF_BLEND.name() + "," + ProbabilityModelOptions.POISSON.name() + ",BPT_LOW,BPT_MID,BPT_HIGH. Multiple entries can be comma separated.");
        probModelOp.setRequired(true);
        ops.addOption(probModelOp);
        Option aftershockOp = new Option("a", "filter-aftershocks", false, "Apply aftershock filter");
        aftershockOp.setRequired(false);
        ops.addOption(aftershockOp);
        Option histOpenOp = new Option("h", "hist-open-interval-basis", true, "Year basis for historical open interval. Default: 1875");
        histOpenOp.setRequired(false);
        ops.addOption(histOpenOp);
        Option solOp = new Option("s", "solution", true, "Input Fault System Solution zip file");
        solOp.setRequired(true);
        ops.addOption(solOp);
        Option outputOp = new Option("o", "output-file", true, "Output file name");
        outputOp.setRequired(true);
        ops.addOption(outputOp);
        Option binaryOp = new Option("b", "binary", false, "Output equivalent annualized rates binary file in FSS rates.bin format. Otherwise CSV format.");
        binaryOp.setRequired(false);
        ops.addOption(binaryOp);
        Option ignoreOp = new Option("i", "ignore-no-date-last", false, "Skips check that ensures date of last event data is set on at least some fault sections. Can be used to calculate time dependent probabilities using only the historical open interval.");
        ignoreOp.setRequired(false);
        ops.addOption(ignoreOp);
        return ops;
    }

    private static CommandLine parse(Options options, String[] args) {
        try {
            GnuParser parser = new GnuParser();
            CommandLine cmd = parser.parse(options, args);
            return cmd;
        }
        catch (Exception e) {
            TimeDepRateExtractor.printHelpAndExit(e.getMessage(), options);
            return null;
        }
    }

    private static void printHelpAndExit(String message, Options options) {
        System.out.println(message);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(ClassUtils.getClassNameWithoutPackage(TimeDepRateExtractor.class), options, true);
        TimeDepRateExtractor.abortAndExit(2);
    }

    private static void abortAndExit(int ret) {
        TimeDepRateExtractor.abortAndExit(null, ret);
    }

    private static void abortAndExit(Throwable t) {
        TimeDepRateExtractor.abortAndExit(t, 1);
    }

    private static void abortAndExit(Throwable t, int ret) {
        if (t != null) {
            t.printStackTrace();
        }
        System.out.flush();
        System.err.flush();
        System.exit(ret);
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("TEST_FROM_ECLIPSE")) {
            args = new String[]{"--duration", "5", "--solution", "/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip", "--prob-model", "U3_PREF_BLEND,POISSON,BPT_LOW,BPT_MID,BPT_HIGH", "--binary", "--output-file", "/tmp/td_output.bin"};
        }
        try {
            Options options = TimeDepRateExtractor.createOptions();
            CommandLine cmd = TimeDepRateExtractor.parse(options, args);
            args = cmd.getArgs();
            if (args.length != 0) {
                TimeDepRateExtractor.printHelpAndExit("Unknown option(s): " + Joiner.on((String)" ").join((Object[])args), options);
            }
            System.err.println("****************************************************");
            System.err.println("WARNING: This is provided as a service and is not exhaustively tested. No warranty is expressed or implied and by using this software you agree to the OpenSHA license/disclaimer available at http://opensha.org/license");
            System.err.println("****************************************************\n");
            TimeDepRateExtractor extract = new TimeDepRateExtractor(cmd);
            extract.calc();
            System.exit(0);
        }
        catch (Throwable t) {
            TimeDepRateExtractor.abortAndExit(t);
        }
    }
}

