/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.metadata.MetadataLoader;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.LazilyInitializedList;
import org.opensha.commons.util.XMLUtils;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.U3AverageFaultSystemSolution;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.griddedSeismicity.GridSourceFileReader;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.UCERF3InversionConfiguration;
import scratch.UCERF3.inversion.laughTest.OldPlausibilityConfiguration;
import scratch.UCERF3.inversion.laughTest.UCERF3PlausibilityConfig;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.LastEventData;
import scratch.UCERF3.utils.MatrixIO;

public class U3FaultSystemIO {
    private static final boolean D = true;
    private static final boolean DD = false;

    public static U3FaultSystemRupSet loadRupSet(File file) throws ZipException, IOException, DocumentException {
        return U3FaultSystemIO.loadRupSetAsApplicable(file);
    }

    public static InversionFaultSystemRupSet loadInvRupSet(File file) throws ZipException, IOException, DocumentException {
        U3FaultSystemRupSet rupSet = U3FaultSystemIO.loadRupSetAsApplicable(file);
        Preconditions.checkArgument((boolean)(rupSet instanceof InversionFaultSystemRupSet), (Object)"Rupture set cannot be loaded as an InversionFaultSystemRupSet");
        return (InversionFaultSystemRupSet)rupSet;
    }

    public static U3FaultSystemSolution loadSol(File file) throws IOException, DocumentException {
        return U3FaultSystemIO.loadSolAsApplicable(file);
    }

    public static InversionFaultSystemSolution loadInvSol(File file) throws IOException, DocumentException {
        U3FaultSystemSolution sol = U3FaultSystemIO.loadSolAsApplicable(file);
        Preconditions.checkArgument((boolean)(sol instanceof InversionFaultSystemSolution), (Object)"Solution cannot be loaded as an InversionFaultSystemSolution");
        return (InversionFaultSystemSolution)sol;
    }

    public static boolean isSolution(File file) throws IOException {
        ZipFile zip = new ZipFile(file);
        boolean found = false;
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith("rates.bin")) continue;
            found = true;
            break;
        }
        zip.close();
        return found;
    }

    public static U3AverageFaultSystemSolution loadAvgInvSol(File file) throws IOException, DocumentException {
        U3FaultSystemSolution sol = U3FaultSystemIO.loadSolAsApplicable(file);
        Preconditions.checkArgument((boolean)(sol instanceof U3AverageFaultSystemSolution), (Object)"Solution cannot be loaded as an AverageFaultSystemSolution");
        return (U3AverageFaultSystemSolution)sol;
    }

    public static void writeRupSet(U3FaultSystemRupSet rupSet, File file) throws IOException {
        File tempDir = FileUtils.createTempDir();
        HashSet<String> zipFileNames = new HashSet<String>();
        U3FaultSystemIO.toZipFile(rupSet, file, tempDir, zipFileNames);
    }

    public static void writeSol(U3FaultSystemSolution sol, File file) throws IOException {
        File tempDir = FileUtils.createTempDir();
        HashSet<String> zipFileNames = new HashSet<String>();
        U3FaultSystemIO.toZipFile(sol, file, tempDir, zipFileNames);
    }

    public static U3FaultSystemRupSet loadRupSetAsApplicable(File file) throws ZipException, IOException, DocumentException {
        return U3FaultSystemIO.loadRupSetAsApplicable(new ZipFile(file), null);
    }

    public static U3FaultSystemRupSet loadRupSetAsApplicable(final ZipFile zip, Map<String, String> nameRemappings) throws IOException, DocumentException {
        ZipEntry clustersEntry;
        U3FaultSystemRupSet rupSet;
        UCERF3PlausibilityConfig filter;
        U3LogicTreeBranch branch;
        ArrayList<FaultSection> faultSectionData;
        block33: {
            ZipEntry magEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("mags.bin", nameRemappings));
            double[] mags = MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(magEntry)), magEntry.getSize());
            ZipEntry sectSlipsEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("sect_slips.bin", nameRemappings));
            double[] sectSlipRates = sectSlipsEntry != null ? MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(sectSlipsEntry)), sectSlipsEntry.getSize()) : null;
            ZipEntry sectSlipStdDevsEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("sect_slips_std_dev.bin", nameRemappings));
            double[] sectSlipRateStdDevs = sectSlipStdDevsEntry != null ? MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(sectSlipStdDevsEntry)), sectSlipStdDevsEntry.getSize()) : null;
            ZipEntry rakesEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("rakes.bin", nameRemappings));
            double[] rakes = MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(rakesEntry)), rakesEntry.getSize());
            ZipEntry rupAreasEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("rup_areas.bin", nameRemappings));
            double[] rupAreas = rupAreasEntry != null ? MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(rupAreasEntry)), rupAreasEntry.getSize()) : null;
            ZipEntry rupLenghtsEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("rup_lengths.bin", nameRemappings));
            double[] rupLengths = rupLenghtsEntry != null ? MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(rupLenghtsEntry)), rupLenghtsEntry.getSize()) : null;
            ZipEntry sectAreasEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("sect_areas.bin", nameRemappings));
            double[] sectAreas = sectAreasEntry != null ? MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(sectAreasEntry)), sectAreasEntry.getSize()) : null;
            ZipEntry rupSectionsEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("rup_sections.bin", nameRemappings));
            List<List<Integer>> sectionForRups = rupSectionsEntry != null ? MatrixIO.intListListFromInputStream(new BufferedInputStream(zip.getInputStream(rupSectionsEntry))) : null;
            Object fsdRemappedName = U3FaultSystemIO.getRemappedName("fault_sections.xml", nameRemappings);
            ZipEntry fsdEntry = zip.getEntry((String)fsdRemappedName);
            if (fsdEntry == null && ((String)fsdRemappedName).startsWith("FM")) {
                int ind = ((String)fsdRemappedName).indexOf("fault_sections");
                String prefix = ((String)fsdRemappedName).substring(0, ind - 1);
                fsdRemappedName = (prefix = prefix.substring(0, prefix.lastIndexOf("_"))) + "_fault_sections.xml";
                fsdEntry = zip.getEntry((String)fsdRemappedName);
                if (fsdEntry != null) {
                    System.out.println("WARNING: using old non DM-specific fault_sections.xml file, may have incorrect non reduced slip rates: " + (String)fsdRemappedName);
                }
            }
            Document doc = XMLUtils.loadDocument(new BufferedInputStream(zip.getInputStream(fsdEntry)));
            Element fsEl = doc.getRootElement().element("FaultSectionPrefDataList");
            faultSectionData = U3FaultSystemIO.fsDataFromXML(fsEl);
            ZipEntry infoEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("info.txt", nameRemappings));
            String info = U3FaultSystemIO.loadInfoFromEntry(zip, infoEntry);
            ZipEntry invXMLEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("inv_rup_set_metadata.xml", nameRemappings));
            branch = null;
            filter = null;
            if (invXMLEntry != null) {
                Element filterEl;
                Document invDoc = XMLUtils.loadDocument(zip.getInputStream(invXMLEntry));
                Element invRoot = invDoc.getRootElement().element("InversionFaultSystemRupSet");
                Element branchEl = invRoot.element("LogicTreeBranch");
                if (branchEl != null) {
                    branch = U3LogicTreeBranch.fromXMLMetadata(branchEl);
                }
                if ((filterEl = invRoot.element("LaughTestFilter")) != null) {
                    filter = UCERF3PlausibilityConfig.fromXMLMetadata(filterEl);
                }
            }
            if (branch == null && invXMLEntry == null) {
                ZipEntry rupSectionSlipModelEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("rup_sec_slip_type.txt", nameRemappings));
                SlipAlongRuptureModels slipModelType = null;
                if (rupSectionSlipModelEntry != null) {
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)zip.getInputStream(rupSectionSlipModelEntry), (Writer)writer);
                    String slipModelName = writer.toString().trim();
                    try {
                        slipModelType = SlipAlongRuptureModels.valueOf(slipModelName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                DeformationModels defModName = null;
                Attribute defModAtt = fsEl.attribute("defModName");
                try {
                    if (defModAtt != null && !defModAtt.getValue().isEmpty()) {
                        defModName = DeformationModels.valueOf(defModAtt.getValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FaultModels faultModel = null;
                Attribute faultModAtt = fsEl.attribute("faultModName");
                try {
                    if (faultModAtt != null && !faultModAtt.getValue().isEmpty()) {
                        faultModel = FaultModels.valueOf(faultModAtt.getValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (faultModel == null && defModAtt != null) {
                    if (defModName == null) {
                        String defModText = defModAtt.getValue();
                        if (defModText.contains("GEOLOGIC") && !defModText.contains("ABM")) {
                            defModName = DeformationModels.GEOLOGIC;
                        } else if (defModText.contains("NCAL")) {
                            defModName = DeformationModels.UCERF2_NCAL;
                        } else if (defModText.contains("ALLCAL")) {
                            defModName = DeformationModels.UCERF2_ALL;
                        } else if (defModText.contains("BAYAREA")) {
                            defModName = DeformationModels.UCERF2_BAYAREA;
                        }
                    }
                    if (defModName != null) {
                        faultModel = defModName.getApplicableFaultModels().get(0);
                    }
                }
                if (faultModel != null && slipModelType != null) {
                    branch = U3LogicTreeBranch.fromValues(false, faultModel, defModName, slipModelType);
                }
            }
            rupSet = new U3FaultSystemRupSet(faultSectionData, sectSlipRates, sectSlipRateStdDevs, sectAreas, sectionForRups, mags, rakes, rupAreas, rupLengths, info);
            ZipEntry plausibilityEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("plausibility.json", nameRemappings));
            if (plausibilityEntry != null) {
                InputStreamReader json = new InputStreamReader(new BufferedInputStream(zip.getInputStream(plausibilityEntry)));
                try {
                    PlausibilityConfiguration plausibilityConfig = PlausibilityConfiguration.readJSON(json, faultSectionData);
                    rupSet.setPlausibilityConfiguration(plausibilityConfig);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("WARNING: Plausibilty configuration specified, but reading it failed. Skipping");
                    if (json == null) break block33;
                    json.close();
                }
            }
        }
        if ((clustersEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("cluster_ruptures.json", nameRemappings))) != null) {
            Callable<List<ClusterRupture>> call = new Callable<List<ClusterRupture>>(){

                @Override
                public List<ClusterRupture> call() throws Exception {
                    System.out.println("Loading ClusterRupture list (lazily) from " + zip.getName());
                    InputStreamReader json = new InputStreamReader(new BufferedInputStream(zip.getInputStream(clustersEntry), 131072));
                    return ClusterRupture.readJSON(json, (List<? extends FaultSection>)faultSectionData);
                }
            };
            rupSet.setClusterRuptures(new LazilyInitializedList<ClusterRupture>(rupSet.getNumRuptures(), call));
        }
        if (branch != null) {
            ZipEntry rupSlipsEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("rup_avg_slips.bin", nameRemappings));
            double[] rupAveSlips = rupSlipsEntry != null ? MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(rupSlipsEntry)), rupSlipsEntry.getSize()) : null;
            ZipEntry closeSectionsEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("close_sections.bin", nameRemappings));
            List<List<Integer>> closeSections = closeSectionsEntry != null ? MatrixIO.intListListFromInputStream(new BufferedInputStream(zip.getInputStream(closeSectionsEntry))) : null;
            ZipEntry clusterRupsEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("cluster_rups.bin", nameRemappings));
            List<List<Integer>> clusterRups = clusterRupsEntry != null ? MatrixIO.intListListFromInputStream(new BufferedInputStream(zip.getInputStream(clusterRupsEntry))) : null;
            ZipEntry clusterSectsEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("cluster_sects.bin", nameRemappings));
            List<List<Integer>> clusterSects = clusterSectsEntry != null ? MatrixIO.intListListFromInputStream(new BufferedInputStream(zip.getInputStream(clusterSectsEntry))) : null;
            try {
                Map<Integer, List<LastEventData>> data = LastEventData.load();
                LastEventData.populateSubSects(rupSet.getFaultSectionDataList(), data);
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException(e);
            }
            return new InversionFaultSystemRupSet(rupSet, branch, filter, rupAveSlips, closeSections, clusterRups, clusterSects);
        }
        return rupSet;
    }

    public static ArrayList<FaultSection> fsDataFromXML(Element el) {
        ArrayList<FaultSection> list = new ArrayList<FaultSection>();
        for (int i = 0; i < el.elements().size(); ++i) {
            FaultSection sect;
            Element subEl = el.element("i" + i);
            Attribute classAt = subEl.attribute("class");
            if (classAt == null || classAt.getValue().equals(FaultSectionPrefData.class.getCanonicalName())) {
                sect = FaultSectionPrefData.fromXMLMetadata(subEl);
            } else {
                Object sectObj;
                String className = classAt.getValue();
                try {
                    sectObj = MetadataLoader.loadXMLwithReflection(subEl, className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Defined fault section class not found, cannot load from XML: " + className, e);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("Defined fault section class does not contain static fromXMLMetadata(Element) method, cannot load from XML: " + className, e);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Defined fault section class does has unexpected method signature for fromXMLMetadata(Element) method, cannot load from XML: " + className, e);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Other error loading fault section class from XML via reflection: " + className, e);
                }
                Preconditions.checkState((boolean)(sectObj instanceof FaultSection), (String)"Fault section could be instantiated from XML, but does not implement FaultSection: %s", (Object)className);
                sect = (FaultSection)sectObj;
            }
            list.add(sect);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadInfoFromEntry(ZipFile zip, ZipEntry infoEntry) throws IOException {
        if (infoEntry != null) {
            StringBuilder text = new StringBuilder();
            String NL = System.getProperty("line.separator");
            try (Scanner scanner = new Scanner(new BufferedInputStream(zip.getInputStream(infoEntry)));){
                while (scanner.hasNextLine()) {
                    text.append(scanner.nextLine() + NL);
                }
            }
            return text.toString();
        }
        return null;
    }

    public static U3FaultSystemSolution loadSolAsApplicable(File file) throws IOException, DocumentException {
        return U3FaultSystemIO.loadSolAsApplicable(file, null);
    }

    private static U3FaultSystemSolution loadSolAsApplicable(File file, Map<String, String> nameRemappings) throws IOException, DocumentException {
        ZipFile zip = new ZipFile(file);
        return U3FaultSystemIO.loadSolAsApplicable(zip, nameRemappings);
    }

    public static U3FaultSystemSolution loadSolAsApplicable(ZipFile zip, Map<String, String> nameRemappings) throws IOException, DocumentException {
        ZipEntry subSeisMFDsEntry;
        U3FaultSystemSolution sol;
        U3FaultSystemRupSet rupSet = U3FaultSystemIO.loadRupSetAsApplicable(zip, nameRemappings);
        String infoString = rupSet.getInfoString();
        ZipEntry ratesEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("rates.bin", nameRemappings));
        double[] rates = MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(ratesEntry)), ratesEntry.getSize());
        if (rupSet instanceof InversionFaultSystemRupSet) {
            InversionFaultSystemRupSet invRupSet = (InversionFaultSystemRupSet)rupSet;
            ZipEntry invXMLEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("inv_sol_metadata.xml", nameRemappings));
            UCERF3InversionConfiguration conf = null;
            HashMap energies = null;
            if (invXMLEntry != null) {
                Element energiesEl;
                Document invDoc = XMLUtils.loadDocument(zip.getInputStream(invXMLEntry));
                Element invRoot = invDoc.getRootElement().element("InversionFaultSystemSolution");
                Element confEl = invRoot.element("InversionConfiguration");
                if (confEl != null) {
                    conf = UCERF3InversionConfiguration.fromXMLMetadata(confEl);
                }
                if ((energiesEl = invRoot.element("Energies")) != null) {
                    energies = Maps.newHashMap();
                    for (Element energyEl : XMLUtils.getSubElementsList(energiesEl)) {
                        String type = energyEl.attributeValue("type");
                        double value = Double.parseDouble(energyEl.attributeValue("value"));
                        energies.put(type, value);
                    }
                }
            } else {
                InversionFaultSystemSolution legacySol = new InversionFaultSystemSolution(invRupSet, infoString, rates);
                invRupSet.setLogicTreeBranch(legacySol.getLogicTreeBranch());
                conf = legacySol.getInversionConfiguration();
                energies = legacySol.getEnergies();
            }
            String ratesPrefix = U3FaultSystemIO.getRemappedRatesPrefix(nameRemappings);
            List<double[]> ratesList = U3FaultSystemIO.loadIndSolRates(ratesPrefix, zip, nameRemappings);
            if (ratesList == null) {
                ratesList = U3FaultSystemIO.loadIndSolRates("sol_rates", zip, nameRemappings);
            }
            sol = ratesList != null ? new U3AverageFaultSystemSolution(invRupSet, ratesList, conf, (Map<String, Double>)energies) : new InversionFaultSystemSolution(invRupSet, rates, conf, energies);
        } else {
            sol = new U3FaultSystemSolution(rupSet, rates);
        }
        ZipEntry rupMFDsEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("rup_mfds.bin", nameRemappings));
        if (rupMFDsEntry != null) {
            DiscretizedFunc[] rupMFDs = MatrixIO.discFuncsFromInputStream(zip.getInputStream(rupMFDsEntry));
            sol.setRupMagDists(rupMFDs);
        }
        if ((subSeisMFDsEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("sub_seismo_on_fault_mfds.bin", nameRemappings))) != null) {
            DiscretizedFunc[] origSubSeisMFDs = MatrixIO.discFuncsFromInputStream(zip.getInputStream(subSeisMFDsEntry));
            Preconditions.checkState((origSubSeisMFDs.length == rupSet.getNumSections() ? 1 : 0) != 0);
            ArrayList subSeisMFDs = Lists.newArrayList();
            for (int i = 0; i < origSubSeisMFDs.length; ++i) {
                subSeisMFDs.add(U3FaultSystemIO.asIncr(origSubSeisMFDs[i]));
            }
            sol.setSubSeismoOnFaultMFD_List(subSeisMFDs);
        }
        ZipEntry gridSourcesEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("grid_sources.xml", nameRemappings));
        ZipEntry gridSourcesBinEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("grid_sources.bin", nameRemappings));
        ZipEntry gridSourcesRegEntry = zip.getEntry(U3FaultSystemIO.getRemappedName("grid_sources_reg.xml", nameRemappings));
        if (gridSourcesEntry != null) {
            sol.setGridSourceProvider(GridSourceFileReader.fromInputStream(zip.getInputStream(gridSourcesEntry)));
        } else if (gridSourcesBinEntry != null && gridSourcesRegEntry != null) {
            sol.setGridSourceProvider(GridSourceFileReader.fromBinStreams(zip.getInputStream(gridSourcesBinEntry), zip.getInputStream(gridSourcesRegEntry)));
        }
        return sol;
    }

    private static List<double[]> loadIndSolRates(String ratesPrefix, ZipFile zip, Map<String, String> nameRemappings) throws IOException {
        int max_digits = 10;
        for (int digits = 1; digits <= max_digits; ++digits) {
            String ratesName;
            ZipEntry entry;
            int c = 0;
            if ((entry = zip.getEntry(ratesName = ratesPrefix + "_" + U3FaultSystemIO.getPaddedNumStr(c++, digits) + ".bin")) == null) continue;
            ArrayList ratesList = Lists.newArrayList();
            do {
                double[] rates = MatrixIO.doubleArrayFromInputStream(new BufferedInputStream(zip.getInputStream(entry)), entry.getSize());
                ratesList.add(rates);
            } while ((entry = zip.getEntry(ratesName = ratesPrefix + "_" + U3FaultSystemIO.getPaddedNumStr(c++, digits) + ".bin")) != null);
            if (ratesList.size() > 1) {
                return ratesList;
            }
            return null;
        }
        return null;
    }

    private static void toZipFile(U3FaultSystemRupSet rupSet, File file, File tempDir, HashSet<String> zipFileNames) throws IOException {
        boolean D = true;
        System.out.println("Saving rup set with " + rupSet.getNumRuptures() + " rups to: " + file.getAbsolutePath());
        U3FaultSystemIO.writeRupSetFilesForZip(rupSet, tempDir, zipFileNames, null);
        System.out.println("Making zip file: " + file.getName());
        FileUtils.createZipFile(file.getAbsolutePath(), tempDir.getAbsolutePath(), zipFileNames);
        System.out.println("Deleting temp files");
        FileUtils.deleteRecursive(tempDir);
        System.out.println("Done saving!");
    }

    public static void writeRupSetFilesForZip(U3FaultSystemRupSet rupSet, File tempDir, HashSet<String> zipFileNames, Map<String, String> nameRemappings) throws IOException {
        List<ClusterRupture> clusterRuptures;
        PlausibilityConfiguration plausibilityConfig;
        String info;
        double[] sectAreas;
        double[] sectSlipRateStdDevs;
        double[] sectSlipRates;
        System.out.println("Saving fault section xml");
        File fsdFile = new File(tempDir, U3FaultSystemIO.getRemappedName("fault_sections.xml", nameRemappings));
        if (!zipFileNames.contains(fsdFile.getName())) {
            Document doc = XMLUtils.createDocumentWithRoot();
            Element root = doc.getRootElement();
            U3FaultSystemIO.fsDataToXML(root, "FaultSectionPrefDataList", rupSet);
            XMLUtils.writeDocumentToFile(fsdFile, doc);
            zipFileNames.add(fsdFile.getName());
        }
        System.out.println("Saving mags");
        File magFile = new File(tempDir, U3FaultSystemIO.getRemappedName("mags.bin", nameRemappings));
        if (!zipFileNames.contains(magFile.getName())) {
            MatrixIO.doubleArrayToFile(rupSet.getMagForAllRups(), magFile);
            zipFileNames.add(magFile.getName());
        }
        if ((sectSlipRates = rupSet.getSlipRateForAllSections()) != null) {
            System.out.println("Saving section slips");
            File sectSlipsFile = new File(tempDir, U3FaultSystemIO.getRemappedName("sect_slips.bin", nameRemappings));
            if (!zipFileNames.contains(sectSlipsFile.getName())) {
                MatrixIO.doubleArrayToFile(sectSlipRates, sectSlipsFile);
                zipFileNames.add(sectSlipsFile.getName());
            }
        }
        if ((sectSlipRateStdDevs = rupSet.getSlipRateStdDevForAllSections()) != null) {
            System.out.println("Saving slip std devs");
            File sectSlipStdDevsFile = new File(tempDir, U3FaultSystemIO.getRemappedName("sect_slips_std_dev.bin", nameRemappings));
            if (!zipFileNames.contains(sectSlipStdDevsFile.getName())) {
                MatrixIO.doubleArrayToFile(sectSlipRateStdDevs, sectSlipStdDevsFile);
                zipFileNames.add(sectSlipStdDevsFile.getName());
            }
        }
        System.out.println("Saving rakes");
        File rakesFile = new File(tempDir, U3FaultSystemIO.getRemappedName("rakes.bin", nameRemappings));
        if (!zipFileNames.contains(rakesFile.getName())) {
            MatrixIO.doubleArrayToFile(rupSet.getAveRakeForAllRups(), rakesFile);
            zipFileNames.add(rakesFile.getName());
        }
        System.out.println("Saving rup areas");
        File rupAreasFile = new File(tempDir, U3FaultSystemIO.getRemappedName("rup_areas.bin", nameRemappings));
        if (!zipFileNames.contains(rupAreasFile.getName())) {
            MatrixIO.doubleArrayToFile(rupSet.getAreaForAllRups(), rupAreasFile);
            zipFileNames.add(rupAreasFile.getName());
        }
        if (rupSet.getLengthForAllRups() != null) {
            System.out.println("Saving rup lengths");
            File rupLengthsFile = new File(tempDir, U3FaultSystemIO.getRemappedName("rup_lengths.bin", nameRemappings));
            if (!zipFileNames.contains(rupLengthsFile.getName())) {
                MatrixIO.doubleArrayToFile(rupSet.getLengthForAllRups(), rupLengthsFile);
                zipFileNames.add(rupLengthsFile.getName());
            }
        }
        if ((sectAreas = rupSet.getAreaForAllSections()) != null) {
            System.out.println("Saving sect areas");
            File sectAreasFile = new File(tempDir, U3FaultSystemIO.getRemappedName("sect_areas.bin", nameRemappings));
            if (!zipFileNames.contains(sectAreasFile.getName())) {
                MatrixIO.doubleArrayToFile(sectAreas, sectAreasFile);
                zipFileNames.add(sectAreasFile.getName());
            }
        }
        System.out.println("Saving rup sections");
        File sectionsForRupsFile = new File(tempDir, U3FaultSystemIO.getRemappedName("rup_sections.bin", nameRemappings));
        if (!zipFileNames.contains(sectionsForRupsFile.getName())) {
            MatrixIO.intListListToFile(rupSet.getSectionIndicesForAllRups(), sectionsForRupsFile);
            zipFileNames.add(sectionsForRupsFile.getName());
        }
        if ((info = rupSet.getInfoString()) != null && !info.isEmpty()) {
            System.out.println("Saving info");
            File infoFile = new File(tempDir, U3FaultSystemIO.getRemappedName("info.txt", nameRemappings));
            if (!zipFileNames.contains(infoFile.getName())) {
                FileWriter fw = new FileWriter(infoFile);
                fw.write(info + "\n");
                fw.close();
                zipFileNames.add(infoFile.getName());
            }
        }
        if ((plausibilityConfig = rupSet.getPlausibilityConfiguration()) != null) {
            System.out.println("Saving plausibility config");
            File plausibilityFile = new File(tempDir, U3FaultSystemIO.getRemappedName("plausibility.json", nameRemappings));
            plausibilityConfig.writeJSON(plausibilityFile);
            zipFileNames.add(plausibilityFile.getName());
        }
        if ((clusterRuptures = rupSet.getClusterRuptures()) != null) {
            System.out.println("Saving cluster ruptures");
            File clusterFile = new File(tempDir, U3FaultSystemIO.getRemappedName("cluster_ruptures.json", nameRemappings));
            ClusterRupture.writeJSON(clusterFile, clusterRuptures, rupSet.getFaultSectionDataList());
            zipFileNames.add(clusterFile.getName());
        }
        if (rupSet instanceof InversionFaultSystemRupSet) {
            List<List<Integer>> closeSections;
            double[] rupAveSlips;
            System.out.println("Saving InversionFaultSystemRupSet specific data");
            InversionFaultSystemRupSet invRupSet = (InversionFaultSystemRupSet)rupSet;
            System.out.println("Saving inversion rup set metadata xml");
            File invFile = new File(tempDir, U3FaultSystemIO.getRemappedName("inv_rup_set_metadata.xml", nameRemappings));
            if (!zipFileNames.contains(invFile.getName())) {
                Document doc = XMLUtils.createDocumentWithRoot();
                Element root = doc.getRootElement();
                U3FaultSystemIO.invRupSetDataToXML(root, invRupSet);
                XMLUtils.writeDocumentToFile(invFile, doc);
                zipFileNames.add(invFile.getName());
            }
            if ((rupAveSlips = invRupSet.getAveSlipForAllRups()) != null) {
                System.out.println("Saving rup avg slips");
                File rupSlipsFile = new File(tempDir, U3FaultSystemIO.getRemappedName("rup_avg_slips.bin", nameRemappings));
                if (!zipFileNames.contains(rupSlipsFile.getName())) {
                    MatrixIO.doubleArrayToFile(rupAveSlips, rupSlipsFile);
                    zipFileNames.add(rupSlipsFile.getName());
                }
            }
            if ((closeSections = invRupSet.getCloseSectionsListList()) != null) {
                System.out.println("Saving close sections");
                File closeSectionsFile = new File(tempDir, U3FaultSystemIO.getRemappedName("close_sections.bin", nameRemappings));
                if (!zipFileNames.contains(closeSectionsFile.getName())) {
                    MatrixIO.intListListToFile(closeSections, closeSectionsFile);
                    zipFileNames.add(closeSectionsFile.getName());
                }
            }
            if (invRupSet.getNumClusters() > 0) {
                ArrayList clusterRups = Lists.newArrayList();
                ArrayList clusterSects = Lists.newArrayList();
                for (int c = 0; c < invRupSet.getNumClusters(); ++c) {
                    clusterRups.add(invRupSet.getRupturesForCluster(c));
                    clusterSects.add(invRupSet.getSectionsForCluster(c));
                }
                System.out.println("Saving cluster rups");
                File clusterRupsFile = new File(tempDir, U3FaultSystemIO.getRemappedName("cluster_rups.bin", nameRemappings));
                if (!zipFileNames.contains(clusterRupsFile.getName())) {
                    MatrixIO.intListListToFile(clusterRups, clusterRupsFile);
                    zipFileNames.add(clusterRupsFile.getName());
                }
                System.out.println("Saving cluster sects");
                File clusterSectsFile = new File(tempDir, U3FaultSystemIO.getRemappedName("cluster_sects.bin", nameRemappings));
                if (!zipFileNames.contains(clusterSectsFile.getName())) {
                    MatrixIO.intListListToFile(clusterSects, clusterSectsFile);
                    zipFileNames.add(clusterSectsFile.getName());
                }
            }
        }
    }

    public static void fsDataToXML(Element parent, String elName, FaultSystemRupSet rupSet) {
        FaultModels fm = null;
        DeformationModels dm = null;
        if (rupSet.hasModule(U3LogicTreeBranch.class)) {
            U3LogicTreeBranch branch = rupSet.requireModule(U3LogicTreeBranch.class);
            fm = branch.getValue(FaultModels.class);
            dm = branch.getValue(DeformationModels.class);
        }
        U3FaultSystemIO.fsDataToXML(parent, elName, fm, dm, rupSet.getFaultSectionDataList());
    }

    public static void fsDataToXML(Element parent, String elName, FaultModels fm, DeformationModels dm, List<? extends FaultSection> fsd) {
        Element el = parent.addElement(elName);
        if (dm != null) {
            el.addAttribute("defModName", dm.name());
        }
        if (fm != null) {
            el.addAttribute("faultModName", fm.name());
        }
        for (int i = 0; i < fsd.size(); ++i) {
            FaultSection data = fsd.get(i);
            data.toXMLMetadata(el, "i" + i);
        }
    }

    private static void invRupSetDataToXML(Element root, InversionFaultSystemRupSet invRupSet) {
        OldPlausibilityConfiguration filter;
        Element el = root.addElement("InversionFaultSystemRupSet");
        U3LogicTreeBranch branch = invRupSet.getLogicTreeBranch();
        if (branch != null) {
            branch.toXMLMetadata(el);
        }
        if ((filter = invRupSet.getOldPlausibilityConfiguration()) != null) {
            filter.toXMLMetadata(el);
        }
    }

    private static String getRemappedName(String name, Map<String, String> nameRemappings) {
        if (nameRemappings == null) {
            return name;
        }
        return nameRemappings.get(name);
    }

    private static void toZipFile(U3FaultSystemSolution sol, File file, File tempDir, HashSet<String> zipFileNames) throws IOException {
        boolean D = true;
        System.out.println("Saving solution with " + sol.getRupSet().getNumRuptures() + " rups to: " + file.getAbsolutePath());
        U3FaultSystemIO.writeSolFilesForZip(sol, tempDir, zipFileNames, null);
        System.out.println("Making zip file: " + file.getName());
        FileUtils.createZipFile(file.getAbsolutePath(), tempDir.getAbsolutePath(), zipFileNames);
        System.out.println("Deleting temp files");
        FileUtils.deleteRecursive(tempDir);
        System.out.println("Done saving!");
    }

    public static void writeSolFilesForZip(U3FaultSystemSolution sol, File tempDir, HashSet<String> zipFileNames, Map<String, String> nameRemappings) throws IOException {
        MFDGridSourceProvider gridSources;
        String info;
        List<? extends IncrementalMagFreqDist> subSeisMFDs;
        U3FaultSystemIO.writeRupSetFilesForZip(sol.getRupSet(), tempDir, zipFileNames, nameRemappings);
        File ratesFile = new File(tempDir, U3FaultSystemIO.getRemappedName("rates.bin", nameRemappings));
        MatrixIO.doubleArrayToFile(sol.getRateForAllRups(), ratesFile);
        zipFileNames.add(ratesFile.getName());
        DiscretizedFunc[] rupMFDs = sol.getRupMagDists();
        if (rupMFDs != null) {
            File mfdFile = new File(tempDir, U3FaultSystemIO.getRemappedName("rup_mfds.bin", nameRemappings));
            MatrixIO.discFuncsToFile(rupMFDs, mfdFile);
            zipFileNames.add(mfdFile.getName());
        }
        if ((subSeisMFDs = sol.getSubSeismoOnFaultMFD_List()) != null) {
            File mfdFile = new File(tempDir, U3FaultSystemIO.getRemappedName("sub_seismo_on_fault_mfds.bin", nameRemappings));
            DiscretizedFunc[] subSeisMFDsArray = new DiscretizedFunc[subSeisMFDs.size()];
            for (int i = 0; i < subSeisMFDs.size(); ++i) {
                subSeisMFDsArray[i] = subSeisMFDs.get(i);
            }
            MatrixIO.discFuncsToFile(subSeisMFDsArray, mfdFile);
            zipFileNames.add(mfdFile.getName());
        }
        if ((info = sol.getInfoString()) != null && !info.isEmpty()) {
            System.out.println("Saving info");
            File infoFile = new File(tempDir, U3FaultSystemIO.getRemappedName("info.txt", nameRemappings));
            FileWriter fw = new FileWriter(infoFile);
            fw.write(info + "\n");
            fw.close();
            zipFileNames.add(infoFile.getName());
        }
        if ((gridSources = (MFDGridSourceProvider)sol.getGridSourceProvider()) != null) {
            System.out.println("Saving grid sources to binary file");
            File gridSourcesBinFile = new File(tempDir, U3FaultSystemIO.getRemappedName("grid_sources.bin", nameRemappings));
            File gridSourcesRegFile = new File(tempDir, U3FaultSystemIO.getRemappedName("grid_sources_reg.xml", nameRemappings));
            if (!zipFileNames.contains(gridSourcesBinFile.getName()) && !zipFileNames.contains(gridSourcesRegFile.getName())) {
                GridSourceFileReader.writeGriddedSeisBinFile(gridSourcesBinFile, gridSourcesRegFile, gridSources, 0.0);
                zipFileNames.add(gridSourcesBinFile.getName());
                zipFileNames.add(gridSourcesRegFile.getName());
            }
        }
        if (sol instanceof InversionFaultSystemSolution) {
            System.out.println("Saving InversionFaultSystemSolution specific data");
            InversionFaultSystemSolution invSol = (InversionFaultSystemSolution)sol;
            System.out.println("Saving inversion solution metadata xml");
            File invFile = new File(tempDir, U3FaultSystemIO.getRemappedName("inv_sol_metadata.xml", nameRemappings));
            if (!zipFileNames.contains(invFile.getName())) {
                Document doc = XMLUtils.createDocumentWithRoot();
                Element root = doc.getRootElement();
                U3FaultSystemIO.invSolDataToXML(root, invSol);
                XMLUtils.writeDocumentToFile(invFile, doc);
                zipFileNames.add(invFile.getName());
            }
            if (sol instanceof U3AverageFaultSystemSolution) {
                U3AverageFaultSystemSolution avgSol = (U3AverageFaultSystemSolution)sol;
                int numSols = avgSol.getNumSolutions();
                System.out.println("Saving AverageFaultSystemSolution specific data for " + numSols + " solutions");
                String ratesPrefix = U3FaultSystemIO.getRemappedRatesPrefix(nameRemappings);
                int digits = new String("" + (numSols - 1)).length();
                for (int s = 0; s < numSols; ++s) {
                    double[] rates = avgSol.getRates(s);
                    String rateStr = U3FaultSystemIO.getPaddedNumStr(s, digits);
                    File rateSubFile = new File(tempDir, ratesPrefix + "_" + rateStr + ".bin");
                    MatrixIO.doubleArrayToFile(rates, rateSubFile);
                    zipFileNames.add(rateSubFile.getName());
                }
            }
        }
    }

    private static void invSolDataToXML(Element root, InversionFaultSystemSolution invSol) {
        Map<String, Double> energies;
        Element el = root.addElement("InversionFaultSystemSolution");
        UCERF3InversionConfiguration conf = invSol.getInversionConfiguration();
        if (conf != null) {
            conf.toXMLMetadata(el);
        }
        if ((energies = invSol.getEnergies()) != null && !energies.isEmpty()) {
            Element energiesEl = el.addElement("Energies");
            for (String type : energies.keySet()) {
                double energy = energies.get(type);
                Element energyEl = energiesEl.addElement("Energy");
                energyEl.addAttribute("type", type);
                energyEl.addAttribute("value", "" + energy);
            }
        }
    }

    private static String getRemappedRatesPrefix(Map<String, String> nameRemappings) {
        String ratesPrefix = U3FaultSystemIO.getRemappedName("rates.bin", nameRemappings);
        ratesPrefix = ratesPrefix.substring(0, ratesPrefix.indexOf(".bin"));
        return ratesPrefix;
    }

    private static String getPaddedNumStr(int num, int digits) {
        String str = "" + num;
        while (str.length() < digits) {
            str = "0" + str;
        }
        return str;
    }

    public static IncrementalMagFreqDist asIncr(DiscretizedFunc func) {
        IncrementalMagFreqDist mfd;
        if (func instanceof EvenlyDiscretizedFunc) {
            EvenlyDiscretizedFunc eFunc = (EvenlyDiscretizedFunc)func;
            mfd = new IncrementalMagFreqDist(eFunc.getMinX(), eFunc.size(), eFunc.getDelta());
        } else {
            mfd = new IncrementalMagFreqDist(func.getMinX(), func.size(), func.getX(1) - func.getX(0));
        }
        mfd.setInfo(func.getInfo());
        mfd.setName(func.getName());
        mfd.setXAxisName(func.getXAxisName());
        mfd.setYAxisName(func.getYAxisName());
        for (int i = 0; i < func.size(); ++i) {
            mfd.set(i, func.getY(i));
            Preconditions.checkState(((float)mfd.getX(i) == (float)func.getX(i) ? 1 : 0) != 0);
        }
        return mfd;
    }
}

