/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class U3SectionMFD_constraint {
    static final boolean D = false;
    private ArrayList<Double> mags = new ArrayList();
    private double[] rates;
    private ArrayList<Double> magEdges = new ArrayList();
    private double maxMag;
    private double minMag;
    private double origMinMag;
    private double upperDelta;
    private transient SummedMagFreqDist targetMFD;
    private transient EvenlyDiscretizedFunc targetCumMFD;
    public static final double DIST_BET_FIRST_AND_SECOND_BIN = 0.18;
    public static final double DIST_BET_SECOND_AND_THIRD_BIN = 0.12;
    public static final double MAX_UPPER_DELTA = 0.1;

    public U3SectionMFD_constraint(FaultSystemSolution fltSysSol, int subSectIndex) {
        FaultSystemRupSet rupSet = fltSysSol.getRupSet();
        this.origMinMag = 100.0;
        this.maxMag = 0.0;
        ArrayList<Double> rupMags = new ArrayList<Double>();
        ArrayList<Double> rupNuclRates = new ArrayList<Double>();
        for (int r : rupSet.getRupturesForSection(subSectIndex)) {
            double rate = fltSysSol.getRateForRup(r);
            if (!(rate > 0.0)) continue;
            rupNuclRates.add(rate * rupSet.getAreaForSection(subSectIndex) / rupSet.getAreaForRup(r));
            double mag = rupSet.getMagForRup(r);
            rupMags.add(mag);
            if (this.origMinMag > mag) {
                this.origMinMag = mag;
            }
            if (!(this.maxMag < mag)) continue;
            this.maxMag = mag;
        }
        this.makeMagBinArrays();
        this.rates = new double[this.mags.size()];
        for (int r = 0; r < rupNuclRates.size(); ++r) {
            double mag = (Double)rupMags.get(r);
            for (int i = 0; i < this.mags.size(); ++i) {
                if (!this.isMagInBin(mag, i)) continue;
                int n = i;
                this.rates[n] = this.rates[n] + (Double)rupNuclRates.get(r);
            }
        }
        double targetDelta = 0.01;
        double magRange = this.magEdges.get(this.magEdges.size() - 1) - this.magEdges.get(0);
        int numPts = (int)Math.round(magRange / targetDelta);
        double delta = magRange / (double)numPts;
        double distMinMag = this.magEdges.get(0) + delta / 2.0;
        double distMaxMag = this.magEdges.get(this.magEdges.size() - 1) - delta / 2.0;
        this.targetMFD = new SummedMagFreqDist(distMinMag, numPts, delta);
        this.targetMFD.setName("Target MFD");
        this.targetMFD.setInfo("(mags and rates from fault system solution)");
        for (int r = 0; r < rupNuclRates.size(); ++r) {
            this.targetMFD.addResampledMagRate((Double)rupMags.get(r), (Double)rupNuclRates.get(r), true);
        }
        this.targetCumMFD = this.targetMFD.getCumRateDistWithOffset();
        this.targetCumMFD.setName("Cumulative Target MFD");
        this.targetCumMFD.setInfo("(mags and cumulative rates from fault system solution)");
        this.targetMFD.scale(1.0 / this.targetMFD.getDelta());
    }

    public U3SectionMFD_constraint(double minMag, FaultSystemSolution fltSysSol, int subSectIndex) {
        FaultSystemRupSet rupSet = fltSysSol.getRupSet();
        this.origMinMag = minMag;
        this.maxMag = 0.0;
        ArrayList<Integer> allSubsectIndicesForParent = new ArrayList<Integer>();
        List<? extends FaultSection> sectDataList = rupSet.getFaultSectionDataList();
        int parIndex = sectDataList.get(subSectIndex).getParentSectionId();
        double totParSectArea = 0.0;
        for (FaultSection faultSection : sectDataList) {
            if (faultSection.getParentSectionId() != parIndex) continue;
            allSubsectIndicesForParent.add(faultSection.getSectionId());
            totParSectArea += faultSection.getReducedDownDipWidth() * faultSection.getTraceLength();
            double mMax = rupSet.getMaxMagForSection(faultSection.getSectionId());
            if (!(this.maxMag < mMax)) continue;
            this.maxMag = mMax;
        }
        this.makeMagBinArrays();
        this.rates = new double[this.mags.size()];
        ArrayList<Double> rupMags = new ArrayList<Double>();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Iterator mMax = allSubsectIndicesForParent.iterator();
        while (mMax.hasNext()) {
            int sthSubSectIndex = (Integer)mMax.next();
            for (int r : rupSet.getRupturesForSection(sthSubSectIndex)) {
                double rate = fltSysSol.getRateForRup(r);
                if (!(rate > 0.0)) continue;
                double rupNuclRate = rate * rupSet.getAreaForSection(subSectIndex) / rupSet.getAreaForRup(r);
                double mag = rupSet.getMagForRup(r);
                rupMags.add(mag);
                arrayList.add(rupNuclRate);
                for (int i = 0; i < this.mags.size(); ++i) {
                    if (!this.isMagInBin(mag, i)) continue;
                    int n = i;
                    this.rates[n] = this.rates[n] + rupNuclRate;
                }
            }
        }
        double fractionalRate = 1.0 / (double)allSubsectIndicesForParent.size();
        for (int i = 0; i < this.rates.length; ++i) {
            this.rates[i] = this.rates[i] * fractionalRate;
        }
        double targetDelta = 0.01;
        double magRange = this.magEdges.get(this.magEdges.size() - 1) - this.magEdges.get(0);
        int numPts = (int)Math.round(magRange / targetDelta);
        double delta = magRange / (double)numPts;
        double distMinMag = this.magEdges.get(0) + delta / 2.0;
        this.targetMFD = new SummedMagFreqDist(distMinMag, numPts, delta);
        this.targetMFD.setName("Target MFD");
        this.targetMFD.setInfo("(mags and rates from fault system solution)");
        for (int r = 0; r < arrayList.size(); ++r) {
            this.targetMFD.addResampledMagRate((Double)rupMags.get(r), (Double)arrayList.get(r) * fractionalRate, true);
        }
        this.targetCumMFD = this.targetMFD.getCumRateDistWithOffset();
        this.targetCumMFD.setName("Cumulative Target MFD");
        this.targetCumMFD.setInfo("(mags and cumulative rates from fault system solution)");
        this.targetMFD.scale(1.0 / this.targetMFD.getDelta());
    }

    public U3SectionMFD_constraint(double minMag, double maxMag, double totMoRate, double fractGR) {
        this.origMinMag = minMag;
        this.maxMag = maxMag;
        this.makeMagBinArrays();
        double targetDelta = 0.01;
        double magRange = this.magEdges.get(this.magEdges.size() - 1) - this.magEdges.get(0);
        int numPts = (int)Math.round(magRange / targetDelta);
        double delta = magRange / (double)numPts;
        double distMinMag = this.magEdges.get(0) + delta / 2.0;
        double distMaxMag = this.magEdges.get(this.magEdges.size() - 1) - delta / 2.0;
        this.rates = new double[this.mags.size()];
        this.targetMFD = new SummedMagFreqDist(distMinMag, numPts, delta);
        this.targetMFD.setName("Target MFD");
        this.targetMFD.setInfo(" ");
        double totGRdistRate = 0.0;
        if (fractGR > 0.0) {
            double bValue = 1.0;
            double grMoment = totMoRate * fractGR;
            GutenbergRichterMagFreqDist grDist = new GutenbergRichterMagFreqDist(distMinMag, numPts, delta, grMoment, bValue);
            this.testFractDifference(grDist.getMagUpper(), distMaxMag, "test of grMaxMag");
            EvenlyDiscretizedFunc cumDist = grDist.getCumRateDistWithOffset();
            cumDist.setTolerance(1.0E-8);
            for (int i = 0; i < this.mags.size(); ++i) {
                double rate1 = cumDist.getInterpolatedY_inLogYDomain(this.magEdges.get(i));
                double rate2 = i == this.mags.size() - 1 ? 0.0 : cumDist.getInterpolatedY_inLogYDomain(this.magEdges.get(i + 1));
                this.rates[i] = rate1 - rate2;
            }
            this.targetMFD.addIncrementalMagFreqDist(grDist);
            totGRdistRate = grDist.getTotalIncrRate();
        }
        if (fractGR < 1.0) {
            double charMag = this.mags.get(this.mags.size() - 1);
            double charMoRate = totMoRate * (1.0 - fractGR);
            double charRateAtMaxMag = charMoRate / MagUtils.magToMoment(charMag);
            int n = this.rates.length - 1;
            this.rates[n] = this.rates[n] + charRateAtMaxMag;
            this.targetMFD.addResampledMagRate(charMag, charRateAtMaxMag, true);
        }
        for (int i = 0; i < this.rates.length; ++i) {
            if (!(this.rates[i] <= 0.0)) continue;
            throw new RuntimeException("Non-zero rate at bin # " + i + ";\tmag=" + String.valueOf(this.mags.get(i)));
        }
        this.targetCumMFD = this.targetMFD.getCumRateDistWithOffset();
        this.targetCumMFD.setName("Cumulative Target MFD");
        this.targetMFD.scale(1.0 / this.targetMFD.getDelta());
    }

    private void testMagBinArrays() {
        int i;
        System.out.println("minMag=" + this.minMag + "\tmaxMag=" + this.maxMag);
        System.out.println("numMags=" + this.mags.size() + "\tnumMagEdges=" + this.magEdges.size() + "\n");
        System.out.println("edge\tmag\tdMag\tdBin\tdiffBetMagAndBinCenter");
        for (i = 0; i < this.magEdges.size() - 1; ++i) {
            if (i == 0) {
                System.out.println((float)this.magEdges.get(i).doubleValue());
            } else {
                System.out.println((float)this.magEdges.get(i).doubleValue() + "\t\t" + (float)(this.mags.get(i) - this.mags.get(i - 1)));
            }
            double magDiff = this.mags.get(i) - (this.magEdges.get(i + 1) + this.magEdges.get(i)) / 2.0;
            System.out.println("\t" + (float)this.mags.get(i).doubleValue() + "\t\t" + (float)(this.magEdges.get(i + 1) - this.magEdges.get(i)) + "\t" + (float)magDiff);
        }
        System.out.println((float)this.magEdges.get(this.magEdges.size() - 1).doubleValue());
        if (this.mags.size() > 1) {
            this.testFractDifference(this.mags.get(1) - this.mags.get(0), 0.18, "test dist between mag indices: 0 & 1");
        }
        if (this.mags.size() > 2) {
            this.testFractDifference(this.mags.get(2) - this.mags.get(1), 0.12, "test dist between mag indices: 1 & 2");
        }
        for (i = 3; i < this.mags.size(); ++i) {
            this.testFractDifference(this.mags.get(i) - this.mags.get(i - 1), this.upperDelta, "test dist between mag indices: " + i + " & " + (i + 1));
        }
        double firstEdge = this.magEdges.get(0);
        double roundTest = (double)Math.round(firstEdge * 10.0) / 10.0;
        this.testFractDifference(roundTest, firstEdge, "test of rounding of the first bin edge");
        for (int i2 = 0; i2 < this.mags.size() - 1; ++i2) {
            this.testFractDifference((this.mags.get(i2) + this.mags.get(i2 + 1)) / 2.0, this.magEdges.get(i2 + 1), "test mag bin edge for index: " + (i2 + 1) + "\t" + String.valueOf(this.mags.get(i2)) + "\t" + String.valueOf(this.mags.get(i2 + 1)));
        }
        if (this.mags.size() > 2) {
            this.testFractDifference(this.mags.get(this.mags.size() - 1) + this.upperDelta / 2.0, this.magEdges.get(this.magEdges.size() - 1), "test mag bin edge for index: " + (this.magEdges.size() - 1));
        } else if (this.mags.size() == 2) {
            this.testFractDifference(this.mags.get(this.mags.size() - 1) + 0.06, this.magEdges.get(this.magEdges.size() - 1), "test mag bin edge for index: " + (this.magEdges.size() - 1));
        }
    }

    private void makeMagBinArrays() {
        int currentBin = 0;
        double firstEdge = U3SectionMFD_constraint.getLowerEdgeOfFirstBin(this.origMinMag);
        this.minMag = firstEdge + 0.09;
        this.minMag = (double)Math.round(this.minMag * 100.0) / 100.0;
        if (this.maxMag <= firstEdge) {
            throw new RuntimeException("maxMag must be greater than first bin edge); firstEdge=" + firstEdge + "\tmaxmag=" + this.maxMag);
        }
        this.mags.add(this.minMag);
        this.magEdges.add(firstEdge);
        this.magEdges.add(this.minMag + 0.09);
        if (!this.isMagInBin(this.maxMag, currentBin)) {
            currentBin = 1;
            this.mags.add(this.mags.get(0) + 0.18);
            this.magEdges.add(this.mags.get(1) + 0.06);
            if (!this.isMagInBin(this.maxMag, currentBin)) {
                currentBin = 2;
                this.mags.add(this.mags.get(1) + 0.12);
                double nextEdgeTest = this.mags.get(2) + 0.05;
                if (this.maxMag < nextEdgeTest) {
                    this.magEdges.add(nextEdgeTest);
                    if (!this.isMagInBin(this.maxMag, currentBin)) {
                        throw new RuntimeException("Problem");
                    }
                } else {
                    double magRange = this.maxMag - this.mags.get(2);
                    this.upperDelta = magRange / Math.ceil(magRange / 0.1);
                    this.magEdges.add(this.mags.get(2) + this.upperDelta / 2.0);
                    while (!this.isMagInBin(this.maxMag, currentBin)) {
                        this.mags.add(this.mags.get(++currentBin - 1) + this.upperDelta);
                        this.magEdges.add(this.mags.get(currentBin) + this.upperDelta / 2.0);
                    }
                }
            }
        }
    }

    public boolean isMagInBin(double mag, int ithBin) {
        return mag < this.magEdges.get(ithBin + 1) && this.magEdges.get(ithBin) <= mag;
    }

    public int getIndexForMag(double mag) {
        for (int i = 0; i < this.getNumMags(); ++i) {
            if (!this.isMagInBin(mag, i)) continue;
            return i;
        }
        return -1;
    }

    private void testFractDifference(double val1, double val2, String infoString) {
        double diff = Math.abs((val1 - val2) / val1);
        if (diff > 1.0E-6) {
            throw new RuntimeException("Problem with " + infoString + "\tval1=" + val1 + "\tval2=" + val2 + "\tfrDiff=" + diff);
        }
    }

    public static double getLowerEdgeOfFirstBin(double origMinMag) {
        double edgeMag = origMinMag - 0.09;
        return Math.floor(edgeMag * 10.0) / 10.0;
    }

    private IncrementalMagFreqDist getTargetMFD() {
        return this.targetMFD;
    }

    private EvenlyDiscretizedFunc getTargetCumMFD() {
        return this.targetCumMFD;
    }

    public ArbitrarilyDiscretizedFunc getCumMFD() {
        double[] cumRates = new double[this.rates.length];
        cumRates[cumRates.length - 1] = this.rates[this.rates.length - 1];
        for (int i = this.rates.length - 2; i >= 0; --i) {
            cumRates[i] = this.rates[i] + cumRates[i + 1];
        }
        ArbitrarilyDiscretizedFunc cumMFD = new ArbitrarilyDiscretizedFunc("Cumulative MFD Constraint (red circles)");
        for (int i = 0; i < this.rates.length; ++i) {
            cumMFD.set(this.magEdges.get(i), cumRates[i]);
        }
        return cumMFD;
    }

    public ArbIncrementalMagFreqDist getResampledToEventlyDiscrMFD(double minMag, int numMag, double deltaMag) {
        ArbitrarilyDiscretizedFunc cumFunc = this.getCumMFD();
        ArbIncrementalMagFreqDist mfd = new ArbIncrementalMagFreqDist(minMag, numMag, deltaMag);
        for (int i = 0; i < mfd.size(); ++i) {
            double magBinLower = mfd.getX(i) - deltaMag / 2.0;
            double magBinUpper = mfd.getX(i) + deltaMag / 2.0;
            double rateLower = magBinLower <= cumFunc.getX(0) ? cumFunc.getY(0) : (magBinLower > cumFunc.getX(cumFunc.size() - 1) ? 0.0 : cumFunc.getInterpolatedY_inLogYDomain(magBinLower));
            double rateUpper = magBinUpper <= cumFunc.getX(0) ? cumFunc.getY(0) : (magBinUpper > cumFunc.getX(cumFunc.size() - 1) ? 0.0 : cumFunc.getInterpolatedY_inLogYDomain(magBinUpper));
            mfd.set(i, rateLower - rateUpper);
        }
        return mfd;
    }

    public ArbitrarilyDiscretizedFunc getMFD() {
        double[] scaledRates = new double[this.rates.length];
        for (int i = 0; i < this.rates.length; ++i) {
            scaledRates[i] = this.rates[i] / this.getBinWidth(i);
        }
        ArbitrarilyDiscretizedFunc mfd = new ArbitrarilyDiscretizedFunc("MFD Constraint");
        mfd.setInfo("(origMinMag=" + this.origMinMag + "\tminMag=" + this.minMag + "\tmaxMag=" + this.maxMag + ")");
        mfd.set(this.magEdges.get(0), scaledRates[0]);
        for (int i = 0; i < this.rates.length; ++i) {
            double mag = this.magEdges.get(i + 1);
            if (i == this.rates.length - 1) {
                mfd.set(mag, scaledRates[i]);
                continue;
            }
            mfd.set(mag - 0.001, scaledRates[i]);
            mfd.set(mag + 0.001, scaledRates[i + 1]);
        }
        return mfd;
    }

    private double getBinWidth(int ithBin) {
        return this.magEdges.get(ithBin + 1) - this.magEdges.get(ithBin);
    }

    public void plotMFDs() {
        ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
        funcs.add(this.getCumMFD());
        funcs.add(this.getMFD());
        funcs.add(this.getTargetCumMFD());
        funcs.add(this.getTargetMFD());
        ArbIncrementalMagFreqDist evenlyMFD = this.getResampledToEventlyDiscrMFD(0.05, 100, 0.1);
        evenlyMFD.scale(1.0 / evenlyMFD.getDelta());
        funcs.add(evenlyMFD);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, PlotSymbol.CIRCLE, 4.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        GraphWindow graph = new GraphWindow(funcs, "Section Constraint MFDs", plotChars);
        graph.setX_AxisLabel("Mangitude");
        graph.setY_AxisLabel("Rate (per year)");
        graph.setAxisRange(6.0, 8.5, 1.0E-8, 0.01);
        graph.setYLog(true);
    }

    public int getNumMags() {
        return this.mags.size();
    }

    public double getRate(int ithMag) {
        return this.rates[ithMag];
    }

    public double getMag(int ithMag) {
        return this.mags.get(ithMag);
    }

    public String toString() {
        Object str = "Bin edges:\n";
        for (int i = 0; i < this.mags.size(); ++i) {
            str = (String)str + String.valueOf(this.magEdges.get(i)) + "\t" + String.valueOf(this.magEdges.get(i + 1)) + "\n";
        }
        return str;
    }

    public static void main(String[] args) {
    }
}

