/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.RegionUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.utils.MFD_InversionConstraint;
import scratch.UCERF3.utils.ModUCERF2.ModMeanUCERF2;

public class UCERF2_MFD_ConstraintFetcher {
    ModMeanUCERF2 modMeanUCERF2;
    Region region;
    SummedMagFreqDist totalMFD;
    SummedMagFreqDist faultMFD;
    SummedMagFreqDist backgroundSeisMFD;
    SummedMagFreqDist targetMinusBackgroundMFD;
    GutenbergRichterMagFreqDist targetMFD;
    static final double MIN_MAG = 5.05;
    static final int NUM_MAG = 40;
    static final double DELTA_MAG = 0.1;
    static final double B_VALUE = 1.0;
    static final int LAST_FLT_SRC_INDEX = 408;

    public UCERF2_MFD_ConstraintFetcher() {
        this(null);
    }

    public UCERF2_MFD_ConstraintFetcher(Region region) {
        long startRunTime = System.currentTimeMillis();
        double forecastDuration = 1.0;
        this.modMeanUCERF2 = new ModMeanUCERF2();
        this.modMeanUCERF2.setParameter("Rupture Offset", 10.0);
        this.modMeanUCERF2.getParameter("Probability Model").setValue("Poisson");
        this.modMeanUCERF2.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_INCLUDE);
        this.modMeanUCERF2.setParameter(UCERF2.BACK_SEIS_RUP_NAME, UCERF2.BACK_SEIS_RUP_POINT);
        this.modMeanUCERF2.getTimeSpan().setDuration(forecastDuration);
        this.modMeanUCERF2.updateForecast();
        double runtime = (System.currentTimeMillis() - startRunTime) / 1000L;
        if (region != null) {
            this.setRegion(region);
        }
    }

    public void setRegion(Region region) {
        this.region = region;
        this.computeMFDs();
    }

    public MFD_InversionConstraint getTargetMinusBackgrMFD_Constraint() {
        return new MFD_InversionConstraint(this.targetMinusBackgroundMFD, this.region);
    }

    public MFD_InversionConstraint getTargetMFDConstraint() {
        return new MFD_InversionConstraint(this.targetMFD, this.region);
    }

    public SummedMagFreqDist getTotalMFD() {
        return this.totalMFD;
    }

    public SummedMagFreqDist getFaultMFD() {
        return this.faultMFD;
    }

    public SummedMagFreqDist getBackgroundSeisMFD() {
        return this.backgroundSeisMFD;
    }

    public SummedMagFreqDist getTargetMinusBackgroundMFD() {
        return this.targetMinusBackgroundMFD;
    }

    public GutenbergRichterMagFreqDist targetMFD() {
        return this.targetMFD;
    }

    private void computeMFDs() {
        if (this.region == null) {
            throw new RuntimeException("Error: Region has not been set");
        }
        this.totalMFD = new SummedMagFreqDist(5.05, 40, 0.1);
        this.faultMFD = new SummedMagFreqDist(5.05, 40, 0.1);
        this.backgroundSeisMFD = new SummedMagFreqDist(5.05, 40, 0.1);
        this.targetMinusBackgroundMFD = new SummedMagFreqDist(5.05, 40, 0.1);
        double duration = this.modMeanUCERF2.getTimeSpan().getDuration();
        for (int s = 0; s < this.modMeanUCERF2.getNumSources(); ++s) {
            ProbEqkSource source = this.modMeanUCERF2.getSource(s);
            for (int r = 0; r < source.getNumRuptures(); ++r) {
                ProbEqkRupture rupture = source.getRupture(r);
                double mag = rupture.getMag();
                double equivRate = rupture.getMeanAnnualRate(duration);
                double fractionInside = RegionUtils.getFractionInside(this.region, rupture.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface());
                this.totalMFD.addResampledMagRate(mag, equivRate * fractionInside, true);
                if (s <= 408) {
                    this.faultMFD.addResampledMagRate(mag, equivRate * fractionInside, true);
                    continue;
                }
                this.backgroundSeisMFD.addResampledMagRate(mag, equivRate * fractionInside, true);
            }
        }
        this.targetMFD = new GutenbergRichterMagFreqDist(5.05, 40, 0.1, 1.0, 1.0);
        this.targetMFD.scaleToIncrRate(5.05, this.totalMFD.getY(5.05));
        this.targetMinusBackgroundMFD.addIncrementalMagFreqDist(this.targetMFD);
        this.targetMinusBackgroundMFD.subtractIncrementalMagFreqDist(this.backgroundSeisMFD);
        this.totalMFD.setName("Total MFD for UCERF2 in Region");
        this.faultMFD.setName("Total Fault MFD for UCERF2 in Region");
        this.backgroundSeisMFD.setName("Total Background Seis. MFD for UCERF2 in Region");
        this.targetMFD.setName("Target MFD for UCERF2 in Region");
        this.targetMinusBackgroundMFD.setName("Target minus Background MFD for UCERF2 in Region");
        this.totalMFD.setInfo(" ");
        this.faultMFD.setInfo(" ");
        this.backgroundSeisMFD.setInfo(" ");
        this.targetMinusBackgroundMFD.setInfo(" ");
    }

    public void plotMFDs() {
        ArrayList<IncrementalMagFreqDist> funcs = new ArrayList<IncrementalMagFreqDist>();
        funcs.add(this.totalMFD);
        funcs.add(this.faultMFD);
        funcs.add(this.backgroundSeisMFD);
        funcs.add(this.targetMFD);
        funcs.add(this.targetMinusBackgroundMFD);
        GraphWindow graph = new GraphWindow(funcs, "Mag-Freq Dists");
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setY_AxisRange(3.0E-6, 3.0);
        graph.setX_AxisRange(5.0, 9.0);
        graph.setYLog(true);
        try {
            graph.saveAsPDF("UCERF2_MFD_ConstraintFetcherPlot.pdf");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void plotCumMFDs() {
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(this.totalMFD.getCumRateDistWithOffset());
        funcs.add(this.faultMFD.getCumRateDistWithOffset());
        funcs.add(this.backgroundSeisMFD.getCumRateDistWithOffset());
        funcs.add(this.targetMFD.getCumRateDistWithOffset());
        funcs.add(this.targetMinusBackgroundMFD.getCumRateDistWithOffset());
        GraphWindow graph = new GraphWindow(funcs, "Cumulative Mag-Freq Dists");
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Cumulative Rate");
        graph.setY_AxisRange(1.0E-4, 10.0);
        graph.setX_AxisRange(5.0, 8.5);
        graph.setYLog(true);
    }

    private void computeMomentRates() {
        int s;
        int lastIndexOfFltSources = 288;
        int lastIndexOfNonCA_FltSources = 408;
        int lastIndexOfFirstBackground = 815;
        int lastIndexOfC_zones = 1919;
        double faultMoRate = 0.0;
        double nonCA_faultMoRate = 0.0;
        double cZoneMoRate = 0.0;
        double backSrcMoRate = 0.0;
        double duration = this.modMeanUCERF2.getTimeSpan().getDuration();
        for (s = 0; s <= lastIndexOfFltSources; ++s) {
            faultMoRate += this.modMeanUCERF2.getSource(s).computeEquivTotalMomentRate(duration);
        }
        for (s = lastIndexOfFltSources + 1; s <= lastIndexOfNonCA_FltSources; ++s) {
            nonCA_faultMoRate += this.modMeanUCERF2.getSource(s).computeEquivTotalMomentRate(duration);
        }
        for (s = lastIndexOfNonCA_FltSources + 1; s <= lastIndexOfFirstBackground; ++s) {
            backSrcMoRate += this.modMeanUCERF2.getSource(s).computeEquivTotalMomentRate(duration);
        }
        for (s = lastIndexOfFirstBackground + 1; s <= lastIndexOfC_zones; ++s) {
            cZoneMoRate += this.modMeanUCERF2.getSource(s).computeEquivTotalMomentRate(duration);
        }
        for (s = lastIndexOfC_zones + 1; s < this.modMeanUCERF2.getNumSources(); ++s) {
            backSrcMoRate += this.modMeanUCERF2.getSource(s).computeEquivTotalMomentRate(duration);
        }
        double moRate = 0.0;
        for (ProbEqkSource source : this.modMeanUCERF2) {
            moRate += source.computeEquivTotalMomentRate(duration);
        }
        System.out.println("totMoRate = " + (float)moRate + "\ttest=" + (float)(faultMoRate + nonCA_faultMoRate + cZoneMoRate + backSrcMoRate) + ")\nfaultMoRate = " + (float)faultMoRate + "\t(" + Math.round(100.0 * (faultMoRate / moRate)) + "%)\nnonCA_faultMoRate = " + (float)nonCA_faultMoRate + "\t(" + Math.round(100.0 * (nonCA_faultMoRate / moRate)) + "%)\ncZoneMoRate = " + (float)cZoneMoRate + "\t(" + Math.round(100.0 * (cZoneMoRate / moRate)) + "%)\nbackSrcMoRate = " + (float)backSrcMoRate + "\t(" + Math.round(100.0 * (backSrcMoRate / moRate)) + "%)\nfaultMoRate/(faultMoRate+cZoneMoRate+backSrcMoRate) = " + Math.round(100.0 * faultMoRate / (faultMoRate + cZoneMoRate + backSrcMoRate)) + " (%)\nfaultMoRate/(faultMoRate+2*cZoneMoRate+backSrcMoRate) = " + Math.round(100.0 * faultMoRate / (faultMoRate + 2.0 * cZoneMoRate + backSrcMoRate)) + " (%)");
        moRate = 0.0;
        String srcName = "Brawley Point2Vert_FaultPoisSource";
        for (ProbEqkSource source : this.modMeanUCERF2) {
            if (!source.getName().equals(srcName)) continue;
            moRate += source.computeEquivTotalMomentRate(duration);
        }
        System.out.println("\ntotMoRate = " + (float)moRate + "\tfor\t" + srcName);
        moRate = 0.0;
        srcName = "Mendos Point2Vert_FaultPoisSource";
        for (ProbEqkSource source : this.modMeanUCERF2) {
            if (!source.getName().equals(srcName)) continue;
            moRate += source.computeEquivTotalMomentRate(duration);
        }
        System.out.println("\ntotMoRate = " + (float)moRate + "\tfor\t" + srcName);
        moRate = 0.0;
        srcName = "Creeps Point2Vert_FaultPoisSource";
        for (ProbEqkSource source : this.modMeanUCERF2) {
            if (!source.getName().equals(srcName)) continue;
            moRate += source.computeEquivTotalMomentRate(duration);
        }
        System.out.println("\ntotMoRate = " + (float)moRate + "\tfor\t" + srcName);
    }

    public static void main(String[] args) {
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        UCERF2_MFD_ConstraintFetcher fetcher = new UCERF2_MFD_ConstraintFetcher(region);
        System.out.println(fetcher.getTotalMFD().getCumRateDistWithOffset());
        fetcher.plotCumMFDs();
        fetcher.plotMFDs();
    }
}

