/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.aveSlip;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoSlipProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class U3AveSlipConstraint
extends UncertainDataConstraint.SectMappedUncertainDataConstraint
implements Serializable {
    public static final String DIR_NAME = "aveSlip";
    public static final String TABLE_5_FILE_NAME = "Table R5v4_withMappings.xls";
    public static final String TABLE_6_FILE_NAME = "Table R6v5_withMappings.xls";
    public static final PaleoSlipProbabilityModel slip_prob_model = new U3AveSlipProbModel();

    public U3AveSlipConstraint(int subSectionIndex, String subSectionName, double weightedMean, double upperUncertaintyBound, double lowerUncertaintyBound, Location loc) {
        super(subSectionName, subSectionIndex, subSectionName, loc, weightedMean, BoundedUncertainty.fromMeanAndBounds(UncertaintyBoundType.TWO_SIGMA, weightedMean, lowerUncertaintyBound, upperUncertaintyBound));
    }

    public int getSubSectionIndex() {
        return this.sectionIndex;
    }

    public String getSubSectionName() {
        return this.sectionName;
    }

    public double getWeightedMean() {
        return this.bestEstimate;
    }

    public double getUpperUncertaintyBound() {
        return this.estimateUncertaintyBounds((UncertaintyBoundType)UncertaintyBoundType.TWO_SIGMA).upperBound;
    }

    public double getLowerUncertaintyBound() {
        return this.estimateUncertaintyBounds((UncertaintyBoundType)UncertaintyBoundType.TWO_SIGMA).lowerBound;
    }

    public Location getSiteLocation() {
        return this.dataLocation;
    }

    public static double getProbabilityOfObservedSlip(double meters) {
        return slip_prob_model.getProbabilityOfObservedSlip(meters);
    }

    @Override
    public String toString() {
        return "AveSlipConstraint [subSectionIndex=" + this.sectionIndex + ", weightedMean=" + this.bestEstimate + ", upperUncertaintyBound=" + this.getUpperUncertaintyBound() + ", lowerUncertaintyBound=" + this.getLowerUncertaintyBound() + "]";
    }

    public static List<U3AveSlipConstraint> load(List<? extends FaultSection> subSectData) throws IOException {
        List<U3AveSlipConstraint> aveSlipData = U3AveSlipConstraint.load(UCERF3_DataUtils.locateResourceAsStream(DIR_NAME, TABLE_5_FILE_NAME), subSectData);
        aveSlipData.addAll(U3AveSlipConstraint.load(UCERF3_DataUtils.locateResourceAsStream(DIR_NAME, TABLE_6_FILE_NAME), subSectData));
        return aveSlipData;
    }

    public static List<U3AveSlipConstraint> load(InputStream is, List<? extends FaultSection> subSectData) throws IOException {
        return U3AveSlipConstraint.load(is, subSectData, -1, null);
    }

    private static List<U3AveSlipConstraint> load(InputStream is, List<? extends FaultSection> subSectData, int mappingCol, File mappingFile) throws IOException {
        HSSFRow row;
        int rowIndex;
        HashMap parentSectsMap = Maps.newHashMap();
        for (FaultSection faultSection : subSectData) {
            Integer parentID = faultSection.getParentSectionId();
            List subSectsForParent = (List)parentSectsMap.get(parentID);
            if (subSectsForParent == null) {
                subSectsForParent = Lists.newArrayList();
                parentSectsMap.put(parentID, subSectsForParent);
            }
            subSectsForParent.add(faultSection);
        }
        POIFSFileSystem fs = new POIFSFileSystem(is);
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(fs);
        HSSFSheet sheet = hSSFWorkbook.getSheetAt(0);
        ArrayList constraints = Lists.newArrayList();
        int lastRowIndex = sheet.getLastRowNum();
        int startRowIndex = 0;
        for (rowIndex = 0; rowIndex <= lastRowIndex; ++rowIndex) {
            if (!sheet.getRow(rowIndex).getCell(0).getStringCellValue().trim().equals("Fault")) continue;
            startRowIndex = rowIndex + 1;
            break;
        }
        Preconditions.checkState((startRowIndex > 0 ? 1 : 0) != 0, (Object)"Couldn't find start row, data file changed?");
        for (rowIndex = startRowIndex; rowIndex <= lastRowIndex && (row = sheet.getRow(rowIndex)) != null; ++rowIndex) {
            String faultName = row.getCell(0).getStringCellValue().trim();
            if (faultName.isEmpty()) continue;
            if (faultName.equals("EXPLANATION") || faultName.isEmpty()) break;
            HSSFCell parentCell = row.getCell(1);
            List<Integer> parentIDs = U3AveSlipConstraint.loadParentIDs(parentCell);
            double lat = row.getCell(2).getNumericCellValue();
            double lon = row.getCell(3).getNumericCellValue();
            Location loc = new Location(lat, lon);
            boolean blindThrustHack = faultName.startsWith("Compton") || faultName.startsWith("Puente Hills");
            FaultSection matchSect = null;
            double minDist = Double.POSITIVE_INFINITY;
            for (Integer parentID : parentIDs) {
                List subSects = (List)parentSectsMap.get(parentID);
                if (subSects == null) continue;
                for (FaultSection subSect : subSects) {
                    FaultTrace trace = FaultUtils.resampleTrace(subSect.getFaultTrace(), 11);
                    for (Location traceLoc : trace) {
                        double dist = LocationUtils.horzDistanceFast(loc, traceLoc);
                        if (!(dist < minDist)) continue;
                        minDist = dist;
                        matchSect = subSect;
                    }
                }
            }
            if (matchSect == null) {
                System.out.println("Skipping ave slip site '" + faultName + "' as parent(s) don't exist in given fault model: " + Joiner.on((String)",").join(parentIDs));
                continue;
            }
            Preconditions.checkState((blindThrustHack || minDist < 5.0 ? 1 : 0) != 0, (Object)("no sub sect found within 5km for site on " + faultName + " at: " + String.valueOf(loc) + " (mindist=" + minDist + ")"));
            double mean = row.getCell(22).getNumericCellValue();
            double uncertaintyPlus = row.getCell(23).getNumericCellValue();
            double uncertaintyMinus = row.getCell(24).getNumericCellValue();
            constraints.add(new U3AveSlipConstraint(matchSect.getSectionId(), matchSect.getSectionName(), mean, mean + uncertaintyPlus, mean - uncertaintyMinus, loc));
            if (mappingCol <= 0) continue;
            HSSFCell mappingCell = row.getCell(mappingCol);
            mappingCell.setCellValue(matchSect.getName());
        }
        if (mappingCol > 0) {
            hSSFWorkbook.write((OutputStream)new FileOutputStream(mappingFile));
        }
        hSSFWorkbook.close();
        return constraints;
    }

    public static List<Integer> loadParentIDs(HSSFCell parentCell) {
        ArrayList parentIDs = Lists.newArrayList();
        if (parentCell.getCellType() == 1) {
            String[] parentSplits;
            for (String parentStr : parentSplits = parentCell.getStringCellValue().trim().split(",")) {
                parentIDs.add(Integer.parseInt(parentStr.trim()));
            }
        } else {
            int val = (int)parentCell.getNumericCellValue();
            if (val > 0) {
                parentIDs.add(val);
            }
        }
        return parentIDs;
    }

    public static class U3AveSlipProbModel
    implements PaleoSlipProbabilityModel {
        private ArbitrarilyDiscretizedFunc probObsSlipModel = new ArbitrarilyDiscretizedFunc();

        public U3AveSlipProbModel() {
            this.probObsSlipModel.set(0.0, 0.0);
            this.probObsSlipModel.set(0.25, 0.1);
            this.probObsSlipModel.set(2.0, 0.9);
        }

        @Override
        public double getProbabilityOfObservedSlip(double slip) {
            if (slip > this.probObsSlipModel.getMaxX()) {
                return this.probObsSlipModel.getY(this.probObsSlipModel.size() - 1);
            }
            return this.probObsSlipModel.getInterpolatedY(slip);
        }
    }
}

