/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.paleoRateConstraints;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.dom4j.DocumentException;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF2_PaleoProbabilityModel;

public class UCERF2_PaleoRateConstraintFetcher {
    private static final String PALEO_DATA_SUB_DIR = "paleoRateData";
    private static final String PALEO_DATA_FILE_NAME = "Appendix_C_Table7_091807.xls";
    protected static final boolean D = true;

    public static ArrayList<U3PaleoRateConstraint> getConstraints(List<? extends FaultSection> faultSectionData) throws IOException {
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = new ArrayList<U3PaleoRateConstraint>();
        System.out.println("Reading Paleo Seg Rate Data from Appendix_C_Table7_091807.xls");
        InputStream is = UCERF3_DataUtils.locateResourceAsStream(PALEO_DATA_SUB_DIR, PALEO_DATA_FILE_NAME);
        POIFSFileSystem fs = new POIFSFileSystem(is);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        int lastRowIndex = sheet.getLastRowNum();
        for (int r = 1; r <= lastRowIndex; ++r) {
            HSSFCell cell;
            HSSFRow row = sheet.getRow(r);
            if (row == null || (cell = row.getCell(1)) == null || cell.getCellType() == 1) continue;
            double lat = cell.getNumericCellValue();
            String siteName = row.getCell(0).getStringCellValue().trim();
            double lon = row.getCell(2).getNumericCellValue();
            double rate = row.getCell(3).getNumericCellValue();
            double sigma = row.getCell(4).getNumericCellValue();
            double lower95Conf = row.getCell(7).getNumericCellValue();
            double upper95Conf = row.getCell(8).getNumericCellValue();
            double minDist = Double.MAX_VALUE;
            int closestFaultSectionIndex = -1;
            Location loc = new Location(lat, lon);
            for (int sectionIndex = 0; sectionIndex < faultSectionData.size(); ++sectionIndex) {
                double dist = faultSectionData.get(sectionIndex).getFaultTrace().minDistToLine(loc);
                if (!(dist < minDist)) continue;
                minDist = dist;
                closestFaultSectionIndex = sectionIndex;
            }
            if (minDist > 2.0) continue;
            String name = faultSectionData.get(closestFaultSectionIndex).getSectionName();
            U3PaleoRateConstraint paleoRateConstraint = new U3PaleoRateConstraint(name, closestFaultSectionIndex, name, loc, rate, new BoundedUncertainty(UncertaintyBoundType.CONF_95, lower95Conf, upper95Conf, sigma));
            System.out.println("\t" + siteName + " (lat=" + lat + ", lon=" + lon + ") associated with " + name + " (section index = " + closestFaultSectionIndex + ")\tdist=" + (float)minDist + "\trate=" + (float)rate + "\tsigma=" + (float)sigma + "\tlower95=" + (float)lower95Conf + "\tupper95=" + (float)upper95Conf);
            paleoRateConstraints.add(paleoRateConstraint);
        }
        return paleoRateConstraints;
    }

    public static void showSegRateComparison(ArrayList<U3PaleoRateConstraint> paleoRateConstraint, ArrayList<U3FaultSystemSolution> solutions) {
        UCERF2_PaleoProbabilityModel paleoProbModel = new UCERF2_PaleoProbabilityModel();
        Preconditions.checkState((paleoRateConstraint.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least one rate constraint");
        Preconditions.checkState((solutions.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least one solution");
        int numSolSects = -1;
        for (U3FaultSystemSolution sol : solutions) {
            if (numSolSects < 0) {
                numSolSects = sol.getRupSet().getNumSections();
            }
            Preconditions.checkArgument((sol.getRupSet().getNumSections() == numSolSects ? 1 : 0) != 0, (Object)"num sections is inconsistant between solutions!");
        }
        List<? extends FaultSection> datas = solutions.get(0).getRupSet().getFaultSectionDataList();
        ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        ArbitrarilyDiscretizedFunc paleoRateMean = new ArbitrarilyDiscretizedFunc();
        paleoRateMean.setName("Paleo Rate Constraint: Mean");
        funcs.add(paleoRateMean);
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 5.0f, Color.BLACK));
        ArbitrarilyDiscretizedFunc paleoRateUpper = new ArbitrarilyDiscretizedFunc();
        paleoRateUpper.setName("Paleo Rate Constraint: Upper 95% Confidence");
        funcs.add(paleoRateUpper);
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.DASH, 5.0f, Color.BLACK));
        ArbitrarilyDiscretizedFunc paleoRateLower = new ArbitrarilyDiscretizedFunc();
        paleoRateLower.setName("Paleo Rate Constraint: Upper 95% Confidence");
        funcs.add(paleoRateLower);
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.DASH, 5.0f, Color.BLACK));
        int xGap = 5;
        int x = 5;
        HashMap<Integer, Integer> xIndForParentMap = new HashMap<Integer, Integer>();
        for (U3PaleoRateConstraint constr : paleoRateConstraint) {
            double paleoRateX;
            int n;
            int sectID = constr.getSectionIndex();
            int parentID = -1;
            String name = null;
            for (FaultSection faultSection : datas) {
                if (faultSection.getSectionId() != sectID) continue;
                if (faultSection.getParentSectionId() < 0) {
                    throw new IllegalStateException("parent ID isn't populated for solution!");
                }
                parentID = faultSection.getParentSectionId();
                name = faultSection.getParentSectionName();
                break;
            }
            if (parentID < 0) {
                System.err.println("No match for rate constraint for section " + sectID);
                continue;
            }
            int minSect = Integer.MAX_VALUE;
            int n2 = -1;
            for (FaultSection faultSection : datas) {
                if (faultSection.getParentSectionId() != parentID) continue;
                int mySectID = faultSection.getSectionId();
                if (mySectID < minSect) {
                    minSect = mySectID;
                }
                if (mySectID <= n) continue;
                n = mySectID;
            }
            Preconditions.checkState((n >= minSect ? 1 : 0) != 0);
            int numSects = n - minSect;
            int n3 = sectID - minSect;
            if (xIndForParentMap.containsKey(parentID)) {
                paleoRateX = (Integer)xIndForParentMap.get(parentID) + n3;
            } else {
                paleoRateX = x + n3;
                for (int i = 0; i < solutions.size(); ++i) {
                    U3FaultSystemSolution sol = solutions.get(i);
                    U3FaultSystemRupSet rupSet = sol.getRupSet();
                    Color color = GraphPanel.defaultColor[i % GraphPanel.defaultColor.length];
                    EvenlyDiscretizedFunc func = new EvenlyDiscretizedFunc((double)x, numSects, 1.0);
                    func.setName("(x=" + x + ") Solution " + i + " rates for: " + name);
                    for (int j = 0; j < numSects; ++j) {
                        double rate = 0.0;
                        int mySectID = minSect + j;
                        for (int rupID : rupSet.getRupturesForSection(mySectID)) {
                            rate += sol.getRateForRup(rupID) * ((PaleoProbabilityModel)paleoProbModel).getProbPaleoVisible(rupSet.getMagForRup(rupID), Double.NaN);
                        }
                        func.set(j, rate);
                    }
                    funcs.add(func);
                    plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, color));
                }
                xIndForParentMap.put(parentID, x);
                x += numSects;
                x += 5;
            }
            paleoRateMean.set(paleoRateX, constr.getMeanRate());
            paleoRateUpper.set(paleoRateX, constr.getUpper95ConfOfRate());
            paleoRateLower.set(paleoRateX, constr.getLower95ConfOfRate());
        }
        GraphWindow w = new GraphWindow(funcs, "Paleosiesmic Constraint Fit", plotChars);
        w.setX_AxisLabel("");
        w.setY_AxisLabel("Event Rate Per Year");
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File precomp = UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR;
        File rupSetsDir = new File(precomp, "FaultSystemRupSets");
        ArrayList<U3FaultSystemSolution> sols = new ArrayList<U3FaultSystemSolution>();
        sols.add(U3FaultSystemIO.loadSol(new File(rupSetsDir, "UCERF2.xml")));
        sols.add(U3FaultSystemIO.loadSol(new File(rupSetsDir, "Model1.xml")));
        UCERF2_PaleoRateConstraintFetcher.showSegRateComparison(UCERF2_PaleoRateConstraintFetcher.getConstraints(((U3FaultSystemSolution)sols.get(0)).getRupSet().getFaultSectionDataList()), sols);
    }
}

