/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.paleoRateConstraints;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class UCERF3_PaleoProbabilityModel
extends PaleoProbabilityModel {
    private EvenlyDiscrXYZ_DataSet xyz;
    private ArbitrarilyDiscretizedFunc dispMagFunc;

    private UCERF3_PaleoProbabilityModel(EvenlyDiscrXYZ_DataSet xyz, ArbitrarilyDiscretizedFunc dispMagFunc) {
        this.xyz = xyz;
        this.dispMagFunc = dispMagFunc;
    }

    @Override
    public double getProbPaleoVisible(double mag, List<? extends FaultSection> rupSects, int sectIndex) {
        return this.getProbPaleoVisible(mag, this.getDistAlongRup(rupSects, sectIndex));
    }

    @Override
    public double getProbPaleoVisible(double mag, double distAlongRup) {
        double maxX = this.xyz.getMaxX();
        if ((float)distAlongRup == (float)maxX) {
            distAlongRup = maxX;
        }
        Preconditions.checkArgument((distAlongRup >= this.xyz.getMinX() && distAlongRup <= maxX ? 1 : 0) != 0, (Object)("distance along rup must be between " + this.xyz.getMinX() + " and " + maxX + " (you supplied: " + distAlongRup + ")"));
        Preconditions.checkArgument((!Double.isNaN(mag) ? 1 : 0) != 0, (Object)"magnitude cannot be NaN!");
        if (mag < this.xyz.getMinY()) {
            return 0.0;
        }
        if (mag > this.xyz.getMaxY()) {
            return 1.0;
        }
        return this.xyz.bilinearInterpolation(distAlongRup, mag);
    }

    public double getProbPaleoVisibleForSlip(double slip, double distAlongRup) {
        Preconditions.checkArgument((!Double.isNaN(slip) ? 1 : 0) != 0, (Object)"slip cannot be NaN!");
        if (slip < this.dispMagFunc.getMinX()) {
            return 0.0;
        }
        if (slip > this.dispMagFunc.getMaxX()) {
            return 1.0;
        }
        return this.getProbPaleoVisible(this.dispMagFunc.getInterpolatedY(slip), distAlongRup);
    }

    public static UCERF3_PaleoProbabilityModel load() throws IOException {
        return UCERF3_PaleoProbabilityModel.fromURL(UCERF3_DataUtils.locateResource("paleoRateData", "pdetection2.txt"));
    }

    public static UCERF3_PaleoProbabilityModel fromFile(File file) throws IOException {
        try {
            return UCERF3_PaleoProbabilityModel.fromURL(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    public static UCERF3_PaleoProbabilityModel fromURL(URL url) throws IOException {
        double[] xVals = null;
        ArrayList<Double> yVals = new ArrayList<Double>();
        ArrayList<double[]> vals = new ArrayList<double[]>();
        ArbitrarilyDiscretizedFunc dispMagFunc = new ArbitrarilyDiscretizedFunc();
        int numVals = -1;
        for (String line : FileUtils.loadFile(url)) {
            StringTokenizer tok = new StringTokenizer(line.trim());
            if (numVals < 0) {
                numVals = tok.countTokens() - 2;
            }
            double[] lineVals = new double[numVals];
            double mag = Double.parseDouble(tok.nextToken());
            double disp = Double.parseDouble(tok.nextToken());
            for (int i = 0; i < numVals; ++i) {
                lineVals[i] = Double.parseDouble(tok.nextToken());
            }
            if (xVals == null) {
                xVals = lineVals;
                continue;
            }
            yVals.add(mag);
            vals.add(lineVals);
            dispMagFunc.set(disp, mag);
        }
        double minX = StatUtils.min(xVals);
        EvenlyDiscrXYZ_DataSet xyz = new EvenlyDiscrXYZ_DataSet(xVals.length, yVals.size(), minX, (double)((Double)Collections.min(yVals)), Math.abs((double)(xVals[1] - xVals[0])));
        for (int yInd = 0; yInd < yVals.size(); ++yInd) {
            for (int xInd = 0; xInd < xVals.length; ++xInd) {
                xyz.set(xVals[xInd], (Double)yVals.get(yInd), ((double[])vals.get(yInd))[xInd]);
            }
        }
        for (int i = 0; i < xyz.size(); ++i) {
            Preconditions.checkState((xyz.get(i) >= 0.0 ? 1 : 0) != 0, (Object)"something didn't get set right!");
        }
        Preconditions.checkState(((float)xyz.getMaxX() == (float)StatUtils.max((double[])xVals) ? 1 : 0) != 0, (Object)("maxX is incorrect! " + (float)xyz.getMaxX() + " != " + (float)StatUtils.max((double[])xVals)));
        Preconditions.checkState(((float)xyz.getMaxY() == ((Double)Collections.max(yVals)).floatValue() ? 1 : 0) != 0, (Object)("maxY is incorrect! " + (float)xyz.getMaxY() + " != " + ((Double)Collections.max(yVals)).floatValue()));
        return new UCERF3_PaleoProbabilityModel(xyz, dispMagFunc);
    }

    public void writeTableData() {
        for (double mag = 5.0; mag <= 8.05; mag += 0.5) {
            double aveSlip = this.dispMagFunc.getFirstInterpolatedX(mag);
            double p05 = this.getProbPaleoVisible(mag, 0.05);
            double p25 = this.getProbPaleoVisible(mag, 0.25);
            double p50 = this.getProbPaleoVisible(mag, 0.4999);
            System.out.println((float)aveSlip + "\t" + mag + "\t" + (float)p05 + "\t" + (float)p25 + "\t" + (float)p50);
        }
    }

    public static void main(String[] args) throws IOException {
        UCERF3_PaleoProbabilityModel model = UCERF3_PaleoProbabilityModel.load();
        model.writeTableData();
    }
}

