/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils.paleoRateConstraints;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.dom4j.DocumentException;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.Uncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;

public class UCERF3_PaleoRateConstraintFetcher {
    private static final String PALEO_DATA_SUB_DIR = "paleoRateData";
    private static final String PALEO_DATA_FILE_NAME = "UCERF3_PaleoRateData_BIASI_v02_withMappings.xls";
    protected static final boolean D = false;

    public static ArrayList<U3PaleoRateConstraint> getConstraints(List<? extends FaultSection> faultSectionData) throws IOException {
        return UCERF3_PaleoRateConstraintFetcher.getConstraints(faultSectionData, -1);
    }

    private static ArrayList<U3PaleoRateConstraint> getConstraints(List<? extends FaultSection> faultSectionData, int mappingCol) throws IOException {
        POIFSFileSystem fs;
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = new ArrayList<U3PaleoRateConstraint>();
        File outputFile = null;
        if (mappingCol > 0) {
            File dir = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR.getParentFile(), PALEO_DATA_SUB_DIR);
            outputFile = new File(dir, PALEO_DATA_FILE_NAME);
            FileInputStream is = new FileInputStream(outputFile);
            fs = new POIFSFileSystem((InputStream)is);
        } else {
            InputStream is = UCERF3_DataUtils.locateResourceAsStream(PALEO_DATA_SUB_DIR, PALEO_DATA_FILE_NAME);
            fs = new POIFSFileSystem(is);
        }
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        boolean hasQuantiles = sheet.getRow(0).getCell(4).getStringCellValue().startsWith("2.5%");
        int lastRowIndex = sheet.getLastRowNum();
        for (int r = 1; r <= lastRowIndex; ++r) {
            double upper95Conf;
            double lower95Conf;
            double upper68Conf;
            double lower68Conf;
            double meanRate;
            HSSFCell nameCell;
            HSSFCell cell;
            HSSFRow row = sheet.getRow(r);
            if (row == null || (cell = row.getCell(1)) == null || cell.getCellType() == 1 || (nameCell = row.getCell(0)) == null || nameCell.getCellType() != 1 || nameCell.getStringCellValue().trim().isEmpty()) continue;
            double lat = cell.getNumericCellValue();
            String siteName = nameCell.getStringCellValue().trim();
            double lon = row.getCell(2).getNumericCellValue();
            if (hasQuantiles) {
                meanRate = row.getCell(8).getNumericCellValue();
                lower68Conf = row.getCell(10).getNumericCellValue();
                upper68Conf = row.getCell(11).getNumericCellValue();
                lower95Conf = row.getCell(9).getNumericCellValue();
                upper95Conf = row.getCell(12).getNumericCellValue();
            } else {
                meanRate = row.getCell(6).getNumericCellValue();
                lower68Conf = row.getCell(8).getNumericCellValue();
                upper68Conf = row.getCell(7).getNumericCellValue();
                lower95Conf = Double.NaN;
                upper95Conf = Double.NaN;
            }
            if (lower68Conf == upper68Conf) {
                System.out.println("Skipping value at " + siteName + " because upper and lower values are equal: meanRate=" + (float)meanRate + "\tlower68=" + (float)lower68Conf + "\tupper68=" + (float)upper68Conf);
                continue;
            }
            double minDist = Double.MAX_VALUE;
            int closestFaultSectionIndex = -1;
            Location loc = new Location(lat, lon);
            boolean blindThrustHack = siteName.equals("Compton") || siteName.equals("Puente Hills");
            boolean safOffshoreHack = siteName.equals("N. San Andreas -Offshore Noyo");
            for (int sectionIndex = 0; sectionIndex < faultSectionData.size(); ++sectionIndex) {
                double dist;
                FaultSection data = faultSectionData.get(sectionIndex);
                if (blindThrustHack && !data.getSectionName().contains(siteName) || !((dist = data.getFaultTrace().minDistToLine(loc)) < minDist)) continue;
                minDist = dist;
                closestFaultSectionIndex = sectionIndex;
            }
            if (minDist > 2.0 && !blindThrustHack && !safOffshoreHack || closestFaultSectionIndex < 0) continue;
            String name = faultSectionData.get(closestFaultSectionIndex).getSectionName();
            Uncertainty[] uncertainties = hasQuantiles ? new BoundedUncertainty[]{BoundedUncertainty.fromMeanAndBounds(UncertaintyBoundType.CONF_68, meanRate, lower68Conf, upper68Conf), BoundedUncertainty.fromMeanAndBounds(UncertaintyBoundType.CONF_95, meanRate, lower95Conf, upper95Conf)} : UCERF3_PaleoRateConstraintFetcher.estimateFrom68(meanRate, lower68Conf, upper68Conf);
            paleoRateConstraints.add(new U3PaleoRateConstraint(siteName, closestFaultSectionIndex, name, loc, meanRate, uncertainties));
            if (mappingCol <= 0) continue;
            HSSFCell mappingCell = row.getCell(mappingCol);
            if (mappingCell == null) {
                mappingCell = row.createCell(mappingCol, 1);
            }
            mappingCell.setCellValue(name);
        }
        if (mappingCol > 0) {
            wb.write((OutputStream)new FileOutputStream(outputFile));
        }
        return paleoRateConstraints;
    }

    private static BoundedUncertainty[] estimateFrom68(double meanRate, double lower68Conf, double upper68Conf) {
        double stdDevOfMeanRate = (meanRate - lower68Conf + (upper68Conf - meanRate)) / 2.0;
        double aveLogStd = (Math.abs(Math.log10(meanRate / lower68Conf)) + Math.abs(Math.log10(meanRate / upper68Conf))) / 2.0;
        double lower95Conf = Math.pow(10.0, Math.log10(meanRate) - 2.0 * aveLogStd);
        double upper95Conf = Math.pow(10.0, Math.log10(meanRate) + 2.0 * aveLogStd);
        return new BoundedUncertainty[]{new BoundedUncertainty(UncertaintyBoundType.CONF_68, lower68Conf, upper68Conf, stdDevOfMeanRate), new BoundedUncertainty(UncertaintyBoundType.CONF_95, lower95Conf, upper95Conf, stdDevOfMeanRate)};
    }

    public static ArrayList<U3PaleoRateConstraint> getConstraints() throws IOException {
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = new ArrayList<U3PaleoRateConstraint>();
        InputStream is = UCERF3_DataUtils.locateResourceAsStream(PALEO_DATA_SUB_DIR, PALEO_DATA_FILE_NAME);
        POIFSFileSystem fs = new POIFSFileSystem(is);
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        boolean hasQuantiles = sheet.getRow(0).getCell(4).getStringCellValue().startsWith("2.5%");
        int lastRowIndex = sheet.getLastRowNum();
        for (int r = 1; r <= lastRowIndex; ++r) {
            double upper95Conf;
            double lower95Conf;
            double upper68Conf;
            double lower68Conf;
            double meanRate;
            HSSFCell nameCell;
            HSSFCell cell;
            HSSFRow row = sheet.getRow(r);
            if (row == null || (cell = row.getCell(1)) == null || cell.getCellType() == 1 || (nameCell = row.getCell(0)) == null || nameCell.getCellType() != 1 || nameCell.getStringCellValue().trim().isEmpty()) continue;
            double lat = cell.getNumericCellValue();
            String siteName = nameCell.getStringCellValue().trim();
            double lon = row.getCell(2).getNumericCellValue();
            if (hasQuantiles) {
                meanRate = row.getCell(8).getNumericCellValue();
                lower68Conf = row.getCell(10).getNumericCellValue();
                upper68Conf = row.getCell(11).getNumericCellValue();
                lower95Conf = row.getCell(9).getNumericCellValue();
                upper95Conf = row.getCell(12).getNumericCellValue();
            } else {
                meanRate = row.getCell(6).getNumericCellValue();
                lower68Conf = row.getCell(8).getNumericCellValue();
                upper68Conf = row.getCell(7).getNumericCellValue();
                lower95Conf = Double.NaN;
                upper95Conf = Double.NaN;
            }
            if (lower68Conf == upper68Conf) {
                System.out.println("Skipping value at " + siteName + " because upper and lower values are equal: meanRate=" + (float)meanRate + "\tlower68=" + (float)lower68Conf + "\tupper68=" + (float)upper68Conf);
                continue;
            }
            Location loc = new Location(lat, lon);
            Uncertainty[] uncertainties = hasQuantiles ? new BoundedUncertainty[]{BoundedUncertainty.fromMeanAndBounds(UncertaintyBoundType.CONF_68, meanRate, lower68Conf, upper68Conf), BoundedUncertainty.fromMeanAndBounds(UncertaintyBoundType.CONF_95, meanRate, lower95Conf, upper95Conf)} : UCERF3_PaleoRateConstraintFetcher.estimateFrom68(meanRate, lower68Conf, upper68Conf);
            paleoRateConstraints.add(new U3PaleoRateConstraint(siteName, -1, null, loc, meanRate, uncertainties));
        }
        return paleoRateConstraints;
    }

    public static void main(String[] args) throws IOException, DocumentException {
        FaultModels fm = FaultModels.FM3_1;
        List<? extends FaultSection> subSects = new DeformationModelFetcher(fm, DeformationModels.forFaultModel(fm).get(0), UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1).getSubSectionList();
        HashSet<FaultSection> mappedSects = new HashSet<FaultSection>();
        ArrayList<Location> siteLocs = new ArrayList<Location>();
        String prefix = "u3_paleo_mappings";
        String title = "UCERF3 Paleo RI Mappings";
        ArrayList<U3PaleoRateConstraint> datas = UCERF3_PaleoRateConstraintFetcher.getConstraints(subSects);
        System.out.println("Loaded " + datas.size() + " values");
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : datas) {
            System.out.println(sectMappedUncertainDataConstraint);
            if (sectMappedUncertainDataConstraint.sectionIndex < 0) continue;
            FaultSection sect = subSects.get(sectMappedUncertainDataConstraint.sectionIndex);
            double dist = sect.getFaultTrace().minDistToLine(sectMappedUncertainDataConstraint.dataLocation);
            System.out.println("\tMapped section: " + sect.getSectionName() + "\tdistance: " + (float)dist + " km");
            mappedSects.add(sect);
            siteLocs.add(sectMappedUncertainDataConstraint.dataLocation);
        }
        RupSetMapMaker mapMaker = new RupSetMapMaker(subSects, (Region)new CaliforniaRegions.RELM_TESTING());
        mapMaker.setSectHighlights(mappedSects, new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
        mapMaker.plotScatters(siteLocs, Color.BLUE);
        mapMaker.setWriteGeoJSON(true);
        mapMaker.plot(new File("/tmp"), prefix, title);
        String string = "http://opensha.usc.edu/ftp/kmilner/nshm23/paleo_mappings/";
        System.out.println("GeoJSON.io URL: " + RupSetMapMaker.getGeoJSONViewerLink(string + prefix + ".geojson"));
    }
}

