/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.opensha.commons.data.CSVFile;
import scratch.UCERF3.U3CompoundFaultSystemSolution;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.MatrixIO;

class FullModelCSVWriter {
    FullModelCSVWriter() {
    }

    public static void main(String[] args) throws ZipException, IOException {
        U3CompoundFaultSystemSolution cfss = U3CompoundFaultSystemSolution.fromZipFile(new File("/home/kevin/workspace/opensha-ucerf3/src/scratch/UCERF3/data/scratch/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_WITH_IND_RUNS.zip"));
        ZipFile binsZip = new ZipFile("/home/kevin/OpenSHA/UCERF3/2013_05_10-ucerf3p3-production-10runs-bins.zip");
        int numRuns = 10;
        File outputDir = new File("/home/kevin/OpenSHA/UCERF3/fss_csvs");
        File outputFile = new File(outputDir, "full_model_csvs.zip");
        ArrayList<Object> header = new ArrayList<Object>();
        header.add("rupID");
        header.add("mag");
        header.add("mean annual rate");
        header.add("water level rate");
        for (int i = 0; i < numRuns; ++i) {
            header.add("solution " + i + " annaul rate");
        }
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        out.setLevel(-1);
        double totWeight = 0.0;
        for (U3LogicTreeBranch branch : cfss.getBranches()) {
            totWeight += branch.getAprioriBranchWt();
        }
        System.out.println("Total weight: " + totWeight);
        CSVFile weightCSV = new CSVFile(true);
        ArrayList<String> weightHeader = new ArrayList<String>();
        weightHeader.add("Index");
        weightHeader.add("Weight");
        weightHeader.add("Prefix");
        U3LogicTreeBranch branch0 = cfss.getBranches().iterator().next();
        for (int i = 0; i < branch0.size(); ++i) {
            weightHeader.add(((U3LogicTreeBranchNode)branch0.getValue(i)).getBranchLevelName());
        }
        weightCSV.addLine(weightHeader);
        for (U3LogicTreeBranch branch : cfss.getBranches()) {
            CSVFile<Object> csv = new CSVFile<Object>(true);
            csv.addLine((List<Object>)header);
            double weight = branch.getAprioriBranchWt() / totWeight;
            ArrayList<Object> weightLine = new ArrayList<Object>();
            weightLine.add("" + (weightCSV.getNumRows() - 1));
            weightLine.add("" + weight);
            weightLine.add(branch.buildFileName());
            for (int i = 0; i < branch.size(); ++i) {
                weightLine.add(((U3LogicTreeBranchNode)branch.getValue(i)).getShortName());
            }
            weightCSV.addLine(weightLine);
            System.out.println("Loading for " + branch.buildFileName());
            double[] mags = cfss.getMags(branch);
            double[] rates = cfss.getRates(branch);
            ArrayList<double[]> subRates = new ArrayList<double[]>();
            for (int i = 0; i < numRuns; ++i) {
                subRates.add(cfss.loadDoubleArray(branch, "rates_" + i + ".bin"));
            }
            String entryPrefix = branch.buildFileName() + "_run0/" + branch.buildFileName() + "_run0";
            ZipEntry run0Entry = binsZip.getEntry(entryPrefix + ".bin");
            double[] run0Rates = MatrixIO.doubleArrayFromInputStream(binsZip.getInputStream(run0Entry), run0Entry.getSize());
            ZipEntry run0RawEntry = binsZip.getEntry(entryPrefix + "_noMinRates.bin");
            double[] run0RawRates = MatrixIO.doubleArrayFromInputStream(binsZip.getInputStream(run0RawEntry), run0RawEntry.getSize());
            Preconditions.checkState((run0Rates.length == rates.length ? 1 : 0) != 0);
            Preconditions.checkState((run0Rates.length == run0RawRates.length ? 1 : 0) != 0);
            for (int r = 0; r < mags.length; ++r) {
                ArrayList<CallSite> line = new ArrayList<CallSite>();
                line.add((CallSite)((Object)("" + r)));
                line.add((CallSite)((Object)("" + mags[r])));
                line.add((CallSite)((Object)("" + rates[r])));
                line.add((CallSite)((Object)("" + (run0Rates[r] - run0RawRates[r]))));
                double avgRate = 0.0;
                for (int i = 0; i < numRuns; ++i) {
                    double rate = ((double[])subRates.get(i))[r];
                    line.add((CallSite)((Object)("" + rate)));
                    avgRate += rate;
                }
                if (numRuns > 0) {
                    Preconditions.checkState(((float)rates[r] == (float)(avgRate /= (double)numRuns) ? 1 : 0) != 0, (String)"Average doesn't compute for r=%s: %s != %s", (Object)r, (Object)rates[r], (Object)avgRate);
                }
                csv.addLine((List<Object>)line);
            }
            String csvName = branch.buildFileName() + ".csv";
            if (weightCSV.getNumRows() == 2) {
                csv.writeToFile(new File("/tmp/" + csvName));
            }
            System.out.println("Writing " + csvName);
            out.putNextEntry(new ZipEntry(csvName));
            csv.writeToStream(out);
            out.flush();
            out.closeEntry();
        }
        out.close();
        weightCSV.writeToFile(new File(outputDir, "full_model_branch_weights.csv"));
    }
}

