/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.map.HashedMap;
import org.dom4j.DocumentException;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.geo.Location;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.utils.U3FaultSystemIO;

class SubSectSurfaceWriter {
    SubSectSurfaceWriter() {
    }

    public static void main(String[] args) throws IOException, DocumentException {
        HashedMap sols = new HashedMap();
        File solDir = new File("/home/kevin/workspace/opensha-ucerf3/src/scratch/UCERF3/data/scratch/InversionSolutions");
        sols.put(FaultModels.FM3_1, U3FaultSystemIO.loadSol(new File(solDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip")));
        sols.put(FaultModels.FM3_2, U3FaultSystemIO.loadSol(new File(solDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_2_MEAN_BRANCH_AVG_SOL.zip")));
        double gridSpacing = 1.0;
        File mainDir = new File("/home/kevin/OpenSHA/UCERF3/sub_sect_surfaces");
        ArrayList<String> header = new ArrayList<String>();
        header.add("Row");
        header.add("Column");
        header.add("Latitude");
        header.add("Longitude");
        header.add("Depth");
        for (FaultModels fm : sols.keySet()) {
            System.out.println(fm);
            U3FaultSystemRupSet rupSet = ((U3FaultSystemSolution)sols.get(fm)).getRupSet();
            for (boolean reduce : new boolean[]{false, true}) {
                String dirName = fm.encodeChoiceString() + "_" + (float)gridSpacing + "km";
                dirName = reduce ? dirName + "_reduced" : dirName + "_full";
                File outputDir = new File(mainDir, dirName);
                System.out.println("Writing to: " + outputDir.getAbsolutePath());
                Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
                for (int s = 0; s < rupSet.getNumSections(); ++s) {
                    FaultSection fsd = rupSet.getFaultSectionData(s);
                    RuptureSurface surf = fsd.getFaultSurface(gridSpacing, false, reduce);
                    Preconditions.checkState((boolean)(surf instanceof EvenlyGriddedSurface));
                    EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surf;
                    FileWriter fw = new FileWriter(new File(outputDir, s + ".txt"));
                    CSVFile<String> csv = new CSVFile<String>(true);
                    csv.addLine((List<String>)header);
                    fw.write("# " + fsd.getName() + "\n");
                    fw.write("# rows: " + gridSurf.getNumRows() + "\n");
                    fw.write("# columns: " + gridSurf.getNumCols() + "\n");
                    fw.write("# points: " + gridSurf.size() + "\n");
                    fw.write("# <row> <column> <latitude> <longitude> <depth>\n");
                    for (int row = 0; row < gridSurf.getNumRows(); ++row) {
                        for (int col = 0; col < gridSurf.getNumCols(); ++col) {
                            Location loc = (Location)gridSurf.get(row, col);
                            fw.write(row + " " + col + " " + loc.getLatitude() + " " + loc.getLongitude() + " " + loc.getDepth() + "\n");
                            ArrayList<CallSite> line = new ArrayList<CallSite>();
                            line.add((CallSite)((Object)("" + row)));
                            line.add((CallSite)((Object)("" + col)));
                            line.add((CallSite)((Object)("" + loc.getLatitude())));
                            line.add((CallSite)((Object)("" + loc.getLongitude())));
                            line.add((CallSite)((Object)("" + loc.getDepth())));
                            csv.addLine((List<String>)line);
                        }
                    }
                    fw.close();
                    csv.writeToFile(new File(outputDir, s + ".csv"));
                }
            }
        }
    }
}

