/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.dom4j.DocumentException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_StatewideCatalogCompletenessParam;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.utils.LastEventData;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class CSEP_ContainerTestExecutable {
    private File solFile;
    private File outputDir;
    private int threads;
    private int numSims;
    private Map<Integer, List<LastEventData>> lastEventData;
    private double[] gridSeisCorrections;
    private double duration;
    private long ot;
    private List<ETAS_EqkRupture> histQkList;
    private ArrayDeque<U3FaultSystemSolution> solCache = new ArrayDeque();
    boolean includeSpontEvents = true;
    U3ETAS_ProbabilityModelOptions probModel = U3ETAS_ProbabilityModelOptions.FULL_TD;
    boolean applySubSeisForSupraNucl = true;
    double totRateScaleFactor = 1.14;
    boolean gridSeisCorr = true;
    boolean griddedOnly = false;
    boolean imposeGR = false;
    boolean includeIndirectTriggering = true;
    double gridSeisDiscr = 0.1;
    GriddedRegion griddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
    List<float[]> fractionSrcAtPointList;
    List<int[]> srcAtPointList;
    int[] isCubeInsideFaultPolygon;
    private Random random = new Random();

    public CSEP_ContainerTestExecutable(File catFile, File cacheDir, File solFile, File outputDir, int numSims, int threads, double duration) throws IOException, DocumentException {
        this.solFile = solFile;
        this.duration = duration;
        this.outputDir = outputDir;
        this.numSims = numSims;
        this.threads = threads;
        ETAS_Simulator.D = false;
        this.lastEventData = LastEventData.load();
        if (this.gridSeisCorr) {
            File cacheFile = new File(cacheDir, "griddedSeisCorrectionCache");
            System.out.println("Loading gridded seismicity correction cache file from " + cacheFile.getAbsolutePath());
            this.gridSeisCorrections = MatrixIO.doubleArrayFromFile(cacheFile);
        }
        System.out.println("Loading fault system solution");
        U3FaultSystemSolution sol = this.checkOutFSS();
        this.histQkList = ETAS_Launcher.loadHistoricalCatalog(catFile, null, sol, Long.MAX_VALUE, null, U3ETAS_StatewideCatalogCompletenessParam.DEFAULT_VALUE);
        this.ot = this.histQkList.get(this.histQkList.size() - 1).getOriginTime() + 1L;
        LastEventData.filterDataAfterTime(this.lastEventData, this.ot);
        System.out.println("Loading caches");
        File fractionSrcAtPointListFile = new File(cacheDir, "sectDistForCubeCache");
        File srcAtPointListFile = new File(cacheDir, "sectInCubeCache");
        File isCubeInsideFaultPolygonFile = new File(cacheDir, "cubeInsidePolyCache");
        Preconditions.checkState((boolean)fractionSrcAtPointListFile.exists(), (Object)("cache file not found: " + fractionSrcAtPointListFile.getAbsolutePath()));
        Preconditions.checkState((boolean)srcAtPointListFile.exists(), (Object)("cache file not found: " + srcAtPointListFile.getAbsolutePath()));
        Preconditions.checkState((boolean)isCubeInsideFaultPolygonFile.exists(), (Object)("cache file not found: " + isCubeInsideFaultPolygonFile.getAbsolutePath()));
        this.fractionSrcAtPointList = MatrixIO.floatArraysListFromFile(fractionSrcAtPointListFile);
        this.srcAtPointList = MatrixIO.intArraysListFromFile(srcAtPointListFile);
        this.isCubeInsideFaultPolygon = MatrixIO.intArrayFromFile(isCubeInsideFaultPolygonFile);
        this.checkInFSS(sol);
    }

    public void calculate() {
        ExecutorService exec = Executors.newFixedThreadPool(this.threads);
        ArrayList futures = new ArrayList();
        System.out.println("Starting " + this.numSims + " simulations across " + this.threads + " threads");
        for (int i = 0; i < this.numSims; ++i) {
            futures.add(exec.submit(new SimulationTask(i)));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                System.out.println("Error with simulation, exiting");
                e.printStackTrace();
                System.exit(1);
            }
        }
        System.out.println("All simulations completed successfully!");
        exec.shutdown();
    }

    public synchronized U3FaultSystemSolution checkOutFSS() {
        U3FaultSystemSolution sol;
        if (this.solCache.isEmpty()) {
            try {
                sol = U3FaultSystemIO.loadSol(this.solFile);
            }
            catch (IOException | DocumentException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            if (this.gridSeisCorrections != null) {
                ETAS_Simulator.correctGriddedSeismicityRatesInERF(sol, false, this.gridSeisCorrections);
            }
        } else {
            sol = this.solCache.pop();
        }
        LastEventData.populateSubSects(sol.getRupSet().getFaultSectionDataList(), this.lastEventData);
        return sol;
    }

    public synchronized void checkInFSS(U3FaultSystemSolution sol) {
        this.solCache.push(sol);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        if (args.length != 7) {
            System.out.println("USAGE: <catalog-input-file> <cache-dir> <u3-sol-file> <output-dir> <num-simulations> <threads> <catalog-duration>");
            System.exit(2);
        }
        File catFile = new File(args[0]);
        Preconditions.checkState((boolean)catFile.exists(), (String)"Catalog file doesn't exist: %s", (Object)catFile.getAbsolutePath());
        File cacheDir = new File(args[1]);
        Preconditions.checkState((boolean)cacheDir.exists(), (String)"Cache dir doesn't exist: %s", (Object)cacheDir.getAbsolutePath());
        File solFile = new File(args[2]);
        Preconditions.checkState((boolean)cacheDir.exists(), (String)"UCERF3 FSS file doesn't exist: %s", (Object)solFile.getAbsolutePath());
        File outputDir = new File(args[3]);
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0, (Object)"Output directory doesn't exist and could not be created: %s");
        int numSims = Integer.parseInt(args[4]);
        Preconditions.checkState((numSims > 0 ? 1 : 0) != 0);
        int threads = Integer.parseInt(args[5]);
        Preconditions.checkState((threads > 0 ? 1 : 0) != 0);
        double duration = Double.parseDouble(args[6]);
        CSEP_ContainerTestExecutable calc = new CSEP_ContainerTestExecutable(catFile, cacheDir, solFile, outputDir, numSims, threads, duration);
        calc.calculate();
    }

    private class SimulationTask
    implements Runnable {
        private int index;

        public SimulationTask(int index) {
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long randSeed;
                System.out.println("Preparing inputs for simulation " + this.index);
                U3FaultSystemSolution sol = CSEP_ContainerTestExecutable.this.checkOutFSS();
                LastEventData.populateSubSects(sol.getRupSet().getFaultSectionDataList(), CSEP_ContainerTestExecutable.this.lastEventData);
                FaultSystemSolutionERF_ETAS erf = ETAS_Launcher.buildERF_millis(sol, false, CSEP_ContainerTestExecutable.this.duration, CSEP_ContainerTestExecutable.this.ot);
                erf.updateForecast();
                ETAS_ParameterList params = new ETAS_ParameterList();
                params.setImposeGR(CSEP_ContainerTestExecutable.this.imposeGR);
                params.setU3ETAS_ProbModel(CSEP_ContainerTestExecutable.this.probModel);
                params.setApplyGridSeisCorr(CSEP_ContainerTestExecutable.this.gridSeisCorrections != null);
                params.setApplySubSeisForSupraNucl(CSEP_ContainerTestExecutable.this.applySubSeisForSupraNucl);
                params.setTotalRateScaleFactor(CSEP_ContainerTestExecutable.this.totRateScaleFactor);
                File myOutputDir = new File(CSEP_ContainerTestExecutable.this.outputDir, "sim_" + this.index);
                Preconditions.checkState((myOutputDir.exists() || myOutputDir.mkdir() ? 1 : 0) != 0);
                String simulationName = "Simulation " + this.index;
                Random random = CSEP_ContainerTestExecutable.this.random;
                synchronized (random) {
                    randSeed = CSEP_ContainerTestExecutable.this.random.nextLong();
                }
                System.out.println("Running simulation " + this.index);
                ETAS_EqkRupture scenarioRup = null;
                ETAS_Simulator.runETAS_Simulation(myOutputDir, (AbstractNthRupERF)erf, CSEP_ContainerTestExecutable.this.griddedRegion, scenarioRup, CSEP_ContainerTestExecutable.this.histQkList, CSEP_ContainerTestExecutable.this.includeSpontEvents, CSEP_ContainerTestExecutable.this.includeIndirectTriggering, CSEP_ContainerTestExecutable.this.gridSeisDiscr, simulationName, (Long)randSeed, CSEP_ContainerTestExecutable.this.fractionSrcAtPointList, CSEP_ContainerTestExecutable.this.srcAtPointList, CSEP_ContainerTestExecutable.this.isCubeInsideFaultPolygon, params, null, null);
                File asciiFile = new File(myOutputDir, "simulatedEvents.txt");
                ETAS_CatalogIO.ETAS_Catalog catalog = ETAS_CatalogIO.loadCatalog(asciiFile);
                File binaryFile = new File(myOutputDir, "simulatedEvents.bin");
                ETAS_CatalogIO.writeCatalogBinary(binaryFile, (List<ETAS_EqkRupture>)catalog);
                if (binaryFile.length() > 0L) {
                    asciiFile.delete();
                } else {
                    binaryFile.delete();
                }
                System.out.println("Done with simulation " + this.index);
                CSEP_ContainerTestExecutable.this.checkInFSS(sol);
            }
            catch (Exception e) {
                System.out.println("Simulation failed!");
                e.printStackTrace();
                System.out.println("Exiting...");
                System.exit(1);
            }
        }
    }
}

