/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.DataUtils;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_CatalogIteration;

public class ETAS_kCOVPlot {
    public static void main(String[] args) {
        File resultsFile = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2019_10_29-Start2012_500yr_kCOV1p5_Spontaneous_HistoricalCatalog/results_m5_preserve_chain.bin");
        final HistogramFunction hist = new HistogramFunction(-4.95, 51, 0.1);
        final DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        ETAS_CatalogIteration.processCatalogs(resultsFile, new ETAS_CatalogIteration.Callback(){

            @Override
            public void processCatalog(ETAS_CatalogIO.ETAS_Catalog catalog, int index) {
                for (ETAS_EqkRupture rup : catalog) {
                    double k = rup.getETAS_k();
                    Preconditions.checkState((boolean)Double.isFinite(k), (String)"bad k=%s", (Object)k);
                    double log10k = Math.log10(k);
                    track.addValue(log10k);
                    hist.add(hist.getClosestXIndex(log10k), 1.0);
                }
            }
        });
        System.out.println(track);
        ArrayList<HistogramFunction> funcs = new ArrayList<HistogramFunction>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        funcs.add(hist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        PlotSpec plot = new PlotSpec(funcs, chars, "k Distribution", "Log10(k)", "Count");
        GraphWindow gw = new GraphWindow(plot);
        gw.setDefaultCloseOperation(3);
    }
}

