/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.etas.weeklyRuns;

import com.google.common.base.Preconditions;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FilePathComparator;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_CatalogIteration;

public class MPJ_WeeklyPostProcessor
extends MPJTaskCalculator {
    private List<File> configFiles = new ArrayList<File>();
    private List<String> header;
    private List<String> fixedDurHeader;
    static final long hour_millis = 3600000L;
    static final long day_millis = 86400000L;
    static final long week_millis = 604800000L;
    static final long month_millis = 2592000000L;
    private static final long time_delta_millis = 3600000L;
    private static double[] min_mags = new double[]{2.5, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
    private static double[] fractiles = new double[]{0.0, 0.025, 0.16, 0.5, 0.84, 0.975, 1.0};
    private static long[] indv_cat_durations = new long[]{86400000L, 604800000L, 2592000000L, 31557600000L};
    private static String[] indv_cat_duration_labels = new String[]{"1 Day", "1 Week", "1 Month", "1 Year"};
    private ExecutorService exec;

    private MPJ_WeeklyPostProcessor(CommandLine cmd, File mainDir) {
        super(cmd);
        this.calcTreeSearch(mainDir, this.configFiles);
        if (this.rank == 0) {
            this.debug("Found " + this.configFiles.size() + " config files");
        }
        Collections.sort(this.configFiles, new FilePathComparator());
        this.header = new ArrayList<String>();
        this.header.add("Time (epoch milliseconds)");
        this.header.add("Probability");
        this.header.add("Mean");
        for (double fractile : fractiles) {
            this.header.add("p" + (float)(100.0 * fractile) + " %-ile");
        }
        this.fixedDurHeader = new ArrayList<String>();
        this.fixedDurHeader.add("Catalog Index");
        for (String label : indv_cat_duration_labels) {
            this.fixedDurHeader.add(label + " Count");
        }
        this.exec = Executors.newFixedThreadPool(this.getNumThreads());
    }

    private void calcTreeSearch(File dir, List<File> configFiles) {
        Preconditions.checkState((boolean)dir.isDirectory());
        File configFile = new File(dir, "config.json");
        if (configFile.exists()) {
            configFiles.add(configFile);
        }
        for (File subDir : dir.listFiles()) {
            if (!subDir.isDirectory() || subDir.getName().startsWith("results")) continue;
            this.calcTreeSearch(subDir, configFiles);
        }
    }

    protected int getNumTasks() {
        return this.configFiles.size();
    }

    protected void calculateBatch(int[] batch) throws Exception {
        ArrayList futures = new ArrayList();
        for (int index : batch) {
            futures.add(this.exec.submit(new CalcRunnable(index)));
        }
        Object object = futures.iterator();
        while (object.hasNext()) {
            Future future = (Future)object.next();
            future.get();
        }
    }

    List<String> buildLine(List<int[][]> allCounts, int magIndex, boolean cumulative, int[] prevCounts, int countIndex, long myTime) {
        double[] counts = new double[allCounts.size()];
        int numWith = 0;
        for (int i = 0; i < allCounts.size(); ++i) {
            int[][] catCounts = allCounts.get(i);
            int count = catCounts[magIndex][countIndex];
            if (cumulative) {
                int n = i;
                prevCounts[n] = prevCounts[n] + count;
                count = prevCounts[i];
            }
            if (count > 0) {
                ++numWith;
            }
            counts[i] = count;
        }
        ArrayList<String> line = new ArrayList<String>();
        line.add("" + myTime);
        double prob = (double)numWith / (double)allCounts.size();
        line.add("" + (float)prob);
        double mean = StatUtils.mean((double[])counts);
        line.add("" + (float)mean);
        for (double fractile : fractiles) {
            double val = fractile == 0.0 ? StatUtils.min((double[])counts) : (fractile == 1.0 ? StatUtils.max((double[])counts) : StatUtils.percentile((double[])counts, (double)(fractile * 100.0)));
            line.add("" + (float)val);
        }
        return line;
    }

    public static String getCSVName(double minMag, boolean cumulative) {
        String name = "m" + (float)minMag;
        if (cumulative) {
            name = name + "_cumulative";
        }
        return name + "_time_stats.csv";
    }

    public static String getFixedCSVName(double minMag) {
        String name = "m" + (float)minMag;
        return name + "_indv_fixed_duration_counts.csv";
    }

    public static String getDailyCSVName(double minMag) {
        String name = "m" + (float)minMag;
        return name + "_daily_counts.csv";
    }

    protected void doFinalAssembly() throws Exception {
        this.exec.shutdown();
    }

    public static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        return ops;
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        try {
            args = MPJTaskCalculator.initMPJ((String[])args);
            Options options = MPJ_WeeklyPostProcessor.createOptions();
            CommandLine cmd = MPJ_WeeklyPostProcessor.parse((Options)options, (String[])args, MPJ_WeeklyPostProcessor.class);
            args = cmd.getArgs();
            if (args.length != 1) {
                System.err.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(MPJ_WeeklyPostProcessor.class) + " [options] <directory>");
                MPJ_WeeklyPostProcessor.abortAndExit((int)2);
            }
            File mainDir = new File(args[0]);
            Preconditions.checkArgument((boolean)mainDir.exists());
            MPJ_WeeklyPostProcessor driver = new MPJ_WeeklyPostProcessor(cmd, mainDir);
            driver.run();
            MPJ_WeeklyPostProcessor.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_WeeklyPostProcessor.abortAndExit((Throwable)t);
        }
    }

    private class CalcRunnable
    implements Runnable {
        int index;

        public CalcRunnable(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            File configFile = MPJ_WeeklyPostProcessor.this.configFiles.get(this.index);
            File resultsFile = new File(configFile.getParentFile(), "results_complete.bin");
            if (!resultsFile.exists()) {
                resultsFile = new File(configFile.getParentFile(), "results_complete.bin.gz");
            }
            File simDir = configFile.getParentFile();
            if (!resultsFile.exists()) {
                MPJ_WeeklyPostProcessor.this.debug(simDir.getName() + " is not yet done, skipping");
                return;
            }
            MPJ_WeeklyPostProcessor.this.debug("processing " + simDir.getName());
            try {
                ETAS_Config config = ETAS_Config.readJSON(configFile);
                long startTime = config.getSimulationStartTimeMillis();
                long endTime = (long)((double)startTime + 3.15576E10 * config.getDuration() + 0.5);
                ArrayList<Long> times = new ArrayList<Long>();
                for (long time = startTime + 3600000L; time <= endTime; time += 3600000L) {
                    times.add(time);
                }
                CatalogCallback callback = new CatalogCallback(times, config);
                int numProcessed = ETAS_CatalogIteration.processCatalogs(resultsFile, callback);
                if (numProcessed < config.getNumSimulations()) {
                    MPJ_WeeklyPostProcessor.this.debug(simDir.getName() + " incomplete, " + numProcessed + "/" + config.getNumSimulations() + " done");
                    return;
                }
                List<int[][]> allCounts = callback.counts;
                Preconditions.checkState((allCounts.size() == numProcessed ? 1 : 0) != 0);
                File outputDir = new File(simDir, "aggregated_results");
                Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
                for (int m = 0; m < min_mags.length; ++m) {
                    for (boolean cumulative : new boolean[]{false, true}) {
                        CSVFile<String> csv = new CSVFile<String>(true);
                        csv.addLine(MPJ_WeeklyPostProcessor.this.header);
                        int[] prevCounts = cumulative ? new int[numProcessed] : null;
                        for (int t = 0; t < times.size(); ++t) {
                            long myTime = (Long)times.get(t);
                            List<String> line = MPJ_WeeklyPostProcessor.this.buildLine(allCounts, m, cumulative, prevCounts, t, myTime);
                            csv.addLine(line);
                        }
                        File csvFile = new File(outputDir, MPJ_WeeklyPostProcessor.getCSVName(min_mags[m], cumulative));
                        MPJ_WeeklyPostProcessor.this.debug("writing " + csvFile.getName());
                        csv.writeToFile(csvFile);
                    }
                    CSVFile<String> csv = new CSVFile<String>(true);
                    csv.addLine(MPJ_WeeklyPostProcessor.this.fixedDurHeader);
                    for (int i = 0; i < callback.fixedTimeCounts.size(); ++i) {
                        int[][] fixedCounts = callback.fixedTimeCounts.get(i);
                        ArrayList<CallSite> line = new ArrayList<CallSite>();
                        line.add((CallSite)((Object)("" + i)));
                        for (int count : fixedCounts[m]) {
                            line.add((CallSite)((Object)("" + count)));
                        }
                        csv.addLine((List<String>)line);
                    }
                    File csvFile = new File(outputDir, MPJ_WeeklyPostProcessor.getFixedCSVName(min_mags[m]));
                    MPJ_WeeklyPostProcessor.this.debug("writing " + csvFile.getName());
                    csv.writeToFile(csvFile);
                    csv = new CSVFile(true);
                    csv.addLine(MPJ_WeeklyPostProcessor.this.header);
                    for (int d = 0; d < callback.numDays; ++d) {
                        long myTime = callback.simStartTime + ((long)d + 1L) * 86400000L;
                        List<String> line = MPJ_WeeklyPostProcessor.this.buildLine(callback.dailyCounts, m, false, null, d, myTime);
                        csv.addLine(line);
                    }
                    csvFile = new File(outputDir, MPJ_WeeklyPostProcessor.getDailyCSVName(min_mags[m]));
                    MPJ_WeeklyPostProcessor.this.debug("writing " + csvFile.getName());
                    csv.writeToFile(csvFile);
                }
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
    }

    private static class CatalogCallback
    implements ETAS_CatalogIteration.Callback {
        List<int[][]> counts;
        List<Long> times;
        List<int[][]> fixedTimeCounts;
        private long simStartTime;
        private int numDays;
        List<int[][]> dailyCounts;

        public CatalogCallback(List<Long> times, ETAS_Config config) {
            this.times = times;
            this.simStartTime = config.getSimulationStartTimeMillis();
            this.numDays = (int)Math.floor(config.getDuration() * 365.25);
            this.counts = new ArrayList<int[][]>();
            this.fixedTimeCounts = new ArrayList<int[][]>();
            this.dailyCounts = new ArrayList<int[][]>();
        }

        @Override
        public void processCatalog(ETAS_CatalogIO.ETAS_Catalog catalog, int index) {
            int[][] myCount = new int[min_mags.length][this.times.size()];
            int[][] myFixedCounts = new int[min_mags.length][indv_cat_durations.length];
            int[][] myDailyCounts = new int[min_mags.length][this.numDays];
            int timeIndex = 0;
            for (ETAS_EqkRupture rup : catalog) {
                long rupTime = rup.getOriginTime();
                long deltaTime = rupTime - this.simStartTime;
                while (timeIndex < this.times.size() && rupTime >= this.times.get(timeIndex)) {
                    ++timeIndex;
                }
                if (timeIndex >= this.times.size()) break;
                int day = (int)(deltaTime / 86400000L);
                double mag = rup.getMag();
                for (int m = 0; m < min_mags.length; ++m) {
                    if (!(mag >= min_mags[m])) continue;
                    int[] nArray = myCount[m];
                    int n = timeIndex;
                    nArray[n] = nArray[n] + 1;
                    for (int i = 0; i < indv_cat_durations.length; ++i) {
                        if (deltaTime >= indv_cat_durations[i]) continue;
                        int[] nArray2 = myFixedCounts[m];
                        int n2 = i;
                        nArray2[n2] = nArray2[n2] + 1;
                    }
                    if (day >= this.numDays) continue;
                    int[] nArray3 = myDailyCounts[m];
                    int n3 = day;
                    nArray3[n3] = nArray3[n3] + 1;
                }
            }
            this.counts.add(myCount);
            this.fixedTimeCounts.add(myFixedCounts);
            this.dailyCounts.add(myDailyCounts);
        }
    }
}

