/*
 * Decompiled with CFR 0.152.
 */
package scratch.kevin.ucerf3.inversion;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.utils.DeformationModelFileParser;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class MiniSectRecurrenceGen {
    public static void main(String[] args) throws IOException, DocumentException {
        File file = new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_01_14-stampede_3p2_production_runs_combined_FM3_1_MEAN_BRANCH_AVG_SOL.zip");
        U3FaultSystemSolution sol = U3FaultSystemIO.loadSol(file);
        Map<Integer, DeformationModelFileParser.DeformationSection> origDM = DeformationModelFileParser.load(DeformationModels.GEOLOGIC.getDataFileURL(FaultModels.FM3_1));
        MiniSectRecurrenceGen.writeRates(new File("/tmp/mini_sect_branch_avg.csv"), origDM, MiniSectRecurrenceGen.calcMinisectionParticRates(origDM, sol, 6.7, true));
    }

    public static Map<Integer, List<Double>> calcMinisectionParticRates(Map<Integer, DeformationModelFileParser.DeformationSection> dm, FaultSystemSolution sol, double minMag, boolean ri) {
        Map<Integer, List<List<Integer>>> mappings = MiniSectRecurrenceGen.buildSubSectMappings(dm, sol.getRupSet().getFaultSectionDataList());
        return MiniSectRecurrenceGen.calcMinisectionParticRates(sol, mappings, minMag, ri);
    }

    public static Map<Integer, List<Double>> calcMinisectionParticRates(FaultSystemSolution sol, Map<Integer, List<List<Integer>>> mappings, double minMag, boolean ri) {
        FaultSystemRupSet rupSet = sol.getRupSet();
        HashMap ratesMap = Maps.newHashMap();
        for (Integer parentID : mappings.keySet()) {
            ArrayList rates = Lists.newArrayList();
            for (List<Integer> subSects : mappings.get(parentID)) {
                int rupID;
                Iterator<Object> iterator;
                HashSet<Integer> rupsSet = new HashSet<Integer>();
                for (int subSect : subSects) {
                    iterator = rupSet.getRupturesForSection(subSect).iterator();
                    while (iterator.hasNext()) {
                        rupID = (Integer)iterator.next();
                        if (!(rupSet.getMagForRup(rupID) >= minMag)) continue;
                        rupsSet.add(rupID);
                    }
                }
                double rate = 0.0;
                iterator = rupsSet.iterator();
                while (iterator.hasNext()) {
                    rupID = (Integer)iterator.next();
                    rate += sol.getRateForRup(rupID);
                }
                if (ri) {
                    rate = 1.0 / rate;
                }
                rates.add(rate);
            }
            ratesMap.put(parentID, rates);
        }
        return ratesMap;
    }

    public static void writeRates(File file, Map<Integer, DeformationModelFileParser.DeformationSection> dm, Map<Integer, List<Double>> rates) throws IOException {
        Map<Integer, List<Double>> rakesBackup = MiniSectRecurrenceGen.replaceRakes(dm, rates);
        DeformationModelFileParser.write(dm, file);
        MiniSectRecurrenceGen.replaceRakes(dm, rakesBackup);
    }

    private static Map<Integer, List<Double>> replaceRakes(Map<Integer, DeformationModelFileParser.DeformationSection> dm, Map<Integer, List<Double>> replacement) {
        HashMap backupMap = Maps.newHashMap();
        for (Integer parentID : dm.keySet()) {
            ArrayList backupList = Lists.newArrayList();
            backupMap.put(parentID, backupList);
            List<Double> ratesList = replacement.get(parentID);
            Preconditions.checkNotNull(ratesList);
            DeformationModelFileParser.DeformationSection sect = dm.get(parentID);
            Preconditions.checkNotNull((Object)sect);
            for (int mini = 0; mini < sect.getRakes().size(); ++mini) {
                backupList.add(sect.getRakes().get(mini));
                sect.getRakes().set(mini, ratesList.get(mini));
            }
        }
        return backupMap;
    }

    public static Map<Integer, List<List<Integer>>> buildSubSectMappings(Map<Integer, DeformationModelFileParser.DeformationSection> origDM, List<? extends FaultSection> subSectsList) {
        HashMap sectsMap = Maps.newHashMap();
        for (FaultSection sect : subSectsList) {
            Integer parentID = sect.getParentSectionId();
            List sects = (List)sectsMap.get(parentID);
            if (sects == null) {
                sects = Lists.newArrayList();
                sectsMap.put(parentID, sects);
            }
            sects.add(sect);
        }
        subSectsList = Lists.newArrayList(subSectsList);
        for (Integer parentID : sectsMap.keySet()) {
            if (origDM.containsKey(parentID)) continue;
            for (FaultSection sect : (List)sectsMap.get(parentID)) {
                subSectsList.remove(sect);
            }
        }
        HashMap mappings = Maps.newHashMap();
        HashSet<Integer> mappedSectsSet = new HashSet<Integer>();
        for (Integer parentID : origDM.keySet()) {
            ArrayList mappingsLists = Lists.newArrayList();
            mappings.put(parentID, mappingsLists);
            List sects = (List)sectsMap.get(parentID);
            DeformationModelFileParser.DeformationSection dmSect = origDM.get(parentID);
            LocationList trace = dmSect.getLocsAsTrace();
            for (int mini = 0; mini < dmSect.getSlips().size(); ++mini) {
                ArrayList miniMappings = Lists.newArrayList();
                mappingsLists.add(miniMappings);
                Location dmStart = dmSect.getLocs1().get(mini);
                Location dmEnd = dmSect.getLocs2().get(mini);
                for (FaultSection sect : sects) {
                    Location sectStart = (Location)sect.getFaultTrace().get(0);
                    Location sectEnd = (Location)sect.getFaultTrace().get(sect.getFaultTrace().size() - 1);
                    boolean startBefore = MiniSectRecurrenceGen.isBefore(dmStart, dmEnd, sectStart);
                    boolean startAfter = MiniSectRecurrenceGen.isAfter(dmStart, dmEnd, sectStart);
                    boolean endBefore = MiniSectRecurrenceGen.isBefore(dmStart, dmEnd, sectEnd);
                    boolean endAfter = MiniSectRecurrenceGen.isAfter(dmStart, dmEnd, sectEnd);
                    if (startAfter || endBefore) continue;
                    miniMappings.add(sect.getSectionId());
                    mappedSectsSet.add(sect.getSectionId());
                }
                Preconditions.checkState((!miniMappings.isEmpty() ? 1 : 0) != 0, (Object)"No mappings found!!!");
            }
        }
        Preconditions.checkState((mappedSectsSet.size() == subSectsList.size() ? 1 : 0) != 0, (Object)("Not all sub sects mapped! Total: " + subSectsList.size() + ", Mapped: " + mappedSectsSet.size()));
        return mappings;
    }

    private static boolean isBefore(Location start, Location end, Location pt) {
        if (start.equals(pt) || LocationUtils.areSimilar(start, pt)) {
            return true;
        }
        double pt_start_dist = LocationUtils.linearDistanceFast(pt, start);
        if (pt_start_dist == 0.0) {
            return true;
        }
        double pt_end_dist = LocationUtils.linearDistanceFast(pt, end);
        double start_end_dist = LocationUtils.linearDistanceFast(start, end);
        return pt_start_dist < pt_end_dist && pt_end_dist > start_end_dist;
    }

    private static boolean isAfter(Location start, Location end, Location pt) {
        if (end.equals(pt) || LocationUtils.areSimilar(end, pt)) {
            return true;
        }
        double pt_end_dist = LocationUtils.linearDistanceFast(pt, end);
        if (pt_end_dist == 0.0) {
            return true;
        }
        double pt_start_dist = LocationUtils.linearDistanceFast(pt, start);
        double start_end_dist = LocationUtils.linearDistanceFast(start, end);
        return pt_end_dist < pt_start_dist && pt_start_dist > start_end_dist;
    }

    private static boolean isBetween(Location start, Location end, Location pt) {
        return !MiniSectRecurrenceGen.isBefore(start, end, pt) && !MiniSectRecurrenceGen.isAfter(start, end, pt);
    }
}

