# OpenSHA 26.1.0 Beta
First iteration of the OpenSHA software beta release
December 17 2025 2025 9:00 AM PT.

abhatthal/opensha-fork/release/26.1-beta:
* Merged from opensha/opensha/master -> main
* bugfix/fortran-erf-removal
* chore/multi-erf-data-servers
* chore/opensha-server-migration

Our next major release is planned for January 6 2026 by EOD PT.

This major software release should reflect the latest iteration of the
corresponding beta release.  Note that the interface is unstable and subject to
change.

## Structure
Unlike previous releases, there are two variants for this OpenSHA beta release.
* standard - Servlet URL uses CNAME alias "https://data.opensha.org"
* hardcode - Servlet URL uses "https://opensha.scec.org" directly.

The standard variant uses unencrypted Tomcat9 connections as the legacy server
does not support it. The hardcode variant is otherwise identical to the primary
beta release.Both use their dev servlets. The hardcoded servlet URL is for the
new OpenSHA server. This allows beta testers to validate the consistency of
behavior in the old and new servers.

Note that the CNAME alias will be updated from the old server
("https://opensha.usc.edu") and that this change happens independently of the
software release. As such, it's not mentioned in the release notes.


## Release Notes (v26.1.0-beta)
Comprehensive change list relative to last stable release v25.4.2:
* Drop support for WG02 Fortran Wrapped ERF Epistemic List across all OpenSHA
  applications 
* Fix bug in Comcat Report Page Generator
  - NaN handling in foreshock and aftershock summary statistics prevented page
    generation
  - Currently patched for use in SCEC Event Page Generator
* Updated [GetFile](https://github.com/abhatthal/getfile) (v25.4.0 -> v25.11.0)
  * GetFile versions are now tagged allowing for easier change comparison
  * Support using GetFile Downloader directly
  * New constructor for multiple server URIs. Uses first server available
    for retrieval.
  * Cleaned documentation and more robust testing
* Support ERF retrieval from CARC project2 first, with CARC project as fallback
* New applications: IMEventSetCalculator GUI and CLT
  * IMEventSetCalculator allows for mean and sigma calculations across multiple
    sites with selected IMRs and IMTs. 
  * In GUI, each site has its own unique set of site data parameters generated
    from IMRs
  * CLT is simpler in its design with limited site data options and without
    site data provider retrieval.
  * See IMEventSetCalculatorCLT-26.1.0-beta/README.txt for CLT usage
* Add support for encrypted connections to Tomcat9 servlets. Used for GMT map
  generation and Site Data Provider retrieval.


## IMEventSetCalculatorGUI Tutorial
Brief tutorial on usage of IMEventSetCalculatorGUI.  This section will be
migrated to the tutorials section of the https://opensha.org website.

The IM Event Set Calculator GUI application consists of three navigation tabs
  * IMRs/IMTs (First pane, you should be here initially)
  * Sites/ERFs
  * Site Data Providers

You can switch through these panes in any order, but using these in sequence
prevents your changes from being overwritten.

1. Select your IMRs
![IMR Selected](img/imr-selected.png)
  * For this demo, select the following IMRs with default IMR Params:
    * Abrahamson & Silva (1997)
    * Campbell & Bozorgnia (2008)
    * Chiou & Youngs (2008)
  * You should first navigate to the drop-down menu under "Set IMR" on the
    left-side of the first pane.
  * After clicking on your desired IMR, navigate directly below to "IMR
    Params" and set as desired.
  * After satisfied, click "Add" above "Set IMR" to add the selected IMR to
    the set of "Selected IMR(s)".
  * Repeat until all desired IMRs have been selected. No other changes
    throughout this application should impact your selected IMRs or IMR
    parameters.
  * Note that it's possible that the combination of selected IMRs does not
    allow for the selection of IMTs. If this happens, you can remove IMRs with
    the "Remove" button.
     
2. Select your IMTs
![IMT Selected](img/imt-selected.png)
  * For this demo, select the following IMTs:
    * PGA
    * SA 1.0
    * SA 2.0
  * On the right side of the page you should see "Set IMT". The same process
    applies here to select your desired IMTs. IMTs available for selection are
    determined by selected IMRs.
  * Click "Add" above "Set IMT" for each desired IMT until satisfied.
  * Note that for the "SA" IMT, you can add this multiple times if you vary
    the SA Period. SA Periods available also vary depending on selected IMRs.
  * You can add more IMRs, but removing selected IMRs may result in selected
    IMTs to be invalidated. Attempting to do so will prompt the user with a
    warning and confirmation if they would like to proceed with IMR removal.

3. Select your Sites
![Sites Selected](img/sites-selected.png)
  * For this demo, select the following Sites with params:
    * (34.0,-110.5): {AS Site Type:Deep Soil; Vs30:760.0; Depth 2.5 km/sec:1.0; Vs30 Type:Inferred; Depth 1.0 km/sec:100.0}
    * (35.0,-118.0): Set Params from Web Services {AS Site Type:Rock/Shallow-Soil; Vs30:710.1; Depth 2.5 km/sec:0.0; Vs30 Type:Inferred; Depth 1.0 km/sec:0.0}
    * (34.0,-118.0): {AS Site Type:Deep-Soil; Vs30:260.0; Depth 2.5 km/sec:0.0; Vs30 Type:Measured; Depth 1.0 km/sec:100.0}
  * Select the "Sites/ERFs" tab at the top of the application window.
  * On the left side of the new pane, select the "Add Site" button.
  * A popup window should appear called "Add Site".
  * Enter desired latitude and longitude coordinates for this site.
  * There should also be a list of Site Params you can set. They are populated
    with default values. Change these values as desired.
  * You can also retrieve values from Site Data Providers (internet required)
  * By default, all Site Data Providers are enabled. To change the selected
    providers, see Step 5, "Optional: Select your Site Data Providers"
  * After satisfied with the site configuration, click "OK" to close the pop-up
    window and add the site to our list of Sites.
  * You can continue to add sites by clicking "Add Site" again. You must use a
    unique set of coordinates for each site, otherwise the pop-up will not close
    when clicking "OK".
  * You can edit any site by selecting it from the "Sites" list and then
    clicking "Edit Site".
  * Select any site or a collection of sites by holding shift and click
    "Remove Site" to remove the selected site(s).
  * Note that the available site data parameters are generated from the selected
    IMRs. Adding new IMRs means existing sites won't have all eligible params
    configured. You can edit each site individually to see any new parameters.
  * Removing IMRs may also result in the removal of site data parameters from
    existing sites. A warning will appear when doing so. This practice is
    strongly discouraged.

4. Select your ERF
![ERF Selected](img/erf-selected.png)
  * For this demo, select the "Mean UCERF3" Eqk Rup Forecast.
  * On the right side of the current pane (Sites/ERF) you should see "Set Forecast".
  * Click on the drop-down menu for "Eqk Rup Forecast" and select the desired ERF.
  * You may have to wait for the selected ERF to download if not already cached.
  * Some ERFs may defer data retrieval until computation.
  * ERF Parameters will populate below and can be selected. You may need to use
    the scroll-wheel on the right to set all parameters as desired.

5. Optional: Select your Site Data Providers
![Site Data Providers](img/site-data-providers.png)
  * For this demo, you do not need to manually set Site Data Providers.
  * Navigate to the "Site Data Providers" tab at the top of the application.
  * Select desired providers and click "Enable" or "Disable" to toggle.
  * After setting providers, navigate back to "Sites/ERF" and add/edit sites
    and click "Set Params from Web Services" to use the new providers.
  * These selected Site Data Providers can be configured differently for each
    site by repeating this process, or the same providers can be used. 
  * Note that any site values previously set with "Set Params from Web
    Services" will only consider which Site Data Providers were enabled at that
    time for that site.
  * The state of selected Site Data Providers at execution
    time does not impact the computation, as retrieval only occurs when users
    explicitly click the "Set Params from Web Services" button.
  * For any individual provider inside the "Site Data Providers" panel, the
    applicable regions are specified in the paragraph at the bottom. Consider
    these regions to see if a site could be affected by the provider.
  * Learn more about toggling and shifting provider priorities by clicking the
    "Help" button inside the "Site Data Providers" panel.

6. Compute Results
![Calculating](img/calculating.png)
  * For this demo, write with "OpenSHA Format Writer". Takes roughly 1 min.
  * At the bottom of the application, there is a drop-down menu with two options
    * OpenSHA Format Writer"
    * HAZ01 Format Writer"
  * Choose your desired output format and click "Compute".
  * A pop-up window will appear asking where you want to write these results.
  * After selecting an output directory, the pop-up will close and a progress bar
    will indiciate the status of the calculation as either "Calculating" or "Done".

7. View Results
![Expected Output Files](img/expected-output-files.png)
  * Navigate to the output directory you specified and you should see
    several output files.
  * For our demo, compare your outputs against the files found at `demo-imesc-outputs/`.


## Beta Testing
Instructions for beta testing OpenSHA applications:
### ERF retrieval from project2
* Try retrieving ERFs in HazardCurveGUI and IMEventSetCalculatorGUI
* Clear cached ERFs by moving or deleting `$HOME/.opensha` to verify new
  retrieval and cache utilization
* Try utilizing cache across different applications and after closing and
  reopening the same app
* Turn your WiFi off (or unplug Ethernet, etc.) and try to use ERFs. Cached
  ERFs should work just fine.
* Note that not all ERFs use project2 retrieval, some small ERF data is
  bundled directly in codebase

### IM Event Set Calculator GUI
  * Follow the IM Event Set Calculator tutorial in this document and validate
    that the generated outputs are consistent with the reference.
  * Note any UX concerns, inconsistencies or bugs encountered.
  * Try toggling WiFi and using both the hardcode and standard variants to
    evaluate retrieval behavior and performance.
  * Note if the new server (hardcoded) is faster or slower for site data
    retrieval

### IM Event Set Calculator CLT
  * The use of hardcoded or standard variants should not impact the CLT as it
    does not invoke the servlets. Verify outputs are consistent with CLT, using
    inputs that are applicable to each. (The GUI is currently more capable).

### GMT Map Application
  * Compare performance generating GMT maps with the standard and hardcoded variants.
  * Note any broken URLs or bugs

### Site Data GUI
  * Similarly to the IMEventSetCalc GUI, verify that site data is retrieved
    with both variants.

It's worth briefly checking all other OpenSHA applications to confirm there are
no unintended side effects (i.e. bugs or performance impact) due to this release.


