/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.calc;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.util.Precision;
import org.opensha.commons.calc.GaussianDistCalc;

public abstract class GaussianExceedProbCalculator {
    private static Precomputed DEFAULT_NO_TRUNC;
    private static Precomputed PREV_ONE_SIDED;
    private static double PREV_ONE_SIDED_LEVEL;
    private static Precomputed PREV_TWO_SIDED;
    private static double PREV_TWO_SIDED_LEVEL;
    static final double BOUND_TO_DOUBLE_PRECISION = 9.0;
    static final int NUM_DISCR = 100000;
    static final boolean INTERPOLATE = true;

    public abstract double getExceedProb(double var1);

    public static synchronized GaussianExceedProbCalculator getPrecomputedExceedProbCalc(int truncType, double truncLevel) {
        if (truncType == 1) {
            if (PREV_ONE_SIDED == null || truncLevel != PREV_ONE_SIDED_LEVEL) {
                PREV_ONE_SIDED = new Precomputed(truncType, truncLevel);
                PREV_ONE_SIDED_LEVEL = truncLevel;
            }
            return PREV_ONE_SIDED;
        }
        if (truncType == 2) {
            if (PREV_TWO_SIDED == null || truncLevel != PREV_TWO_SIDED_LEVEL) {
                PREV_TWO_SIDED = new Precomputed(truncType, truncLevel);
                PREV_TWO_SIDED_LEVEL = truncLevel;
            }
            return PREV_TWO_SIDED;
        }
        if (DEFAULT_NO_TRUNC == null) {
            DEFAULT_NO_TRUNC = new Precomputed();
        }
        return DEFAULT_NO_TRUNC;
    }

    private static void testCachedProbOptimization() {
        int num = 100000000;
        double[] rands = new double[num];
        for (int i = 0; i < num; ++i) {
            rands[i] = Math.random() * 9.0 * 2.0 - 9.0;
        }
        double[] valuesOrig = new double[num];
        double[] valuesOptimized = new double[num];
        Dynamic dynamicCalc = new Dynamic();
        Stopwatch cacheWatch = Stopwatch.createStarted();
        Precomputed cachedCalc = new Precomputed();
        cacheWatch.stop();
        double cacheSecs = (double)cacheWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        System.out.println("Caching took " + (float)cacheSecs + " s");
        double tol = 1.0E-4;
        for (int j = 0; j < 5; ++j) {
            Stopwatch origWatch = Stopwatch.createStarted();
            for (int i = 0; i < num; ++i) {
                valuesOrig[i] = ((GaussianExceedProbCalculator)dynamicCalc).getExceedProb(rands[i]);
            }
            origWatch.stop();
            Stopwatch optimizedWatch = Stopwatch.createStarted();
            for (int i = 0; i < num; ++i) {
                valuesOptimized[i] = ((GaussianExceedProbCalculator)cachedCalc).getExceedProb(rands[i]);
            }
            optimizedWatch.stop();
            double origSecs = (double)origWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            double optimizedSecs = (double)optimizedWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            System.out.println("Orig took " + (float)origSecs + " s (" + (float)((double)num / origSecs) + " /sec)");
            System.out.println("Optimized took " + (float)optimizedSecs + " s (" + (float)((double)num / optimizedSecs) + " /sec)");
            System.out.println("Speedup factor: " + (float)(origSecs / optimizedSecs));
            double maxDiff = 0.0;
            double maxPDiff = 0.0;
            double sumDiff = 0.0;
            double sumPDiff = 0.0;
            for (int i = 0; i < num; ++i) {
                double diff = valuesOptimized[i] - valuesOrig[i];
                double pDiff = 100.0 * diff / valuesOrig[i];
                maxDiff = Math.max(maxDiff, Math.abs(diff));
                maxPDiff = Math.max(maxPDiff, Math.abs(pDiff));
                sumDiff += Math.abs(diff);
                if (valuesOrig[i] > 0.0) {
                    sumPDiff += Math.abs(pDiff);
                }
                Preconditions.checkState((boolean)Precision.equals((double)valuesOptimized[i], (double)valuesOrig[i], (double)tol), (String)"Mismatch for input=%s: %s != %s; diff=%s, pDiff=%s", (Object[])new Object[]{rands[i], valuesOrig[i], valuesOptimized[i], diff, pDiff});
            }
            double avgDiff = sumDiff / (double)num;
            double avgPDiff = sumPDiff / (double)num;
            System.out.println("\tdiffs: avg=" + (float)avgDiff + ", max=" + (float)maxDiff);
            System.out.println("\tpDiffs: avg=" + (float)avgPDiff + ", max=" + (float)maxPDiff);
        }
    }

    public static void main(String[] args) {
        GaussianExceedProbCalculator.testCachedProbOptimization();
        System.out.println("pDown=" + GaussianDistCalc.getExceedProb(-9.0));
        System.out.println("pUp=" + GaussianDistCalc.getExceedProb(9.0));
    }

    static {
        PREV_ONE_SIDED_LEVEL = Double.NaN;
        PREV_TWO_SIDED_LEVEL = Double.NaN;
    }

    public static class Precomputed
    extends GaussianExceedProbCalculator {
        private static final double PRECISION_SCALE = 1.00000000000001;
        private final double[] probCache;
        private final double[] probSlopeCache;
        private final double delta;
        private final double scaleOverDelta;
        private final double minForCache;
        private final double maxForCache;

        public Precomputed() {
            this(-9.0, 9.0, 100000, 0);
        }

        public Precomputed(int truncType, double truncLevel) {
            this(truncType < 2 ? -9.0 : -truncLevel, truncType > 0 ? truncLevel : 9.0, 100000, truncType);
        }

        private Precomputed(double minForCache, double maxForCache, int discrCount, int truncType) {
            int i;
            Preconditions.checkArgument((minForCache < maxForCache ? 1 : 0) != 0);
            Preconditions.checkState((discrCount > 1 ? 1 : 0) != 0);
            Preconditions.checkState((truncType >= 0 && truncType < 3 ? 1 : 0) != 0);
            this.minForCache = minForCache;
            this.maxForCache = maxForCache;
            this.delta = (maxForCache - minForCache) / (double)(discrCount - 1);
            this.probCache = new double[discrCount];
            this.scaleOverDelta = 1.00000000000001 / this.delta;
            switch (truncType) {
                case 0: {
                    for (int i2 = 0; i2 < discrCount; ++i2) {
                        this.probCache[i2] = GaussianDistCalc.getExceedProb(this.getX(i2));
                    }
                    Preconditions.checkState(((float)this.probCache[0] == 1.0f ? 1 : 0) != 0);
                    Preconditions.checkState(((float)this.probCache[this.probCache.length - 1] == 0.0f ? 1 : 0) != 0);
                    break;
                }
                case 1: {
                    double pUp = GaussianDistCalc.getCDF(maxForCache);
                    for (int i3 = 0; i3 < discrCount; ++i3) {
                        double cdf = GaussianDistCalc.getCDF(this.getX(i3));
                        this.probCache[i3] = 1.0 - cdf / pUp;
                    }
                    Preconditions.checkState(((float)this.probCache[0] == 1.0f ? 1 : 0) != 0);
                    break;
                }
                case 2: {
                    double pDown = GaussianDistCalc.getCDF(minForCache);
                    double pUp = GaussianDistCalc.getCDF(maxForCache);
                    double upDown = pUp - pDown;
                    for (i = 0; i < discrCount; ++i) {
                        double cdf = GaussianDistCalc.getCDF(this.getX(i));
                        this.probCache[i] = (pUp - cdf) / upDown;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected truncation type: " + truncType);
                }
            }
            this.probSlopeCache = new double[discrCount];
            double invDelta = 1.0 / this.delta;
            for (i = 0; i < discrCount - 1; ++i) {
                this.probSlopeCache[i] = invDelta * (this.probCache[i + 1] - this.probCache[i]);
            }
        }

        private double getX(int index) {
            return this.minForCache + this.delta * (double)index;
        }

        @Override
        public double getExceedProb(double standRandVariable) {
            if (standRandVariable < this.minForCache) {
                return 1.0;
            }
            if (standRandVariable > this.maxForCache) {
                return 0.0;
            }
            int xBefore = Precomputed.floorInt(this.scaleOverDelta * (standRandVariable - this.minForCache));
            return this.findY(this.getX(xBefore), this.probCache[xBefore], this.probSlopeCache[xBefore], standRandVariable);
        }

        static int floorInt(double x) {
            return (int)Math.floor(x);
        }

        double findY(double x1, double y1, double ySlope, double x) {
            return Math.fma(ySlope, x - x1, y1);
        }
    }

    public static class Dynamic
    extends GaussianExceedProbCalculator {
        private int truncType;
        private double truncLevel;
        private double pUp;
        private double pUpMinusDown;

        public Dynamic() {
            this.truncType = 0;
        }

        public Dynamic(int truncType, double truncLevel) {
            this.truncType = truncType;
            this.truncLevel = truncLevel;
            switch (truncType) {
                case 0: {
                    break;
                }
                case 1: {
                    Preconditions.checkState((truncLevel > 0.0 ? 1 : 0) != 0);
                    this.pUp = GaussianDistCalc.getCDF(truncLevel);
                    break;
                }
                case 2: {
                    Preconditions.checkState((truncLevel > 0.0 ? 1 : 0) != 0);
                    this.pUp = GaussianDistCalc.getCDF(truncLevel);
                    double pDown = GaussianDistCalc.getCDF(-truncLevel);
                    this.pUpMinusDown = this.pUp - pDown;
                    break;
                }
                default: {
                    throw new IllegalStateException("Bad trunc type: " + truncType);
                }
            }
        }

        @Override
        public double getExceedProb(double standRandVariable) {
            if (this.truncType == 0) {
                return GaussianDistCalc.getExceedProb(standRandVariable);
            }
            double cdf = GaussianDistCalc.getCDF(standRandVariable);
            if (this.truncType == 1) {
                if (standRandVariable > this.truncLevel) {
                    return 0.0;
                }
                return 1.0 - cdf / this.pUp;
            }
            if (standRandVariable > this.truncLevel) {
                return 0.0;
            }
            if (standRandVariable < -this.truncLevel) {
                return 1.0;
            }
            return (this.pUp - cdf) / this.pUpMinusDown;
        }
    }
}

