/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.StringConcatFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.opensha.commons.util.FileUtils;

public class CSVFile<E>
implements Iterable<List<E>> {
    private List<List<E>> values;
    private int cols;
    private boolean strictRowSizes;
    private static final String NULL_STR = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"null"});

    public CSVFile(boolean strictRowSizes) {
        this(null, strictRowSizes);
    }

    public CSVFile(List<List<E>> values, boolean strictRowSizes) {
        if (values == null) {
            values = new ArrayList<List<List<E>>>();
        }
        this.strictRowSizes = strictRowSizes;
        this.cols = -1;
        if (strictRowSizes) {
            for (List<List<E>> list : values) {
                if (this.cols < 0) {
                    this.cols = list.size();
                    continue;
                }
                Preconditions.checkArgument((this.cols == list.size() ? 1 : 0) != 0, (Object)"Values lists aren't the same size!");
            }
        } else {
            int exactCols = -1;
            for (List<List<E>> list : values) {
                int size = list.size();
                if (exactCols < 0) {
                    exactCols = size;
                    continue;
                }
                if (exactCols == size) continue;
                exactCols = -1;
                break;
            }
            if (exactCols >= 0) {
                this.cols = exactCols;
            }
        }
        this.values = values;
    }

    public int getNumRows() {
        return this.values.size();
    }

    public int getNumCols() {
        return this.cols;
    }

    public boolean isStrictRowSizes() {
        return this.strictRowSizes;
    }

    public void set(int row, int col, E value) {
        this.getLine(row).set(col, value);
    }

    public void addLine(List<E> line) {
        this.checkValidLine(line);
        this.values.add(line);
    }

    public void addLine(E ... line) {
        this.addLine(Lists.newArrayList((Object[])line));
    }

    public void addLine(int index, List<E> line) {
        this.checkValidLine(line);
        this.values.add(index, line);
    }

    public void setLine(int index, List<E> line) {
        this.checkValidLine(line);
        this.values.set(index, line);
    }

    public void addAll(Collection<List<E>> lines) {
        Preconditions.checkNotNull(lines, (Object)"lines cannot be null!");
        for (List<E> line : lines) {
            this.checkValidLine(line);
        }
        for (List<E> line : lines) {
            this.values.add(line);
        }
    }

    public List<E> removeLine(int index) {
        List<E> ret = this.values.remove(index);
        if (this.values.isEmpty()) {
            this.cols = -1;
        }
        return ret;
    }

    public void addColumn(List<E> vals) {
        if (this.getNumRows() == 0) {
            for (int i = 0; i < vals.size(); ++i) {
                this.addLine(new ArrayList());
            }
        }
        Preconditions.checkArgument((vals.size() == this.getNumRows() ? 1 : 0) != 0);
        int prevNumCols = this.cols;
        for (int row = 0; row < vals.size(); ++row) {
            List<E> line = this.getLine(row);
            E val = vals.get(row);
            if (!this.strictRowSizes && line.size() < prevNumCols) {
                if (val == null) continue;
                while (line.size() < prevNumCols) {
                    line.add(null);
                }
                line.add(val);
                continue;
            }
            line.add(val);
        }
        ++this.cols;
    }

    private void checkValidLine(List<E> line) {
        Preconditions.checkNotNull(line, (Object)"Cannot add a null line!");
        if (this.strictRowSizes) {
            if (this.cols < 0) {
                this.cols = line.size();
            } else {
                Preconditions.checkArgument((line.size() == this.cols ? 1 : 0) != 0, (Object)("New line must contain same number of values as columns (expected " + this.cols + ", got " + line.size() + ")"));
            }
        }
    }

    public E get(int row, int col) {
        return this.getLine(row).get(col);
    }

    public double getDouble(int row, int col) throws NumberFormatException {
        return Double.parseDouble(this.get(row, col).toString());
    }

    public float getFloat(int row, int col) throws NumberFormatException {
        return Float.parseFloat(this.get(row, col).toString());
    }

    public int getInt(int row, int col) throws NumberFormatException {
        return Integer.parseInt(this.get(row, col).toString());
    }

    public long getLong(int row, int col) throws NumberFormatException {
        return Long.parseLong(this.get(row, col).toString());
    }

    public boolean getBoolean(int row, int col) throws NumberFormatException {
        return Boolean.parseBoolean(this.get(row, col).toString());
    }

    public List<E> getLine(int index) {
        return this.values.get(index);
    }

    public String getLineStr(int i) {
        return CSVFile.getLineStr(this.getLine(i));
    }

    public static String getLineStr(List<?> line) {
        return CSVFile.getLineStr(line.toArray());
    }

    public List<E> getColumn(int col) {
        Preconditions.checkArgument((col < this.getNumCols() ? 1 : 0) != 0, (Object)("No column at " + col));
        ArrayList colVals = Lists.newArrayList();
        for (int row = 0; row < this.getNumRows(); ++row) {
            List<E> line = this.getLine(row);
            if (!this.strictRowSizes && col >= line.size()) {
                colVals.add(null);
                continue;
            }
            colVals.add(line.get(col));
        }
        return colVals;
    }

    private static boolean shouldWrap(String valStr) {
        return valStr.contains(",") && (!valStr.startsWith("\"") || !valStr.endsWith("\""));
    }

    public static String getLineStr(Object[] line) {
        StringBuilder lineStr = null;
        for (Object val : line) {
            if (lineStr == null) {
                lineStr = new StringBuilder();
            } else {
                lineStr.append(',');
            }
            if (val == null) {
                lineStr.append(NULL_STR);
                continue;
            }
            String valStr = val.toString();
            boolean wrap = CSVFile.shouldWrap(valStr);
            if (wrap) {
                lineStr.append('\"');
            }
            lineStr.append(valStr);
            if (!wrap) continue;
            lineStr.append('\"');
        }
        return lineStr.toString();
    }

    public static void writeLine(Writer fw, Object[] line) throws IOException {
        for (int i = 0; i < line.length; ++i) {
            Object val = line[i];
            if (i > 0) {
                fw.write(44);
            }
            if (val == null) {
                fw.write(NULL_STR);
                continue;
            }
            String valStr = val.toString();
            boolean wrap = CSVFile.shouldWrap(valStr);
            if (wrap) {
                fw.write(34);
            }
            fw.write(valStr);
            if (!wrap) continue;
            fw.write(34);
        }
        fw.write(10);
    }

    public static void writeLine(Writer fw, List<?> line) throws IOException {
        int length = line.size();
        for (int i = 0; i < length; ++i) {
            Object val = line.get(i);
            if (i > 0) {
                fw.write(44);
            }
            if (val == null) {
                fw.write(NULL_STR);
                continue;
            }
            String valStr = val.toString();
            boolean wrap = CSVFile.shouldWrap(valStr);
            if (wrap) {
                fw.write(34);
            }
            fw.write(valStr);
            if (!wrap) continue;
            fw.write(34);
        }
        fw.write(10);
    }

    public String getHeader() {
        return CSVFile.getLineStr(this.getLine(0));
    }

    public void writeToFile(File file) throws IOException {
        OutputStreamWriter fw = file.getName().toLowerCase().endsWith(".gz") ? new OutputStreamWriter(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)))) : new FileWriter(file);
        this.writeWriter(fw);
        ((Writer)fw).close();
    }

    public void writeToStream(OutputStream stream) throws IOException {
        if (!(stream instanceof BufferedOutputStream)) {
            stream = new BufferedOutputStream(stream);
        }
        this.writeWriter(new OutputStreamWriter(stream));
    }

    private void writeWriter(Writer w) throws IOException {
        for (int i = 0; i < this.getNumRows(); ++i) {
            CSVFile.writeLine(w, this.getLine(i));
        }
        w.flush();
    }

    public void writeToTabSeparatedFile(File file, int headerLines) throws IOException {
        FileWriter fw = new FileWriter(file);
        for (int i = 0; i < this.getNumRows(); ++i) {
            List<E> line = this.getLine(i);
            Object lineStr = null;
            for (E val : line) {
                lineStr = lineStr == null ? "" : (String)lineStr + "\t";
                lineStr = (String)lineStr + val.toString();
            }
            if (i < headerLines) {
                lineStr = "# " + lineStr;
            }
            fw.write((String)lineStr + "\n");
        }
        fw.close();
    }

    public void removeColumn(int i) {
        Preconditions.checkArgument((i >= 0 ? 1 : 0) != 0, (Object)"column must be >= 0");
        Preconditions.checkArgument((this.cols < 0 || i < this.cols ? 1 : 0) != 0, (Object)("invalid column: " + i));
        for (List<E> list : this.values) {
            if (list.size() <= i) continue;
            list.remove(i);
        }
    }

    public static List<String> loadLine(String line) {
        return CSVFile.loadLine(line, -1, -1);
    }

    public static List<String> loadLine(String line, int padToLength, int expectedNum) {
        int end;
        ArrayList<String> vals = expectedNum > 0 ? new ArrayList<String>(expectedNum) : new ArrayList();
        boolean inside = false;
        StringBuilder cur = new StringBuilder();
        int length = line.length();
        int start = 0;
        if (Character.isWhitespace(line.charAt(start))) {
            while (start < length && Character.isWhitespace(line.charAt(start))) {
                ++start;
            }
        }
        if (Character.isWhitespace(line.charAt(end = length - 1))) {
            while (end > start && Character.isWhitespace(line.charAt(end))) {
                --end;
            }
        }
        for (int i = start; i <= end; ++i) {
            char c = line.charAt(i);
            if (!inside && c == ',') {
                vals.add(cur.toString());
                cur.setLength(0);
                continue;
            }
            if (c == '\"') {
                inside = !inside;
                continue;
            }
            cur.append(c);
        }
        if (cur.length() > 0) {
            vals.add(cur.toString());
        }
        while (vals.size() < padToLength) {
            vals.add("");
        }
        return vals;
    }

    public static CSVFile<String> readFile(File file, boolean strictRowSizes) throws IOException {
        return CSVFile.readFile(file, strictRowSizes, -1);
    }

    public static CSVFile<String> readFile(File file, boolean strictRowSizes, int cols) throws IOException {
        if (file.getName().toLowerCase().endsWith(".gz")) {
            GZIPInputStream gzis = new GZIPInputStream(new FileInputStream(file));
            CSVFile<String> csv = CSVFile.readStream(gzis, strictRowSizes, cols);
            gzis.close();
            return csv;
        }
        return CSVFile.readURL(file.toURI().toURL(), strictRowSizes, cols);
    }

    public static CSVFile<String> readURL(URL url, boolean strictRowSizes) throws IOException {
        return CSVFile.readURL(url, strictRowSizes, -1);
    }

    public static CSVFile<String> readURL(URL url, boolean strictRowSizes, int cols) throws IOException {
        return CSVFile.readStream((InputStream)url.getContent(), strictRowSizes, cols);
    }

    public static CSVFile<String> readStream(InputStream is, boolean strictRowSizes) throws IOException {
        return CSVFile.readStream(is, strictRowSizes, -1);
    }

    public static CSVFile<String> readStream(InputStream is, boolean strictRowSizes, int cols) throws IOException {
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<List<List<String>>> values = new ArrayList<List<List<String>>>();
        String line = br.readLine();
        int prevNum = -1;
        while (line != null) {
            if (strictRowSizes && cols < 0) {
                cols = CSVFile.loadLine(line, -1, prevNum).size();
            }
            List<String> vals = CSVFile.loadLine(line, cols, prevNum);
            prevNum = vals.size();
            if (strictRowSizes && vals.size() > cols) {
                br.close();
                throw new IllegalStateException("Line lenghts inconsistant and strictRowSizes=true");
            }
            values.add(vals);
            line = br.readLine();
        }
        br.close();
        return new CSVFile<String>(values, strictRowSizes);
    }

    public static CSVFile<Double> readFileNumeric(File file, boolean strictRowSizes, int headerLines) throws NumberFormatException, IOException {
        return CSVFile.readURLNumeric(file.toURI().toURL(), strictRowSizes, headerLines);
    }

    public static CSVFile<Double> readURLNumeric(URL url, boolean strictRowSizes, int headerLines) throws NumberFormatException, IOException {
        return CSVFile.readStreamNumeric((InputStream)url.getContent(), strictRowSizes, -1, headerLines);
    }

    public static CSVFile<Double> readStreamNumeric(InputStream is, boolean strictRowSizes, int cols, int headerLines) throws NumberFormatException, IOException {
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        ArrayList<List<ArrayList>> values = new ArrayList<List<ArrayList>>();
        int lineCount = 0;
        int prevNum = -1;
        for (String line : FileUtils.loadStream(is)) {
            List<Double> doubles;
            if (headerLines > lineCount) {
                ++lineCount;
                continue;
            }
            if (strictRowSizes && cols < 0) {
                cols = CSVFile.loadLine(line, -1, prevNum).size();
            }
            List<String> vals = CSVFile.loadLine(line, cols, prevNum);
            prevNum = vals.size();
            if (strictRowSizes && vals.size() > cols) {
                throw new IllegalStateException("Line lenghts inconsistant and strictRowSizes=true");
            }
            if (strictRowSizes) {
                double[] array = new double[vals.size()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = Double.parseDouble(vals.get(i));
                }
                doubles = Doubles.asList((double[])array);
            } else {
                doubles = Lists.newArrayList();
                for (String val : vals) {
                    doubles.add(Double.parseDouble(val));
                }
            }
            values.add(doubles);
            ++lineCount;
        }
        return new CSVFile<Double>(values, strictRowSizes);
    }

    @Override
    public Iterator<List<E>> iterator() {
        return this.values.iterator();
    }

    public void sort(int col, int headerRows, Comparator<E> comparator) {
        ArrayList header = Lists.newArrayList();
        for (int row = 0; row < headerRows; ++row) {
            header.add(this.removeLine(0));
        }
        ColumnComparator comp = new ColumnComparator(col, comparator);
        Collections.sort(this.values, comp);
        Collections.reverse(header);
        for (List line : header) {
            this.addLine(0, line);
        }
    }

    public void addColumn() {
        for (List<Object> list : this.values) {
            list.add(null);
        }
    }

    public void printPretty(String delim) {
        ArrayList colSizes = Lists.newArrayList();
        for (int row = 0; row < this.getNumRows(); ++row) {
            List<E> line = this.getLine(row);
            for (int col = 0; col < line.size(); ++col) {
                int len = line.get(col).toString().length();
                if (colSizes.size() == col) {
                    colSizes.add(len);
                    continue;
                }
                if (len <= (Integer)colSizes.get(col)) continue;
                colSizes.set(col, len);
            }
        }
        Joiner j = Joiner.on((String)delim);
        for (List<E> line : this) {
            ArrayList paddedLine = Lists.newArrayList();
            for (int col = 0; col < line.size(); ++col) {
                E e = line.get(col);
                int len = (Integer)colSizes.get(col);
                Object str = e.toString();
                while (((String)str).length() < len) {
                    str = (String)str + " ";
                }
                paddedLine.add(str);
            }
            System.out.println(j.join((Iterable)paddedLine));
        }
    }

    private class ColumnComparator
    implements Comparator<List<E>> {
        private Comparator<E> comp;
        private int col;

        public ColumnComparator(int col, Comparator<E> comp) {
            this.col = col;
            this.comp = comp;
        }

        @Override
        public int compare(List<E> o1, List<E> o2) {
            return this.comp.compare(o1.get(this.col), o2.get(this.col));
        }
    }
}

