/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.opensha.commons.data.CSVFile;

public class CSVReader
implements Closeable,
Iterable<Row> {
    protected BufferedReader reader;
    protected int expectedSize = -1;

    public CSVReader(InputStream in) {
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    public Row read() {
        String line;
        try {
            line = this.reader.readLine();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        if (line == null) {
            return null;
        }
        Row row = new Row(line, this.expectedSize);
        this.expectedSize = row.columns();
        return row;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){
            private Row next = null;
            private boolean done = false;

            @Override
            public Row next() {
                if (this.next != null || this.hasNext()) {
                    Row result = this.next;
                    this.next = null;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.done) {
                    return false;
                }
                if (this.next != null) {
                    return true;
                }
                this.next = CSVReader.this.read();
                if (this.next == null) {
                    this.done = true;
                    return false;
                }
                return true;
            }
        };
    }

    public static class Row {
        protected final List<String> line;

        Row(String row, int expectedSize) {
            this.line = CSVFile.loadLine(row, -1, expectedSize);
        }

        public String get(int column) {
            return this.line.get(column);
        }

        public int getInt(int column) {
            return Integer.parseInt(this.get(column).trim());
        }

        public double getDouble(int column) {
            return Double.parseDouble(this.get(column).trim());
        }

        public float getFloat(int column) {
            return Float.parseFloat(this.get(column).trim());
        }

        public List<String> getLine() {
            return this.line;
        }

        public int columns() {
            return this.line.size();
        }
    }
}

