/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.opensha.commons.exceptions.InvalidRangeException;

@Deprecated
public class OldTimeSpan
extends GregorianCalendar {
    protected static final String C = "OldTimeSpan";
    protected static final boolean D = false;
    protected double duration;
    protected long endTime;

    public OldTimeSpan() {
        this.duration = 1.0;
        this.endTime = this.getTimeInMillis() + (long)(this.duration * 1000.0);
    }

    public OldTimeSpan(double interval) {
        this.duration = interval;
        this.endTime = this.getTimeInMillis() + (long)(this.duration * 1000.0);
    }

    public OldTimeSpan(GregorianCalendar cal, double duration) {
        super(TimeZone.getDefault(), Locale.getDefault());
        this.set(0, 1);
        this.set(1, cal.get(1));
        this.set(2, cal.get(2));
        this.set(5, cal.get(5));
        this.set(11, cal.get(11));
        this.set(12, cal.get(12));
        this.set(13, cal.get(13));
        this.set(14, cal.get(14));
        this.duration = duration;
        this.endTime = this.getTimeInMillis() + (long)(duration * 1000.0);
    }

    public void setDuration(double duration) {
        this.duration = duration;
        this.endTime = this.getTimeInMillis() + (long)(duration * 1000.0);
    }

    public void setStartTime(GregorianCalendar cal) {
        this.set(1, cal.get(1));
        this.set(2, cal.get(2));
        this.set(5, cal.get(5));
        this.set(11, cal.get(11));
        this.set(12, cal.get(12));
        this.set(13, cal.get(13));
        this.set(14, cal.get(14));
        this.endTime = this.getTimeInMillis() + (long)(this.duration * 1000.0);
    }

    public void setEndTime(GregorianCalendar cal) throws InvalidRangeException {
        String S = "OldTimeSpan: setEndTime():";
        long start = this.getTime().getTime();
        long end = cal.getTime().getTime();
        if (end <= start) {
            throw new InvalidRangeException(S + "End time cannot be before or equal to the start time");
        }
        this.endTime = end;
        this.duration = Math.round((double)((end - start) / 1000L));
    }

    public double getDuration() {
        return this.duration;
    }

    public GregorianCalendar getEndTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(this.endTime));
        return cal;
    }

    public GregorianCalendar getStartTime() {
        return this;
    }

    public static void main(String[] args) {
        GregorianCalendar cal = new GregorianCalendar(2000, 1, 1, 1, 1, 1);
        double dur = 3600.0;
        OldTimeSpan tspan = new OldTimeSpan(cal, dur);
        GregorianCalendar calEnd = tspan.getEndTime();
        System.out.println(cal.toString());
        System.out.print("Start: Year: " + cal.get(1) + "; ");
        System.out.print("Month: " + cal.get(2) + "; ");
        System.out.print("Day: " + cal.get(5) + "; ");
        System.out.print("Hour: " + cal.get(11) + "; ");
        System.out.print("Min: " + cal.get(12) + "; ");
        System.out.print("Sec: " + cal.get(13) + "; \n");
        System.out.print("End:   Year: " + calEnd.get(1) + "; ");
        System.out.print("Month: " + calEnd.get(2) + "; ");
        System.out.print("Day: " + calEnd.get(5) + "; ");
        System.out.print("Hour: " + calEnd.get(11) + "; ");
        System.out.print("Min: " + calEnd.get(12) + "; ");
        System.out.print("Sec: " + calEnd.get(13) + "; \n");
    }
}

