/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.comcat;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.comcat.EdgeRuptureSurface;
import org.opensha.commons.geo.LocationList;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.RuptureSurface;

public class ComcatInvertedFiniteFault {
    private List<LocationList> polygons;
    private List<Double> slips;
    private List<Double> moments;

    public ComcatInvertedFiniteFault(List<LocationList> locs, List<Double> slips, List<Double> moments) {
        this.polygons = locs;
        this.slips = slips;
        this.moments = moments;
    }

    ComcatInvertedFiniteFault() {
        this.polygons = new ArrayList<LocationList>();
        this.slips = new ArrayList<Double>();
        this.moments = new ArrayList<Double>();
    }

    void addRecord(LocationList outline, double slip, double moment) {
        this.polygons.add(outline);
        this.slips.add(slip);
        this.moments.add(moment);
    }

    public RuptureSurface buildSurface(double minSlip, double gridSpacing) {
        ArrayList<EdgeRuptureSurface> surfs = new ArrayList<EdgeRuptureSurface>();
        for (LocationList outline : this.getOutlines(minSlip)) {
            surfs.add(EdgeRuptureSurface.build(outline, gridSpacing));
        }
        Preconditions.checkState((!surfs.isEmpty() ? 1 : 0) != 0, (String)"No surfaces found with slip >= %s", (Object)minSlip);
        if (surfs.size() == 1) {
            return (RuptureSurface)surfs.get(0);
        }
        return new CompoundSurface(surfs);
    }

    public LocationList[] getOutlines(double minSlip) {
        ArrayList<LocationList> outlines = new ArrayList<LocationList>();
        for (int i = 0; i < this.polygons.size(); ++i) {
            if (!(this.slips.get(i) >= minSlip)) continue;
            outlines.add(this.polygons.get(i));
        }
        return outlines.toArray(new LocationList[0]);
    }
}

