/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.comcat;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultTrace;

public class EdgeRuptureSurface
extends AbstractEvenlyGriddedSurface {
    private static final boolean D = false;
    private FaultTrace upperTrace;
    private FaultTrace lowerTrace;
    private double maxSpacing;
    private FaultTrace discrUpperTrace;
    private FaultTrace discrLowerTrace;
    private double aveDip;
    private double aveStrike;
    private double upperDepth;
    private double lowerDepth;

    public EdgeRuptureSurface(FaultTrace upperTrace, LocationList lowerTrace, double maxSpacing) {
        this.maxSpacing = maxSpacing;
        Preconditions.checkState((upperTrace.size() == lowerTrace.size() ? 1 : 0) != 0, (Object)"Upper and lower traces must be of the same size");
        double traceStrike = upperTrace.getStrikeDirection();
        double lowerStrike = LocationUtils.azimuth(lowerTrace.first(), lowerTrace.last());
        double strikeDiff = FaultUtils.getAbsAngleDiff(traceStrike, lowerStrike);
        if (strikeDiff > 90.0) {
            LocationList newLower = new LocationList();
            newLower.addAll(lowerTrace);
            newLower.reverse();
            lowerTrace = newLower;
        }
        this.upperTrace = upperTrace;
        this.lowerTrace = new FaultTrace(null);
        this.lowerTrace.addAll(lowerTrace);
        this.buildSurface();
    }

    private void buildSurface() {
        double upperLength = this.upperTrace.getTraceLength();
        double lowerLength = this.lowerTrace.getTraceLength();
        double minLen = Math.min(upperLength, lowerLength);
        int cols = Integer.max((int)Math.ceil(minLen / this.maxSpacing), this.upperTrace.getNumLocations() * 2);
        this.discrUpperTrace = FaultUtils.resampleTrace(this.upperTrace, cols - 1);
        this.discrLowerTrace = FaultUtils.resampleTrace(this.lowerTrace, cols - 1);
        Preconditions.checkState((this.discrUpperTrace.size() == this.discrLowerTrace.size() ? 1 : 0) != 0);
        Preconditions.checkState((this.discrUpperTrace.size() == cols ? 1 : 0) != 0);
        this.gridSpacingAlong = Math.min(this.discrUpperTrace.getTraceLength(), this.discrLowerTrace.getTraceLength()) / ((double)cols - 1.0);
        double maxUpperDepth = Double.NEGATIVE_INFINITY;
        double minLowerDepth = Double.POSITIVE_INFINITY;
        for (Location loc : this.upperTrace) {
            maxUpperDepth = Math.max(maxUpperDepth, loc.getDepth());
        }
        for (Location loc : this.lowerTrace) {
            minLowerDepth = Math.min(minLowerDepth, loc.getDepth());
        }
        Preconditions.checkState((maxUpperDepth < minLowerDepth ? 1 : 0) != 0, (String)"Deepest point on upper trace must be above shallowest point on lower trace: %s >= %s", (Object)maxUpperDepth, (Object)minLowerDepth);
        double minDepthSpan = minLowerDepth - maxUpperDepth;
        int rows = Integer.max((int)Math.ceil(minDepthSpan / this.maxSpacing), 2);
        this.setNumRowsAndNumCols(rows, cols);
        ArrayList<Double> dips = new ArrayList<Double>();
        ArrayList<Double> upperDepths = new ArrayList<Double>();
        ArrayList<Double> lowerDepths = new ArrayList<Double>();
        this.gridSpacingDown = Double.POSITIVE_INFINITY;
        for (int col = 0; col < cols; ++col) {
            Location upperLoc = (Location)this.discrUpperTrace.get(col);
            Location lowerLoc = (Location)this.discrLowerTrace.get(col);
            upperDepths.add(upperLoc.getDepth());
            lowerDepths.add(lowerLoc.getDepth());
            double horzDist = LocationUtils.horzDistanceFast(upperLoc, lowerLoc);
            double vertDist = LocationUtils.vertDistance(upperLoc, lowerLoc);
            double dip = horzDist > 0.0 ? Math.toDegrees(Math.atan(horzDist / vertDist)) : 90.0;
            Preconditions.checkState((dip > 0.0 && dip <= 90.0 ? 1 : 0) != 0, (String)"Bad dip=%s at col=%s with horzDist=%s, vertDist=%s.\n\tUpperLoc: %s\n\tLowerLoc: %s", (Object[])new Object[]{Float.valueOf((float)dip), col, Float.valueOf((float)horzDist), Float.valueOf((float)vertDist), upperLoc, lowerLoc});
            dips.add(dip);
            LocationVector vector = LocationUtils.vector(upperLoc, lowerLoc);
            vector.setHorzDistance(vector.getHorzDistance() / ((double)rows - 1.0));
            vector.setVertDistance(vector.getVertDistance() / ((double)rows - 1.0));
            this.gridSpacingDown = Math.min(this.gridSpacingDown, Math.sqrt(vector.getHorzDistance() * vector.getHorzDistance() + vector.getVertDistance() * vector.getVertDistance()));
            this.set(0, col, upperLoc);
            for (int row = 1; row < rows; ++row) {
                this.set(row, col, LocationUtils.location((Location)this.get(row - 1, col), vector));
            }
        }
        this.sameGridSpacing = (float)this.gridSpacingAlong == (float)this.gridSpacingDown;
        this.aveDip = StatUtils.mean((double[])Doubles.toArray(dips));
        this.aveStrike = this.discrUpperTrace.getAveStrike();
        this.upperDepth = StatUtils.mean((double[])Doubles.toArray(upperDepths));
        this.lowerDepth = StatUtils.mean((double[])Doubles.toArray(lowerDepths));
    }

    @Override
    public double getAveDip() {
        return this.aveDip;
    }

    @Override
    public double getAveStrike() {
        return this.aveStrike;
    }

    @Override
    public double getAveRupTopDepth() {
        return this.upperDepth;
    }

    @Override
    public double getAveDipDirection() {
        return this.lowerDepth;
    }

    @Override
    protected AbstractEvenlyGriddedSurface getNewInstance() {
        return new EdgeRuptureSurface(this.discrUpperTrace, this.discrLowerTrace, this.maxSpacing);
    }

    public static EdgeRuptureSurface build(List<Location> locs, double maxGridSpacing) {
        Preconditions.checkState((locs.size() % 2 == 1 ? 1 : 0) != 0, (Object)"Must have odd number of surface outline locations");
        Preconditions.checkState((boolean)LocationUtils.areSimilar(locs.get(0), locs.get(locs.size() - 1)), (Object)"Surface outline must be a closed polygon");
        int numEach = locs.size() / 2;
        FaultTrace upper = new FaultTrace(null);
        for (int i = 0; i < numEach; ++i) {
            upper.add(locs.get(i));
        }
        LocationList lower = new LocationList();
        for (int i = numEach; i < numEach * 2; ++i) {
            lower.add(locs.get(i));
        }
        EdgeRuptureSurface surf = new EdgeRuptureSurface(upper, lower, maxGridSpacing);
        return surf;
    }
}

