/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.gson.annotations.JsonAdapter;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.dom4j.Element;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;

@JsonAdapter(value=XY_DataSet.XYAdapter.class)
public class DefaultXY_DataSet
extends AbstractXY_DataSet {
    private static final long serialVersionUID = 1L;
    private ArrayList<Point2D> points;
    private SummaryStatistics xStats;
    private SummaryStatistics yStats;

    public DefaultXY_DataSet() {
        this.init();
    }

    public DefaultXY_DataSet(List<Double> x, List<Double> y) {
        this(Doubles.toArray(x), Doubles.toArray(y));
    }

    public DefaultXY_DataSet(double[] x, double[] y) {
        Preconditions.checkNotNull((Object)x, (Object)"Supplied x-values are null");
        Preconditions.checkNotNull((Object)y, (Object)"Supplied y-values are null");
        Preconditions.checkArgument((x.length > 0 ? 1 : 0) != 0, (Object)"Supplied x-values are empty");
        Preconditions.checkArgument((y.length > 0 ? 1 : 0) != 0, (Object)"Supplied y-values are empty");
        Preconditions.checkArgument((x.length == y.length ? 1 : 0) != 0, (String)"%s [x=%s, y=%s]", (Object)"Supplied data sets are different sizes", (Object)x.length, (Object)y.length);
        this.init();
        for (int i = 0; i < x.length; ++i) {
            this.set(x[i], y[i]);
        }
    }

    private void init() {
        this.points = new ArrayList();
        this.xStats = new SummaryStatistics();
        this.yStats = new SummaryStatistics();
    }

    @Override
    public XY_DataSet deepClone() {
        DefaultXY_DataSet xy = new DefaultXY_DataSet();
        for (Point2D pt : this.points) {
            xy.set(pt);
        }
        xy.setName(this.getName());
        xy.setInfo(this.getInfo());
        xy.setXAxisName(this.getXAxisName());
        xy.setYAxisName(this.getYAxisName());
        return xy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultXY_DataSet)) {
            return false;
        }
        DefaultXY_DataSet function = (DefaultXY_DataSet)obj;
        if (!this.getName().equals(function.getName())) {
            return false;
        }
        return this.getInfo().equals(function.getInfo());
    }

    @Override
    public Point2D get(int index) {
        return this.points.get(index);
    }

    @Override
    public double getMaxX() {
        return this.xStats.getMax();
    }

    @Override
    public double getMaxY() {
        return this.yStats.getMax();
    }

    @Override
    public double getMinX() {
        return this.xStats.getMin();
    }

    @Override
    public double getMinY() {
        return this.yStats.getMin();
    }

    @Override
    public int size() {
        return this.points.size();
    }

    @Override
    public double getX(int index) {
        return this.get(index).getX();
    }

    @Override
    public double getY(int index) {
        return this.get(index).getY();
    }

    @Override
    public void set(Point2D point) {
        this.points.add(point);
        this.xStats.addValue(point.getX());
        this.yStats.addValue(point.getY());
    }

    @Override
    public void set(double x, double y) {
        this.set(new Point2D.Double(x, y));
    }

    @Override
    public void set(int index, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Element toXMLMetadata(Element root) {
        throw new RuntimeException("not supported");
    }

    @Override
    public Element toXMLMetadata(Element root, String elName) {
        throw new RuntimeException("not supported");
    }

    @Override
    public Element toXMLMetadata(Element root, String elName, NumberFormat format) {
        throw new RuntimeException("not supported");
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Name: " + this.getName() + "\n");
        b.append("Num Points: " + this.size() + "\n");
        b.append("Info: " + this.getInfo() + "\n\n");
        b.append("X, Y Data:\n");
        b.append(this.getMetadataString() + "\n");
        return b.toString();
    }

    @Override
    public String getMetadataString() {
        StringBuffer b = new StringBuffer();
        for (Point2D point : this) {
            double x = point.getX();
            double y = point.getY();
            b.append((float)x + "\t  " + (float)y + "\n");
        }
        return b.toString();
    }

    @Override
    public boolean hasX(double x) {
        for (Point2D pt : this) {
            if (pt.getX() != x) continue;
            return true;
        }
        return false;
    }

    public void scale(double scalar) {
        this.yStats = new SummaryStatistics();
        for (int i = 0; i < this.points.size(); ++i) {
            Point2D pt = this.points.get(i);
            pt.setLocation(pt.getX(), pt.getY() * scalar);
            this.yStats.addValue(pt.getY());
        }
    }
}

