/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.dom4j.Element;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;

public class PrimitiveArrayXY_Dataset
extends AbstractXY_DataSet {
    private double[] xs;
    private double[] ys;
    private int size;
    private SummaryStatistics xStats;
    private SummaryStatistics yStats;
    private boolean fixedX = false;

    public PrimitiveArrayXY_Dataset(XY_DataSet xy) {
        this(xy.size());
        for (Point2D pt : xy) {
            this.set(pt);
        }
    }

    public PrimitiveArrayXY_Dataset(int initialCapacity) {
        this.xs = new double[initialCapacity];
        this.ys = new double[initialCapacity];
        this.size = 0;
        this.xStats = new SummaryStatistics();
        this.yStats = new SummaryStatistics();
    }

    public PrimitiveArrayXY_Dataset(double[] xs) {
        this.xs = xs;
        this.fixedX = true;
        this.ys = new double[xs.length];
        this.size = 0;
        this.xStats = new SummaryStatistics();
        this.yStats = new SummaryStatistics();
    }

    public double[] getXArray() {
        return this.xs;
    }

    public double[] getYArray() {
        return this.ys;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.xs.length) {
            int padding = this.xs.length / 2;
            if (padding < 10) {
                padding = 10;
            }
            this.xs = Doubles.ensureCapacity((double[])this.xs, (int)capacity, (int)padding);
            this.ys = Doubles.ensureCapacity((double[])this.ys, (int)capacity, (int)padding);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double getMaxX() {
        return this.xStats.getMax();
    }

    @Override
    public double getMaxY() {
        return this.yStats.getMax();
    }

    @Override
    public double getMinX() {
        return this.xStats.getMin();
    }

    @Override
    public double getMinY() {
        return this.yStats.getMin();
    }

    @Override
    public Point2D get(int index) {
        return new Point2D.Double(this.xs[index], this.ys[index]);
    }

    @Override
    public double getX(int index) throws IndexOutOfBoundsException {
        return this.xs[index];
    }

    @Override
    public double getY(int index) throws IndexOutOfBoundsException {
        return this.ys[index];
    }

    @Override
    public void set(Point2D point) {
        this.set(point.getX(), point.getY());
    }

    @Override
    public synchronized void set(double x, double y) {
        if (this.fixedX) {
            Preconditions.checkState((this.size < this.xs.length ? 1 : 0) != 0);
            Preconditions.checkState((this.xs[this.size] == x ? 1 : 0) != 0);
        } else {
            this.ensureCapacity(this.size + 1);
            this.xs[this.size] = x;
        }
        this.ys[this.size] = y;
        this.xStats.addValue(x);
        this.yStats.addValue(y);
        ++this.size;
    }

    @Override
    public synchronized void set(int index, double y) throws IndexOutOfBoundsException {
        this.ys[index] = y;
        this.yStats.clear();
        for (int i = 0; i < this.size; ++i) {
            this.yStats.addValue(this.ys[i]);
        }
    }

    @Override
    public boolean hasX(double x) {
        for (int i = 0; i < this.size; ++i) {
            if (this.xs[i] != x) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getMetadataString() {
        StringBuffer b = new StringBuffer();
        for (Point2D point : this) {
            double x = point.getX();
            double y = point.getY();
            b.append((float)x + "\t  " + (float)y + "\n");
        }
        return b.toString();
    }

    @Override
    public XY_DataSet deepClone() {
        return new PrimitiveArrayXY_Dataset(this);
    }

    @Override
    public Element toXMLMetadata(Element root, String elName) {
        throw new RuntimeException("not supported");
    }

    @Override
    public Element toXMLMetadata(Element root, String elName, NumberFormat format) {
        throw new RuntimeException("not supported");
    }

    @Override
    public Element toXMLMetadata(Element root) {
        throw new RuntimeException("not supported");
    }

    public static void main(String[] args) {
        PrimitiveArrayXY_Dataset xy = new PrimitiveArrayXY_Dataset(3);
        for (int i = 0; i < 100; ++i) {
            double x = (double)i + Math.random();
            double y = (double)i + Math.random();
            xy.set(x, y);
            System.out.println(i + ". x=" + x + ", y=" + y);
            System.out.println("\tCurrent capacity: " + xy.xs.length);
            System.out.println("\tVal: " + String.valueOf(xy.get(i)));
            System.out.println("\tMax: " + xy.getMaxX() + " " + xy.getMaxY());
        }
    }
}

