/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.WeightedFuncList;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.gui.plot.PlotElement;

public class WeightedFuncListforPlotting
extends WeightedFuncList
implements PlotElement {
    private boolean individualCurvesToPlot = true;
    private boolean fractilesToPlot = true;
    private boolean meantoPlot = true;

    public void setIndividualCurvesToPlot(boolean toPlot) {
        this.individualCurvesToPlot = toPlot;
    }

    public void setFractilesToPlot(boolean toPlot) {
        this.fractilesToPlot = toPlot;
    }

    public void setMeanToPlot(boolean toPlot) {
        this.meantoPlot = toPlot;
    }

    public boolean areIndividualCurvesToPlot() {
        return this.individualCurvesToPlot;
    }

    public boolean areFractilesToPlot() {
        return this.fractilesToPlot;
    }

    public boolean isMeanToPlot() {
        return this.meantoPlot;
    }

    @Override
    public XY_DataSetList getDatasetsToPlot() {
        XY_DataSetList list;
        XY_DataSetList plottedFuncs = new XY_DataSetList();
        if (this.areIndividualCurvesToPlot()) {
            list = this.getWeightedFunctionList();
            plottedFuncs.addAll(list);
        }
        if (this.areFractilesToPlot()) {
            list = this.getFractileList();
            plottedFuncs.addAll(list);
        }
        if (this.isMeanToPlot()) {
            AbstractXY_DataSet meanFunc = this.getMean();
            plottedFuncs.add(meanFunc);
        }
        return plottedFuncs;
    }

    @Override
    public List<Integer> getPlotNumColorList() {
        ArrayList numColorArray = Lists.newArrayList();
        if (this.areIndividualCurvesToPlot()) {
            numColorArray.add(this.getWeightedFunctionList().size());
        }
        if (this.areFractilesToPlot()) {
            numColorArray.add(this.getFractileList().size());
        }
        if (this.isMeanToPlot()) {
            numColorArray.add(1);
        }
        return numColorArray;
    }
}

