/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.base.Preconditions;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import org.dom4j.Element;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.metadata.XMLSaveable;

@JsonAdapter(value=XYAdapter.class)
public interface XY_DataSet
extends PlotElement,
Named,
XMLSaveable,
Serializable,
Iterable<Point2D> {
    public void setName(String var1);

    public void setInfo(String var1);

    @Override
    public String getInfo();

    public int size();

    public double getMinX() throws IndexOutOfBoundsException;

    public double getMaxX() throws IndexOutOfBoundsException;

    public double getMinY() throws IndexOutOfBoundsException;

    public double getMaxY() throws IndexOutOfBoundsException;

    public Point2D get(int var1);

    public double getX(int var1) throws IndexOutOfBoundsException;

    public double getY(int var1) throws IndexOutOfBoundsException;

    public double getClosestYtoX(double var1);

    public double getClosestXtoY(double var1);

    public void set(Point2D var1);

    public void set(double var1, double var3);

    public void set(int var1, double var2) throws IndexOutOfBoundsException;

    default public void setYofX(DoubleUnaryOperator mappedFn) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, mappedFn.applyAsDouble(this.getX(i)));
        }
    }

    default public void setYofX(DoubleBinaryOperator mappedFn) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, mappedFn.applyAsDouble(this.getX(i), this.getY(i)));
        }
    }

    public boolean hasX(double var1);

    public Iterator<Double> getXValuesIterator();

    public Iterator<Double> getYValuesIterator();

    public String toString();

    public String getMetadataString();

    public XY_DataSet deepClone();

    public boolean areAllXValuesInteger(double var1);

    public void setXAxisName(String var1);

    public String getXAxisName();

    public void setYAxisName(String var1);

    public String getYAxisName();

    public List<Double> xValues();

    public List<Double> yValues();

    public Element toXMLMetadata(Element var1, String var2);

    public Element toXMLMetadata(Element var1, String var2, NumberFormat var3);

    public static abstract class AbstractAdapter<E extends XY_DataSet>
    extends TypeAdapter<E> {
        public void write(JsonWriter out, E xy) throws IOException {
            if (xy == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            AbstractAdapter<?> adapter = null;
            try {
                adapter = this.getSubclassAdapter(xy.getClass());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (adapter != null) {
                adapter.innerWrite(out, xy);
            } else {
                this.innerWrite(out, xy);
            }
            out.endObject();
        }

        protected void innerWrite(JsonWriter out, E xy) throws IOException {
            String yName;
            String xName;
            String info;
            Class<E> serType = this.getType();
            Preconditions.checkState((boolean)serType.isAssignableFrom(xy.getClass()));
            out.name("type").value(serType.getName());
            String name = xy.getName();
            if (name != null && !name.isEmpty()) {
                out.name("name").value(name);
            }
            if ((info = xy.getInfo()) != null && !info.isEmpty()) {
                out.name("info").value(info);
            }
            if ((xName = xy.getXAxisName()) != null && !xName.isEmpty()) {
                out.name("xAxisName").value(xName);
            }
            if ((yName = xy.getYAxisName()) != null && !yName.isEmpty()) {
                out.name("yAxisName").value(yName);
            }
            out.name("size").value((long)xy.size());
            out.name("minX").value(xy.getMinX());
            out.name("maxX").value(xy.getMaxX());
            this.serializeExtras(out, xy);
            out.name("values").beginArray();
            for (int i = 0; i < xy.size(); ++i) {
                out.beginArray();
                Point2D val = xy.get(i);
                out.value(val.getX()).value(val.getY());
                out.endArray();
            }
            out.endArray();
        }

        protected void serializeExtras(JsonWriter out, E xy) throws IOException {
        }

        protected abstract E instance(Double var1, Double var2, Integer var3);

        protected abstract Class<E> getType();

        protected Consumer<E> deserializeExtra(JsonReader in, String name) throws IOException {
            in.skipValue();
            return null;
        }

        private AbstractAdapter<E> getSubclassAdapter(String type) throws Exception {
            Class<?> clazz = Class.forName(type);
            return this.getSubclassAdapter(clazz);
        }

        private AbstractAdapter<E> getSubclassAdapter(Class<? extends E> clazz) throws Exception {
            Class<E> testClass = clazz;
            while (XY_DataSet.class.isAssignableFrom(testClass)) {
                Class adapterClass;
                JsonAdapter adapterAnn = testClass.getAnnotation(JsonAdapter.class);
                if (adapterAnn != null && AbstractAdapter.class.isAssignableFrom(adapterClass = adapterAnn.value())) {
                    return (AbstractAdapter)((Object)adapterClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                testClass = testClass.getSuperclass();
            }
            return null;
        }

        public E read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            E xy = this.innerRead(in);
            in.endObject();
            return xy;
        }

        public E innerReadAsType(JsonReader in, Class<? extends E> clazz) throws IOException {
            try {
                AbstractAdapter<E> adapter = this.getSubclassAdapter(clazz);
                if (adapter != null) {
                    return adapter.innerRead(in);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.innerRead(in);
        }

        public E innerRead(JsonReader in) throws IOException {
            String xyName = null;
            String info = null;
            String xName = null;
            String yName = null;
            Integer size = null;
            Double minX = null;
            Double maxX = null;
            XY_DataSet xy = null;
            ArrayList<Consumer<E>> consumers = new ArrayList<Consumer<E>>();
            boolean first = true;
            while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "type": {
                        String type = in.nextString();
                        if (!first) break;
                        AbstractAdapter<E> adapter = null;
                        try {
                            adapter = this.getSubclassAdapter(type);
                        }
                        catch (Exception e) {
                            System.err.println("WARNING: error getting subclass adapter for type='" + type + "', will use generic adapter: " + e.getMessage());
                        }
                        if (adapter == null) break;
                        return adapter.innerRead(in);
                    }
                    case "name": {
                        xyName = in.nextString();
                        break;
                    }
                    case "info": {
                        info = in.nextString();
                        break;
                    }
                    case "xAxisName": {
                        xName = in.nextString();
                        break;
                    }
                    case "yAxisName": {
                        yName = in.nextString();
                        break;
                    }
                    case "size": {
                        size = in.nextInt();
                        break;
                    }
                    case "minX": {
                        minX = in.nextDouble();
                        break;
                    }
                    case "maxX": {
                        maxX = in.nextDouble();
                        break;
                    }
                    case "values": {
                        xy = this.instance(minX, maxX, size);
                        in.beginArray();
                        while (in.hasNext()) {
                            in.beginArray();
                            double x = in.nextDouble();
                            double y = in.nextDouble();
                            xy.set(x, y);
                            in.endArray();
                        }
                        in.endArray();
                        break;
                    }
                    default: {
                        Consumer<E> consumer = this.deserializeExtra(in, name);
                        if (consumer == null) break;
                        consumers.add(consumer);
                    }
                }
                first = false;
            }
            Preconditions.checkNotNull(xy, (Object)"missing 'values'");
            xy.setName(xyName);
            xy.setInfo(info);
            xy.setXAxisName(xName);
            xy.setYAxisName(yName);
            for (Consumer consumer : consumers) {
                consumer.accept(xy);
            }
            return (E)xy;
        }
    }

    public static class XYAdapter
    extends AbstractAdapter<XY_DataSet> {
        @Override
        protected XY_DataSet instance(Double minX, Double maxX, Integer size) {
            return new DefaultXY_DataSet();
        }

        @Override
        protected Class<XY_DataSet> getType() {
            return XY_DataSet.class;
        }
    }
}

