/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.function;

import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import java.util.List;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;

public class XY_DatasetBinner {
    public static XY_DataSet[] bin(List<Point2D> points, List<Double> scalars, double min, int num, double delta) {
        return XY_DatasetBinner.bin(points, scalars, new EvenlyDiscretizedFunc(min, num, delta));
    }

    public static XY_DataSet[] bin(List<Point2D> points, List<Double> scalars, EvenlyDiscretizedFunc binFunc) {
        int i;
        Preconditions.checkArgument((points.size() == scalars.size() ? 1 : 0) != 0);
        XY_DataSet[] ret = new XY_DataSet[binFunc.size()];
        for (i = 0; i < ret.length; ++i) {
            ret[i] = new DefaultXY_DataSet();
        }
        for (i = 0; i < points.size(); ++i) {
            double scalar = scalars.get(i);
            int index = binFunc.getClosestXIndex(scalar);
            ret[index].set(points.get(i));
        }
        return ret;
    }

    public static XY_DataSet[][] bin2D(List<Point2D> points, List<Double> scalars1, List<Double> scalars2, EvenlyDiscretizedFunc binFunc1, EvenlyDiscretizedFunc binFunc2) {
        int i;
        Preconditions.checkArgument((points.size() == scalars1.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((points.size() == scalars2.size() ? 1 : 0) != 0);
        XY_DataSet[][] ret = new XY_DataSet[binFunc1.size()][binFunc2.size()];
        for (i = 0; i < ret.length; ++i) {
            for (int j = 0; j < ret[i].length; ++j) {
                ret[i][j] = new DefaultXY_DataSet();
            }
        }
        for (i = 0; i < points.size(); ++i) {
            double scalar1 = scalars1.get(i);
            double scalar2 = scalars2.get(i);
            int index1 = binFunc1.getClosestXIndex(scalar1);
            int index2 = binFunc2.getClosestXIndex(scalar2);
            ret[index1][index2].set(points.get(i));
        }
        return ret;
    }
}

