/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.region;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;

public class CaliforniaRegions {
    private static Gson gson;

    private CaliforniaRegions() {
    }

    private static synchronized Gson getGson() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
            builder.registerTypeHierarchyAdapter(Region.class, (Object)new Region.Adapter());
            builder.registerTypeHierarchyAdapter(GriddedRegion.class, (Object)new GriddedRegion.Adapter());
            gson = builder.create();
        }
        return gson;
    }

    private static Region loadRegion(String prefix) {
        BufferedReader reader = CaliforniaRegions.getReader(prefix + ".geojson");
        if (reader != null) {
            return (Region)CaliforniaRegions.getGson().fromJson((Reader)reader, Region.class);
        }
        reader = CaliforniaRegions.getReader(prefix + ".coords");
        return new Region(CaliforniaRegions.readCoords(reader), BorderType.MERCATOR_LINEAR);
    }

    private static GriddedRegion loadGridRegion(String prefix, double spacing) {
        BufferedReader reader = CaliforniaRegions.getReader(prefix + "_" + (float)spacing + ".geojson");
        if (reader != null) {
            return (GriddedRegion)CaliforniaRegions.getGson().fromJson((Reader)reader, GriddedRegion.class);
        }
        reader = CaliforniaRegions.getReader(prefix + ".coords");
        return new GriddedRegion(CaliforniaRegions.readCoords(reader), BorderType.MERCATOR_LINEAR, spacing, GriddedRegion.ANCHOR_0_0);
    }

    private static BufferedReader getReader(String filename) {
        InputStream is = CaliforniaRegions.class.getResourceAsStream("/data/region/" + filename);
        if (is == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    private static LocationList readCoords(BufferedReader br) {
        try {
            String s;
            LocationList ll = new LocationList();
            while ((s = br.readLine()) != null) {
                String[] vals = s.trim().split(",");
                double lat = Double.valueOf(vals[0]);
                double lon = Double.valueOf(vals[1]);
                Location loc = Location.backwardsCompatible(lat, lon, 0.0);
                ll.add(loc);
            }
            br.close();
            return ll;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        Region[] regions;
        File outputDir = new File("src/main/resources/data/region");
        Preconditions.checkState((boolean)outputDir.exists());
        for (Region region : regions = new Region[]{new RELM_GRIDDED(), new RELM_TESTING(), new RELM_TESTING_GRIDDED(), new RELM_COLLECTION(), new RELM_COLLECTION_GRIDDED(), new RELM_NOCAL(), new RELM_NOCAL_GRIDDED(), new RELM_SOCAL(), new RELM_SOCAL_GRIDDED(), new SF_BOX_GRIDDED(), new SF_BOX(), new LA_BOX_GRIDDED(), new LA_BOX(), new NORTHRIDGE_BOX(), new SAN_DIEGO_BOX(), new CYBERSHAKE_MAP_REGION(), new CYBERSHAKE_CCA_MAP_REGION(), new CYBERSHAKE_BAY_AREA_MAP_REGION(), new CYBERSHAKE_BAY_AREA_SMALL_MAP_REGION()}) {
            File jsonFile;
            Class<Region> type;
            Object prefix;
            if (region instanceof CA_Region) {
                prefix = ((CA_Region)region).prefix;
                type = Region.class;
            } else {
                Preconditions.checkState((boolean)(region instanceof CA_GriddedRegion));
                CA_GriddedRegion caGrid = (CA_GriddedRegion)region;
                prefix = caGrid.prefix + "_" + (float)caGrid.getSpacing();
                type = GriddedRegion.class;
            }
            System.out.println(region.getName() + " has prefix " + (String)prefix);
            if (region instanceof GriddedRegion) {
                System.out.println("\t" + ((GriddedRegion)region).getNodeCount() + " grid nodes");
            }
            if ((jsonFile = new File(outputDir, (String)prefix + ".geojson")).exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
                System.out.println("Deserializing from: " + jsonFile.getAbsolutePath());
                Region serialized = (Region)CaliforniaRegions.getGson().fromJson((Reader)reader, type);
                System.out.println("\tdeserialized name: " + serialized.getName());
                System.out.println("\tequals? " + region.equals(serialized));
                System.out.println("\tequalsRegion? " + region.equalsRegion(serialized));
                continue;
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(jsonFile));
            System.out.println("Serializing to: " + jsonFile.getAbsolutePath());
            CaliforniaRegions.getGson().toJson((Object)region, type, (Appendable)writer);
            writer.close();
        }
    }

    @Deprecated
    public static final class RELM_GRIDDED
    extends CA_GriddedRegion {
        private static final long serialVersionUID = 1L;

        public RELM_GRIDDED() {
            super("RELM", 0.1);
        }
    }

    public static final class RELM_TESTING
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public RELM_TESTING() {
            super("RELM_testing");
            this.setName("RELM_TESTING Region");
        }
    }

    public static final class RELM_TESTING_GRIDDED
    extends CA_GriddedRegion {
        private static final long serialVersionUID = 1L;

        public RELM_TESTING_GRIDDED() {
            this(0.1);
        }

        public RELM_TESTING_GRIDDED(double spacing) {
            super("RELM_testing", spacing);
            this.setName("RELM_TESTING Region");
        }
    }

    public static final class RELM_COLLECTION
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public RELM_COLLECTION() {
            super("RELM_collection");
            this.setName("RELM_COLLECTION Region");
        }
    }

    public static final class RELM_COLLECTION_GRIDDED
    extends CA_GriddedRegion {
        private static final long serialVersionUID = 1L;

        public RELM_COLLECTION_GRIDDED() {
            super("RELM_collection", 0.1);
        }
    }

    public static final class RELM_NOCAL
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public RELM_NOCAL() {
            super("RELM_NoCal");
            this.setName("RELM_NOCAL Region");
        }
    }

    public static final class RELM_NOCAL_GRIDDED
    extends CA_GriddedRegion {
        private static final long serialVersionUID = 1L;

        public RELM_NOCAL_GRIDDED() {
            super("RELM_NoCal", 0.1);
            this.setName("RELM_NOCAL Region");
        }
    }

    public static final class RELM_SOCAL
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public RELM_SOCAL() {
            super("RELM_SoCal");
            this.setName("RELM_SOCAL Region");
        }
    }

    public static final class RELM_SOCAL_GRIDDED
    extends CA_GriddedRegion {
        private static final long serialVersionUID = 1L;

        public RELM_SOCAL_GRIDDED() {
            super("RELM_SoCal", 0.1);
            this.setName("RELM_SOCAL Region");
        }
    }

    public static final class SF_BOX_GRIDDED
    extends CA_GriddedRegion {
        private static final long serialVersionUID = 1L;

        public SF_BOX_GRIDDED() {
            super("WG02", 0.1);
        }
    }

    public static final class SF_BOX
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public SF_BOX() {
            super("WG02");
            this.setName("SF_BOX Region");
        }
    }

    public static final class LA_BOX_GRIDDED
    extends CA_GriddedRegion {
        private static final long serialVersionUID = 1L;

        public LA_BOX_GRIDDED() {
            this(0.1);
        }

        public LA_BOX_GRIDDED(double spacing) {
            super("WG07", spacing);
        }
    }

    public static final class LA_BOX
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public LA_BOX() {
            super("WG07");
            this.setName("LA_BOX Region");
        }
    }

    public static final class NORTHRIDGE_BOX
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public NORTHRIDGE_BOX() {
            super("NorthridgeBox");
            this.setName("NORTHRIDGE_BOX Region");
        }
    }

    public static final class SAN_DIEGO_BOX
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public SAN_DIEGO_BOX() {
            super("SanDiego");
            this.setName("SAN_DIEGO_BOX Region");
        }
    }

    public static final class CYBERSHAKE_MAP_REGION
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public CYBERSHAKE_MAP_REGION() {
            super("CyberShake_Map");
            this.setName("CyberShake Map Region");
        }
    }

    public static final class CYBERSHAKE_CCA_MAP_REGION
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public CYBERSHAKE_CCA_MAP_REGION() {
            super("CyberShake_Map_CCA");
            this.setName("CyberShake CCA Map Region");
        }
    }

    public static final class CYBERSHAKE_BAY_AREA_MAP_REGION
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public CYBERSHAKE_BAY_AREA_MAP_REGION() {
            super("CyberShake_Map_BayArea");
            this.setName("CyberShake Bay Area Map Region");
        }
    }

    public static final class CYBERSHAKE_BAY_AREA_SMALL_MAP_REGION
    extends CA_Region {
        private static final long serialVersionUID = 1L;

        public CYBERSHAKE_BAY_AREA_SMALL_MAP_REGION() {
            super("CyberShake_Map_BayAreaSmall");
            this.setName("CyberShake Bay Area Map Region (small)");
        }
    }

    private static class CA_Region
    extends Region {
        protected String prefix;

        public CA_Region(String prefix) {
            super(CaliforniaRegions.loadRegion(prefix));
            this.prefix = prefix;
        }
    }

    private static class CA_GriddedRegion
    extends GriddedRegion {
        protected String prefix;

        public CA_GriddedRegion(String prefix, double spacing) {
            super(CaliforniaRegions.loadGridRegion(prefix, spacing));
            this.prefix = prefix;
        }
    }

    public static final class CYBERSHAKE_CCA_MAP_GRIDDED
    extends CA_GriddedRegion {
        private static final long serialVersionUID = 1L;

        public CYBERSHAKE_CCA_MAP_GRIDDED(double spacing) {
            super("CyberShake_Map_CCA", spacing);
        }
    }

    public static final class CYBERSHAKE_MAP_GRIDDED
    extends CA_GriddedRegion {
        private static final long serialVersionUID = 1L;

        public CYBERSHAKE_MAP_GRIDDED(double spacing) {
            super("CyberShake_Map", spacing);
        }
    }
}

