/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.gui;

import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.opensha.commons.data.siteData.gui.SiteDataApplet;
import org.opensha.commons.data.siteData.gui.SiteDataMapApplet;
import org.opensha.commons.gui.DisclaimerDialog;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.bugReports.DefaultExceptionHandler;

public class SiteDataCombinedApp
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final String APP_NAME = "Site Data Application";
    public static final String APP_SHORT_NAME = "SiteData";
    private static ApplicationVersion version;
    private JTabbedPane pane;
    private SiteDataApplet dataApplet;
    private SiteDataMapApplet mapApplet;

    public static ApplicationVersion getAppVersion() {
        if (version == null) {
            try {
                version = ApplicationVersion.loadBuildVersion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public void init() {
        this.pane = new JTabbedPane(1);
        this.dataApplet = new SiteDataApplet();
        this.mapApplet = new SiteDataMapApplet();
        this.pane.addTab("Site Data Values", this.dataApplet);
        this.pane.addTab("Site Data Maps", this.mapApplet);
        this.setContentPane(this.pane);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setTitle("Site Data Application (" + String.valueOf(SiteDataCombinedApp.getAppVersion()) + ")");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        new DisclaimerDialog(APP_NAME, APP_SHORT_NAME, SiteDataCombinedApp.getAppVersion());
        DefaultExceptionHandler exp = new DefaultExceptionHandler(APP_SHORT_NAME, SiteDataCombinedApp.getAppVersion(), null, null);
        Thread.setDefaultUncaughtExceptionHandler(exp);
        SiteDataCombinedApp.launch(exp);
    }

    public static SiteDataCombinedApp launch(DefaultExceptionHandler handler) {
        SiteDataCombinedApp app = new SiteDataCombinedApp();
        if (handler != null) {
            handler.setApp(app);
            handler.setParent(app);
        }
        app.init();
        return app;
    }
}

