/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.SiteDataToXYZ;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.binFile.BinaryMesh2DCalculator;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

public class CVM2BasinDepth
extends AbstractSiteData<Double> {
    public static final String NAME = "SCEC Community Velocity Model Version 2 Basin Depth";
    public static final String SHORT_NAME = "CVM2";
    public static final String FILE_NAME = "src/main/resources/data/site/CVM2/depth_2.5.bin";
    private boolean useServlet;
    private SiteDataServletAccessor<Double> servlet = null;
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/CVM2";
    private GeolocatedRectangularBinaryMesh2DCalculator calc = null;
    private RandomAccessFile file = null;
    private String fileName = null;
    private byte[] recordBuffer = null;
    private FloatBuffer floatBuff = null;
    public static final double minLat = 32.0;
    public static final double minLon = -121.0;
    private static final int nx = 701;
    private static final int ny = 401;
    private static final long MAX_FILE_POS = 0x111700L;
    public static final double gridSpacing = 0.01;

    public CVM2BasinDepth() throws IOException {
        this(null, true);
    }

    public CVM2BasinDepth(String fileName) throws IOException {
        this(fileName, false);
    }

    private CVM2BasinDepth(String fileName, boolean useServlet) throws FileNotFoundException {
        this.useServlet = useServlet;
        this.fileName = fileName;
        this.calc = new GeolocatedRectangularBinaryMesh2DCalculator(BinaryMesh2DCalculator.DataType.FLOAT, 701, 401, 32.0, -121.0, 0.01);
        if (useServlet) {
            this.servlet = new SiteDataServletAccessor<Double>(this, SERVLET_URL);
        } else {
            this.file = new RandomAccessFile(fileName, "r");
            this.calc.setStartBottom(true);
            this.calc.setStartLeft(true);
            this.recordBuffer = new byte[4];
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.LITTLE_ENDIAN);
            this.floatBuff = record.asFloatBuffer();
        }
        this.initDefaultBasinParams();
        this.paramList.addParameter(this.minBasinDoubleParam);
        this.paramList.addParameter(this.maxBasinDoubleParam);
    }

    @Override
    public Region getApplicableRegion() {
        return this.calc.getApplicableRegion();
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        if (this.useServlet) {
            return this.servlet.getClosestLocation(loc);
        }
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double getResolution() {
        return 0.01;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getMetadata() {
        return "Depth to Vs = 2.5 KM/sec, extracted from version 2 of the SCEC Community Velocity Model, part of the SCEC Phase III report.\n\nIt has a grid spacing of 0.01 degrees, and was converted to binary for fast I/O February 2009.";
    }

    @Override
    public String getDataType() {
        return "Depth to Vs = 2.5 km/sec";
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.certifyMinMaxBasinDepth(this.servlet.getValue(loc));
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        if (pos > 0x111700L || pos < 0L) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        double val = this.floatBuff.get(0);
        Double dobVal = val / 1000.0;
        return this.certifyMinMaxBasinDepth(dobVal);
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            ArrayList<Double> vals = this.servlet.getValues(locs);
            for (int i = 0; i < vals.size(); ++i) {
                vals.set(i, this.certifyMinMaxBasinDepth(vals.get(i)));
            }
            return vals;
        }
        return super.getValues(locs);
    }

    @Override
    public boolean isValueValid(Double el) {
        return el >= 0.0 && !Double.isNaN(el);
    }

    @Override
    protected Element addXMLParameters(Element paramsEl) {
        paramsEl.addAttribute("useServlet", "" + this.useServlet);
        paramsEl.addAttribute("fileName", this.fileName);
        return super.addXMLParameters(paramsEl);
    }

    public static CVM2BasinDepth fromXMLParams(Element paramsElem) throws FileNotFoundException {
        boolean useServlet = Boolean.parseBoolean(paramsElem.attributeValue("useServlet"));
        String fileName = paramsElem.attributeValue("fileName");
        return new CVM2BasinDepth(fileName, useServlet);
    }

    public static void main(String[] args) throws IOException {
        CVM2BasinDepth map = new CVM2BasinDepth();
        SiteDataToXYZ.writeXYZ(map, 0.01, "/tmp/basin.txt");
        LocationList locs = new LocationList();
        locs.add(new Location(34.0192, -118.288));
        locs.add(new Location(34.9192, -118.32));
        locs.add(new Location(34.78192, -118.886));
        locs.add(new Location(34.2192, -118.386));
        locs.add(new Location(34.6192, -118.186));
        ArrayList<Double> vals = map.getValues(locs);
        for (double val : vals) {
            System.out.println(val);
        }
    }
}

