/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.RunScript;
import org.opensha.commons.util.ServerPrefUtils;

public class GarciaRegionPerlWrapper
extends AbstractSiteData<String> {
    private static final boolean D = false;
    private File perlScript;
    private SiteDataServletAccessor<String> accessor;
    private Region region = Region.getGlobalRegion();
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/GarciaRegionPerlWrapper";

    public GarciaRegionPerlWrapper(File perlScript) {
        Preconditions.checkState((boolean)perlScript.exists(), (String)"Perl script doesn't exist: %s", (Object)perlScript.getAbsolutePath());
        this.perlScript = perlScript;
    }

    public GarciaRegionPerlWrapper() {
        this.accessor = new SiteDataServletAccessor<String>(this, SERVLET_URL);
    }

    @Override
    public Region getApplicableRegion() {
        return this.region;
    }

    @Override
    public double getResolution() {
        return 0.0;
    }

    @Override
    public String getName() {
        return "Garcia Reigon Perl Wrapper";
    }

    @Override
    public String getShortName() {
        return "GarciaPerlWrap";
    }

    @Override
    public String getDataType() {
        return "Tectonic Regime";
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return loc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<String> getValues(LocationList locs) throws IOException {
        if (this.accessor != null) {
            return this.accessor.getValues(locs);
        }
        File tempDir = null;
        ArrayList ret = null;
        try {
            tempDir = Files.createTempDir();
            File inputFile = new File(tempDir, "fake_input_cat.txt");
            File outputFile = new File(tempDir, "output.txt");
            FileWriter fw = new FileWriter(inputFile);
            for (Location loc : locs) {
                fw.write("col1 col2 col3 col4 col5 " + loc.getLongitude() + " " + loc.getLatitude() + " " + loc.getDepth() + " col9 col10\n");
            }
            fw.close();
            File runScript = new File(tempDir, "runFE.sh");
            fw = new FileWriter(runScript);
            fw.write("#!/bin/bash\n");
            fw.write("\n");
            fw.write("cd " + this.perlScript.getParentFile().getAbsolutePath() + "\n");
            fw.write("\n");
            fw.write("/bin/cat " + inputFile.getAbsolutePath() + " | ./" + this.perlScript.getName() + " > " + outputFile.getAbsolutePath() + "\n");
            fw.close();
            String[] command = new String[]{"sh", "-c", "sh " + runScript.getAbsolutePath()};
            RunScript.runScript(command);
            Preconditions.checkState((boolean)outputFile.exists());
            ret = Lists.newArrayList();
            for (String line : Files.readLines((File)outputFile, (Charset)Charset.defaultCharset())) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] split = line.split(" ");
                Preconditions.checkState((split.length == 12 ? 1 : 0) != 0, (String)"Expected 12 items, got %s", (int)split.length);
                String reg = split[11];
                Preconditions.checkState((boolean)this.isValueValid(reg), (String)"Bad value: %s", (Object)reg);
                ret.add(reg);
            }
            Preconditions.checkState((ret.size() == locs.size() ? 1 : 0) != 0, (Object)"Bad output size");
        }
        finally {
            if (tempDir != null) {
                FileUtils.deleteDirectory((File)tempDir);
            }
        }
        return ret;
    }

    @Override
    public String getValue(Location loc) throws IOException {
        LocationList locs = new LocationList();
        locs.add(loc);
        return this.getValues(locs).get(0);
    }

    @Override
    public boolean isValueValid(String el) {
        return el != null && el.length() > 0;
    }

    @Override
    public String getMetadata() {
        return "Java wrapper to F-E region Perl Script, updated for Garcia subregions";
    }

    public static void main(String[] args) {
        GarciaRegionPerlWrapper garcia = new GarciaRegionPerlWrapper();
        LocationList locs = new LocationList();
        locs.add(new Location(28.2305, 84.7314, 8.22));
        locs.add(new Location(35.0, -118.0, 7.0));
        locs.add(new Location(35.0, -50.0, 7.0));
        for (int i = 0; i < 10; ++i) {
            double lat = 180.0 * Math.random() - 90.0;
            double lon = 360.0 * Math.random() - 180.0;
            double depth = 20.0 * Math.random();
            locs.add(new Location(lat, lon, depth));
        }
        try {
            ArrayList<String> vals = garcia.getValues(locs);
            for (int i = 0; i < locs.size(); ++i) {
                System.out.println(String.valueOf(locs.get(i)) + ": " + (String)vals.get(i));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

