/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.SiteDataToXYZ;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.binFile.BinaryMesh2DCalculator;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

public class USGS_SFBay_BasinDepth_v21p1
extends AbstractSiteData<Double> {
    public static final String NAME = "USGS SF Bay Area Velocity Model Release 21.1";
    public static final String SHORT_NAME = "USGSSFBayAreaBasin21.1";
    public static final double minLat = 36.9;
    public static final double minLon = -123.4;
    private static final int nx = 421;
    private static final int ny = 401;
    private static final long MAX_FILE_POS = 672000L;
    public static final double gridSpacing = 0.005;
    public static final String DEPTH_2_5_FILE = "src/main/resources/data/site/USGS_SF_21.1/sfcvm_z2.5.firstOrSecond";
    public static final String DEPTH_1_0_FILE = "src/main/resources/data/site/USGS_SF_21.1/sfcvm_z1.0.firstOrSecond";
    public static final String SERVLET_2_5_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/USGS_SF_21p1_2_5";
    public static final String SERVLET_1_0_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/USGS_SF_21p1_1_0";
    private RandomAccessFile file = null;
    private String fileName = null;
    private GeolocatedRectangularBinaryMesh2DCalculator calc = null;
    private byte[] recordBuffer = null;
    private FloatBuffer floatBuff = null;
    private boolean useServlet;
    private String type;
    private SiteDataServletAccessor<Double> servlet = null;

    public USGS_SFBay_BasinDepth_v21p1(String type) throws IOException {
        this(type, null, true);
    }

    public USGS_SFBay_BasinDepth_v21p1(String type, String dataFile) throws IOException {
        this(type, dataFile, false);
    }

    public USGS_SFBay_BasinDepth_v21p1(String type, boolean useServlet) throws IOException {
        this(type, null, useServlet);
    }

    public USGS_SFBay_BasinDepth_v21p1(String type, String dataFile, boolean useServlet) throws IOException {
        this.useServlet = useServlet;
        this.fileName = dataFile;
        this.type = type;
        this.calc = new GeolocatedRectangularBinaryMesh2DCalculator(BinaryMesh2DCalculator.DataType.FLOAT, 421, 401, 36.9, -123.4, 0.005);
        if (useServlet) {
            this.servlet = type.equals("Depth to Vs = 1.0 km/sec") ? new SiteDataServletAccessor<Double>(this, SERVLET_1_0_URL) : new SiteDataServletAccessor<Double>(this, SERVLET_2_5_URL);
        } else {
            if (dataFile == null) {
                dataFile = type.equals("Depth to Vs = 1.0 km/sec") ? DEPTH_1_0_FILE : DEPTH_2_5_FILE;
            }
            this.file = new RandomAccessFile(new File(dataFile), "r");
            this.calc.setStartBottom(true);
            this.calc.setStartLeft(true);
            this.recordBuffer = new byte[4];
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.LITTLE_ENDIAN);
            this.floatBuff = record.asFloatBuffer();
        }
        this.initDefaultBasinParams();
        this.paramList.addParameter(this.minBasinDoubleParam);
        this.paramList.addParameter(this.maxBasinDoubleParam);
    }

    @Override
    public Region getApplicableRegion() {
        return this.calc.getApplicableRegion();
    }

    @Override
    public Location getClosestDataLocation(Location loc) {
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getMetadata() {
        return this.type + ", Extracted by Mei-Hui Su on 3/22/24 from UCVM (model name 'sfcvm'), representing version 21.1 of the USGS SF Bay Area Velocity Model from https://www.sciencebase.gov/catalog/item/61817394d34e9f2789e3c36c.\n\nAccording to Scott Callaghan, it is modified \"to include corrections to the gabbro regions.\"\n\nIt has a grid spacing of 0.005 degrees";
    }

    @Override
    public double getResolution() {
        return 0.005;
    }

    @Override
    public String getDataType() {
        return this.type;
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.certifyMinMaxBasinDepth(this.servlet.getValue(loc));
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        if (pos > 672000L || pos < 0L) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        double val = this.floatBuff.get(0);
        if (val >= 1.0E8) {
            return Double.NaN;
        }
        Double dobVal = val / 1000.0;
        return this.certifyMinMaxBasinDepth(dobVal);
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            ArrayList<Double> vals = this.servlet.getValues(locs);
            for (int i = 0; i < vals.size(); ++i) {
                vals.set(i, this.certifyMinMaxBasinDepth(vals.get(i)));
            }
            return vals;
        }
        return super.getValues(locs);
    }

    @Override
    public boolean isValueValid(Double val) {
        return val != null && !Double.isNaN(val);
    }

    @Override
    protected Element addXMLParameters(Element paramsEl) {
        paramsEl.addAttribute("useServlet", "" + this.useServlet);
        paramsEl.addAttribute("fileName", this.fileName);
        paramsEl.addAttribute("type", this.type);
        return super.addXMLParameters(paramsEl);
    }

    public static USGS_SFBay_BasinDepth_v21p1 fromXMLParams(Element paramsElem) throws IOException {
        boolean useServlet = Boolean.parseBoolean(paramsElem.attributeValue("useServlet"));
        String fileName = paramsElem.attributeValue("fileName");
        String type = paramsElem.attributeValue("type");
        return new USGS_SFBay_BasinDepth_v21p1(type, fileName, useServlet);
    }

    public static void main(String[] args) {
        try {
            USGS_SFBay_BasinDepth_v21p1 cvm = new USGS_SFBay_BasinDepth_v21p1("Depth to Vs = 1.0 km/sec", DEPTH_1_0_FILE, false);
            SiteDataToXYZ.writeXYZ(cvm, 0.05, "/tmp/sfbasin.txt");
            System.out.println(cvm.getValue(new Location(37.743302641211756, -122.45461093949983)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

