/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.servlet.SiteDataServletAccessor;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.mapping.gmt.topo.NED_Convert;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.binFile.BinaryMesh2DCalculator;
import org.opensha.commons.util.binFile.GeolocatedRectangularBinaryMesh2DCalculator;

public class US_3secTopography
extends AbstractSiteData<Double> {
    public static final String NAME = "US 3 Sec Topography from USGS NED";
    public static final String SHORT_NAME = "US3secNED";
    public static final double arcSecondSpacing = 3.0;
    public static final double spacing = GeoTools.secondsToDeg(3.0);
    public static final int nx = 81601;
    public static final int ny = 38401;
    public static final double minLon = -128.0;
    public static final double minLat = 20.0;
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "SiteData/US3secNED";
    private boolean useServlet;
    private Region region;
    private RandomAccessFile file = null;
    private byte[] recordBuffer = null;
    private FloatBuffer floatBuff = null;
    private GeolocatedRectangularBinaryMesh2DCalculator calc = null;
    private SiteDataServletAccessor<Double> servlet = null;

    public US_3secTopography() throws IOException {
        this(null, true);
    }

    public US_3secTopography(File file) throws IOException {
        this(file, false);
    }

    private US_3secTopography(File file, boolean useServlet) throws IOException {
        this.useServlet = useServlet;
        if (useServlet) {
            this.servlet = new SiteDataServletAccessor<Double>(this, SERVLET_URL);
        } else {
            this.file = new RandomAccessFile(file, "r");
            this.recordBuffer = new byte[4];
            ByteBuffer record = ByteBuffer.wrap(this.recordBuffer);
            record.order(ByteOrder.BIG_ENDIAN);
            this.floatBuff = record.asFloatBuffer();
        }
        this.calc = new GeolocatedRectangularBinaryMesh2DCalculator(BinaryMesh2DCalculator.DataType.FLOAT, 81601, 38401, 20.0, -128.0, spacing);
        this.calc.setStartBottom(true);
        this.calc.setStartLeft(true);
        this.region = new Region(new Location(20.0, -128.0), new Location(this.calc.getMaxLat(), this.calc.getMaxLon()));
    }

    @Override
    public Region getApplicableRegion() {
        return this.region;
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return this.calc.calcClosestLocation(loc);
    }

    @Override
    public String getMetadata() {
        return "Topography from USGS National Elevelation Dataset (NED) 1 arcsecond dataset.\n\nDownloaded from: http://ned.usgs.gov/\n\n (May, 2014)\n\nConverted to 3 arcsecond and stiched to a single file by " + String.valueOf(NED_Convert.class);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double getResolution() {
        return spacing;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getDataType() {
        return "Elevation (m)";
    }

    @Override
    public String getDataMeasurementType() {
        return "Measured";
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        if (this.useServlet) {
            return this.servlet.getValue(loc);
        }
        long pos = this.calc.calcClosestLocationFileIndex(loc);
        if (pos < 0L || pos > this.calc.getMaxFilePos()) {
            return Double.NaN;
        }
        this.file.seek(pos);
        this.file.read(this.recordBuffer);
        float val = this.floatBuff.get(0);
        return val;
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        if (this.useServlet) {
            return this.servlet.getValues(locs);
        }
        return super.getValues(locs);
    }

    @Override
    public boolean isValueValid(Double val) {
        return val != null && !Double.isNaN(val);
    }

    public static void main(String[] args) throws IOException {
        US_3secTopography data = new US_3secTopography();
        System.out.println(data.getValue(new Location(34.0, -118.0)));
        System.out.println(data.getValue(new Location(37.630173, -119.032681)));
    }
}

