/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.siteData.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.siteData.AbstractSiteData;
import org.opensha.commons.data.siteData.SiteData;
import org.opensha.commons.data.siteData.impl.SRTM30PlusTopoSlope;
import org.opensha.commons.data.siteData.impl.SRTM30PlusTopography;
import org.opensha.commons.data.siteData.impl.SRTM30TopoSlope;
import org.opensha.commons.data.siteData.impl.SRTM30Topography;
import org.opensha.commons.geo.GeoTools;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ArbitrarilyDiscretizedFuncTableModel;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.ArbitrarilyDiscretizedFuncParameter;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.StringParameter;

public class WaldAllenGlobalVs30
extends AbstractSiteData<Double>
implements ParameterChangeListener {
    private static final boolean D = false;
    public static final String NAME = "Global Vs30 from Topographic Slope (Wald & Allen 2008)";
    public static final String SHORT_NAME = "GlobalTopoSlopeVs30";
    public static final double arcSecondSpacing = 30.0;
    public static final double spacing = GeoTools.secondsToDeg(30.0);
    private StringParameter coeffPresetParam;
    public static final String COEFF_SELECT_PARAM_NAME = "Region Type";
    public static final String COEFF_ACTIVE_NAME = "Active Tectonic";
    public static final String COEFF_STABLE_NAME = "Stable Continent";
    public static final String COEFF_CUSTOM_NAME = "Custom Coefficients";
    private ArbitrarilyDiscretizedFuncParameter coeffFuncParam;
    public static final String COEFF_FUNC_PARAM_NAME = "Topographic Slope Translation Coefficients";
    private final ArbitrarilyDiscretizedFunc activeFunc = WaldAllenGlobalVs30.createActiveCoefficients();
    private final ArbitrarilyDiscretizedFunc stableFunc = WaldAllenGlobalVs30.createStableCoefficients();
    private ArbitrarilyDiscretizedFunc customFunc = null;
    private SRTM30TopoSlope srtm30_Slope = new SRTM30TopoSlope();
    private SRTM30PlusTopoSlope srtm30plus_Slope = new SRTM30PlusTopoSlope();
    private SiteData<Double> slopeProvider;
    private ArbitrarilyDiscretizedFunc coeffFunc;
    private BooleanParameter interpolateParam;
    public static final String INTERPOLATE_PARAM_NAME = "Interpolate Between Slope Values (Linear)";
    public static final Boolean INTERPOLATE_PARAM_DEFAULT = true;
    private StringParameter demParam;
    public static final String DEM_SELECT_PARAM_NAME = "Digital Elevation Model";
    public static final String DEM_SRTM30 = "SRTM30 Version 2";
    public static final String DEM_SRTM30_PLUS = "SRTM30 Plus Version 5 (NOTE: contains bathymetry)";
    public static final String DEM_SELECT_DEFAULT = "SRTM30 Version 2";
    private boolean interpolate = true;

    public static ArbitrarilyDiscretizedFunc createActiveCoefficients() {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(3.0E-4, 180.0);
        func.set(0.0035, 240.0);
        func.set(0.01, 300.0);
        func.set(0.018, 360.0);
        func.set(0.05, 490.0);
        func.set(0.1, 620.0);
        func.set(0.14, 760.0);
        return func;
    }

    public static ArbitrarilyDiscretizedFunc createStableCoefficients() {
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(2.0E-5, 180.0);
        func.set(0.002, 240.0);
        func.set(0.004, 300.0);
        func.set(0.0072, 360.0);
        func.set(0.013, 490.0);
        func.set(0.018, 620.0);
        func.set(0.025, 760.0);
        return func;
    }

    public WaldAllenGlobalVs30() throws IOException {
        ArrayList<String> coeffNames = new ArrayList<String>();
        coeffNames.add(COEFF_ACTIVE_NAME);
        coeffNames.add(COEFF_STABLE_NAME);
        coeffNames.add(COEFF_CUSTOM_NAME);
        this.coeffPresetParam = new StringParameter(COEFF_SELECT_PARAM_NAME, coeffNames, COEFF_ACTIVE_NAME);
        this.coeffFuncParam = new ArbitrarilyDiscretizedFuncParameter(COEFF_FUNC_PARAM_NAME, this.activeFunc.deepClone());
        this.coeffFuncParam.setNonEditable();
        this.coeffPresetParam.addParameterChangeListener(this);
        this.coeffFuncParam.addParameterChangeListener(this);
        this.coeffFunc = (ArbitrarilyDiscretizedFunc)this.coeffFuncParam.getValue();
        this.interpolateParam = new BooleanParameter(INTERPOLATE_PARAM_NAME, INTERPOLATE_PARAM_DEFAULT);
        this.interpolateParam.addParameterChangeListener(this);
        ArrayList<String> demNames = new ArrayList<String>();
        demNames.add("SRTM30 Version 2");
        demNames.add(DEM_SRTM30_PLUS);
        this.demParam = new StringParameter(DEM_SELECT_PARAM_NAME, demNames, "SRTM30 Version 2");
        this.demParam.addParameterChangeListener(this);
        this.slopeProvider = this.srtm30_Slope;
        this.initDefaultVS30Params();
        this.paramList.addParameter(this.demParam);
        this.paramList.addParameter(this.interpolateParam);
        this.paramList.addParameter(this.coeffPresetParam);
        this.paramList.addParameter(this.coeffFuncParam);
        this.paramList.addParameter(this.minVs30Param);
        this.paramList.addParameter(this.maxVs30Param);
    }

    @Override
    public Region getApplicableRegion() {
        return this.slopeProvider.getApplicableRegion();
    }

    @Override
    public Location getClosestDataLocation(Location loc) throws IOException {
        return this.srtm30_Slope.getClosestDataLocation(loc);
    }

    @Override
    public String getMetadata() {
        return "Vs30 estimations from topographic slope, as described in:\n\nTopographic Slope as a Proxy for Seismic Site Conditions and Amplification\nBy David J. Wald and Trevor I. Allen\nBulletin of the Seismological Society of America, Vol. 97, No. 5, pp. 1379\u20131395, October 2007, doi: 10.1785/0120060267\n\nAnd updated in:\n\nOn the use of high\u00adresolution topographic data as a proxy for seismic site conditions (Vs30)\nBy Trevor I. Allen and David J. Wald\n\nDigital Elevation model in use is '" + this.slopeProvider.getName() + "', 30 arc second resolution";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public double getResolution() {
        return spacing;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getDataType() {
        return "Vs30";
    }

    @Override
    public String getDataMeasurementType() {
        return "Inferred";
    }

    private double getVs30(double slope) {
        double vs = slope <= this.coeffFunc.getMinX() ? this.coeffFunc.getY(0) : (slope >= this.coeffFunc.getMaxX() ? this.coeffFunc.getY(this.coeffFunc.size() - 1) : (this.interpolate ? this.coeffFunc.getInterpolatedY(slope) : this.coeffFunc.getClosestYtoX(slope)));
        return vs;
    }

    @Override
    public Double getValue(Location loc) throws IOException {
        Double slope = this.slopeProvider.getValue(loc);
        if (!this.srtm30_Slope.isValueValid(slope)) {
            return Double.NaN;
        }
        double vs30 = this.getVs30(slope);
        return this.certifyMinMaxVs30(vs30);
    }

    @Override
    public ArrayList<Double> getValues(LocationList locs) throws IOException {
        ArrayList<Double> slopes = this.slopeProvider.getValues(locs);
        ArrayList<Double> vs30 = new ArrayList<Double>();
        for (int i = 0; i < slopes.size(); ++i) {
            vs30.add(this.certifyMinMaxVs30(this.getVs30(slopes.get(i))));
        }
        return vs30;
    }

    public void setInterpolateValues(boolean interpolate) {
        this.interpolateParam.setValue(interpolate);
    }

    public void setActiveCoefficients() {
        this.coeffPresetParam.setValue(COEFF_ACTIVE_NAME);
    }

    public void setStableCoefficients() {
        this.coeffPresetParam.setValue(COEFF_STABLE_NAME);
    }

    @Override
    public boolean isValueValid(Double el) {
        return el > 0.0 && !el.isNaN();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName == COEFF_SELECT_PARAM_NAME) {
            String val = (String)this.coeffPresetParam.getValue();
            ArbitrarilyDiscretizedFunc oldFunc = (ArbitrarilyDiscretizedFunc)this.coeffFuncParam.getValue();
            if (!ArbitrarilyDiscretizedFuncTableModel.areFunctionPointsEqual(oldFunc, this.activeFunc) && !ArbitrarilyDiscretizedFuncTableModel.areFunctionPointsEqual(oldFunc, this.stableFunc)) {
                this.customFunc = oldFunc;
            }
            if (val == COEFF_ACTIVE_NAME) {
                this.coeffFuncParam.setValue(this.activeFunc.deepClone());
            } else if (val == COEFF_STABLE_NAME) {
                this.coeffFuncParam.setValue(this.stableFunc.deepClone());
            } else if (val == COEFF_CUSTOM_NAME) {
                if (this.customFunc == null) {
                    this.customFunc = this.activeFunc.deepClone();
                }
                this.coeffFuncParam.setValue(this.customFunc);
            }
            this.refreshParams();
        } else if (paramName == COEFF_FUNC_PARAM_NAME) {
            this.coeffFunc = (ArbitrarilyDiscretizedFunc)this.coeffFuncParam.getValue();
            double prevX = 0.0;
            double prevY = 0.0;
            for (int i = 0; i < this.coeffFunc.size(); ++i) {
                double x = this.coeffFunc.getX(i);
                double y = this.coeffFunc.getY(i);
                if (x < prevX || y < prevY) {
                    System.err.println("WARNING: portion of coefficient function has negative slope!");
                }
                prevX = x;
                prevY = y;
            }
        } else if (paramName == INTERPOLATE_PARAM_NAME) {
            this.interpolate = (Boolean)this.interpolateParam.getValue();
        } else if (paramName == DEM_SELECT_PARAM_NAME) {
            String newDem = (String)this.demParam.getValue();
            if (newDem == "SRTM30 Version 2") {
                this.slopeProvider = this.srtm30_Slope;
            } else if (newDem == DEM_SRTM30_PLUS) {
                this.slopeProvider = this.srtm30plus_Slope;
            }
        }
    }

    private void refreshParams() {
        if (this.paramEdit == null) {
            return;
        }
        String val = (String)this.coeffPresetParam.getValue();
        ParameterEditor funcEditor = this.paramEdit.getParameterEditor(COEFF_FUNC_PARAM_NAME);
        funcEditor.setEnabled(val == COEFF_CUSTOM_NAME);
        this.paramEdit.refreshParamEditor();
        funcEditor.getComponent().validate();
        this.paramEdit.validate();
    }

    public void setCoeffFunction(ArbitrarilyDiscretizedFunc func) {
        String selected = (String)this.coeffPresetParam.getValue();
        if (!selected.equals(COEFF_CUSTOM_NAME)) {
            this.coeffPresetParam.setValue(COEFF_CUSTOM_NAME);
        }
        this.coeffFuncParam.setValue(func);
    }

    public ArbitrarilyDiscretizedFunc getCoeffFunctionClone() {
        return this.coeffFunc.deepClone();
    }

    public static void printMapping(ArbitrarilyDiscretizedFunc func) {
        for (int i = 0; i < func.size(); ++i) {
            System.out.println(func.getX(i) + "\t=>\t" + func.getY(i));
        }
    }

    @Override
    protected void initParamListEditor() {
        super.initParamListEditor();
        this.refreshParams();
    }

    public static void main(String[] args) throws IOException {
        WaldAllenGlobalVs30 data = new WaldAllenGlobalVs30();
        data.setActiveCoefficients();
        double vs30 = data.getValue(new Location(34.0, -118.0));
        LocationList locs = new LocationList();
        locs.add(new Location(34.1, -118.0));
        locs.add(new Location(34.2, -118.0));
        locs.add(new Location(34.3, -118.0));
        ArrayList<Double> vs30Vals = data.getValues(locs);
        SRTM30TopoSlope sdata = new SRTM30TopoSlope();
        SRTM30PlusTopoSlope spdata = new SRTM30PlusTopoSlope();
        SRTM30Topography tdata = new SRTM30Topography();
        SRTM30PlusTopography tpdata = new SRTM30PlusTopography();
        System.out.println(data.getValue(new Location(34.0, -118.0)));
        System.out.println(data.getValue(new Location(34.0, -10.0)));
        GriddedRegion region = new GriddedRegion(new Location(32.0, -121.0), new Location(35.0, -117.0), 0.01, new Location(0.0, 0.0));
        ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
        func.set(3.2E-5, 180.0);
        func.set(0.0022, 240.0);
        func.set(0.0063, 300.0);
        func.set(0.018, 360.0);
        func.set(0.05, 490.0);
        func.set(0.1, 620.0);
        func.set(0.138, 760.0);
        data.setCoeffFunction(func);
        System.out.println(data.getCoeffFunctionClone());
        System.out.println("Active Tectonic:");
        WaldAllenGlobalVs30.printMapping(WaldAllenGlobalVs30.createActiveCoefficients());
        System.out.println("Stable Continent:");
        WaldAllenGlobalVs30.printMapping(WaldAllenGlobalVs30.createStableCoefficients());
        Location loc = new Location(34.5, -117.51);
        System.out.println("Slope: " + sdata.getValue(loc));
        System.out.println("Elevation: " + tdata.getValue(loc));
        System.out.println("Plus Slope: " + spdata.getValue(loc));
        System.out.println("Plus Elevation: " + tpdata.getValue(loc));
        System.out.println("Vs30: " + data.getValue(loc));
    }

    public static WaldAllenGlobalVs30 fromXMLParams(Element paramsElem) throws IOException {
        return new WaldAllenGlobalVs30();
    }
}

