/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.uncertainty;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertainDiscretizedFunc;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

@JsonAdapter(value=Adapter.class)
public class UncertainIncrMagFreqDist
extends IncrementalMagFreqDist
implements UncertainDiscretizedFunc {
    protected EvenlyDiscretizedFunc stdDevs;

    public static UncertainIncrMagFreqDist relStdDev(IncrementalMagFreqDist mfd, DoubleUnaryOperator relStdDevFunc) {
        EvenlyDiscretizedFunc stdDevs = new EvenlyDiscretizedFunc(mfd.getMinX(), mfd.getMaxX(), mfd.size());
        stdDevs.setYofX(relStdDevFunc);
        for (int i = 0; i < stdDevs.size(); ++i) {
            stdDevs.set(i, stdDevs.getY(i) * mfd.getY(i));
        }
        return new UncertainIncrMagFreqDist(mfd, stdDevs);
    }

    public static UncertainIncrMagFreqDist constantRelStdDev(IncrementalMagFreqDist mfd, double relStdDev) {
        EvenlyDiscretizedFunc stdDevs = new EvenlyDiscretizedFunc(mfd.getMinX(), mfd.getMaxX(), mfd.size());
        stdDevs.setYofX((double M) -> relStdDev);
        for (int i = 0; i < stdDevs.size(); ++i) {
            stdDevs.set(i, stdDevs.getY(i) * mfd.getY(i));
        }
        return new UncertainIncrMagFreqDist(mfd, stdDevs);
    }

    public static UncertainIncrMagFreqDist absStdDev(IncrementalMagFreqDist mfd, DoubleUnaryOperator absStdDevFunc) {
        EvenlyDiscretizedFunc stdDevs = new EvenlyDiscretizedFunc(mfd.getMinX(), mfd.getMaxX(), mfd.size());
        stdDevs.setYofX(absStdDevFunc);
        return new UncertainIncrMagFreqDist(mfd, stdDevs);
    }

    public static UncertainIncrMagFreqDist absStdDev(IncrementalMagFreqDist mfd, DoubleBinaryOperator absStdDevFunc) {
        EvenlyDiscretizedFunc stdDevs = new EvenlyDiscretizedFunc(mfd.getMinX(), mfd.getMaxX(), mfd.size());
        stdDevs.setYofX(absStdDevFunc);
        return new UncertainIncrMagFreqDist(mfd, stdDevs);
    }

    public UncertainIncrMagFreqDist(IncrementalMagFreqDist mfd, EvenlyDiscretizedFunc stdDevs) throws InvalidRangeException {
        super(mfd.getMinX(), mfd.getMaxX(), mfd.size());
        this.setRegion(mfd.getRegion());
        this.stdDevs = stdDevs;
        if (stdDevs != null) {
            Preconditions.checkState((mfd.size() == stdDevs.size() ? 1 : 0) != 0);
        }
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, mfd.getY(i));
        }
    }

    @Override
    public UncertainIncrMagFreqDist deepClone() {
        return new UncertainIncrMagFreqDist(this, this.stdDevs.deepClone());
    }

    @Override
    public void scale(double val) {
        super.scale(val);
        if (this.stdDevs != null) {
            this.stdDevs.scale(val);
        }
    }

    @Override
    public EvenlyDiscretizedFunc getStdDevs() {
        return this.stdDevs;
    }

    @Override
    public UncertainBoundedIncrMagFreqDist estimateBounds(UncertaintyBoundType boundType) {
        IncrementalMagFreqDist lowerBounds = new IncrementalMagFreqDist(this.getMinX(), this.getMaxX(), this.size());
        IncrementalMagFreqDist upperBounds = new IncrementalMagFreqDist(this.getMinX(), this.getMaxX(), this.size());
        for (int i = 0; i < this.size(); ++i) {
            BoundedUncertainty bounds = boundType.estimate(this.getY(i), this.getStdDev(i));
            lowerBounds.set(i, Math.max(0.0, bounds.lowerBound));
            upperBounds.set(i, bounds.upperBound);
        }
        return new UncertainBoundedIncrMagFreqDist(this, lowerBounds, upperBounds, boundType, this.stdDevs);
    }

    public static class Adapter
    extends IncrementalMagFreqDist.GenericAdapter<UncertainIncrMagFreqDist> {
        EvenlyDiscretizedFunc.Adapter funcAdapter = new EvenlyDiscretizedFunc.Adapter();

        @Override
        protected UncertainIncrMagFreqDist instance(Double minX, Double maxX, Integer size) {
            Preconditions.checkNotNull((Object)minX, (Object)"minX must be supplied before values to deserialize EvenlyDiscretizedFunc");
            Preconditions.checkNotNull((Object)maxX, (Object)"maxX must be supplied before values to deserialize EvenlyDiscretizedFunc");
            Preconditions.checkNotNull((Object)size, (Object)"size must be supplied before values to deserialize EvenlyDiscretizedFunc");
            IncrementalMagFreqDist mfd = new IncrementalMagFreqDist((double)minX, maxX, size);
            return new UncertainIncrMagFreqDist(mfd, null);
        }

        @Override
        protected void serializeExtras(JsonWriter out, UncertainIncrMagFreqDist xy) throws IOException {
            super.serializeExtras(out, xy);
            if (xy.stdDevs != null) {
                out.name("stdDevs");
                Adapter.writeDoubleArray(out, xy.stdDevs);
            }
        }

        static void writeDoubleArray(JsonWriter out, DiscretizedFunc func) throws IOException {
            out.beginArray();
            for (Point2D pt : func) {
                out.value(pt.getY());
            }
            out.endArray();
        }

        static List<Double> readDoubleArray(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<Double> ret = new ArrayList<Double>();
            while (in.hasNext()) {
                ret.add(in.nextDouble());
            }
            in.endArray();
            return ret;
        }

        private static EvenlyDiscretizedFunc buildFunc(EvenlyDiscretizedFunc xVals, List<Double> yVals) {
            Preconditions.checkState((xVals.size() == yVals.size() ? 1 : 0) != 0);
            EvenlyDiscretizedFunc ret = new EvenlyDiscretizedFunc(xVals.getMinX(), xVals.size(), xVals.getDelta());
            for (int i = 0; i < yVals.size(); ++i) {
                ret.set(i, (double)yVals.get(i));
            }
            return ret;
        }

        @Override
        protected Consumer<UncertainIncrMagFreqDist> deserializeExtra(JsonReader in, String name) throws IOException {
            if (name.equals("stdDevs")) {
                if (in.peek() == JsonToken.NULL) {
                    return null;
                }
                if (in.peek() == JsonToken.BEGIN_OBJECT) {
                    final EvenlyDiscretizedFunc stdDevs = (EvenlyDiscretizedFunc)this.funcAdapter.read(in);
                    return new Consumer<UncertainIncrMagFreqDist>(){
                        final /* synthetic */ Adapter this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void accept(UncertainIncrMagFreqDist t) {
                            Preconditions.checkState((t.size() == stdDevs.size() ? 1 : 0) != 0);
                            t.stdDevs = stdDevs;
                        }
                    };
                }
                final List<Double> stdDevs = Adapter.readDoubleArray(in);
                return new Consumer<UncertainIncrMagFreqDist>(){
                    final /* synthetic */ Adapter this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void accept(UncertainIncrMagFreqDist t) {
                        t.stdDevs = Adapter.buildFunc(t, stdDevs);
                    }
                };
            }
            return super.deserializeExtra(in, name);
        }

        @Override
        protected Class<UncertainIncrMagFreqDist> getType() {
            return UncertainIncrMagFreqDist.class;
        }
    }
}

