/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.data.xyz;

import org.opensha.commons.data.xyz.AbstractGeoDataSet;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSetMath;
import org.opensha.commons.geo.Location;

public class GeoDataSetMath
extends XYZ_DataSetMath {
    public static GeoDataSet add(GeoDataSet map1, GeoDataSet map2) {
        ArbDiscrGeoDataSet sum = new ArbDiscrGeoDataSet(map1.isLatitudeX());
        for (int i = 0; i < map1.size(); ++i) {
            Location loc = map1.getLocation(i);
            double val1 = map1.get(i);
            int map2Index = map2.indexOf(loc);
            if (map2Index < 0) continue;
            double val2 = map2.get(map2Index);
            sum.set(loc, val1 + val2);
        }
        return sum;
    }

    public static GeoDataSet subtract(GeoDataSet minuend, GeoDataSet subtrahend) {
        ArbDiscrGeoDataSet difference = new ArbDiscrGeoDataSet(minuend.isLatitudeX());
        for (int i = 0; i < minuend.size(); ++i) {
            Location loc = minuend.getLocation(i);
            double val1 = minuend.get(i);
            int map2Index = subtrahend.indexOf(loc);
            if (map2Index < 0) continue;
            double val2 = subtrahend.get(map2Index);
            difference.set(loc, val1 - val2);
        }
        return difference;
    }

    public static GeoDataSet multiply(GeoDataSet map1, GeoDataSet map2) {
        ArbDiscrGeoDataSet product = new ArbDiscrGeoDataSet(map1.isLatitudeX());
        for (int i = 0; i < map1.size(); ++i) {
            Location loc = map1.getLocation(i);
            double val1 = map1.get(i);
            int map2Index = map2.indexOf(loc);
            if (map2Index < 0) continue;
            double val2 = map2.get(map2Index);
            product.set(loc, val1 * val2);
        }
        return product;
    }

    public static GeoDataSet divide(GeoDataSet dividend, GeoDataSet divisor) {
        AbstractGeoDataSet quotient = dividend instanceof GriddedGeoDataSet && divisor instanceof GriddedGeoDataSet && ((GriddedGeoDataSet)dividend).getRegion().equals(((GriddedGeoDataSet)divisor).getRegion()) ? new GriddedGeoDataSet(((GriddedGeoDataSet)dividend).getRegion(), dividend.isLatitudeX()) : new ArbDiscrGeoDataSet(dividend.isLatitudeX());
        for (int i = 0; i < dividend.size(); ++i) {
            Location loc = dividend.getLocation(i);
            double val1 = dividend.get(i);
            int map2Index = divisor.indexOf(loc);
            if (map2Index < 0) continue;
            double val2 = divisor.get(map2Index);
            quotient.set(loc, val1 / val2);
        }
        return quotient;
    }
}

