/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.filters;

import com.google.common.primitives.Doubles;
import java.awt.geom.Path2D;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.opensha.commons.eq.cat.MutableCatalog;
import org.opensha.commons.eq.cat.filters.CatalogFilter;
import org.opensha.commons.eq.cat.filters.ExtentsFilter;
import org.opensha.commons.eq.cat.util.DataType;
import org.opensha.commons.geo.GeoTools;

public class PolygonFilter
implements CatalogFilter {
    private Path2D poly;
    private ExtentsFilter extents = new ExtentsFilter();
    private double latMin;
    private double latMax;
    private double lonMin;
    private double lonMax;

    public PolygonFilter() {
    }

    public PolygonFilter(double[] lats, double[] lons) {
        this.setPolygon(lats, lons);
    }

    public void setPolygon(double[] lats, double[] lons) {
        PolygonFilter.validateInput(lats, lons);
        this.setPath(lats, lons);
        this.latMin = Doubles.min((double[])lats);
        this.latMax = NumberUtils.max((double[])lats);
        this.lonMin = NumberUtils.min((double[])lons);
        this.lonMax = NumberUtils.max((double[])lons);
    }

    @Override
    public int[] process(MutableCatalog catalog) {
        int[] indicesOut;
        if (this.poly == null) {
            return null;
        }
        this.extents.setLatitudes((float)this.latMin, (float)this.latMax);
        this.extents.setLongitudes((float)this.lonMin, (float)this.lonMax);
        int count = 0;
        int[] indices = this.extents.process(catalog);
        if (indices == null) {
            return null;
        }
        double[] eq_latitude = (double[])catalog.getData(DataType.LATITUDE);
        double[] eq_longitude = (double[])catalog.getData(DataType.LONGITUDE);
        for (int i = 0; i < indices.length; ++i) {
            if (!this.poly.contains(eq_longitude[indices[i]], eq_latitude[indices[i]])) continue;
            indices[count] = indices[i];
            ++count;
        }
        if (count != 0) {
            indicesOut = new int[count];
            System.arraycopy(indices, 0, indicesOut, 0, count);
        } else {
            indicesOut = null;
        }
        return indicesOut;
    }

    private void setPath(double[] lats, double[] lons) {
        this.poly = new Path2D.Double(0, lats.length);
        this.poly.moveTo(lons[0], lats[0]);
        for (int i = 1; i < lats.length; ++i) {
            this.poly.lineTo(lons[i], lats[i]);
        }
        this.poly.closePath();
    }

    private static void validateInput(double[] lats, double[] lons) {
        if (!ArrayUtils.isSameLength((double[])lats, (double[])lons)) {
            throw new IllegalArgumentException("PolygonFilter: Vertex arrays must be the same length");
        }
        try {
            GeoTools.validateLats(lats);
            GeoTools.validateLons(lons);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("PolygonFilter: " + iae.getMessage());
        }
    }
}

