/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.opensha.commons.eq.cat.Catalog;
import org.opensha.commons.eq.cat.io.CatalogWriter;

public abstract class AbstractWriter
implements CatalogWriter {
    private String name;
    private String description;
    protected int[] dat_eventIDs;
    protected int[] dat_eventTypes;
    protected long[] dat_dates;
    protected double[] dat_longitudes;
    protected double[] dat_latitudes;
    protected double[] dat_depths;
    protected double[] dat_magnitudes;
    protected int[] dat_magnitudeTypes;
    protected int[] dat_eventQuality;
    protected double[] dat_xyErrors;
    protected double[] dat_zErrors;
    protected int[] dat_fpStrikes;
    protected int[] dat_fpDips;
    protected int[] dat_fpRakes;
    protected final GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    protected Catalog catalog;

    public AbstractWriter(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public AbstractWriter() {
        this("No name", "No description");
    }

    public abstract void initWriter(PrintWriter var1);

    public abstract void writeLine(int var1) throws IOException;

    @Override
    public void process(Catalog catalog, File file) throws IOException {
        this.catalog = catalog;
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            this.initWriter(pw);
            for (int i = 0; i < this.catalog.size(); ++i) {
                this.writeLine(i);
            }
            this.clearArrays();
        }
        catch (IOException ioe) {
            try {
                throw new IOException("Error opening catalog file: " + file.getName(), ioe);
            }
            catch (Throwable throwable) {
                this.clearArrays();
                IOUtils.closeQuietly(pw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)pw);
    }

    private void clearArrays() {
        this.dat_eventIDs = null;
        this.dat_eventTypes = null;
        this.dat_dates = null;
        this.dat_longitudes = null;
        this.dat_latitudes = null;
        this.dat_depths = null;
        this.dat_magnitudes = null;
        this.dat_magnitudeTypes = null;
        this.dat_eventQuality = null;
        this.dat_xyErrors = null;
        this.dat_zErrors = null;
        this.dat_fpStrikes = null;
        this.dat_fpDips = null;
        this.dat_fpRakes = null;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }
}

