/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.eq.cat.io;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.eq.cat.io.AbstractReader;
import org.opensha.commons.eq.cat.util.DataType;

public class Reader_TW_RELOC
extends AbstractReader {
    private static final String NAME = "";
    private static final String DESC = "";
    private int count;

    public Reader_TW_RELOC(int size) {
        super("", "", size);
    }

    @Override
    public void initReader() {
        this.count = 0;
        this.dat_dates = new ArrayList(this.size);
        this.dat_longitudes = new ArrayList(this.size);
        this.dat_latitudes = new ArrayList(this.size);
        this.dat_depths = new ArrayList(this.size);
        this.dat_magnitudes = new ArrayList(this.size);
    }

    @Override
    public void loadData() {
        this.catalog.addData(DataType.TIME, Longs.toArray((Collection)this.dat_dates));
        this.catalog.addData(DataType.LONGITUDE, Doubles.toArray((Collection)this.dat_longitudes));
        this.catalog.addData(DataType.LATITUDE, Doubles.toArray((Collection)this.dat_latitudes));
        this.catalog.addData(DataType.DEPTH, Doubles.toArray((Collection)this.dat_depths));
        this.catalog.addData(DataType.MAGNITUDE, Doubles.toArray((Collection)this.dat_magnitudes));
    }

    @Override
    public void parseLine(String line) {
        try {
            ++this.count;
            if (!StringUtils.isNumeric((CharSequence)line.substring(0, 1))) {
                return;
            }
            this.cal.set(1, Integer.parseInt(line.substring(0, 4).trim()));
            this.cal.set(2, Integer.parseInt(line.substring(5, 7).trim()) - 1);
            this.cal.set(5, Integer.parseInt(line.substring(8, 10).trim()));
            this.cal.set(11, Integer.parseInt(line.substring(11, 13).trim()));
            this.cal.set(12, Integer.parseInt(line.substring(14, 16).trim()));
            this.cal.set(13, Integer.parseInt(line.substring(18, 20).trim()));
            this.cal.set(14, Integer.parseInt(line.substring(21, 23).trim()) * 10);
            this.dat_dates.add(this.cal.getTimeInMillis());
            this.dat_magnitudes.add(Double.parseDouble(line.substring(48, 52).trim()));
            this.dat_latitudes.add(Double.parseDouble(line.substring(23, 31).trim()));
            this.dat_longitudes.add(Double.parseDouble(line.substring(31, 40).trim()));
            this.dat_depths.add(Double.parseDouble(line.substring(42, 47).trim()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading catalog file format at line: " + this.count);
        }
    }
}

